<?php declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Api\ServiceApi;

use AmazonPHP\SellingPartner\AccessToken;
use AmazonPHP\SellingPartner\Configuration;
use AmazonPHP\SellingPartner\Exception\ApiException;
use AmazonPHP\SellingPartner\Exception\InvalidArgumentException;
use AmazonPHP\SellingPartner\HttpFactory;
use AmazonPHP\SellingPartner\HttpSignatureHeaders;
use AmazonPHP\SellingPartner\ObjectSerializer;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Log\LoggerInterface;

/**
 * This class was auto-generated by https://github.com/OpenAPITools/openapi-generator/.
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh.
 */
final class ServicesSDK
{
    public const API_NAME = 'Services';

    public const OPERATION_ADDAPPOINTMENTFORSERVICEJOBBYSERVICEJOBID = 'addAppointmentForServiceJobByServiceJobId';

    public const OPERATION_ADDAPPOINTMENTFORSERVICEJOBBYSERVICEJOBID_PATH = '/service/v1/serviceJobs/{serviceJobId}/appointments';

    public const OPERATION_CANCELSERVICEJOBBYSERVICEJOBID = 'cancelServiceJobByServiceJobId';

    public const OPERATION_CANCELSERVICEJOBBYSERVICEJOBID_PATH = '/service/v1/serviceJobs/{serviceJobId}/cancellations';

    public const OPERATION_COMPLETESERVICEJOBBYSERVICEJOBID = 'completeServiceJobByServiceJobId';

    public const OPERATION_COMPLETESERVICEJOBBYSERVICEJOBID_PATH = '/service/v1/serviceJobs/{serviceJobId}/completions';

    public const OPERATION_GETSERVICEJOBBYSERVICEJOBID = 'getServiceJobByServiceJobId';

    public const OPERATION_GETSERVICEJOBBYSERVICEJOBID_PATH = '/service/v1/serviceJobs/{serviceJobId}';

    public const OPERATION_GETSERVICEJOBS = 'getServiceJobs';

    public const OPERATION_GETSERVICEJOBS_PATH = '/service/v1/serviceJobs';

    public const OPERATION_RESCHEDULEAPPOINTMENTFORSERVICEJOBBYSERVICEJOBID = 'rescheduleAppointmentForServiceJobByServiceJobId';

    public const OPERATION_RESCHEDULEAPPOINTMENTFORSERVICEJOBBYSERVICEJOBID_PATH = '/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}';

    private ClientInterface $client;

    private HttpFactory $httpFactory;

    private Configuration $configuration;

    private LoggerInterface $logger;

    public function __construct(ClientInterface $client, HttpFactory $requestFactory, Configuration $configuration, LoggerInterface $logger)
    {
        $this->client = $client;
        $this->httpFactory = $requestFactory;
        $this->configuration = $configuration;
        $this->logger = $logger;
    }

    /**
     * Operation addAppointmentForServiceJobByServiceJobId.
     *
     * @param AccessToken $accessToken
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\AddAppointmentRequest $body Add appointment operation input details. (required)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\ApiException on non-2xx response
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function addAppointmentForServiceJobByServiceJobId(AccessToken $accessToken, string $region, string $service_job_id, \AmazonPHP\SellingPartner\Model\Services\AddAppointmentRequest $body) : \AmazonPHP\SellingPartner\Model\Services\SetAppointmentResponse
    {
        $request = $this->addAppointmentForServiceJobByServiceJobIdRequest($accessToken, $region, $service_job_id, $body);

        $this->configuration->extensions()->preRequest('Services', 'addAppointmentForServiceJobByServiceJobId', $request);

        try {
            $correlationId = \uuid_create(UUID_TYPE_RANDOM);

            if ($this->configuration->loggingEnabled('Services', 'addAppointmentForServiceJobByServiceJobId')) {
                $sanitizedRequest = $request;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'addAppointmentForServiceJobByServiceJobId'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'Services',
                        'operation' => 'addAppointmentForServiceJobByServiceJobId',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('Services', 'addAppointmentForServiceJobByServiceJobId', $request, $response);

            if ($this->configuration->loggingEnabled('Services', 'addAppointmentForServiceJobByServiceJobId')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'addAppointmentForServiceJobByServiceJobId'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'Services',
                        'operation' => 'addAppointmentForServiceJobByServiceJobId',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\Services\SetAppointmentResponse',
            []
        );
    }

    /**
     * Create request for operation 'addAppointmentForServiceJobByServiceJobId'.
     *
     * @param AccessToken $accessToken
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\AddAppointmentRequest $body Add appointment operation input details. (required)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function addAppointmentForServiceJobByServiceJobIdRequest(AccessToken $accessToken, string $region, string $service_job_id, \AmazonPHP\SellingPartner\Model\Services\AddAppointmentRequest $body) : RequestInterface
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (\is_array($service_job_id) && \count($service_job_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling addAppointmentForServiceJobByServiceJobId'
            );
        }

        if (\strlen($service_job_id) > 100) {
            throw new InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceApi.addAppointmentForServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }

        if (\strlen($service_job_id) < 1) {
            throw new InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceApi.addAppointmentForServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling addAppointmentForServiceJobByServiceJobId'
            );
        }

        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}/appointments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($service_job_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation cancelServiceJobByServiceJobId.
     *
     * @param AccessToken $accessToken
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     * @param string $cancellation_reason_code A cancel reason code that specifies the reason for cancelling a service job. (required)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\ApiException on non-2xx response
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function cancelServiceJobByServiceJobId(AccessToken $accessToken, string $region, string $service_job_id, string $cancellation_reason_code) : \AmazonPHP\SellingPartner\Model\Services\CancelServiceJobByServiceJobIdResponse
    {
        $request = $this->cancelServiceJobByServiceJobIdRequest($accessToken, $region, $service_job_id, $cancellation_reason_code);

        $this->configuration->extensions()->preRequest('Services', 'cancelServiceJobByServiceJobId', $request);

        try {
            $correlationId = \uuid_create(UUID_TYPE_RANDOM);

            if ($this->configuration->loggingEnabled('Services', 'cancelServiceJobByServiceJobId')) {
                $sanitizedRequest = $request;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'cancelServiceJobByServiceJobId'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'Services',
                        'operation' => 'cancelServiceJobByServiceJobId',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('Services', 'cancelServiceJobByServiceJobId', $request, $response);

            if ($this->configuration->loggingEnabled('Services', 'cancelServiceJobByServiceJobId')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'cancelServiceJobByServiceJobId'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'Services',
                        'operation' => 'cancelServiceJobByServiceJobId',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\Services\CancelServiceJobByServiceJobIdResponse',
            []
        );
    }

    /**
     * Create request for operation 'cancelServiceJobByServiceJobId'.
     *
     * @param AccessToken $accessToken
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     * @param string $cancellation_reason_code A cancel reason code that specifies the reason for cancelling a service job. (required)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function cancelServiceJobByServiceJobIdRequest(AccessToken $accessToken, string $region, string $service_job_id, string $cancellation_reason_code) : RequestInterface
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (\is_array($service_job_id) && \count($service_job_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling cancelServiceJobByServiceJobId'
            );
        }

        if (\strlen($service_job_id) > 100) {
            throw new InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceApi.cancelServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }

        if (\strlen($service_job_id) < 1) {
            throw new InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceApi.cancelServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'cancellation_reason_code' is set
        if ($cancellation_reason_code === null || (\is_array($cancellation_reason_code) && \count($cancellation_reason_code) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $cancellation_reason_code when calling cancelServiceJobByServiceJobId'
            );
        }

        if (\strlen($cancellation_reason_code) > 100) {
            throw new InvalidArgumentException('invalid length for "$cancellation_reason_code" when calling ServiceApi.cancelServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }

        if (\strlen($cancellation_reason_code) < 1) {
            throw new InvalidArgumentException('invalid length for "$cancellation_reason_code" when calling ServiceApi.cancelServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }

        if (!\preg_match('/^[A-Z0-9_]*$/', $cancellation_reason_code)) {
            throw new InvalidArgumentException('invalid value for "cancellation_reason_code" when calling ServiceApi.cancelServiceJobByServiceJobId, must conform to the pattern /^[A-Z0-9_]*$/.');
        }

        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}/cancellations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($cancellation_reason_code)) {
            $cancellation_reason_code = ObjectSerializer::serializeCollection($cancellation_reason_code, '', true);
        }

        if ($cancellation_reason_code !== null) {
            $queryParams['cancellationReasonCode'] = ObjectSerializer::toString($cancellation_reason_code);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($service_job_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'PUT',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation completeServiceJobByServiceJobId.
     *
     * @param AccessToken $accessToken
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\ApiException on non-2xx response
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function completeServiceJobByServiceJobId(AccessToken $accessToken, string $region, string $service_job_id) : \AmazonPHP\SellingPartner\Model\Services\CompleteServiceJobByServiceJobIdResponse
    {
        $request = $this->completeServiceJobByServiceJobIdRequest($accessToken, $region, $service_job_id);

        $this->configuration->extensions()->preRequest('Services', 'completeServiceJobByServiceJobId', $request);

        try {
            $correlationId = \uuid_create(UUID_TYPE_RANDOM);

            if ($this->configuration->loggingEnabled('Services', 'completeServiceJobByServiceJobId')) {
                $sanitizedRequest = $request;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'completeServiceJobByServiceJobId'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'Services',
                        'operation' => 'completeServiceJobByServiceJobId',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('Services', 'completeServiceJobByServiceJobId', $request, $response);

            if ($this->configuration->loggingEnabled('Services', 'completeServiceJobByServiceJobId')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'completeServiceJobByServiceJobId'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'Services',
                        'operation' => 'completeServiceJobByServiceJobId',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\Services\CompleteServiceJobByServiceJobIdResponse',
            []
        );
    }

    /**
     * Create request for operation 'completeServiceJobByServiceJobId'.
     *
     * @param AccessToken $accessToken
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function completeServiceJobByServiceJobIdRequest(AccessToken $accessToken, string $region, string $service_job_id) : RequestInterface
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (\is_array($service_job_id) && \count($service_job_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling completeServiceJobByServiceJobId'
            );
        }

        if (\strlen($service_job_id) > 100) {
            throw new InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceApi.completeServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }

        if (\strlen($service_job_id) < 1) {
            throw new InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceApi.completeServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }

        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}/completions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($service_job_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'PUT',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation getServiceJobByServiceJobId.
     *
     * @param AccessToken $accessToken
     * @param string $service_job_id A service job identifier. (required)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\ApiException on non-2xx response
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function getServiceJobByServiceJobId(AccessToken $accessToken, string $region, string $service_job_id) : \AmazonPHP\SellingPartner\Model\Services\GetServiceJobByServiceJobIdResponse
    {
        $request = $this->getServiceJobByServiceJobIdRequest($accessToken, $region, $service_job_id);

        $this->configuration->extensions()->preRequest('Services', 'getServiceJobByServiceJobId', $request);

        try {
            $correlationId = \uuid_create(UUID_TYPE_RANDOM);

            if ($this->configuration->loggingEnabled('Services', 'getServiceJobByServiceJobId')) {
                $sanitizedRequest = $request;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'getServiceJobByServiceJobId'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'Services',
                        'operation' => 'getServiceJobByServiceJobId',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('Services', 'getServiceJobByServiceJobId', $request, $response);

            if ($this->configuration->loggingEnabled('Services', 'getServiceJobByServiceJobId')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'getServiceJobByServiceJobId'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'Services',
                        'operation' => 'getServiceJobByServiceJobId',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\Services\GetServiceJobByServiceJobIdResponse',
            []
        );
    }

    /**
     * Create request for operation 'getServiceJobByServiceJobId'.
     *
     * @param AccessToken $accessToken
     * @param string $service_job_id A service job identifier. (required)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function getServiceJobByServiceJobIdRequest(AccessToken $accessToken, string $region, string $service_job_id) : RequestInterface
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (\is_array($service_job_id) && \count($service_job_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling getServiceJobByServiceJobId'
            );
        }

        if (\strlen($service_job_id) > 100) {
            throw new InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceApi.getServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }

        if (\strlen($service_job_id) < 1) {
            throw new InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceApi.getServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }

        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($service_job_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation getServiceJobs.
     *
     * @param AccessToken $accessToken
     * @param string[] $marketplace_ids Used to select jobs that were placed in the specified marketplaces. (required)
     * @param string[] $service_order_ids List of service order ids for the query you want to perform.Max values supported 20. (optional)
     * @param string[] $service_job_status A list of one or more job status by which to filter the list of jobs. (optional)
     * @param string $page_token String returned in the response of your previous request. (optional)
     * @param int $page_size A non-negative integer that indicates the maximum number of jobs to return in the list, Value must be 1 - 20. Default 20. (optional, default to 20)
     * @param string $sort_field Sort fields on which you want to sort the output. (optional)
     * @param string $sort_order Sort order for the query you want to perform. (optional)
     * @param string $created_after A date used for selecting jobs created after (or at) a specified time must be in ISO 8601 format. Required if LastUpdatedAfter is not specified.Specifying both CreatedAfter and LastUpdatedAfter returns an error. (optional)
     * @param string $created_before A date used for selecting jobs created before (or at) a specified time must be in ISO 8601 format. (optional)
     * @param string $last_updated_after A date used for selecting jobs updated after (or at) a specified time must be in ISO 8601 format. Required if createdAfter is not specified.Specifying both CreatedAfter and LastUpdatedAfter returns an error. (optional)
     * @param string $last_updated_before A date used for selecting jobs updated before (or at) a specified time must be in ISO 8601 format. (optional)
     * @param string $schedule_start_date A date used for filtering jobs schedule after (or at) a specified time must be in ISO 8601 format. schedule end date should not be earlier than schedule start date. (optional)
     * @param string $schedule_end_date A date used for filtering jobs schedule before (or at) a specified time must be in ISO 8601 format. schedule end date should not be earlier than schedule start date. (optional)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\ApiException on non-2xx response
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function getServiceJobs(AccessToken $accessToken, string $region, array $marketplace_ids, array $service_order_ids = null, array $service_job_status = null, string $page_token = null, int $page_size = 20, string $sort_field = null, string $sort_order = null, string $created_after = null, string $created_before = null, string $last_updated_after = null, string $last_updated_before = null, string $schedule_start_date = null, string $schedule_end_date = null) : \AmazonPHP\SellingPartner\Model\Services\GetServiceJobsResponse
    {
        $request = $this->getServiceJobsRequest($accessToken, $region, $marketplace_ids, $service_order_ids, $service_job_status, $page_token, $page_size, $sort_field, $sort_order, $created_after, $created_before, $last_updated_after, $last_updated_before, $schedule_start_date, $schedule_end_date);

        $this->configuration->extensions()->preRequest('Services', 'getServiceJobs', $request);

        try {
            $correlationId = \uuid_create(UUID_TYPE_RANDOM);

            if ($this->configuration->loggingEnabled('Services', 'getServiceJobs')) {
                $sanitizedRequest = $request;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'getServiceJobs'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'Services',
                        'operation' => 'getServiceJobs',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('Services', 'getServiceJobs', $request, $response);

            if ($this->configuration->loggingEnabled('Services', 'getServiceJobs')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'getServiceJobs'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'Services',
                        'operation' => 'getServiceJobs',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\Services\GetServiceJobsResponse',
            []
        );
    }

    /**
     * Create request for operation 'getServiceJobs'.
     *
     * @param AccessToken $accessToken
     * @param string[] $marketplace_ids Used to select jobs that were placed in the specified marketplaces. (required)
     * @param string[] $service_order_ids List of service order ids for the query you want to perform.Max values supported 20. (optional)
     * @param string[] $service_job_status A list of one or more job status by which to filter the list of jobs. (optional)
     * @param string $page_token String returned in the response of your previous request. (optional)
     * @param int $page_size A non-negative integer that indicates the maximum number of jobs to return in the list, Value must be 1 - 20. Default 20. (optional, default to 20)
     * @param string $sort_field Sort fields on which you want to sort the output. (optional)
     * @param string $sort_order Sort order for the query you want to perform. (optional)
     * @param string $created_after A date used for selecting jobs created after (or at) a specified time must be in ISO 8601 format. Required if LastUpdatedAfter is not specified.Specifying both CreatedAfter and LastUpdatedAfter returns an error. (optional)
     * @param string $created_before A date used for selecting jobs created before (or at) a specified time must be in ISO 8601 format. (optional)
     * @param string $last_updated_after A date used for selecting jobs updated after (or at) a specified time must be in ISO 8601 format. Required if createdAfter is not specified.Specifying both CreatedAfter and LastUpdatedAfter returns an error. (optional)
     * @param string $last_updated_before A date used for selecting jobs updated before (or at) a specified time must be in ISO 8601 format. (optional)
     * @param string $schedule_start_date A date used for filtering jobs schedule after (or at) a specified time must be in ISO 8601 format. schedule end date should not be earlier than schedule start date. (optional)
     * @param string $schedule_end_date A date used for filtering jobs schedule before (or at) a specified time must be in ISO 8601 format. schedule end date should not be earlier than schedule start date. (optional)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function getServiceJobsRequest(AccessToken $accessToken, string $region, array $marketplace_ids, array $service_order_ids = null, array $service_job_status = null, string $page_token = null, int $page_size = 20, string $sort_field = null, string $sort_order = null, string $created_after = null, string $created_before = null, string $last_updated_after = null, string $last_updated_before = null, string $schedule_start_date = null, string $schedule_end_date = null) : RequestInterface
    {
        // verify the required parameter 'marketplace_ids' is set
        if ($marketplace_ids === null || (\is_array($marketplace_ids) && \count($marketplace_ids) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $marketplace_ids when calling getServiceJobs'
            );
        }

        if (\count($marketplace_ids) > 1) {
            throw new InvalidArgumentException('invalid value for "$marketplace_ids" when calling ServiceApi.getServiceJobs, number of items must be less than or equal to 1.');
        }

        if ($service_order_ids !== null && \count($service_order_ids) > 20) {
            throw new InvalidArgumentException('invalid value for "$service_order_ids" when calling ServiceApi.getServiceJobs, number of items must be less than or equal to 20.');
        }

        if ($service_order_ids !== null && \count($service_order_ids) < 1) {
            throw new InvalidArgumentException('invalid value for "$service_order_ids" when calling ServiceApi.getServiceJobs, number of items must be greater than or equal to 1.');
        }

        if ($page_size !== null && $page_size > 20) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling ServiceApi.getServiceJobs, must be smaller than or equal to 20.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling ServiceApi.getServiceJobs, must be bigger than or equal to 1.');
        }

        $resourcePath = '/service/v1/serviceJobs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($service_order_ids)) {
            $service_order_ids = ObjectSerializer::serializeCollection($service_order_ids, 'form', true);
        }

        if ($service_order_ids !== null) {
            $queryParams['serviceOrderIds'] = ObjectSerializer::toString($service_order_ids);
        }
        // query params
        if (\is_array($service_job_status)) {
            $service_job_status = ObjectSerializer::serializeCollection($service_job_status, 'form', true);
        }

        if ($service_job_status !== null) {
            $queryParams['serviceJobStatus'] = ObjectSerializer::toString($service_job_status);
        }
        // query params
        if (\is_array($page_token)) {
            $page_token = ObjectSerializer::serializeCollection($page_token, '', true);
        }

        if ($page_token !== null) {
            $queryParams['pageToken'] = ObjectSerializer::toString($page_token);
        }
        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }
        // query params
        if (\is_array($sort_field)) {
            $sort_field = ObjectSerializer::serializeCollection($sort_field, '', true);
        }

        if ($sort_field !== null) {
            $queryParams['sortField'] = ObjectSerializer::toString($sort_field);
        }
        // query params
        if (\is_array($sort_order)) {
            $sort_order = ObjectSerializer::serializeCollection($sort_order, '', true);
        }

        if ($sort_order !== null) {
            $queryParams['sortOrder'] = ObjectSerializer::toString($sort_order);
        }
        // query params
        if (\is_array($created_after)) {
            $created_after = ObjectSerializer::serializeCollection($created_after, '', true);
        }

        if ($created_after !== null) {
            $queryParams['createdAfter'] = ObjectSerializer::toString($created_after);
        }
        // query params
        if (\is_array($created_before)) {
            $created_before = ObjectSerializer::serializeCollection($created_before, '', true);
        }

        if ($created_before !== null) {
            $queryParams['createdBefore'] = ObjectSerializer::toString($created_before);
        }
        // query params
        if (\is_array($last_updated_after)) {
            $last_updated_after = ObjectSerializer::serializeCollection($last_updated_after, '', true);
        }

        if ($last_updated_after !== null) {
            $queryParams['lastUpdatedAfter'] = ObjectSerializer::toString($last_updated_after);
        }
        // query params
        if (\is_array($last_updated_before)) {
            $last_updated_before = ObjectSerializer::serializeCollection($last_updated_before, '', true);
        }

        if ($last_updated_before !== null) {
            $queryParams['lastUpdatedBefore'] = ObjectSerializer::toString($last_updated_before);
        }
        // query params
        if (\is_array($schedule_start_date)) {
            $schedule_start_date = ObjectSerializer::serializeCollection($schedule_start_date, '', true);
        }

        if ($schedule_start_date !== null) {
            $queryParams['scheduleStartDate'] = ObjectSerializer::toString($schedule_start_date);
        }
        // query params
        if (\is_array($schedule_end_date)) {
            $schedule_end_date = ObjectSerializer::serializeCollection($schedule_end_date, '', true);
        }

        if ($schedule_end_date !== null) {
            $queryParams['scheduleEndDate'] = ObjectSerializer::toString($schedule_end_date);
        }
        // query params
        if (\is_array($marketplace_ids)) {
            $marketplace_ids = ObjectSerializer::serializeCollection($marketplace_ids, 'form', true);
        }

        if ($marketplace_ids !== null) {
            $queryParams['marketplaceIds'] = ObjectSerializer::toString($marketplace_ids);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation rescheduleAppointmentForServiceJobByServiceJobId.
     *
     * @param AccessToken $accessToken
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     * @param string $appointment_id An existing appointment identifier for the Service Job. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\RescheduleAppointmentRequest $body Reschedule appointment operation input details. (required)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\ApiException on non-2xx response
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function rescheduleAppointmentForServiceJobByServiceJobId(AccessToken $accessToken, string $region, string $service_job_id, string $appointment_id, \AmazonPHP\SellingPartner\Model\Services\RescheduleAppointmentRequest $body) : \AmazonPHP\SellingPartner\Model\Services\SetAppointmentResponse
    {
        $request = $this->rescheduleAppointmentForServiceJobByServiceJobIdRequest($accessToken, $region, $service_job_id, $appointment_id, $body);

        $this->configuration->extensions()->preRequest('Services', 'rescheduleAppointmentForServiceJobByServiceJobId', $request);

        try {
            $correlationId = \uuid_create(UUID_TYPE_RANDOM);

            if ($this->configuration->loggingEnabled('Services', 'rescheduleAppointmentForServiceJobByServiceJobId')) {
                $sanitizedRequest = $request;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'rescheduleAppointmentForServiceJobByServiceJobId'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'Services',
                        'operation' => 'rescheduleAppointmentForServiceJobByServiceJobId',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('Services', 'rescheduleAppointmentForServiceJobByServiceJobId', $request, $response);

            if ($this->configuration->loggingEnabled('Services', 'rescheduleAppointmentForServiceJobByServiceJobId')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('Services', 'rescheduleAppointmentForServiceJobByServiceJobId'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'Services',
                        'operation' => 'rescheduleAppointmentForServiceJobByServiceJobId',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\Services\SetAppointmentResponse',
            []
        );
    }

    /**
     * Create request for operation 'rescheduleAppointmentForServiceJobByServiceJobId'.
     *
     * @param AccessToken $accessToken
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     * @param string $appointment_id An existing appointment identifier for the Service Job. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\RescheduleAppointmentRequest $body Reschedule appointment operation input details. (required)
     *
     * @throws \AmazonPHP\SellingPartner\Exception\InvalidArgumentException
     */
    public function rescheduleAppointmentForServiceJobByServiceJobIdRequest(AccessToken $accessToken, string $region, string $service_job_id, string $appointment_id, \AmazonPHP\SellingPartner\Model\Services\RescheduleAppointmentRequest $body) : RequestInterface
    {
        // verify the required parameter 'service_job_id' is set
        if ($service_job_id === null || (\is_array($service_job_id) && \count($service_job_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $service_job_id when calling rescheduleAppointmentForServiceJobByServiceJobId'
            );
        }

        if (\strlen($service_job_id) > 100) {
            throw new InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceApi.rescheduleAppointmentForServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }

        if (\strlen($service_job_id) < 1) {
            throw new InvalidArgumentException('invalid length for "$service_job_id" when calling ServiceApi.rescheduleAppointmentForServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'appointment_id' is set
        if ($appointment_id === null || (\is_array($appointment_id) && \count($appointment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $appointment_id when calling rescheduleAppointmentForServiceJobByServiceJobId'
            );
        }

        if (\strlen($appointment_id) > 100) {
            throw new InvalidArgumentException('invalid length for "$appointment_id" when calling ServiceApi.rescheduleAppointmentForServiceJobByServiceJobId, must be smaller than or equal to 100.');
        }

        if (\strlen($appointment_id) < 1) {
            throw new InvalidArgumentException('invalid length for "$appointment_id" when calling ServiceApi.rescheduleAppointmentForServiceJobByServiceJobId, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling rescheduleAppointmentForServiceJobByServiceJobId'
            );
        }

        $resourcePath = '/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($service_job_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'serviceJobId' . '}',
                ObjectSerializer::toPathValue($service_job_id),
                $resourcePath
            );
        }
        // path params
        if ($appointment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'appointmentId' . '}',
                ObjectSerializer::toPathValue($appointment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }
}
