<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Cron extends Model
{
    // Table name (optional if Laravel can infer correctly)
    protected $table = 'crons';

    // Primary key (optional if it's `id`)
    protected $primaryKey = 'id';

    // If you don't use Laravel's created_at/updated_at timestamps
    public $timestamps = false;

    // Fillable columns for mass assignment
    protected $fillable = [
        'crontype',
        'isrunning',
        'lastrun',
        'info',
    ];

    // Optional: cast columns to native types
    protected $casts = [
        'isrunning' => 'boolean',
        'lastrun' => 'datetime',
    ];
}
