<?php

namespace App\Http\Controllers;
use App\Product;
use App\ShopifyProduct;

use App\ShopifyRequest;
use BcMath\Number;
use Illuminate\Http\Request;
use App\Role;
use App\User;
use App\EbKey;
use App\EbRequest;
use App\Setting;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Profile;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Tymon\JWTAuth\Facades\JWTAuth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class AuthenticateController extends Controller
{
public function authenticate2(Request $request)
	{
		// return response()->json(['error' => 'Down for maintenance!'], 401);

		$permissions = array();
		if (!$request->has("key")) {
			return response()->json(['error' => 'Invalid Credentials'], 401);
		}
		$tempcode = $request->input("key");
		$user = User::with("summary")->where('tempcode', $tempcode)->first(["id", "shopurl", "status", "tempcode", "membershiptype", "plan", "sync", "skulimit", "skuconsumed", "review", "custommode", "created_at", "paid_at", "usermsg", "appTour", "SetupStep"]);
		if (!$user) {
			return response()->json(['error' => 'Invalid Credentials'], 401);
		}

		// $sproducts = ShopifyProduct::where('user_id', '=', $user->id)->count();
		// $products = Product::where('user_id', '=', $user->id)->count();
		// $vproducts = Product::where('user_id', '=', $user->id)->where('status', '=', 'Imported')->count();
		// $ShopifyProduct = ShopifyProduct::where('user_id', '=', $user->id)->where('status', '=', 'Imported')->count();
		//  $ebayrequeststatus = EbRequest::where('user_id', '=', $user->id)->count();
		//  $ebayrequeststatusPending = EbRequest::where('user_id', '=', $user->id)->where('status','pending')->count();
		$ebayRequestCounts = EbRequest::selectRaw("
        COUNT(*) as total, 
        COUNT(CASE WHEN status = 'pending' THEN 1 END) as pending
    	")
			->where('user_id', $user->id)
			->first();

		$ebayrequeststatus = $ebayRequestCounts->total;
		$ebayrequeststatusPending = $ebayRequestCounts->pending;
		// $sh_requests = ShopifyRequest::where('user_id', '=', $user->id)->count();
		// $sh_requests_pending = ShopifyRequest::where('user_id', '=', $user->id)->where('status', 'pending')->where('inprocess', 0)->count();
		$shRequestCounts = ShopifyRequest::selectRaw("
        COUNT(*) as total,
        COUNT(CASE WHEN status = 'pending' AND inprocess = 0 THEN 1 END) as pending
    	")
			->where('user_id', $user->id)
			->first();
		$sh_requests = $shRequestCounts->total;
		$sh_requests_pending = $shRequestCounts->pending;

		Log::info("sh_requesr count : ");
		// Log::info($sh_requests);
		$user->lastlogin = DB::raw('now()');
		$user->save();
		// $profileNames = Profile::where("user_id", $user->id)->get(['id', 'name', 'is_variantions']);
		$paid_at = $user->paid_at;
		// $user->profileData = $profileNames;
		$created_at = $user->created_at;
		$review = $user->review;
		$eb_key = EbKey::where('user_id', $user->id)->get();
		$fromtime = new Carbon($paid_at);
		if (strtotime($paid_at) < 1) {
			$fromtime = new Carbon($created_at);
		}

		$countkeys = EbKey::where('user_id', '=', $user->id)->count();

		$user->eb_key = $eb_key;
		$now = Carbon::now();
		$difference = $fromtime->diffInDays($now);
		//Log::info("difference == ".$difference);
		if ($difference > 30 && $user->sync == 0 && $user->review == 0) {
			$user->expired = 1;
		} else if ($difference > 60 && $user->sync == 0 && $user->review == 1) {
			$user->expired = 1;
		} else {
			$user->expired = 0;
		}
		$user->expired = 0;
		$user->countkeys = $countkeys;
		$ebKey = $user->ebKey()->first();
		if (!$ebKey) {
			$user->ebtoken = 0;
		} else {
			$expirydate = $ebKey->expirydate;
			$expirytime = new Carbon($expirydate);
			$expdifference = $now->diffInDays($expirytime, false);
			if ($ebKey->valid == 0 || $expdifference < 15) {
				$user->ebtoken = 2;
			} else {
				$user->ebtoken = 1;
			}
		}
		$planprice = 0;
		if ($user->plan == 1) {
			$planprice = 19.99;
		} else if ($user->plan == 2) {
			$planprice = 29.99;
		} else if ($user->plan == 3) {
			$planprice = 59.99;
		}
		$user->planprice = $planprice;
		if ($sh_requests_pending === 1 && $sh_requests === 1) {
			$user->sh_requests = 0;
			$user->sh_requests_pending = 1;
		} else if ($sh_requests === 1) {
			$user->sh_requests_pending = 2;
		} else {
			$user->sh_requests = $sh_requests;
			$user->sh_requests_pending = $sh_requests_pending;
		}
		

		if ($ebayrequeststatusPending === 1 && $ebayrequeststatus === 1) {
			$user->ebrequest = 0;
		} else {
			$user->ebrequest = $ebayrequeststatus;
		}


		$user->shproducts = $user->summary->shopify_products ?? 0;
		$user->ebproduct = $user->summary->ebay_products ?? 0;
		$user->importedproducts = $user->summary->imported_ebay_products ?? 0;
		$user->TotalImportedproducts = (int) ($user->summary->imported_ebay_products ?? 0) + (int) ($user->summary->imported_shopify_products ?? 0);
		//$user->TotalImportedproducts = 0;
		$user->showpop = 0;

		if ($user->usermsg == 'shtoeb') {
			$user->showpop = 1;
		}


		$settings = $user->settings()->first();

		if (!$settings) {
			$settingObj = new Setting;
			$settingObj->published = 1;
			$settingObj->tags = "";
			$settingObj->vendor = "";
			$settingObj->product_type = "";
			$settingObj->inventory_policy = "shopify";
			$settingObj->inventory_sync = 0;
			$settingObj->price_sync = 0;
			$settingObj->outofstock_action = "outofstock";
			$settingObj->desc_cond = 0;
			$settingObj->desc_itemspecs = 0;
			$settingObj->markupenabled = 0;
			$settingObj->markuptype = 'FIXED';
			$settingObj->markupval = 0;
			$settingObj->markupround = 0;
			$user->settings()->save($settingObj);

		}

		try {
			// verify the credentials and create a token for the user
			if (!$token = JWTAuth::fromUser($user)) {
				return response()->json(['error' => 'Invalid Credentials'], 401);
			}
		} catch (JWTException $e) {
			// something went wrong
			return response()->json(['error' => 'could_not_create_token'], 500);
		}
		return response()->json(compact('token', 'user'));
	}
public function authenticate(Request $request)
    {
        // return response()->json(['error' => 'Down for maintenance!'], 401);
        //exit;
        $permissions = array();
        if (!$request->has("key")) {
            return response()->json(['error' => 'Invalid Credentials'], 401);
        }
        $tempcode = $request->input("key");
       $user = User::where('tempcode', $tempcode)->first(["id", "shopurl", "status", "tempcode", "membershiptype", "plan", "sync", "skulimit", "skuconsumed", "review", "custommode", "created_at", "paid_at", "usermsg", "appTour", "SetupStep"]);
        if (!$user) {
            return response()->json(['error' => 'Invalid Credentials'], 401);
        }
        // $sproducts = ShopifyProduct::where('user_id', '=', $user->id)->count();
        // $products = Product::where('user_id', '=', $user->id)->count();
        // $vproducts = Product::where('user_id', '=', $user->id)->where('status', '=', 'Imported')->count();
        // $ShopifyProduct = ShopifyProduct::where('user_id', '=', $user->id)->where('status', '=', 'Imported')->count();
        // $ebayrequeststatus = EbRequest::where('user_id', '=', $user->id)->count();
        // $eb_pending_request = EbRequest::where('user_id', '=', $user->id)->where('status','pending')->count();
        $ebayRequestCounts = EbRequest::selectRaw("
        COUNT(*) as total,
        COUNT(CASE WHEN status = 'pending' THEN 1 END) as pending
        ")
            ->where('user_id', $user->id)
            ->first();
        $ebayrequeststatus = $ebayRequestCounts->total;
        $eb_pending_request = $ebayRequestCounts->pending;

     
 
        // Log::info(json_encode($products));
        // $sh_requests = ShopifyRequest::where('user_id', '=', $user->id)->count();
        // $sh_requests_pending = ShopifyRequest::where('user_id', '=', $user->id)->where('status','pending')->where('inprocess',0)->count();
       $shRequestCounts = ShopifyRequest::selectRaw("
        COUNT(*) as total,
        COUNT(CASE WHEN status = 'pending' AND inprocess = 0 THEN 1 END) as pending
        ")
            ->where('user_id', $user->id)
            ->first();
        $sh_requests = $shRequestCounts->total;
        $sh_requests_pending = $shRequestCounts->pending;
 
 
        Log::info("sh_requesr count : ");
        Log::info($sh_requests);
        $user->lastlogin = DB::raw('now()');
        $user->save();
        if ($eb_pending_request == 1) {
            $user-> eb_requests_pending =  $eb_pending_request;
        }else{
            $user-> eb_requests_pending =  2;
        }
        $profileNames = Profile::where("user_id", $user->id)->get(['id', 'name', 'is_variantions']);
        $paid_at = $user->paid_at;
        $user->profileData = $profileNames;
        $created_at = $user->created_at;
        $review = $user->review;
        // $eb_key = EbKey::where('user_id', $user->id)->first();
        // $eb_keyCount = EbKey::where('user_id', $user->id)->count();
        $eb_keys = EbKey::where('user_id', $user->id)->get();
        $eb_key = $eb_keys->first();
        $eb_keyCount = $eb_keys->count();
 
        $fromtime = new Carbon($paid_at);
        if (strtotime($paid_at) < 1) {
            $fromtime = new Carbon($created_at);
        }
 
        // $countkeys = EbKey::where('user_id', '=', $user->id)->count();
 
        $user->eb_key = $eb_keys;
        $now = Carbon::now();
        $difference = $fromtime->diffInDays($now);
        //Log::info("difference == ".$difference);
        if ($difference > 30 && $user->sync == 0 && $user->review == 0) {
            $user->expired = 1;
        } else if ($difference > 60 && $user->sync == 0 && $user->review == 1) {
            $user->expired = 1;
        } else {
            $user->expired = 0;
        }
        $user->expired = 0;
        // $user->countkeys = $countkeys;
        // $ebKey = $user->ebKey()->first();
        // if (!$ebKey) {
        //     $user->ebtoken = 0;
        // } else {
        //     $expirydate = $ebKey->expirydate;
        //     $expirytime = new Carbon($expirydate);
        //     $expdifference = $now->diffInDays($expirytime, false);
        //     if ($ebKey->valid == 0 || $expdifference < 15) {
        //         $user->ebtoken = 2;
        //     } else {
        //         $user->ebtoken = 1;
        //     }
        // }
        $planprice = 0;
        if ($user->plan == 1) {
            $planprice = 19.99;
        } else if ($user->plan == 2) {
            $planprice = 29.99;
        } else if ($user->plan == 3) {
            $planprice = 59.99;
        }
        $user->planprice = $planprice;
        if ($sh_requests_pending === 1 && $sh_requests === 1) {
            $user->sh_requests = 0;
            $user->sh_requests_pending = 1;
        }else if ( $sh_requests === 1){
            $user->sh_requests_pending = 2;
            $user->sh_requests = $sh_requests;
        }else{
            $user->sh_requests = $sh_requests;
            $user->sh_requests_pending = $sh_requests_pending;
        }
        $user->eb_keysCount = $eb_keyCount;
        $user->ebrequest = $ebayrequeststatus;
 
        # $user->shproducts = $user->summary->shopify_products ?? 0;
        # $user->ebproduct = $user->summary->ebay_products ?? 0;
        # $user->importedproducts = $user->summary->imported_ebay_products ?? 0;
        # $user->TotalImportedproducts = (int) ($user->summary->imported_ebay_products ?? 0) + (int) ($user->summary->imported_shopify_products ?? 0);
        //$user->TotalImportedproducts = 0;
        $user->showpop = 0;
       
        if ($user->usermsg == 'shtoeb') {
            $user->showpop = 1;
        }
        if ($eb_pending_request == 1) {
            $user-> eb_requests_pending =  $eb_pending_request;
        }else{
            $user-> eb_requests_pending =  2;
        }
 
        $settings = $user->settings()->first();
 
        if (!$settings) {
            $settingObj = new Setting;
            $settingObj->published = 1;
            $settingObj->tags = "";
            $settingObj->vendor = "";
            $settingObj->product_type = "";
            $settingObj->inventory_policy = "shopify";
            $settingObj->inventory_sync = 0;
            $settingObj->price_sync = 0;
            $settingObj->outofstock_action = "outofstock";
            $settingObj->desc_cond = 0;
            $settingObj->desc_itemspecs = 0;
            $settingObj->markupenabled = 0;
            $settingObj->markuptype = 'FIXED';
            $settingObj->markupval = 0;
            $settingObj->markupround = 0;
            $user->settings()->save($settingObj);
 
        }
 
        try {
            // verify the credentials and create a token for the user
            if (!$token = JWTAuth::fromUser($user)) {
                return response()->json(['error' => 'Invalid Credentials'], 401);
            }
        } catch (JWTException $e) {
            // something went wrong
            return response()->json(['error' => 'could_not_create_token'], 500);
        }
        return response()->json(compact('token', 'user'));
    }
    public function authenticate1(Request $request)
    {
        // return response()->json(['error' => 'Down for maintenance!'], 401);
        //exit;
        $permissions = array();
        if (!$request->has("key")) {
            return response()->json(['error' => 'Invalid Credentials'], 401);
        }
        $tempcode = $request->input("key");
       $user = User::with("summary")->where('tempcode', $tempcode)->first(["id", "shopurl", "status", "tempcode", "membershiptype", "plan", "sync", "skulimit", "skuconsumed", "review", "custommode", "created_at", "paid_at", "usermsg", "appTour", "SetupStep"]);
        if (!$user) {
            return response()->json(['error' => 'Invalid Credentials'], 401);
        }
        // $sproducts = ShopifyProduct::where('user_id', '=', $user->id)->count();
        // $products = Product::where('user_id', '=', $user->id)->count();
        // $vproducts = Product::where('user_id', '=', $user->id)->where('status', '=', 'Imported')->count();
        // $ShopifyProduct = ShopifyProduct::where('user_id', '=', $user->id)->where('status', '=', 'Imported')->count();
        // $ebayrequeststatus = EbRequest::where('user_id', '=', $user->id)->count();
        // $eb_pending_request = EbRequest::where('user_id', '=', $user->id)->where('status','pending')->count();
        $ebayRequestCounts = EbRequest::selectRaw("
        COUNT(*) as total,
        COUNT(CASE WHEN status = 'pending' THEN 1 END) as pending
        ")
            ->where('user_id', $user->id)
            ->first();
 
        $ebayrequeststatus = $ebayRequestCounts->total;
        $eb_pending_request = $ebayRequestCounts->pending;
 
        // Log::info(json_encode($products));
        // $sh_requests = ShopifyRequest::where('user_id', '=', $user->id)->count();
        // $sh_requests_pending = ShopifyRequest::where('user_id', '=', $user->id)->where('status','pending')->where('inprocess',0)->count();
       $shRequestCounts = ShopifyRequest::selectRaw("
        COUNT(*) as total,
        COUNT(CASE WHEN status = 'pending' AND inprocess = 0 THEN 1 END) as pending
        ")
            ->where('user_id', $user->id)
            ->first();
        $sh_requests = $shRequestCounts->total;
        $sh_requests_pending = $shRequestCounts->pending;
 
 
        Log::info("sh_requesr count : ");
        Log::info($sh_requests);
        $user->lastlogin = DB::raw('now()');
        $user->save();
        $profileNames = Profile::where("user_id", $user->id)->get(['id', 'name', 'is_variantions']);
        $paid_at = $user->paid_at;
        $user->profileData = $profileNames;
        $created_at = $user->created_at;
        $review = $user->review;
        // $eb_key = EbKey::where('user_id', $user->id)->first();
        // $eb_keyCount = EbKey::where('user_id', $user->id)->count();
        $eb_keys = EbKey::where('user_id', $user->id)->get();
        $eb_key = $eb_keys->first();
        $eb_keyCount = $eb_keys->count();
 
        $fromtime = new Carbon($paid_at);
        if (strtotime($paid_at) < 1) {
            $fromtime = new Carbon($created_at);
        }
 
        $countkeys = EbKey::where('user_id', '=', $user->id)->count();
 
        $user->eb_key = $eb_key;
        $now = Carbon::now();
        $difference = $fromtime->diffInDays($now);
        //Log::info("difference == ".$difference);
        if ($difference > 30 && $user->sync == 0 && $user->review == 0) {
            $user->expired = 1;
        } else if ($difference > 60 && $user->sync == 0 && $user->review == 1) {
            $user->expired = 1;
        } else {
            $user->expired = 0;
        }
        $user->expired = 0;
        $user->countkeys = $countkeys;
        $ebKey = $user->ebKey()->first();
        if (!$ebKey) {
            $user->ebtoken = 0;
        } else {
            $expirydate = $ebKey->expirydate;
            $expirytime = new Carbon($expirydate);
            $expdifference = $now->diffInDays($expirytime, false);
            if ($ebKey->valid == 0 || $expdifference < 15) {
                $user->ebtoken = 2;
            } else {
                $user->ebtoken = 1;
            }
        }
        $planprice = 0;
        if ($user->plan == 1) {
            $planprice = 19.99;
        } else if ($user->plan == 2) {
            $planprice = 29.99;
        } else if ($user->plan == 3) {
            $planprice = 59.99;
        }
        $user->planprice = $planprice;
        if ($sh_requests_pending === 1 && $sh_requests === 1) {
            $user->sh_requests = 0;
            $user->sh_requests_pending = 1;
        }else if ( $sh_requests === 1){
            $user->sh_requests_pending = 2;
            $user->sh_requests = $sh_requests;
        }else{
            $user->sh_requests = $sh_requests;
            $user->sh_requests_pending = $sh_requests_pending;
        }
        $user->eb_keysCount = $eb_keyCount;
        $user->ebrequest = $ebayrequeststatus;
 
        $user->shproducts = $user->summary->shopify_products ?? 0;
        $user->ebproduct = $user->summary->ebay_products ?? 0;
        $user->importedproducts = $user->summary->imported_ebay_products ?? 0;
        $user->TotalImportedproducts = (int) ($user->summary->imported_ebay_products ?? 0) + (int) ($user->summary->imported_shopify_products ?? 0);
        //$user->TotalImportedproducts = 0;
        $user->showpop = 0;
       
        if ($user->usermsg == 'shtoeb') {
            $user->showpop = 1;
        }
        if ($eb_pending_request == 1) {
            $user-> eb_pending_request =  $eb_pending_request;
        }else{
            $user-> eb_pending_request =  2;
        }
 
        $settings = $user->settings()->first();
 
        if (!$settings) {
            $settingObj = new Setting;
            $settingObj->published = 1;
            $settingObj->tags = "";
            $settingObj->vendor = "";
            $settingObj->product_type = "";
            $settingObj->inventory_policy = "shopify";
            $settingObj->inventory_sync = 0;
            $settingObj->price_sync = 0;
            $settingObj->outofstock_action = "outofstock";
            $settingObj->desc_cond = 0;
            $settingObj->desc_itemspecs = 0;
            $settingObj->markupenabled = 0;
            $settingObj->markuptype = 'FIXED';
            $settingObj->markupval = 0;
            $settingObj->markupround = 0;
            $user->settings()->save($settingObj);
 
        }
 
        try {
            // verify the credentials and create a token for the user
            if (!$token = JWTAuth::fromUser($user)) {
                return response()->json(['error' => 'Invalid Credentials'], 401);
            }
        } catch (JWTException $e) {
            // something went wrong
            return response()->json(['error' => 'could_not_create_token'], 500);
        }
        return response()->json(compact('token', 'user'));
    }
	public function getUserDetail(Request $request)
	{
		$tempcode = $request->input("key");

		if (empty($tempcode)) {
			return response()->json(['error' => 'Invalid Credentials'], 401);
		}

		$user = User::where('tempcode', $tempcode)->first(['shopurl','SetupStep','id']);
		$vproducts = Product::where('user_id', '=', $user->id)->where('status', '=', 'Imported')->count();
		// $ShopifyProduct = ShopifyProduct::where('user_id', '=', $user->id)->where('status', '=', 'Imported')->count();
		$user->TotalImportedproducts = (int) $vproducts + (int)0;// $ShopifyProduct;

		if (!$user) {
			return response()->json(['error' => 'User not found'], 404);
		}

		return response()->json(['success' => $user], 200);
	}
    public function productCounts(Request $request) {
        $userId = $request->query('userId'); 
        Log::info('User ID: ' . $userId);

        $sproducts = ShopifyProduct::where('user_id', $userId)->count();
        $products = Product::where('user_id', $userId)->count();
        $vproducts = Product::where('user_id', $userId)->where('status', 'Imported')->count();
        $ShopifyProduct = ShopifyProduct::where('user_id', $userId)->where('status', 'Imported')->count();

        $TotalImportedproducts = (int) $vproducts + (int) $ShopifyProduct;

        $data = [
            'TotalImportedproducts' => $TotalImportedproducts,
            'shproducts' => $sproducts,
            'ebproduct' => $products
        ];

        return response()->json($data);
    }
}