<?php

namespace App\Http\Controllers;

use App\EbKey;
use App\EbRequest;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Collection;
use App\Product;
use App\Http\Requests;
use Validator;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class EbConfigController extends Controller {

	public function __construct() {
        // Apply the jwt.auth middleware to all methods in this controller
        // except for the authenticate method. We don't want to prevent
        // the user from retrieving their token if they don't already have it
        $this->middleware('jwt.auth', ['except' => ['authenticate']]);
    }

    public function index() {
		$currUser = Auth::User();
		$ebKey = $currUser->ebKey()->first();
		if(!$ebKey){
			return response()->json([], 201);
		} else {
			$ebObject = Auth::User()->ebKey()->get();
			$now = Carbon::now();
			// $expirydate = $ebObject->expirydate;
		    // $expirytime = new Carbon($expirydate);
		    // $expdifference = $now->diffInDays($expirytime, false);
		    // if($expdifference < 15){
		    //     $ebObject->valid = 0;
		    // }
			// if($currUser->id == 212){
			// 	$ebObject->sellerid = "uk-sky-1 and *lowestpriceguarantee*";
			// } else if($currUser->id == 818){
			// 	$ebObject->sellerid = "manortel, manmanotele, amrik-2012, arveensingh2012, shop12016, rickys079";
			// } else if($currUser->id == 4856){
            //     $ebObject->sellerid = "protechtools,protechtoolsonline";
            // } else if($currUser->id == 5500){
            //     $ebObject->sellerid = "little_red_shark,lastnorman";
            // } else if($currUser->id == 1054){
            //     $ebObject->sellerid = "its_simples,webuyanytelly";
            // } else if($currUser->id == 5780){
            //     $ebObject->sellerid = "polskie_suplementy, cosmelogia, aroma-teas and eqvilibri-trade";
            // } else if($currUser->id == 5433){
            //     $ebObject->sellerid = "luxykarat,916au,forever22karat";
            // } else if($currUser->id == 6143){
            //     $ebObject->sellerid = "graded-appliances-786,bigdiscountelectricalappliances";
            // } else if($currUser->id == 3431){
            //     $ebObject->sellerid = "thebluetulipconsignment, thebluetulipshapewear";
            // } else if($currUser->id == 8282){
            //     $ebObject->sellerid = "safeplace246, styledunder25";
            // } else if($currUser->id == 8870){
            //     $ebObject->sellerid = "cavalierpostcards, nostalgiapostcards";
            // } else if($currUser->id == 9276){
            //     $ebObject->sellerid = "mother_natures_showroom, edynamicmarketing";
            // } else if($currUser->id == 9059){
            //     $ebObject->sellerid = "designerrose, janilynscloset";
            // } else if($currUser->id == 9750){
            //     $ebObject->sellerid = "curtain_lining_uk, pandoras-upholstery";
            // } else if($currUser->id == 15107){
            //     $ebObject->sellerid = "njicoins and mygoldhands";
            // } else if($currUser->id == 13686){
            //     $ebObject->sellerid = "nowandforeverjewels and nowandforeverjewelry";
            // } else if($currUser->id == 14562){
            //     $ebObject->sellerid = "king_salvage_spare_parts and parts4u2011krcarpartsltd";
            // } else if($currUser->id == 10955){
            //     $ebObject->sellerid = "hubdental and 2thdrdental";
            // } else if($currUser->id == 15205){
            //     $ebObject->sellerid = "srsserviceprogram, kingsautopart and insideautopart";
            // } else if($currUser->id == 16647){
            //     $ebObject->sellerid = "lucky*diamonds, myluckydiamonds and luckydiamonds";
            // } else if($currUser->id == 9256){
            //     $ebObject->sellerid = "personal.car and outlet-ricambi";
            // } else if($currUser->id == 17382){
            //     $ebObject->sellerid = "bocamedtech and bocamedandtech";
            // } else if($currUser->id == 3747){
            //     $ebObject->sellerid = "thecarpartsclub and vauxcentre";
            // } else if($currUser->id == 16834){
            //     $ebObject->sellerid = "utvsalvage and utvsalvageinc";
            // }
            //  else if($currUser->id == 20507){
            //     $ebObject->sellerid = "ugo-autoteile and hugo-autoteile";
            // } 
            //   else if($currUser->id == 21114){
            //     $ebObject->sellerid = "dab-online and dabbletrading";
            // }  
            // else if($currUser->id == 19680){
            //     $ebObject->sellerid = "grayhawk19 and southwest217";
            // }  
            // else if($currUser->id == 16968){
            //     $ebObject->sellerid = "seba_281 and jabogbr";
            // }  
            // else if($currUser->id == 22794){
            //     $ebObject->sellerid = "4u-carparts and novacarparts";
            // } 
            // else if($currUser->id == 23005){
            //     $ebObject->sellerid = "toadstool_seeds and happygrowingplants";
            // } 
            // else if($currUser->id == 17540){
            //     $ebObject->sellerid = "wheelersndealers2020 and wheelersndealers";
            // } 
          
            foreach ($ebObject as $ebObjects) {
                // $expirydate = $ebObjects->expirydate; // Accessing 'expirydate' attribute of the model
                // $expirytime = new Carbon($expirydate);
                // $expdifference = $now->diffInDays($expirytime , false);
            
                // Log::info('Difference in days: ' . $expdifference);
            
                // if ($expdifference < 15) {
                //     $ebObjects->valid = 0; // Update 'valid' attribute of the model
                //     $ebObjects->save(); // Save the changes to the database
                // }
                $addprodcut[] = $ebObjects;

            }
			// return $ebObject;
            return ['ebkeys' => $addprodcut];

			// return $ebObject;
		}
    }

	public function fetch(Request $request) {
		$currUser = Auth::User();
		$ebKey = $currUser->ebKey()->first();
		if(!$ebKey){
			return response()->json(['error' => ["msg"=>['eBay account is not configured.']]], 406);			
		}

		$existingRequests = $currUser->ebRequests()->where('status', '!=', 'completed')->first();
		if($existingRequests){
			return response()->json(['error' => ["msg"=>['A request to fetch eBay products is already in progress. Please check the product page after a few moments.']]], 406);	

		
		}

		$ebRequestObject = EbRequest::create(array("status" => "pending"));
		$currUser->ebRequests()->save($ebRequestObject);
		return response()->json(['success'], 200);		
    }

	public function status(Request $request) {
		$currUser = Auth::User();
		$ebKey = $currUser->ebKey()->first();
		if(!$ebKey){
			return response()->json(['status' => "EB_KEY_NOT_EXIST"], 200);		
		} 
		$existingRequests = $currUser->ebRequests()->where('status', '!=', 'completed')->first();
		if($existingRequests){
			return response()->json(['status' => "REQUEST_IN_PROGRESS"], 200);						
		}
        $existingRequestscomplete = $currUser->ebRequests()->where('status', '=', 'completed')->first();
        $products =Product::where('user_id', '=',$currUser->id)->count();
		if($existingRequestscomplete && $products == 0){
			return response()->json(['status' => "NO_ACTIVE_PRODUCT"], 200);						
		}			
		return response()->json(['status' => "NO_PRODUCT"], 200);
    }

        public function getEbayAccounts(){
        $currUser = Auth::User();
        $ebKey = $currUser->ebKey()->get();
        if($ebKey){
            return response()->json($ebKey, 200);
        }
        return response()->json(["No records found"], 200);
    }
}
