<?php

namespace App\Http\Controllers;
use App\ProcessEbayImport;
use App\EbayCategories;
use App\EbayItemCondition;
use App\EbKey;
use App\Profile;
use App\Libraries\Ebay;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Log;
use PhpParser\Node\Stmt\Return_;
use Validator;

require '/home/cp1infoshoreapps/public_html/updatedepi/api/ebay_sdk/vendor/autoload.php';
// use \DTS\eBaySDK\Constants;
use \DTS\eBaySDK\BusinessPoliciesManagement\Services;
use \DTS\eBaySDK\BusinessPoliciesManagement\Types;
// use DTS\eBaySDK\Trading\Services;
// use DTS\eBaySDK\Trading\Types;
use DTS\eBaySDK\Trading\Enums;
use \DTS\eBaySDK\Constants;


use function GuzzleHttp\json_decode;

class ProfileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

     public function __construct() {

        $this->middleware('jwt.auth', ['except' => ['authenticate']]);
    }
    public function index()
    {
        Log::info("inside profileController");
		$currUser = Auth::User();
        return $currUser->profiles()->orderBy('id', 'desc')->get();

    }
    public function sellerProfile()
    {
        Log::info( "seller profile inside");
        Log::info("inside profileController sellerProfile");
		$currUser = Auth::User();
        Log::info("user data ");
        Log::info($currUser);
        $payment =  $currUser->sellerProfiles()->where('type','PAYMENT')->get();
        if ($payment->count() === 0) {
           return  $this->refreshShoppingProfile();
        }
        $RETURN_POLICY =  $currUser->sellerProfiles()->where('type','RETURN_POLICY')->get();
        $SHIPPING =  $currUser->sellerProfiles()->where('type','SHIPPING')->get();
        return [
            'shipping_policies'=>$SHIPPING,
            'payment_policies'=> $payment,
            'return_policies'=>$RETURN_POLICY
        ];

    }

    public function sellerProfileUpdate(Request $request){
        Log::info($request);
    }

       public function fetchItemCondition(Request $request) {
            $currUser = Auth::User();
            $ebKey = $currUser->ebKey()->first();
            $siteid = $ebKey->siteid;
            $condition = array();
            $RECOMMENDED = array();
            $duration_enanle = 0;
            
            $ebay_categories = EbayCategories::where('id',$request->category_id)->where('ebay_site',$siteid)->where('is_last_level',1)->where('treeid',$siteid)->first();
            $category_attributes = $ebay_categories->category_attributes;
            Log::info( $category_attributes);
            $categoryFeature  = json_decode($ebay_categories->category_info,true);
            if(is_array($category_attributes) && !empty($category_attributes)){
                $this->fetchCategoryAttribute($ebay_categories	,$currUser,$ebKey);
                $ebay_categories = EbayCategories::where('id',$request->category_id)->where('ebay_site',$siteid)->where('is_last_level',1)->where('treeid',$siteid)->first();
                $category_attributes = json_decode( $ebay_categories->category_attributes,true);
            }
            // Log::info($ebay_categories);
    $data = json_decode( $category_attributes, true);

        Log::info(   $data);

        
            foreach( $data as $attribute){
                if($attribute['aspectUsage'] == 'RECOMMENDED'){
                    $RECOMMENDED[$attribute['name']] = $attribute['values'];
                }
            }
            if (isset($categoryFeature['Category']['ConditionValues'])) {
                # code...
                $condition = $categoryFeature['Category']['ConditionValues']['Condition'];
            }
            $variationSupported = $categoryFeature['Category']['VariationsEnabled'] ?? false;
            $productType  =  '';
            if (isset($categoryFeature['Category']['EANEnabled']) ) {
                $productType = 'EAN';
            }else  if (isset($categoryFeature['Category']['UPCEnabled'])) {
                $productType = 'UPC';
            } else if (isset($categoryFeature['Category']['ISBNEnabled']) ) {
                $productType = 'ISBN';
            }else  if (isset($categoryFeature['Category']['BrandMPNIdentifierEnabled'])) {
                $productType = 'BrandMPN';
            }else{
                $productType = 'ALL';
            }
            return [
                'recommended'=> $RECOMMENDED,
                'condition'=> $condition,
                'ebay_category_id'=>$ebay_categories->ebay_category_id,
                'is_variantions'=>$variationSupported,
                'productTypeEnable'=>true,
                "productType"=>$productType
            ];
    }

    public function fetchCategoryAttribute(   $category_attributes,$user,$ebKey){
        $siteid = $ebKey->siteid;
        $accessToken = 'v^1.1#i^1#p^1#I^3#r^0#f^0#t^H4sIAAAAAAAA/+VYbWwURRjutddihVYLogiNORbKD8ju7cft3t3SO3L9Pilt6R0tkBjcj9l26d3usjPb9kowbaONMVFDIkYwCmgkTYwxIRFjJaJoEPwBImlCghpRUflI/AEoRBF3r0e5VgJIL7GJ9+cy77zzzvM8874zs0P2FxUvHWoY+r3ENSN/Vz/Zn+9yUTPJ4qLCZaUF+fML88gsB9eu/sX97sGCXyqhkEwYfCuAhq5B4OlNJjTIp40hzDI1XhegCnlNSALII4mPRVY18jRB8oapI13SE5gnWhPCgBBQGJmjKeCTZMbns63ajZhxPYRRCs2JfkmSOYqiacHuhtACUQ0iQUMhjCZpFidZnPbHyQDvC/AsQ7Acsx7ztAETqrpmuxAkFk6j5dNjzSyot0cqQAhMZAfBwtFIXaw5Eq2pbYpXerNihTMyxJCALDixVa3LwNMmJCxw+2lg2puPWZIEIMS84bEZJgblIzfA3AP8tNKyjxJEjmMUkZRsTdmcSFmnm0kB3R6HY1FlXEm78kBDKkrdSVFbDXEjkFCm1WSHiNZ4nL/VlpBQFRWYIay2KrIu0tJix9IUPdapm3hs5ZoqSxQTeEtrDe6jFTZA+QGNCywggxzlz0w0Fi0j86SZqnVNVh3RoKdJR1XARg0ma8NkaWM7NWvNZkRBDqIsP4q8oSFLr3cWdWwVLdSpOesKkrYQnnTzziswPhohUxUtBMYjTO5ISxTCBMNQZWxyZzoXM+nTC0NYJ0IG7/X29PQQPQyhmx1emiQp79pVjTGpEyTtYrN9nVpP+6t3HoCraSoSsEdClUcpw8bSa+eqDUDrwMI0zfmCbEb3ibDCk63/MGRx9k6siFxViJ0rXNAvi76gokgBISebTTiTpF4HBxCFFJ4UzC6AjIQgAVyy88xKAlOVeYZVaCagAFzmggruQMBFVuZwSgGABEAUpWDg/1Qod5vqMSCZAOUm13OV58uC7fW15JqUVd0t9FHG2npEdYuaKlCxaF0L29dhxZOrA1HKq7T6QndbDbckX51QbWXi9vw5EcCp9ZyJ0KBDBOQp0YtJugFa9IQqpabXAjOm3CKYKBUDiYRtmBLJiGFEc7RX54rev9wm7o13Ds+o/+Z8uiUr6KTs9GLljId2AMFQCecEIiQ96dWdWhfs64dj3pBGPSXeqn1znVasbZJjbFV57MpJ6A5dAnZLhAmgbpn2bZtodm5gcb0LaPZ5hkw9kQBmGzXlek4mLSSICTDdCjsHCa4K0+ywpfy+AMOwfoaZEi8pfZRumG5bUk62YnfdvV2rvRO/8cN56R816DpIDro+yne5yEqyglpELiwqWOMumDUfqggQqqAQUO3Q7G9XExBdIGUIqpk/J+9YaaM80NB4uV+03m+/tCKQV5L1xLDrCXLe+CNDcQE1M+vFgSy/2VNIPfBICc2SLO0nA74Ay6wnF93sdVMPux+au2Pbu5UDM6t/dpeeUD6fsSN/9otBsmTcyeUqzHMPuvKG9w5WHT4559rHby08dPqTeq+4ds+jXWX78wS0crNe90M3t/1YaPjc+ZUvzdsUPndly+Jn/6w4dNGoqawolwe3pIqazkSeaz5ZtvfA2eG+sqG2p3cvOB+Xrz7fvvPL4k0n2FfnLr8y8uDZzaPvtbdtLPwxdAHbd+ZUx8X4C7N/e5y7/75atfrq7s4lStESaejCCi9+/Pt3RkYPrd7f2rsQvrIEfv3kyIzPtnKrXnuDO7P8zYomwv/BY0Rf+9Gj3X+N7lxwIDrr1MDr5V+tuxwv3/RFz7ZL1wfa920/V99w+MPRnj3xI0t/LT89/N2R0tay66cPLP7pqaGXl11zfxs8Xnxw+9uu0dQfm7c8882nl0bG1vJvjbY6WfwRAAA=';
        $aspects = [];
         	  
		$values = [
			0 => 'EBAY-US',
			2 =>'EBAY-CA',
			3 => 'EBAY-GB',
			15 =>'EBAY-AU',
			16 => 'EBAY-AT',
			23 =>'EBAY-FRBE',
			71=>'EBAY-FR',
			77 => 'EBAY-DE',
			100 =>'EBAY-MOTOR',
			101 => 'EBAY-IT',
			123 => 'EBAY-NLBE',
			146 => 'EBAY-NL',
			186 =>'EBAY-ES',
			193 => 'EBAY-CH',
			201 => 'EBAY-HK',
			205 => 'EBAY-IE',
			207 => 'EBAY-MY',
			210 => 'EBAY-FRCA',
			211 => 'EBAY-PH',
			212 =>'EBAY-PL',
			216 => 'EBAY-SG'
		];
         print_r("2222222222");
        $marketplace = "";
		
		foreach($values as $key => $value){
			if($siteid ==  $key){
				$marketplace = $value;
				break;
			}
		}
        $result = json_decode($category_attributes,true);

        $catid = $result['ebay_category_id'];
        $treeid = $result['treeid'];
        $esite_id = $result['ebay_site'];
        $marketplaceID12 =$marketplace;
        $url ="https://api.ebay.com/commerce/taxonomy/v1/category_tree/".$treeid."/get_item_aspects_for_category?category_id=".$catid."";
        
        $responsetree = $this->callUrl($url,$accessToken,$marketplaceID12);
        	  if (isset($responsetree['aspects']) && $responsetree['aspects']) {
					  print_r("item specifics found");
						foreach ($responsetree['aspects'] as $aspect) {
						   
							 $values = [];
							 if(isset($aspect['aspectValues']) && $aspect['aspectValues']){
							   foreach ($aspect['aspectValues'] as $aspectValue) {
								   $values[] = $aspectValue['localizedValue'];
							   }
							}
								 $aspects[] = [
									   'name' => $aspect['localizedAspectName'],
									   'type' => $aspect['aspectConstraint']['aspectDataType'],
										'selection_mode' => $aspect['aspectConstraint']['aspectMode'],
									    'values' => $values,
										'aspectUsage' => $aspect['aspectConstraint']['aspectUsage'],
									   'min_values'=>0,
									   'max_values'=>1,
								 ];
					 }
				 }
			 $attr = json_encode($aspects);
            $ebay_categories = EbayCategories::where('ebay_category_id',$catid)->where('ebay_site',$siteid)->update(['category_attributes' => $attr]);

    }
    public function callUrl($url,$accessToken,$marketplaceID) {
		  $headers = [
			  'Content-Type: application/json',
			  'Authorization: Bearer '. $accessToken,
			  'X-EBAY-C-MARKETPLACE-ID: '.$marketplaceID, // Replace with your marketplace ID if different
			  'X-EBAY-C-ENDUSERCTX: affiliateCampaignId=<ePNCampaignId>,affiliateReferenceId=<referenceId>',
			  'X-EBAY-REQUEST-ID: ' . uniqid()
		  ];
		  $ch = curl_init();
		  
		  // Set cURL options
		  curl_setopt_array($ch, [
			  CURLOPT_URL => $url,
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_HTTPHEADER => $headers,
			  CURLOPT_HEADER => false,
			  CURLOPT_CUSTOMREQUEST => 'GET',
			  CURLOPT_FOLLOWLOCATION => true,
		  ]);
		  
		  $response = curl_exec($ch);
		  if (curl_errno($ch)) {
			  exit;
		  }
		  
		  curl_close($ch);
		  
		  $responseData = json_decode($response,true);
		  
		  log::info("responsetree222222 ->".json_encode($responseData,true));
 
		 return $responseData;
		 
		  
    }
    public function refreshShoppingProfile(){
        $currUser = Auth::user();
        $eb_key =EbKey::where('user_id',$currUser->id)->first();
        
        $site_id = $eb_key->siteid;
        $token = $eb_key->token;
        $globalId = Constants\GlobalIds::US;
        if($site_id == 2){
            $globalId = Constants\GlobalIds::ENCA;
        }
        else if($site_id == 3){
            $globalId = Constants\GlobalIds::GB;
        }
        else if($site_id == 15){
            $globalId = Constants\GlobalIds::AU;
        }
        else if($site_id == 23){
            $globalId = Constants\GlobalIds::FRBE;
        }
        else if($site_id == 71){
            $globalId = Constants\GlobalIds::FR;
        }
        else if($site_id == 77){
            $globalId = Constants\GlobalIds::DE;
        }
        else if($site_id == 203){
            $globalId = Constants\GlobalIds::IN;
        }
        else if($site_id == 210){
            $globalId = Constants\GlobalIds::FRCA;
        }
        else if($site_id == 216){
            $globalId = Constants\GlobalIds::SG;
        }
        else if($site_id == 207){
            $globalId = Constants\GlobalIds::MY;
        }
        else if($site_id == 205){
            $globalId = Constants\GlobalIds::IE;
        }
        else if($site_id == 186){
            $globalId = Constants\GlobalIds::ES;
        }
        else if($site_id == 101){
            $globalId = Constants\GlobalIds::IT;
        }
        $ebConfig = config('ebay.ebConfig');
        
        $ebayService = new Services\BusinessPoliciesManagementService([
            'credentials' => $ebConfig['production']['credentials'],
            'authToken'   => $token,
            'globalId'    => $globalId
        ]);

        Log::info($ebConfig);
        $ebayRequest = new Types\GetSellerProfilesRequest();
        $ebayResponse = $ebayService->getSellerProfiles($ebayRequest);
        $ebayResponse = ($ebayResponse) ? $ebayResponse->toArray() : array();
        

        Log::info("ebay response ");
        Log::info($ebayResponse);
        if ($ebayResponse['ack'] =='Success') {
             $paymentProfiles = (isset($ebayResponse["paymentProfileList"])) ? $ebayResponse["paymentProfileList"]["PaymentProfile"] : array();
             if($paymentProfiles){
                 foreach($paymentProfiles as $profile){
                      Log::info("ebayy payment profile recvd");
                     $profileId = $profile["profileId"];
                     $profileType = $profile["profileType"];
                     $profileName = $profile["profileName"];

                     $profileInDB = $currUser->sellerProfiles()->where('seller_profile_id',$profileId)->first();

                     if($profileInDB){
                        Log::info("inside update condition");
                        $profileInDB->name =$profileName;
                        $profileInDB->type = $profileType;
                        $profileInDB->seller_profiles_data = json_encode($profile);
                        $profileInDB->save();

                     }else{
                        $payment_profile_id[] = $profileId; 

    
                        $proData = array(
                            "seller_profile_id"=>$profileId,
                            "name"=>$profileName,
                            "type"=>$profileType,
                            "seller_profiles_data"=> json_encode($profile),
                            "user_id"=>$currUser->id
                        );

                       $currUser->sellerProfiles()->create($proData);
                         Log::info('$paymentProfiles created');
                     }  
                     }
                 }
             }

             $returnPolicyProfiles = (isset($ebayResponse["returnPolicyProfileList"])) ? $ebayResponse["returnPolicyProfileList"]["ReturnPolicyProfile"] : array();
             Log::info('returnPolicyProfiles started');
         
             if($returnPolicyProfiles){
                  Log::info("ebayy reponse return policy recvd");
                 foreach($returnPolicyProfiles as $profile){
                     $profileId = $profile["profileId"];
                     $profileType = $profile["profileType"];
                     $profileName = $profile["profileName"];
                     $return_profile_id[] = $profileId;
                     $profileInDB = $currUser->sellerProfiles()->where('seller_profile_id',$profileId)->first();

                     if($profileInDB){
                        Log::info("inside update condition");
                        $profileInDB->name =$profileName;
                        $profileInDB->type = $profileType;
                        $profileInDB->seller_profiles_data = json_encode($profile);
                        $profileInDB->save();

                     }else{
                        Log::info("ebayy profile was not in db already");
                        $proData = array(
                            "seller_profile_id"=>$profileId,
                            "name"=>$profileName,
                            "type"=>$profileType,
                            "seller_profiles_data"=> json_encode($profile),
                            "user_id"=>$currUser->id
                        );
                       $currUser->sellerProfiles()->create($proData);

                     }  
               
                          Log::info('returnPolicyProfiles saved as it was not in db');
                     
                 }
             }

             $shippingPolicyProfiles = (isset($ebayResponse["shippingPolicyProfile"])) ? $ebayResponse["shippingPolicyProfile"]["ShippingPolicyProfile"] : array();
             Log::info('shippingPolicyProfiles starts');
             
         
             if($shippingPolicyProfiles){
                 foreach($shippingPolicyProfiles as $profile){
                     $weight_required = 0;
                     $shippingService_name = $profile["shippingPolicyInfo"]['domesticShippingType'];
                         Log::info('shippingPolicyProfiles starts' . $profile["shippingPolicyInfo"]['domesticShippingType']);

                     $profileId = $profile["profileId"];
                     $profileType = $profile["profileType"];
                     $profileName = $profile["profileName"];
                     $shipping_profile_id[] = $profileId;
                     $profileInDB = $currUser->sellerProfiles()->where('seller_profile_id',$profileId)->first();

                     if($profileInDB){
                        Log::info("inside update condition");
                        $profileInDB->name =$profileName;
                        $profileInDB->shippingService_name = $shippingService_name;
                        $profileInDB->type = $profileType;
                        $profileInDB->seller_profiles_data = json_encode($profile);
                        $profileInDB->save();
                     }else{
                        Log::info("ebayy profile was not in db already");
                        $proData = array(
                            "seller_profile_id"=>$profileId,
                            "name"=>$profileName,
                            "type"=>$profileType,
                            "shippingService_name"=>$shippingService_name,
                            "weight_required"=>$weight_required,
                            "seller_profiles_data"=> json_encode($profile),
                            "user_id"=>$currUser->id
                        );
                       $currUser->sellerProfiles()->create($proData);

                     }  
              

                         Log::info('shippingPolicyProfiles ended');
                     
                 }
             }
        //     $businessPolicies =  $currUser->sellerProfiles()->get();
      
        //   // Organize policies into categories
        //   $paymentPolicies = [];
        //   $returnPolicies = [];
        //   $shippingPolicies = [];
  
        //   foreach ($businessPolicies as $policy) {
             
        //       $profileData = [
        //           'ProfileID' => $policy['seller_profile_id'],
        //           'ProfileName' => $policy['name'],
        //           'ID' => $policy['id'],
        //       ];
  
        //       // Categorize based on ProfileType
        //       switch ($policy['type']) {
        //           case 'PAYMENT':
        //               $paymentPolicies[] = $profileData;
        //               break;
        //           case 'RETURN_POLICY':
        //               $returnPolicies[] = $profileData;
        //               break;
        //           case 'SHIPPING':
        //               $shippingPolicies[] = $profileData;
        //               break;
        //       }
        //   }
        //   // Attach business policies to the profile response
        //   return [
        //       'payment_policies' => $paymentPolicies,
        //       'shipping_policies' => $shippingPolicies,
        //       'return_policies' => $returnPolicies,
        //   ];
            $payment =  $currUser->sellerProfiles()->where('type','PAYMENT')->get();
        // if ($payment->count() === 0) {
        //    return  $this->refreshShoppingProfile();
        // }
        $RETURN_POLICY =  $currUser->sellerProfiles()->where('type','RETURN_POLICY')->get();
        $SHIPPING =  $currUser->sellerProfiles()->where('type','SHIPPING')->get();
        return [
            'shipping_policies'=>$SHIPPING,
            'payment_policies'=> $payment,
            'return_policies'=>$RETURN_POLICY
        ];


    }   

    public function createData(){
        $currUser = Auth::user();
        Log::info('inside createData funtion ');
        Log::info($currUser);
        $shopurl = $currUser->shopurl;
        $token = $currUser->token;

    //    $response = $this->getShopifyLocation($shopurl,$token);

       $locations = [];

        // foreach ($response['data']['locations']['edges'] as $edge) {
        //     $node = $edge['node'];
        //     $country = array(
        //         'name'=>$node['address']['country'],
        //         'code'=>$node['address']['countryCode']
        //     );
        //     $locations[$node['name']] = [
        //         'country' =>$country,
        //         'postal'  => $node['address']['zip'],
        //     ];
        // }


        return [
            'locations'=>$locations
        ];


    }
    

    public function copyProfile($profile_id)
    {
        Log::info("Inside copyProfile with ID: " . $profile_id);

        $currUser = Auth::user();

        // Fetch original profile
        $profile = $currUser->profiles()->where('id', $profile_id)->first();

        if (!$profile) {
            return response()->json(['error' => ['msg' => ['Profile not found.']]], 404);
        }

        $newProfileName = 'Copy of ' . $profile->name;

        // Check if the copied name already exists
        $checkProfile = $currUser->profiles()->where('name', $newProfileName)->first();

        if ($checkProfile) {
            return response()->json(['error' => ['msg' => ['This profile already exists.']]], 406);
        }

        // Duplicate profile
        $newProfile = $profile->replicate(); 
        $newProfile->name = $newProfileName;
        $newProfile->user_id = $currUser->id; 
        $newProfile->save();

        return response()->json(['success' => true, 'message' => 'Profile copied successfully.', 'profile' => $newProfile]);
    }

    public function deleteProfile($profile_id)
    {
        Log::info("inside of deleteProfile " . $profile_id);
        $currUser = Auth::user();
        $profile = $currUser->profiles()->where('id', $profile_id)->first();
    
        if (!$profile) {
            return response()->json(['error' => ['msg' => ['Profile not found.']]], 404);
        }
    
        // Check the total number of profiles for the user
        $profileCount = $currUser->profiles()->count();
    
        if ($profileCount <= 1) {
            return response()->json(['error' => ['msg' => ['Cannot delete the last profile. At least one profile must exist.']]], 403);
        }
    
        try {
            $profile->delete(); // Or $profile->forceDelete() for permanent deletion
            Log::info("Profile deleted: " . $profile_id);
            return response()->json(['message' => 'Profile deleted successfully'], 200);
        } catch (\Exception $e) {
            Log::error("Error deleting profile: " . $e->getMessage());
            return response()->json(['error' => ['msg' => ['Failed to delete profile.']]], 500);
        }
    }

    
    public function create(Request $request)
    {
        Log::info($request);
        $data = $request->productDateToSave;
        $user = Auth::user();
        $sh_product_id = '';
        if ($request->sh_product_id) {
            $sh_product_id = $request->sh_product_id;
        }
        Log::info($data);
    
        Log::info("Creating profile", ['request' => $data]);
       
        $profile = new Profile([
            'name' => $data['name'] ?? null,
            'ebay_category_1' => $data['ebay_categoryid1'] ?? null,
            'ebay_category_id' => $data['ebay_category_id'] ?? null,
            'is_variantions' => $data['is_variantions'] ?? null,
            'shipping_profile' => $data['businessPolicies']['Shipping'] ?? null,
            'payment_profile' => $data['businessPolicies']['Payment'] ?? null,
            'return_profile' => $data['businessPolicies']['Return'] ?? null,
        ]);
    
        if (!empty($data['item_specific'])) {
            $profile->item_specifics = json_encode($data['item_specific'],true);
        }
        if (!empty($data['category_attributes'])) {
            $profile->category_attributes = json_encode($data['category_attributes'],true);
        }
    
        if (isset($data['productType'])) {
            $profile->product_id_type = json_encode($data['productType']);
        }
    
        $profile->item_condition = is_array($data['item_condition'] ?? null) 
            ? json_encode($data['item_condition']) 
            : ($data['item_condition'] ?? null);
    
        $profile->item_condition_data = is_array($data['item_condition_data'] ?? null) 
            ? json_encode($data['item_condition_data']) 
            : null;
    
        $profile->user_id = $user->id;
        Log::info('Saving profile', ['profile' => $profile]);
        $profile->save();
        $productId = $data['importproductId'] ?? null ;
        $profileId = $profile->id;
        if($productId){
            $productStatusUpdate = $user
            ->sh_products()
            ->where("id", $productId)
            ->update([
                "status" => "Import In Process",
                "profile_id" => $profileId,
            ]);
            $importRequest = ProcessEbayImport::create([
                "status" => "pending",
                "sh_product_id" => $productId,
            ]);
            $user->processebayimports()->save($importRequest);
            Log::info('productId', ['profile' => $productId . ' '. $profileId ]);
        }


        Log::info($profile);

        $ebaySiteId = $user->ebKey()->value('siteid');
        
        if($ebaySiteId == 0){
            $profileData["sales_tax_rate"] = 19.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "USPSFirstClass";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
          
            
            }elseif($ebaySiteId == 3){
            $profileData["sales_tax_rate"] = 19.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "UK_PackLinkPostable";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
           
            
            }elseif($ebaySiteId == 2){
            $profileData["sales_tax_rate"] = 19.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "CA_EconomyShipping";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
           

            }elseif($ebaySiteId == 77){
            $profileData["sales_tax_rate"] = 19.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "DE_StandardDispatch";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
          
                
            }elseif($ebaySiteId == 15){
            $profileData["sales_tax_rate"] = 19.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "AU_StandardDelivery";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
            

            }
            elseif($ebaySiteId == 101){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "IT_ExpressCourier";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
           

            }
            elseif($ebaySiteId == 16){

            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "AT_InsuredDispatch";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
          
            }
            elseif($ebaySiteId == 23){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "BEFR_LaPosteStandardShipping";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
           
            }
            elseif($ebaySiteId == 71){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "FR_Chronopost";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
          
            }
            elseif($ebaySiteId == 77){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "DE_StandardDispatch";
            $profileData["ship_fee1"] = 4.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
            
            }
            elseif($ebaySiteId == 123){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "BENL_PriorityDelivery";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
           
            }
            elseif($ebaySiteId == 146){

            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "NL_StandardDelivery";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
        
            }
            elseif($ebaySiteId == 186){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "ES_EnvioEstandarALasIslasCanarias";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
        
            }
            elseif($ebaySiteId == 193){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "CH_StandardDispatchAPost";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
            }
            elseif($ebaySiteId == 205){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "IE_SellersStandardRate";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
            }
            elseif($ebaySiteId == 212 ){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "PL_DomesticRegular";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
            }
            $profile->update($profileData);

             if ($sh_product_id !=  '') {
                    $data = [
                        'id' => $sh_product_id,
                        'profile_id' => $profile->id,
                    ];
                    $request = new Request($data);

                    $shopifyProductController =  new ShopifyProductController();
                    $response = $shopifyProductController->insertProductOnPendingImport($request);

                   Log::info($response);
                   if (isset($response['massage'])) {
                        $profileNames = Profile::where("user_id", $user->id)->get(['id', 'name', 'is_variantions']);
                         return [
                            'status' => 'success',
                            'profiles' => $profileNames
                        ];
                   }else{
                       $profileNames = Profile::where("user_id", $user->id)->get(['id', 'name', 'is_variantions']);
                         return [
                            'status' => 'error',
                            'profiles' => $profileNames,
                            'verify'=>$response,
                        ];
                   }

             }
            $profileNames = Profile::where("user_id", $user->id)->get(['id', 'name', 'is_variantions']);

            return [
                'status' => 'success',
                'profiles' => $profileNames
            ];
                    
    }
    


    public function getShopifyLocation($shopurl,$token){
        $query = 'query {
                    locations(first: 5) {
                        edges {
                        node {
                            id
                            name
                            address {
                            country
                            countryCode
                            zip
                            }
                        }
                        }
                    }
                    }
                    ';

                 $locationData =    $this->callShopifyGraphQL($shopurl, $token, $query);

                 Log::info($locationData);

                 return $locationData;

    }

	function callShopifyGraphQL($shopUrl, $accessToken, $query, $variables = []) {
		$ch = curl_init("https://$shopUrl/admin/api/2024-10/graphql.json");
		$payload = [
			'query' => $query
		];

		if (!empty($variables)) {
			$payload['variables'] = $variables;
		}

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			"Content-Type: application/json",
			"X-Shopify-Access-Token: $accessToken"
		]);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

		$response = curl_exec($ch);

		if (curl_errno($ch)) {
			$errorMsg = curl_error($ch);
			curl_close($ch);
			return [
				'error' => true,
				'message' => "cURL error: $errorMsg"
			];
		}

		curl_close($ch);

		$responseDecoded = json_decode($response, true);
		if (json_last_error() !== JSON_ERROR_NONE) {
			return [
				'error' => true,
				'message' => 'Invalid JSON response',
				'rawResponse' => $response
			];
		}
		return $responseDecoded;
	}
    public function verify(Request $request){
        Log::info($request->all());
    
        $data = $request->input('add'); // <== Get data from "add" key
    
        $validator = Validator::make($data, [
            'name'             => 'required|string',		
            'item_location'    => 'required|string',									   
            'listing_format'   => 'required|string',									   
            'postal_code'      => 'required|string',									   
            'Country'          => 'required',
        ]);
    
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 406);
        } else {
            return response()->json(['success' => 'validate'], 200);
        }
    }
    

    public function store(Request $request)
    {
        
    }

    public function show1($id)
    {
        //
        $RECOMMENDED = array();

        Log::info("inside profileController");
		$currUser = Auth::User();
        $profile =  $currUser->profiles()->where('id',$id)->first();

  
        $currUser = Auth::User();
        Log::info("user data ");
        Log::info($currUser);
        $businessPolicies =  $currUser->sellerProfiles()->get();
      
          // Organize policies into categories
          $paymentPolicies = [];
          $returnPolicies = [];
          $shippingPolicies = [];
  
          foreach ($businessPolicies as $policy) {
             
              $profileData = [
                  'ProfileID' => $policy['seller_profile_id'],
                  'ProfileName' => $policy['name'],
                  'ID' => $policy['id'],
              ];
  
              // Categorize based on ProfileType
              switch ($policy['type']) {
                  case 'PAYMENT':
                      $paymentPolicies[] = $profileData;
                      break;
                  case 'RETURN_POLICY':
                      $returnPolicies[] = $profileData;
                      break;
                  case 'SHIPPING':
                      $shippingPolicies[] = $profileData;
                      break;
              }
          }
          // Attach business policies to the profile response
          $profile->businessPolicies = [
              'payment_policies' => $paymentPolicies,
              'shipping_policies' => $shippingPolicies,
              'return_policies' => $returnPolicies,
          ];
        return [
            'profile'=>$profile,
        ];
    }
    public function show(Request $request)
    {
        //
        $RECOMMENDED = array();
        $id = $request->input("id");

        Log::info("inside profileController");
		$currUser = Auth::User();
        $profile =  $currUser->profiles()->where('id',$id)->first();

        if ($profile->category_attributes) {
             Log::info("attribute has ");
      
             Log::info( $request->category_id);
     
             $ebay_categories = EbayCategories::where('id',$profile->ebay_category_1)->first();
             $category_attributes = json_decode($ebay_categories->category_attributes,true);
     
             foreach($category_attributes as $attribute){
                 Log::info("++++++++++++++++++++++++++++attribute ");
                 Log::info($attribute);
                 if($attribute['aspectUsage'] == 'RECOMMENDED'){
                     $RECOMMENDED[$attribute['name']] = $attribute['values'];
                 }
             }

        }
        return [
            'profile'=>$profile,
            'recommended'=> $RECOMMENDED
        ];
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }


 public function update(Request $request)
{
    $data = $request->productDateToSave;
    $user = Auth::user();

    Log::info($data);

    $validator = Validator::make($data, [
        'id'                  => 'required|integer|exists:profiles,id',
        'name'                => 'required|string',
        'ebay_category_1'     => 'required',
        'ebay_category_id'    => 'required',
        'businessPolicies.Shipping' => 'required',
        'businessPolicies.Payment'  => 'required',
        'businessPolicies.Return'   => 'required',
    ]);

    if ($validator->fails()) {
        return response()->json(['error' => $validator->errors()], 406);
    }

    // ✅ Find existing profile
    $profile = Profile::find($data['id']);
    if (!$profile) {
        return response()->json(['error' => 'Profile not found'], 404);
    }

    // ✅ Update profile data
    $profile->name = $data['name'];
    $profile->ebay_category_1 = $data['ebay_category_1'];
    $profile->ebay_category_id = $data['ebay_category_id'];
    $profile->is_variantions = $data['is_variantions'];
    $profile->shipping_profile = $data['businessPolicies']['Shipping'];
    $profile->payment_profile = $data['businessPolicies']['Payment'];
    $profile->return_profile = $data['businessPolicies']['Return'];
    $profile->user_id = $user->id;
    $profile->item_specifics =  $data['item_specific'] ?  json_encode($data['item_specific']) : '';
    $profile->category_attributes =  $data['category_attributes'] ?  json_encode($data['category_attributes']) : '';


    // if (!empty($data['item_specific'])) {
    //     $profile->item_specifics = json_encode($data['item_specific']);
    // }

    // if (!empty($data['category_attributes'])) {
    //     $profile->category_attributes = json_encode($data['category_attributes']);
    // }

    if (isset($data['productType'])) {
        $profile->product_id_type = json_encode($data['productType']);
    }

    $profile->item_condition = json_encode($data['item_condition'] ?? []);
    $profile->item_condition_data = json_encode($data['item_condition_data'] ?? []);

    Log::info('Saving updated profile', ['profile' => $profile]);

    $profile->save(); // ✅ Save updated profile

    $profileNames = Profile::where("user_id", $user->id)->get(['id', 'name', 'is_variantions']);

    return [
        'status' => 'success',
        'profiles' => $profileNames
    ];
}

    public function updateEbayCategoryJson(){

        echo "adfad0";
		die();
		$siteIDs = array('0','2','3','15','16','23','71','77','100','101','123','146','186','193','201','203','205','207','210','211','212','216');
		// $siteIDs = array('100');
	
		
		foreach($siteIDs as $site_id){
			$ebayCategories = EbayCategories::select('id','category_tree_name')->where('is_last_level',1)->where('ebay_site',$site_id)->get();
			if($ebayCategories->count() > 0){
				$ebayCategories = $ebayCategories->toArray();
				/*foreach($ebayCategories as $key => $ebayCategory){
					$ebayCategories[$key]["category_attributes"] = ($ebayCategory["category_attributes"]) ? json_decode($ebayCategory["category_attributes"],true) : [];
				}*/
				file_put_contents("C:/xampp74/htdocs/newepi/eBayImporter2025/api/public/category-json/categories_".$site_id.".json",json_encode($ebayCategories));
			}
		}
 
		return response()->json(['success' => 'ebay category json updated'],200);
	}
    public function fetchCategoriesInfo(){
     
        $ebayKey = EbKey::where('user_id',1)->first();
        $ebay_token = $ebayKey->token;
        $ebay_categories = EbayCategories::where('is_last_level',1)->where('category_info',null)->get();
        foreach ($ebay_categories as $category) {
            $catid = $category->ebay_category_id;
                $_EBAY = array(
                'trade'  => 'https://api.ebay.com/ws/api.dll',
                'signin' => 'https://signin.ebay.com/ws/eBayISAPI.dll?SignIn&',
                'devid'  => '0bb9bac1-a532-41bd-b7f9-33ee0c929ad2',
                'appid'  => 'InfoShor-0163-4838-9046-b9adee4af175',
                'certid' => '0f0a7aef-366e-4a90-a4d4-440fc51110b4',
                'RuName' => 'InfoShore_Softw-InfoShor-0163-4-nflzmjw',
                'compatabilityLevel' => 859,
                'siteID'=>$ebayKey->siteid,
            );
             $ebayClient = new Ebay($ebay_token,$_EBAY['devid'],$_EBAY['appid'],$_EBAY['certid'],$_EBAY['trade'],$_EBAY['compatabilityLevel'],$_EBAY['siteID'],"GetCategoryFeatures");                			
                
                    $requestXmlBody = '<?xml version="1.0" encoding="utf-8"?>';
                    $requestXmlBody .= '<GetCategoryFeaturesRequest  xmlns="urn:ebay:apis:eBLBaseComponents">';
                    $requestXmlBody .= '<RequesterCredentials>';
                    $requestXmlBody .= '<eBayAuthToken>'.$ebay_token.'</eBayAuthToken>';
                    $requestXmlBody .= '</RequesterCredentials>';
                    $requestXmlBody .= '<ErrorLanguage>en_US</ErrorLanguage>';
                    $requestXmlBody .= '<WarningLevel>High</WarningLevel>';
                    $requestXmlBody .= '<CategoryID>'.$catid.'</CategoryID>';
                    $requestXmlBody .= '<DetailLevel>ReturnAll</DetailLevel>';
                    $requestXmlBody .= '</GetCategoryFeaturesRequest >';
                    $responseXml = $ebayClient->sendHttpRequest($requestXmlBody);
                    $responseXml = simplexml_load_string($responseXml);
            if(isset($responseXml) && $responseXml && $responseXml->Ack != "Failure"){
                    $category->category_info = json_encode($responseXml,true);
                    $category->save();
                }
                die();
        }
    
    }
    public function destroy($id)
    {
        //
    }
}
