<?php

namespace App\Http\Controllers;
use App\ProcessEbayImport;
use App\EbayCategories;
use App\EbayItemCondition;
use App\EbKey;
use App\Profile;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Log;
use PhpParser\Node\Stmt\Return_;
use Validator;

// require 'C:\xampp74\htdocs\apibck\api\ebay_sdk\vendor\autoload.php';
// use \DTS\eBaySDK\Constants;
use \DTS\eBaySDK\BusinessPoliciesManagement\Services;
use \DTS\eBaySDK\BusinessPoliciesManagement\Types;
// use DTS\eBaySDK\Trading\Services;
// use DTS\eBaySDK\Trading\Types;
use DTS\eBaySDK\Trading\Enums;
use \DTS\eBaySDK\Constants;


use function GuzzleHttp\json_decode;

class ProfileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

     public function __construct() {

        $this->middleware('jwt.auth', ['except' => ['authenticate']]);
    }
    public function index()
    {
        Log::info("inside profileController");
		$currUser = Auth::User();
        return $currUser->profiles()->get();
    }
    public function sellerProfile()
    {
        Log::info( "seller profile inside");
        Log::info("inside profileController sellerProfile");
		$currUser = Auth::User();
        Log::info("user data ");
        Log::info($currUser);
        $payment =  $currUser->sellerProfiles()->where('type','PAYMENT')->get();
        $RETURN_POLICY =  $currUser->sellerProfiles()->where('type','RETURN_POLICY')->get();
        $SHIPPING =  $currUser->sellerProfiles()->where('type','SHIPPING')->get();

        return [
            'shipping_policies'=>$SHIPPING,
            'payment_policies'=> $payment,
            'return_policies'=>$RETURN_POLICY
        ];

    }

    public function sellerProfileUpdate(Request $request){
        Log::info($request);
    }

    public function fetchItemCondition(Request $request) {
        Log::info("inside fetchItemCondition");
        $RECOMMENDED = array();
        Log::info( $request->category_id);
        $duration_enanle = 0;
        

        $ebay_categories = EbayCategories::where('id',$request->category_id)->first();
        Log::info($ebay_categories);
        $EbayItemCondition = EbayItemCondition::where('categories_id',$request->category_id)->first();
        $category_attributes = json_decode($ebay_categories->category_attributes,true);
        $EbayItemCondition = json_decode($EbayItemCondition->item_condition_data,true);

        foreach($category_attributes as $attribute){
       
            if($attribute['aspectUsage'] == 'RECOMMENDED'){
                $RECOMMENDED[$attribute['name']] = $attribute['values'];
            }
        }
      
        Log::info("--------contions----");

        Log::info(  $RECOMMENDED);
            return [
                'recommended'=> $RECOMMENDED,
                'condition'=> $EbayItemCondition,
                'ebay_category_id'=>$ebay_categories->ebay_category_id,
                'is_variantions'=>$ebay_categories->is_variantions,
                'productTypeEnable'=>true,
                "productType"=>'UPC'
            ];
    }

    public function refreshShoppingProfile(){
        $currUser = Auth::user();
        $eb_key =EbKey::where('user_id',$currUser->id)->first();
        
        $site_id = $eb_key->siteid;
        $token = $eb_key->token;
        $globalId = Constants\GlobalIds::US;
        if($site_id == 2){
            $globalId = Constants\GlobalIds::ENCA;
        }
        else if($site_id == 3){
            $globalId = Constants\GlobalIds::GB;
        }
        else if($site_id == 15){
            $globalId = Constants\GlobalIds::AU;
        }
        else if($site_id == 23){
            $globalId = Constants\GlobalIds::FRBE;
        }
        else if($site_id == 71){
            $globalId = Constants\GlobalIds::FR;
        }
        else if($site_id == 77){
            $globalId = Constants\GlobalIds::DE;
        }
        else if($site_id == 203){
            $globalId = Constants\GlobalIds::IN;
        }
        else if($site_id == 210){
            $globalId = Constants\GlobalIds::FRCA;
        }
        else if($site_id == 216){
            $globalId = Constants\GlobalIds::SG;
        }
        else if($site_id == 207){
            $globalId = Constants\GlobalIds::MY;
        }
        else if($site_id == 205){
            $globalId = Constants\GlobalIds::IE;
        }
        else if($site_id == 186){
            $globalId = Constants\GlobalIds::ES;
        }
        else if($site_id == 101){
            $globalId = Constants\GlobalIds::IT;
        }
        $ebConfig = config('ebay.ebConfig');
        
        $ebayService = new Services\BusinessPoliciesManagementService([
            'credentials' => $ebConfig['production']['credentials'],
            'authToken'   => $token,
            'globalId'    => $globalId
        ]);

        Log::info($ebConfig);
        $ebayRequest = new Types\GetSellerProfilesRequest();
        $ebayResponse = $ebayService->getSellerProfiles($ebayRequest);
        $ebayResponse = ($ebayResponse) ? $ebayResponse->toArray() : array();
        

        Log::info("ebay response ");
        Log::info($ebayResponse);
        if ($ebayResponse['ack'] =='Success') {
             $paymentProfiles = (isset($ebayResponse["paymentProfileList"])) ? $ebayResponse["paymentProfileList"]["PaymentProfile"] : array();
             if($paymentProfiles){
                 foreach($paymentProfiles as $profile){
                      Log::info("ebayy payment profile recvd");
                     $profileId = $profile["profileId"];
                     $profileType = $profile["profileType"];
                     $profileName = $profile["profileName"];

                     $profileInDB = $currUser->sellerProfiles()->where('seller_profile_id',$profileId)->first();

                     if($profileInDB){
                        Log::info("inside update condition");
                        $profileInDB->name =$profileName;
                        $profileInDB->type = $profileType;
                        $profileInDB->seller_profiles_data = json_encode($profile);
                        $profileInDB->save();

                     }else{
                        $payment_profile_id[] = $profileId; 

    
                        $proData = array(
                            "seller_profile_id"=>$profileId,
                            "name"=>$profileName,
                            "type"=>$profileType,
                            "seller_profiles_data"=> json_encode($profile),
                            "user_id"=>$currUser->id
                        );

                       $currUser->sellerProfiles()->create($proData);
                         Log::info('$paymentProfiles created');
                     }  
                     }
                 }
             }

             $returnPolicyProfiles = (isset($ebayResponse["returnPolicyProfileList"])) ? $ebayResponse["returnPolicyProfileList"]["ReturnPolicyProfile"] : array();
             Log::info('returnPolicyProfiles started');
         
             if($returnPolicyProfiles){
                  Log::info("ebayy reponse return policy recvd");
                 foreach($returnPolicyProfiles as $profile){
                     $profileId = $profile["profileId"];
                     $profileType = $profile["profileType"];
                     $profileName = $profile["profileName"];
                     $return_profile_id[] = $profileId;
                     $profileInDB = $currUser->sellerProfiles()->where('seller_profile_id',$profileId)->first();

                     if($profileInDB){
                        Log::info("inside update condition");
                        $profileInDB->name =$profileName;
                        $profileInDB->type = $profileType;
                        $profileInDB->seller_profiles_data = json_encode($profile);
                        $profileInDB->save();

                     }else{
                        Log::info("ebayy profile was not in db already");
                        $proData = array(
                            "seller_profile_id"=>$profileId,
                            "name"=>$profileName,
                            "type"=>$profileType,
                            "seller_profiles_data"=> json_encode($profile),
                            "user_id"=>$currUser->id
                        );
                       $currUser->sellerProfiles()->create($proData);

                     }  
               
                          Log::info('returnPolicyProfiles saved as it was not in db');
                     
                 }
             }

             $shippingPolicyProfiles = (isset($ebayResponse["shippingPolicyProfile"])) ? $ebayResponse["shippingPolicyProfile"]["ShippingPolicyProfile"] : array();
             Log::info('shippingPolicyProfiles starts');
             
         
             if($shippingPolicyProfiles){
                 foreach($shippingPolicyProfiles as $profile){
                     $weight_required = 0;
                     $shippingService_name = $profile["shippingPolicyInfo"]['domesticShippingType'];
                         Log::info('shippingPolicyProfiles starts' . $profile["shippingPolicyInfo"]['domesticShippingType']);

                     $profileId = $profile["profileId"];
                     $profileType = $profile["profileType"];
                     $profileName = $profile["profileName"];
                     $shipping_profile_id[] = $profileId;
                     $profileInDB = $currUser->sellerProfiles()->where('seller_profile_id',$profileId)->first();

                     if($profileInDB){
                        Log::info("inside update condition");
                        $profileInDB->name =$profileName;
                        $profileInDB->shippingService_name = $shippingService_name;
                        $profileInDB->type = $profileType;
                        $profileInDB->seller_profiles_data = json_encode($profile);
                        $profileInDB->save();
                     }else{
                        Log::info("ebayy profile was not in db already");
                        $proData = array(
                            "seller_profile_id"=>$profileId,
                            "name"=>$profileName,
                            "type"=>$profileType,
                            "shippingService_name"=>$shippingService_name,
                            "weight_required"=>$weight_required,
                            "seller_profiles_data"=> json_encode($profile),
                            "user_id"=>$currUser->id
                        );
                       $currUser->sellerProfiles()->create($proData);

                     }  
              

                         Log::info('shippingPolicyProfiles ended');
                     
                 }
             }
             $businessPolicies =  $currUser->sellerProfiles()->get();
      
          // Organize policies into categories
          $paymentPolicies = [];
          $returnPolicies = [];
          $shippingPolicies = [];
  
          foreach ($businessPolicies as $policy) {
             
              $profileData = [
                  'ProfileID' => $policy['seller_profile_id'],
                  'ProfileName' => $policy['name'],
                  'ID' => $policy['id'],
              ];
  
              // Categorize based on ProfileType
              switch ($policy['type']) {
                  case 'PAYMENT':
                      $paymentPolicies[] = $profileData;
                      break;
                  case 'RETURN_POLICY':
                      $returnPolicies[] = $profileData;
                      break;
                  case 'SHIPPING':
                      $shippingPolicies[] = $profileData;
                      break;
              }
          }
          // Attach business policies to the profile response
          return [
              'payment_policies' => $paymentPolicies,
              'shipping_policies' => $shippingPolicies,
              'return_policies' => $returnPolicies,
          ];

    }

    public function createData(){
        $currUser = Auth::user();
        Log::info('inside createData funtion ');
        Log::info($currUser);
        $shopurl = $currUser->shopurl;
        $token = $currUser->token;

    //    $response = $this->getShopifyLocation($shopurl,$token);

       $locations = [];

        // foreach ($response['data']['locations']['edges'] as $edge) {
        //     $node = $edge['node'];
        //     $country = array(
        //         'name'=>$node['address']['country'],
        //         'code'=>$node['address']['countryCode']
        //     );
        //     $locations[$node['name']] = [
        //         'country' =>$country,
        //         'postal'  => $node['address']['zip'],
        //     ];
        // }


        return [
            'locations'=>$locations
        ];


    }
    

    public function copyProfile($profile_id)
    {
        Log::info("inside of copyProfile " . $profile_id);
        $currUser = Auth::user();
        $profile = $currUser->profiles()->where('id', $profile_id)->first();
        if (!$profile) {
            return response()->json(['error' => ['msg' => ['Profile not found.']]], 404);
        }
        $newProfileName = 'Copy of ' . $profile->name;
        $checkProfile = $currUser->profiles()->where('name', $newProfileName)->first();
        if (!$checkProfile) {
            $newProfile = $currUser->profiles()->create([
                'name' => $newProfileName,
          
            ]);
            Log::info("New profile created: " . json_encode($newProfile));
            return ['success'];
        } else {
            return response()->json(['error' => [
                'msg' => ['This Profile already exists.']
            ]], 406);
        }
    }
    public function deleteProfile($profile_id)
    {
        Log::info("inside of deleteProfile " . $profile_id);
        $currUser = Auth::user();
        $profile = $currUser->profiles()->where('id', $profile_id)->first();
    
        if (!$profile) {
            return response()->json(['error' => ['msg' => ['Profile not found.']]], 404);
        }
    
        // Check the total number of profiles for the user
        $profileCount = $currUser->profiles()->count();
    
        if ($profileCount <= 1) {
            return response()->json(['error' => ['msg' => ['Cannot delete the last profile. At least one profile must exist.']]], 403);
        }
    
        try {
            $profile->delete(); // Or $profile->forceDelete() for permanent deletion
            Log::info("Profile deleted: " . $profile_id);
            return response()->json(['message' => 'Profile deleted successfully'], 200);
        } catch (\Exception $e) {
            Log::error("Error deleting profile: " . $e->getMessage());
            return response()->json(['error' => ['msg' => ['Failed to delete profile.']]], 500);
        }
    }

    
    public function create(Request $request)
    {
        $data = $request->productDateToSave;
        $user = Auth::user();

        Log::info($data);
    
        Log::info("Creating profile", ['request' => $data]);
       
        $profile = new Profile([
            'name' => $data['name'] ?? null,
            'ebay_category_1' => $data['ebay_categoryid1'] ?? null,
            'ebay_category_id' => $data['ebay_category_id'] ?? null,
            'is_variantions' => $data['is_variantions'] ?? null,
            'shipping_profile' => $data['businessPolicies']['Shipping'] ?? null,
            'payment_profile' => $data['businessPolicies']['Payment'] ?? null,
            'return_profile' => $data['businessPolicies']['Return'] ?? null
        ]);
    
        $recomm = [];
        if (!empty($data['recommendation'])) {
            foreach ($data['recommendation'] as $key => $value) {
                $label = $value['selectedAttributeOption']['label'] ?? '';
                switch ($label) {
                    case 'Recommendation':
                        $recomm[] = [$key => ['recommendation' => $value['selectedRemmendationvalue']]];
                        break;
                    case 'Shopify':
                        $recomm[] = [$key => ['shopify' => $value['shopifyOption']]];
                        break;
                    case 'Custom':
                        $recomm[] = [$key => ['custum' => $value['customValue']]];
                        break;
                }
            }
        }
    
        if (!empty($recomm)) {
            $profile->category_attributes = json_encode($recomm);
        }
    
        if (isset($data['productType'])) {
            $profile->product_id_type = json_encode($data['productType']);
        }
    
     
   
    
        $profile->item_condition = is_array($data['item_condition'] ?? null) 
            ? json_encode($data['item_condition']) 
            : ($data['item_condition'] ?? null);
    
        $profile->item_condition_data = is_array($data['item_condition_data'] ?? null) 
            ? json_encode($data['item_condition_data']) 
            : null;
    
   
    
        $profile->user_id = $user->id;
        Log::info('Saving profile', ['profile' => $profile]);
        $profile->save();
        $productId = $data['importproductId'] ?? null ;
        $profileId = $profile->id;
        if($productId){
            $productStatusUpdate = $user
            ->sh_products()
            ->where("id", $productId)
            ->update([
                "status" => "Import In Process",
                "profile_id" => $profileId,
            ]);
            $importRequest = ProcessEbayImport::create([
                "status" => "pending",
                "sh_product_id" => $productId,
            ]);
            $user->processebayimports()->save($importRequest);
            Log::info('productId', ['profile' => $productId . ' '. $profileId ]);
        }


        Log::info($profile);

        $ebaySiteId = $user->ebKey()->value('siteid');
        
        if($ebaySiteId == 0){
            $profileData["sales_tax_rate"] = 19.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "USPSFirstClass";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
          
            
            }elseif($ebaySiteId == 3){
            $profileData["sales_tax_rate"] = 19.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "UK_PackLinkPostable";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
           
            
            }elseif($ebaySiteId == 2){
            $profileData["sales_tax_rate"] = 19.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "CA_EconomyShipping";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
           

            }elseif($ebaySiteId == 77){
            $profileData["sales_tax_rate"] = 19.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "DE_StandardDispatch";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
          
                
            }elseif($ebaySiteId == 15){
            $profileData["sales_tax_rate"] = 19.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "AU_StandardDelivery";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
            

            }
            elseif($ebaySiteId == 101){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "IT_ExpressCourier";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 2;
           

            }
            elseif($ebaySiteId == 16){

            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "AT_InsuredDispatch";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
          
            }
            elseif($ebaySiteId == 23){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "BEFR_LaPosteStandardShipping";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
           
            }
            elseif($ebaySiteId == 71){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "FR_Chronopost";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
          
            }
            elseif($ebaySiteId == 77){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "DE_StandardDispatch";
            $profileData["ship_fee1"] = 4.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
            
            }
            elseif($ebaySiteId == 123){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "BENL_PriorityDelivery";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
           
            }
            elseif($ebaySiteId == 146){

            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "NL_StandardDelivery";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
        
            }
            elseif($ebaySiteId == 186){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "ES_EnvioEstandarALasIslasCanarias";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
        
            }
            elseif($ebaySiteId == 193){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "CH_StandardDispatchAPost";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
            }
            elseif($ebaySiteId == 205){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "IE_SellersStandardRate";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
            }
            elseif($ebaySiteId == 212 ){
            $profileData["sales_tax_rate"] = 22.00;
            $profileData["apply_tax_to_shipping"] = 1;
            $profileData["return_policy_details"] = "only unused, originally packaged goods";
            $profileData["domestic_shipping"] = "Flat";
            $profileData["domestic_ship_service1"]= "PL_DomesticRegular";
            $profileData["ship_fee1"] = 6.00;
            $profileData["domestic_ships_within_handling_days"] = 15;
            }
            $profile->update($profileData);
            $profileNames = Profile::where("user_id",$user->id)->get(['id','name','is_variantions']);

            $profileNames = Profile::where("user_id", $user->id)->get(['id', 'name', 'is_variantions']);

            return [
                'status' => 'success',
                'profiles' => $profileNames
            ];
                    
    }
    


    public function getShopifyLocation($shopurl,$token){
        $query = 'query {
                    locations(first: 5) {
                        edges {
                        node {
                            id
                            name
                            address {
                            country
                            countryCode
                            zip
                            }
                        }
                        }
                    }
                    }
                    ';

                 $locationData =    $this->callShopifyGraphQL($shopurl, $token, $query);

                 Log::info($locationData);

                 return $locationData;

    }

	function callShopifyGraphQL($shopUrl, $accessToken, $query, $variables = []) {
		$ch = curl_init("https://$shopUrl/admin/api/2024-10/graphql.json");
		$payload = [
			'query' => $query
		];

		if (!empty($variables)) {
			$payload['variables'] = $variables;
		}

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			"Content-Type: application/json",
			"X-Shopify-Access-Token: $accessToken"
		]);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

		$response = curl_exec($ch);

		if (curl_errno($ch)) {
			$errorMsg = curl_error($ch);
			curl_close($ch);
			return [
				'error' => true,
				'message' => "cURL error: $errorMsg"
			];
		}

		curl_close($ch);

		$responseDecoded = json_decode($response, true);
		if (json_last_error() !== JSON_ERROR_NONE) {
			return [
				'error' => true,
				'message' => 'Invalid JSON response',
				'rawResponse' => $response
			];
		}
		return $responseDecoded;
	}
    public function verify(Request $request){
        Log::info($request->all());
    
        $data = $request->input('add'); // <== Get data from "add" key
    
        $validator = Validator::make($data, [
            'name'             => 'required|string',		
            'item_location'    => 'required|string',									   
            'listing_format'   => 'required|string',									   
            'postal_code'      => 'required|string',									   
            'Country'          => 'required',
        ]);
    
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 406);
        } else {
            return response()->json(['success' => 'validate'], 200);
        }
    }
    

    public function store(Request $request)
    {
        
    }

    public function show1($id)
    {
        //
        $RECOMMENDED = array();

        Log::info("inside profileController");
		$currUser = Auth::User();
        $profile =  $currUser->profiles()->where('id',$id)->first();

        if ($profile->category_attributes) {
             Log::info("attribute has ");
      
     
             $ebay_categories = EbayCategories::where('id',$profile->ebay_category_1)->first();
             $category_attributes = json_decode($ebay_categories->category_attributes,true);

           
             foreach($category_attributes as $attribute){
                 Log::info("++++++++++++++++++++++++++++attribute ");
                 Log::info($attribute);
                 if($attribute['aspectUsage'] == 'RECOMMENDED'){
                     $RECOMMENDED[$attribute['name']] = $attribute['values'];
                 }
             }
        }
        $currUser = Auth::User();
        Log::info("user data ");
        Log::info($currUser);
        $businessPolicies =  $currUser->sellerProfiles()->get();
      
          // Organize policies into categories
          $paymentPolicies = [];
          $returnPolicies = [];
          $shippingPolicies = [];
  
          foreach ($businessPolicies as $policy) {
             
              $profileData = [
                  'ProfileID' => $policy['seller_profile_id'],
                  'ProfileName' => $policy['name'],
                  'ID' => $policy['id'],
              ];
  
              // Categorize based on ProfileType
              switch ($policy['type']) {
                  case 'PAYMENT':
                      $paymentPolicies[] = $profileData;
                      break;
                  case 'RETURN_POLICY':
                      $returnPolicies[] = $profileData;
                      break;
                  case 'SHIPPING':
                      $shippingPolicies[] = $profileData;
                      break;
              }
          }
          // Attach business policies to the profile response
          $profile->businessPolicies = [
              'payment_policies' => $paymentPolicies,
              'shipping_policies' => $shippingPolicies,
              'return_policies' => $returnPolicies,
          ];
        return [
            'profile'=>$profile,
        ];
    }
    public function show(Request $request)
    {
        //
        $RECOMMENDED = array();
        $id = $request->input("id");

        Log::info("inside profileController");
		$currUser = Auth::User();
        $profile =  $currUser->profiles()->where('id',$id)->first();

        if ($profile->category_attributes) {
             Log::info("attribute has ");
      
             Log::info( $request->category_id);
     
             $ebay_categories = EbayCategories::where('id',$profile->ebay_category_1)->first();
             $category_attributes = json_decode($ebay_categories->category_attributes,true);
     
             foreach($category_attributes as $attribute){
                 Log::info("++++++++++++++++++++++++++++attribute ");
                 Log::info($attribute);
                 if($attribute['aspectUsage'] == 'RECOMMENDED'){
                     $RECOMMENDED[$attribute['name']] = $attribute['values'];
                 }
             }

        }
        return [
            'profile'=>$profile,
            'recommended'=> $RECOMMENDED
        ];
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }


    public function update(Request $request)
    {
        //
        Log::info("update profile ");
        Log::info( $request->add);
        $updateProfile = $request->add;
        $profileId =$updateProfile['id'];
        unset(
            $updateProfile["reqParams"],
            $updateProfile['route'],
            $updateProfile['id'],
            $updateProfile['restangularized'],
            $updateProfile['fromServer'],
            $updateProfile['parentResource'],
            $updateProfile['restangularCollection'],
            $updateProfile['created_at'],
            $updateProfile['updated_at']

        );
        $updateProfile['item_condition'] = $updateProfile['item_condition'];
        if (is_array($updateProfile['Country'])) {
            $updateProfile['Country'] = json_encode($updateProfile['Country'],true);
        }
        if (is_array($updateProfile['payment_profile'])) {
             $updateProfile['payment_profile'] = $updateProfile['payment_profile']['id'];
        }
        if (is_array($updateProfile['return_profile'])) {
            $updateProfile['return_profile'] = $updateProfile['return_profile']['id'];
       }  
       if (is_array($updateProfile['shipping_profile'])) {
        $updateProfile['shipping_profile'] = $updateProfile['shipping_profile']['id'];
        }
        if(!is_array($updateProfile['category_attributes']) && isset($updateProfile['action']) && $updateProfile['action'] == 'create'){
            $updateProfile['category_attributes'] = null;
        }
   
        Log::info($updateProfile);
        
        if(isset($updateProfile['recommendation'])){
        
            foreach($updateProfile['recommendation'] as $key =>$value){
                Log::info($key);
                Log::info($value);
                $label = isset($value['selectedAttributeOption']['label']) ? $value['selectedAttributeOption']['label'] : null;
                if ($label === 'Recommendation' && isset($value['selectedRemmendationvalue'])) {
                    $recomm[] = [
                        $key => [
                            'recommendation' => $value['selectedRemmendationvalue']
                        ]
                    ];
                }
                if ($label === 'Shopify' && isset($value['shopifyOption'])) {
                    $recomm[] = [
                        $key => [
                            'shopify' => $value['shopifyOption']
                        ]
                    ];
                }
            
                if ($label === 'Custom' && isset($value['customValue'])) {
                    $recomm[] = [
                        $key => [
                            'custom' => $value['customValue']
                        ]
                    ];
                }
            
                if (!$label && isset($value['shopifyOption'])) {
                    $recomm[] = [
                        $key => [
                            'shopify' => $value['shopifyOption']
                        ]
                    ];
                }
            }
        }
        if(isset($updateProfile['recommendation']) && $updateProfile['category_attributes'] != null){
            Log::info("in side if ");

            Log::info(json_decode($updateProfile['category_attributes'],true));
        }
        if (!empty($recomm)) {
            $updateProfile['category_attributes']  = json_encode($recomm,true);
            unset(
                $updateProfile["recommendation"],
                $updateProfile["action"],
            );
        }
        unset(
            $updateProfile["action"],

        );
        $currUser = Auth::User();
        Log::info($updateProfile);
        return $currUser->profiles()->where('id',$profileId)->update($updateProfile);

    }


    public function destroy($id)
    {
        //
    }
}
