<?php

Route::group(['prefix' => 'v1'], function()
{
	// authentication
    Route::resource('authenticate', 'AuthenticateController', ['only' => ['index']]);
    Route::get('authenticate', 'AuthenticateController@authenticate');
    Route::post('authenticate', 'AuthenticateController@authenticate');
    Route::post('authenticate1', 'AuthenticateController@authenticatePost');

    Route::put('updateapptour','SettingsController@updateAppTour');
    Route::get('getuserdetail', 'AuthenticateController@getUserDetail');
	Route::get('/productCounts', 'AuthenticateController@productCounts');
	Route::get('ebayaccounts','EbConfigController@getEbayAccounts');     

    Route::get('product/priceupdate','ProductController@PriceAndQuantityUpdateBoth');  
	Route::resource('product', 'ProductController', ['only' => ['index']]);
    Route::get('product/search','ProductController@search');    
	Route::post('product/block/{id}', 'ProductController@block'); 
	Route::post('product/unblock/{id}', 'ProductController@unblock'); 
	Route::post('product/push/{id}', 'ProductController@push');
	Route::post('product/pushall', 'ProductController@pushall');
	Route::get('product/suggestedplan', 'ProductController@suggestedPlan');
	Route::get('product/variants', 'ProductController@getVariants');
	Route::get('product/getvarientsupdate', 'ProductController@getvarientsupdate'); // by hiteshmali
	Route::get('product/shopify/variants', 'ShopifyProductController@getShopifyVariants');

	Route::post('product/updatepdesc', 'ProductController@updatePDesc');
	Route::post('product/reimport/{id}', 'ProductController@reimport');
	Route::post('product/remove/{id}', 'ProductController@remove');
	Route::get('product/export/file', 'ProductController@exportFile');

	Route::put('fetchEbayProduct/request','ProductController@fetchEbayProductRequest');
	Route::get('product/getProductCount', 'ProductController@getProductCount');
	Route::get('shopify/getProductCount','ShopifyProductController@getProductCount');


	Route::get('getprofiles','ProfileController@index');
	Route::get('profile/show/{id}','ProfileController@show');
	Route::get('profiledata/{id}','ProfileController@show1');
	Route::put('product/shopify/linkedProductToEbay',"ShopifyProductController@linkedProductToEbay");


	Route::get('fetchEbayProfiles','ProfileController@sellerProfile');

	Route::post('profile/sellerProfileUpdate','ProfileController@sellerProfileUpdate');
	Route::get('updateEbayCategoryJson','ProfileController@updateEbayCategoryJson');



	Route::get('profile/createData','ProfileController@createData');
	Route::post('profile/copyProfile/{id}','ProfileController@copyProfile');
	Route::post('profile/deleteProfile/{id}','ProfileController@deleteProfile');
	Route::post('profile/createProfile/','ProfileController@create');
	Route::post('profile/updateProfile/','ProfileController@update');
	Route::post('profile/verifyProfile/','ProfileController@verify');

	Route::get('/profile/refreshShoppingProfile','ProfileController@refreshShoppingProfile');

	Route::get('profile/fetchItemCondition','ProfileController@fetchItemCondition');


	Route::get('product/shopify/search','ShopifyProductController@searchShopifyProduct');
	Route::get('product/shopify','ShopifyProductController@index');

	Route::get('importProductToEbay','ShopifyProductController@importProductToEbay');

	Route::get('product/shopify/variants', 'ShopifyProductController@getVariantShopify');
	Route::put('product/shopify/fetchShopifyProducts', 'ShopifyProductController@fetchShopifyProducts');
	Route::get('product/shopify/statusChanged', 'ShopifyProductController@shopifyProductStatus');
	Route::put('product/shopify/insertEbayImportRequest/', 'ShopifyProductController@insertProductOnPendingImport');

	Route::put('product/shopify/saveEdit', 'ShopifyProductController@saveEdit');


	Route::get('product/shopify/profiles', 'ShopifyProductController@getProfiles');

	Route::put('/verifyEbayItem','ShopifyProductController@verifyEbayItem');

	
	Route::get('product/shopifytoebay', 'ProductController@ShopifyToEbay');

	Route::get('ebconfig','EbConfigController@index');
	Route::post('ebconfig/fetch','EbConfigController@fetch');
	Route::get('ebconfig/status','EbConfigController@status');
	
	Route::get('settings','SettingsController@index');
	Route::put('updateSetupStep','SettingsController@updateSetupStep');
	Route::put('settings/setupFinalStep','SettingsController@setupFinalStep');
	Route::put('settings','SettingsController@store');
	Route::put('settings','SettingsController@storeNew');

	Route::post('settings/pricingrules','SettingsController@savePricingRulesSettings');
	Route::post('settings/sync','SettingsController@saveSyncSettings');
	
	Route::post('contact/requestquote','ContactController@requestquote');
});