<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductVariant extends Model {
	
	protected $table = 'product_variants';

	protected $primaryKey = 'id';
	
	public function user() {
		return $this->belongsTo('App\User', 'user_id', 'id');
	}

	public function product() {
		return $this->belongsTo('App\Product', 'product_id', 'product_id');
	}	
	
	public function images() {
		return $this->hasMany('App\ProductImage', 'variant_id', 'id');
	}

	public function mainImage() {
		return $this->hasOne('App\ProductImage', 'variant_id', 'id');
	}

	protected $fillable = [
        'product_id', 'sku', 'ebayitemid','status', 'option1val', 'option2val', 'option3val', 'option4val', 'option5val', 'price', 'quantity', 'newflag', 'quantityflag', 'priceflag', 'shopifyproductid', 'shopifyvariantid','shopifyinventoryid', 'productid', 'productidtype', 'weight', 'weight_unit'
    ];
}