<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Profile extends Model
{
    protected $table = 'profiles';

    public function paymentProfile(){
		return $this->hasOne('App\SellerProfile','id','payment_profile');
	}

	public function shippingProfile(){
		return $this->hasOne('App\SellerProfile','id','shipping_profile');
	}

	public function returnProfile(){
		return $this->hasOne('App\SellerProfile','id','return_profile');
	}
    protected $fillable = [
        'name',
        'trim_title',
        'is_default_profile',
        'listing_title',
        'product_id_type',
        'item_condition',
        'ebay_category_id',
        'child_item_condition',
        'ebay_category_1',
        'category_attributes',
        'is_variantions',
        'item_condition_data',
        'ebay_category_2',
        'store_category',
        'listing_format',
        'listing_duration',
        'listing_duration_json',
        'item_location',
        'paypal_email',
        'immediate_payment',
        'payment_methods',
        'payment_instructions',
        'sales_tax_region',
        'sales_tax_rate',
        'apply_tax_to_shipping',
        'domestic_returns_accepted',
        'domestic_returned_within',
        'domestic_returns_paid_by',
        'domestic_refund_given_as',
        'international_returns_accepted',
        'international_returned_within',
        'international_returns_paid_by',
        'international_refund_given_as',
        'return_policy_details',
        'item_specifics',
        'item_specifics2',
        'domestic_shipping',
        'domestic_ship_service1',
        'ship_fee1',
        'x_ship_fee1',
        'domestic_free_shipping',
        'domestic_local_pickup',
        'domestic_ships_within_handling_days',
        'domestic_pkg_handling_fee',
        'intl_shipping',
        'intl_ship_options1',
        'intl_locations1',
        'intl_ship_service1',
        'intl_ship_fee1',
        'intl_x_ship_fee1',
        'intl_pkg_handling_fee',
        'ship_options',
        'ship_global_locations',
        'postal_code',
        'Country',
        'domestic_ship_additional_services',
        'intl_ship_additional_services',
        'shipping_profile',
        'payment_profile',
        'return_profile',
        'user_id',
        'created_at',
        'updated_at'
    ];

}
