<?php

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.0 on 2012-12-12 at 13:17:14.
 */
class AmazonReportAcknowledgerTest extends PHPUnit_Framework_TestCase {

    /**
     * @var AmazonReportAcknowledger
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        resetLog();
        $this->object = new AmazonReportAcknowledger('testStore', null, true, null, __DIR__.'/../../test-config.php');
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {
        
    }
    
    public function testSetUp(){
        $obj = new AmazonReportAcknowledger('testStore', '77');
        
        $o = $obj->getOptions();
        $this->assertArrayHasKey('ReportIdList.Id.1',$o);
        $this->assertEquals('77', $o['ReportIdList.Id.1']);
    }
    
    public function testSetReportIds(){
        $this->assertFalse($this->object->setReportIds(null)); //can't be nothing
        $this->assertFalse($this->object->setReportIds(5)); //can't be an int
        
        $set = array('One','Two','Three');
        $this->assertNull($this->object->setReportIds($set));
        
        $o = $this->object->getOptions();
        $this->assertArrayHasKey('ReportIdList.Id.1',$o);
        $this->assertEquals('One',$o['ReportIdList.Id.1']);
        $this->assertArrayHasKey('ReportIdList.Id.2',$o);
        $this->assertEquals('Two',$o['ReportIdList.Id.2']);
        $this->assertArrayHasKey('ReportIdList.Id.3',$o);
        $this->assertEquals('Three',$o['ReportIdList.Id.3']);
        
        $this->assertNull($this->object->setReportIds('Four')); //will cause reset
        $o2 = $this->object->getOptions();
        $this->assertArrayHasKey('ReportIdList.Id.1',$o2);
        $this->assertEquals('Four',$o2['ReportIdList.Id.1']);
        $this->assertArrayNotHasKey('ReportIdList.Id.2',$o2);
        $this->assertArrayNotHasKey('ReportIdList.Id.3',$o2);
    }
    
    public function testSetAcknowledgedFilter(){
        $this->assertFalse($this->object->setAcknowledgedFilter(5)); //can't be an int
        $this->assertFalse($this->object->setAcknowledgedFilter('banana')); //can't be a random word
        $this->assertNull($this->object->setAcknowledgedFilter(false));
        $this->assertNull($this->object->setAcknowledgedFilter(true));
        $this->assertNull($this->object->setAcknowledgedFilter('false'));
        $this->assertNull($this->object->setAcknowledgedFilter('true'));
        $o = $this->object->getOptions();
        $this->assertArrayHasKey('Acknowledged',$o);
        $this->assertEquals('true',$o['Acknowledged']);
        $this->assertNull($this->object->setAcknowledgedFilter(null)); //causes reset
        $o2 = $this->object->getOptions();
        $this->assertArrayNotHasKey('Acknowledged',$o2);
    }
    
    public function testAcknowledgeReports(){
        resetLog();
        $this->object->setMock(true,'acknowledgeReports.xml');
        
        $this->assertFalse($this->object->acknowledgeReports()); //no Report ID set yet
        $this->object->setReportIds('123456');
        
        $this->assertNull($this->object->acknowledgeReports());
        
        $check = parseLog();
        $this->assertEquals('Single Mock File set: acknowledgeReports.xml',$check[1]);
        $this->assertEquals('Report IDs must be set in order to acknowledge reports!',$check[2]);
        $this->assertEquals('Fetched Mock File: mock/acknowledgeReports.xml',$check[3]);
        
        return $this->object;
    }
    
    /**
     * @depends testAcknowledgeReports
     */
    public function testGetReportId($o){
        $get = $o->getReportId(0);
        $this->assertEquals('841997483',$get);
        
        $this->assertFalse($o->getReportId('wrong')); //not number
        $this->assertFalse($this->object->getReportId()); //not fetched yet for this object
    }
    
    /**
     * @depends testAcknowledgeReports
     */
    public function testGetReportType($o){
        $get = $o->getReportType(0);
        $this->assertEquals('_GET_MERCHANT_LISTINGS_DATA_',$get);
        
        $this->assertFalse($o->getReportType('wrong')); //not number
        $this->assertFalse($this->object->getReportType()); //not fetched yet for this object
    }
    
    /**
     * @depends testAcknowledgeReports
     */
    public function testGetReportRequestId($o){
        $get = $o->getReportRequestId(0);
        $this->assertEquals('2234038326',$get);
        
        $this->assertFalse($o->getReportRequestId('wrong')); //not number
        $this->assertFalse($this->object->getReportRequestId()); //not fetched yet for this object
    }
    
    /**
     * @depends testAcknowledgeReports
     */
    public function testGetAvailableDate($o){
        $get = $o->getAvailableDate(0);
        $this->assertEquals('2009-01-06T03:48:36+00:00',$get);
        
        $this->assertFalse($o->getAvailableDate('wrong')); //not number
        $this->assertFalse($this->object->getAvailableDate()); //not fetched yet for this object
    }
    
    /**
     * @depends testAcknowledgeReports
     */
    public function testGetIsAcknowledged($o){
        $get = $o->getIsAcknowledged(0);
        $this->assertEquals('true',$get);
        
        $this->assertFalse($o->getIsAcknowledged('wrong')); //not number
        $this->assertFalse($this->object->getIsAcknowledged()); //not fetched yet for this object
    }
    
    /**
     * @depends testAcknowledgeReports
     */
    public function testGetAcknowledgedDate($o){
        $get = $o->getAcknowledgedDate(0);
        $this->assertEquals('2009-02-20T02:10:41+00:00',$get);
        
        $this->assertFalse($o->getAcknowledgedDate('wrong')); //not number
        $this->assertFalse($this->object->getAcknowledgedDate()); //not fetched yet for this object
    }
    
    /**
     * @depends testAcknowledgeReports
     */
    public function testGetCount($o){
        $get = $o->getCount();
        $this->assertEquals('1',$get);
        
        $this->assertFalse($this->object->getCount()); //not fetched yet for this object
    }
    
    /**
     * @depends testAcknowledgeReports
     */
    public function testGetList($o){
        $x = array();
        $x1 = array();
        $x1['ReportId'] = '841997483';
        $x1['ReportType'] = '_GET_MERCHANT_LISTINGS_DATA_';
        $x1['ReportRequestId'] = '2234038326';
        $x1['AvailableDate'] = '2009-01-06T03:48:36+00:00';
        $x1['Acknowledged'] = 'true';
        $x1['AcknowledgedDate'] = '2009-02-20T02:10:41+00:00';
        $x[0] = $x1;
        
        $this->assertEquals($x,$o->getList());
        $this->assertEquals($x1,$o->getList(0));
        
        $this->assertFalse($this->object->getList()); //not fetched yet for this object
    }
    
}

require_once('helperFunctions.php');