<?php

require_once("includes/config.php");

$filename = "logs/shopifyFetch-" . date("Ymd") . ".txt";
$logfile = fopen($filename, "a+") or die("Unable to open log file!");addlog("Execution Started", "INFO");

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);
// Check connection
if ($conn->connect_error) {		
    addlog("Database connection failed: " . $conn->connect_error, "ERROR");
    die("");
}

 $crons = $conn->query("select * from crons where crontype = 'fetchshopifyproduct'");

$cronRow = $crons->fetch_assoc();
if($cronRow['isrunning'] == 1){
    addlog("Cron is already running, exiting script.", "WARNING");
    die('Cron is already running');
}else{
    $conn->query("update crons set isrunning = 1 where crontype = 'fetchshopifyproduct'");
    addlog("Cron is now running.", "INFO");
}

 $users = array();
 $shRequest = $conn->query("select * from sh_requests where status = 'pending' and inprocess = 0");

 if($shRequest->num_rows > 0){
     $shRequest = $shRequest->fetch_assoc();
     $user_id = $shRequest['user_id'];
     $users[] = $user_id;
     addlog("User ID from pending request: $user_id", "INFO");
 }		

 foreach ($users as $key => $user_id) {        
        $configResult = $conn->query("select * from users where id = ".$user_id."");
        if($configResult->num_rows > 0){
            $configRow = $configResult->fetch_assoc();
            $shopurl = $configRow['shopurl'];
            $token = $configRow['token'];
            $conn->query("update sh_requests set inprocess=1  where user_id = $user_id");
            fetchShopifyproduct($user_id,$shopurl,$token,$configRow);
            $conn->query("update sh_requests set inprocess=0 ,status='completed' where user_id = $user_id");
          

            // $shCount = $conn->query( "select count(*) as cnt from sh_products where user_id = ".$user_id);
            // $shCount = $shCount->fetch_assoc();
            // addlog("select count(*) as cnt from sh_products where user_id = ".$user_id);
            // addlog($shCount['cnt'] );
            // print_r($shCount['cnt'] );
    }
 }

 addlog("update crons set isrunning = 0 where crontype = 'fetchshopifyproduct'");
$conn->query("update crons set isrunning = 0 where crontype = 'fetchshopifyproduct'");

function fetchShopifyproduct($user_id,$shopurl,$token,$userDetails){
    global $servername,$username,$password,$dbname;
        $conn = new mysqli($servername, $username, $password, $dbname);
    try{
            
    
          $existingSKUs = array();
            $result = $conn->query("select distinct shopify_product_id from sh_products where user_id = ".$user_id);
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {	
                    $existingSKUs[] = $row['shopify_product_id'];
                }
            }
            $hasNextPage = true;
            $after = null;
            do {
                $allProducts = [];
                 $query = 'query {
                        products(first: 250, query: "status:active"' . ($after ? ', after: "' . $after . '"' : '') . ') {
                            edges {
                                node {
                                    id
                                    title
                                    vendor
                                    createdAt
                                    handle
                                    status
                                    variantsCount{
                                      count
                                    }
                                    productType
                                    publishedAt
                                    tags
                                    bodyHtml
                                    images(first: 250) {
                                        edges {
                                            node {
                                                id
                                                url
                                            }
                                        }
                                    }
                                    variants(first: 250) {
                                        edges {
                                            node {
                                                id
                                                title
                                                price
                                                compareAtPrice
                                                position
                                                 selectedOptions {
                                                            name
                                                            value
                                                        }
                                                sku
                                                barcode
                                                inventoryQuantity
                                                image {
                                                    id
                                                    url
                                                }
                                                 inventoryItem{
                                                    id
                                                    measurement{
                                                        id
                                                        weight{
                                                            unit
                                                            value
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    options(first: 250) {
                                        id
                                        name
                                        position
                                        values
                                    }
                                }
                                cursor
                            }
                            pageInfo {
                                hasNextPage
                            }
                        }
                    }';
                   
                $responseDecoded = callShopifyGraphQL($shopurl, $token, $query);
                if(isset($responseDecoded['errors'])){
                    addlog(" fetchShopifyProducts user $user_id " . $responseDecoded['errors']);
                    return;
                }
                $products = $responseDecoded['data']['products']['edges'] ?? [];
                $allProducts = array_merge($allProducts, $products);
                // Update cursor and hasNextPage
                $hasNextPage = $responseDecoded['data']['products']['pageInfo']['hasNextPage'] ?? false;
                $after = end($products)['cursor'] ?? null;
                addlog(" fetchShopifyProducts   Cursor Updated: $after   Has Next Page:  $hasNextPage");
                if (empty($allProducts)){
                    addlog("fetchShopifyProducts shopurl   $shopurl   This user does not have the product on their Shopify. ");
                    // stop 
                    return;
                }
                $productArray = array();
                $allProducts =   transformShopifyProductData($allProducts);
                
                $countProduct = 0;
                foreach ($allProducts as $product) {
                    $productNode = $product;
                        if(in_array($product['id'], $existingSKUs)){
                            echo "already in db";
                            continue;
                        } 	
                    shopifyProductInsert($product,$userDetails,$user_id,$productNode,$productArray);
                    $countProduct = $countProduct + 1;
                    if($countProduct == 1){
                        addlog("count prpduct ".$countProduct."  - ".count($productArray));
                        insertInDataBase($productArray);
                        $productArray = array();
                        $countProduct = 0;

                    }

                }
                if(!empty($productArray)){
                    addlog("count prpduct ".$countProduct."  - ".count($productArray));

                    insertInDataBase($productArray);
                    $productArray = array();
                }
            } while ($hasNextPage);
        }catch(\Exception $e) {
            $errors[] = $e->getMessage();
        }
}

function insertInDataBase($product_Array){
        global $servername,$username,$password,$dbname;
        $conn = new mysqli($servername, $username, $password, $dbname);

    $sql = 'INSERT INTO `sh_products`( `title`, `image`, `status`,`has_variation`, `shopify_product_id`, `shopify_product_handle`, `shopify_product_type`, `brand`,`shopify_product_data`, `Source`,`user_id`, `created_at`, `updated_at`) VALUES';
    $values = [];
    $product_ids = [];
    foreach ($product_Array as $productArray) {

        $product = $productArray['product'];
        $values[] = "('" . 
            mysqli_real_escape_string($conn, $product['title']) . "', '" . 
            mysqli_real_escape_string($conn, $product['image']) . "', '" . 
            mysqli_real_escape_string($conn, $product['status']) . "', " . 
            mysqli_real_escape_string($conn, $product['has_variation']) . ", " . 
            mysqli_real_escape_string($conn, $product['shopify_product_id']) . ", '" . 
            mysqli_real_escape_string($conn, $product['shopify_product_handle']) . "', '" . 
            mysqli_real_escape_string($conn, $product['shopify_product_type']) . "', '" . 
            mysqli_real_escape_string($conn, $product['brand']) . "', '" . 
            mysqli_real_escape_string($conn, $product['shopify_product_data']) . "', '" . 
            mysqli_real_escape_string($conn, $product['source']) . "', " . 
            mysqli_real_escape_string($conn, $product['user_id']) . ", " . 
            " NOW(), NOW())";
    }


    // Execute query
    $sql .= implode(", ", $values);
    if ($conn->query($sql) === TRUE) {
        // Get the first inserted ID
        $first_id = $conn->insert_id; // First inserted ID
        $total_inserted = $conn->affected_rows; // Number of inserted rows
        
    
        $product_ids = range($first_id, $first_id + $total_inserted - 1);

        addlog("Bulk insert successful!  Inserted Product IDs: " . implode(", ", $product_ids)." total insert ".$total_inserted);
    } else {
        addlog("Error: " . $conn->error);
    }
    $val = 0;
						
		
    foreach ($product_Array as $productArray) {
        $variantInsertArray = array();
        $product_variant = $productArray['varinat'];
        $product_id = $product_ids[$val++];
        addlog("product id when insert variant ".$product_id);
        foreach($product_variant as $variant){
            $variantInsertArray[] = "(" . 
            "'" . mysqli_real_escape_string($conn, $variant['title']) . "', " . 
            "'" . mysqli_real_escape_string($conn, $variant['sku']) . "', " . 
            "'" . mysqli_real_escape_string($conn, $variant['image']) . "', " . 
            "'" . mysqli_real_escape_string($conn, $variant['Barcode']) . "', " . 
            "" . mysqli_real_escape_string($conn, $variant['quantity']) . ", " . 
            "" . floatval($variant['price']) . ", " . 
            "" . floatval($variant['compare_at_price']) . ", " . 
            "" . mysqli_real_escape_string($conn,$variant['shopify_variant_id']) . ", " . 
            "" . mysqli_real_escape_string($conn, $variant['shopify_inventory_item_id']) . ", " . 
            "" . mysqli_real_escape_string($conn, $variant['shopify_product_id']) . ", " . 
            "'" . mysqli_real_escape_string($conn, $variant['shopify_variant_data']) . "', " . 
            "" . mysqli_real_escape_string($conn, $product_id) . ", " . 
            "" . mysqli_real_escape_string($conn, $variant['user_id']) . ", " . 
             " NOW(), NOW()" . 
        ")";
        }
            $productVariantQuery = "INSERT INTO `sh_product_variants`(`title`, `sku`, `image`, `Barcode`, `quantity`, `price`, `compare_at_price`, `shopify_variant_id`, `shopify_inventory_item_id`, `shopify_product_id`, `shopify_variant_data`, `sh_product_id`, `user_id`, `created_at`, `updated_at`) VALUES" .implode(", ", $variantInsertArray);
    if ($conn->query($productVariantQuery)) {
        $first_id = $conn->insert_id; 
        $total_inserted = $conn->affected_rows; 
    
        $variant_ids = range($first_id, $first_id + $total_inserted - 1);
        addlog(implode(", ", $variant_ids));
        
    } 
 
    
    }

}
function shopifyProductInsert($product,$userDetails,$userId,$productNode,&$productArray){
    addlog("shopifyProductInsert function in " . json_encode($productNode,true));
    $shopifyProductId = (int)str_replace('gid://shopify/Product/', '', $productNode['id']);
     $shProductData = [ 
       'title' => $productNode['title'],
       'image' => isset($productNode['imageSrc']) && isset($productNode['imageSrc']) ? $productNode['imageSrc'] : NULL,
       'shopify_product_handle'=> $productNode['handle'] ,
       "user_id" => $userId,
       "brand"=>$productNode['vendor'],
       "has_variation"=>$productNode['variantsCount'],
       "shopify_product_type"=> $productNode['product_type'],
       "shopify_product_id" => $productNode['id'],
       "shopify_product_data" => json_encode($productNode, JSON_INVALID_UTF8_IGNORE),
      ];  

      $shProductData['status'] = 'Unlinked';
      $shProductData['source'] = 'shopfiy';
      $productVariants = $productNode['variants'];
      $productVariantArray = array();
    //   addlog("check product count");
      $product_id = 1;
      foreach ($productVariants as $variants) {
        $variantsNode = $variants;
        $shopifyVariantId = (int)str_replace('gid://shopify/ProductVariant/', '', $variantsNode['id']);
            
             $productVariantArray[] =  shopifyVariantInsert($variantsNode,$shopifyVariantId,$userDetails,$userId,$shopifyProductId,$product_id);
           
     }
     $productArray[] = array(
        'product' => $shProductData,
        'varinat' => $productVariantArray
     );

}

function shopifyVariantInsert($variantsNode,$shopifyVariantId,$userDetails,$userId,$shopifyProductId,$shProductId){
    // addlog("shopifyVariantInsert function inside ");
   

    // addlog("shopifyVariantInsert: shopify Variant id $shopifyVariantId");
    $shVariantsData = [
    'title' => $variantsNode['title'],
    'sku' => $variantsNode['sku'],
    'Barcode' => $variantsNode['barcode'],
    'quantity' =>  $variantsNode['inventory_quantity'],
    'image' => isset($variantsNode['image']) ? $variantsNode['image'] : '',
    'price' => $variantsNode['price'],
    'compare_at_price' => $variantsNode['compare_at_price'],
     'shopify_inventory_item_id' => $variantsNode['inventory_item_id'],
     'shopify_variant_data' => json_encode($variantsNode, JSON_INVALID_UTF8_IGNORE),
     'shopify_product_id' =>  $variantsNode['product_id'] , 
    ];
    $shVariantsData['user_id'] = $userId;
    $shVariantsData['sh_product_id'] = $shProductId;
    $shVariantsData['shopify_variant_id'] = $variantsNode['id'] ;
    return $shVariantsData;
}
function callShopifyGraphQL($shopUrl, $accessToken, $query) {
    
    $ch = curl_init("https://$shopUrl/admin/api/2024-10/graphql.json");
    $payload = [
        'query' => $query
    ];

  

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "X-Shopify-Access-Token: $accessToken"
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    
    

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        $errorMsg = curl_error($ch);
        curl_close($ch);
        return [
            'error' => true,
            'message' => "cURL error: $errorMsg"
        ];
    }

    curl_close($ch);

    $responseDecoded = json_decode($response, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        return [
            'error' => true,
            'message' => 'Invalid JSON response',
            'rawResponse' => $response
        ];
    }
   
    return $responseDecoded;
}

function transformShopifyProductData($data) {
    $transformedProducts = [];

    foreach ($data as $productData) {
        $node = $productData['node'];

    
        $productId = (int)str_replace('gid://shopify/Product/', '', $node['id']);
        $transformedProduct = [
            'id' => $productId,
            'title' => $node['title'],
            'body_html' => '<p><span>' . (isset($node['bodyHtml']) ? $node['bodyHtml'] : '') . '</span></p>',
            'vendor' => $node['vendor'],
            'created_at' => $node['createdAt'],
            'variantsCount'=>$node['variantsCount']['count'],
            'imageSrc'=>$node['images']['edges'][0]['node']['url']?json_encode($node['images']['edges'],true) :'',
            'handle' => $node['handle'],
            'product_type' => $node['productType'],
            'published_at' => $node['publishedAt'],
            'updated_at' => date('c'),
            'template_suffix' => '',
            'published_scope' => 'web',
            'tags' => isset($node['productType']) ? $node['productType'] : '',
            'status' => strtolower($node['status']),
            'admin_graphql_api_id' => $node['id'],
        ];
        echo "shopify proudct id ".$productId;
        // Variants
        $variants = [];
        foreach ($node['variants']['edges'] as $variantEdge) {
            $variantNode = $variantEdge['node'];
            $variantId = (int)str_replace('gid://shopify/ProductVariant/', '', $variantNode['id']);

            $options = [];
            foreach ($variantNode['selectedOptions'] as $opt) {
                $options[] = $opt['value'];
            }
            $option1 = isset($options[0]) ? $options[0] : null;
            $option2 = isset($options[1]) ? $options[1] : null;
            $option3 = isset($options[2]) ? $options[2] : null;


            $variants[] = [
                'id' => $variantId,
                'product_id' => $productId,
                'title' => $variantNode['title'],
                'price' => $variantNode['price'],
                'image'=> isset($variantNode['image']['url']) ? $variantNode['image']['url'] : '',
                'position' => $variantNode['position'],
                'inventory_policy' => 'deny',
                'compare_at_price' => null,
                'option1' => $option1,
                'option2' => $option2,
                'option3' => $option3,
                'created_at' => date('c'),
                'updated_at' => date('c'),
                'taxable' => true,
                'barcode' => isset($variantNode['barcode']) ? $variantNode['barcode'] : '',
                'fulfillment_service' => 'manual',
                'grams' => 0,
                'inventory_management' => 'shopify',
                'requires_shipping' => true,
                'sku' => isset($variantNode['sku']) ? $variantNode['sku'] : '',
                'weight' => isset($variantNode['inventoryItem']['measurement']['weight']['value']) ? $variantNode['inventoryItem']['measurement']['weight']['value'] : 0,
                'weight_unit' => isset($variantNode['inventoryItem']['measurement']['weight']['unit']) ? strtolower($variantNode['inventoryItem']['measurement']['weight']['unit']) : 'kg',
                'inventory_item_id' => (int)str_replace('gid://shopify/InventoryItem/', '', $variantNode['inventoryItem']['id']),
                'inventory_quantity' => $variantNode['inventoryQuantity'],
                'old_inventory_quantity' => $variantNode['inventoryQuantity'],
                'admin_graphql_api_id' => $variantNode['id'],
                'image_id' => isset($variantNode['image']['id']) ? (int)str_replace('gid://shopify/ProductImage/', '', $variantNode['image']['id']) : null,
            ];
        }
        $transformedProduct['variants'] = $variants;

        // Options
        $options = [];
        foreach ($node['options'] as $option) {
            $optionId = (int)str_replace('gid://shopify/ProductOption/', '', $option['id']);
            $options[] = [
                'id' => $optionId,
                'product_id' => $productId,
                'name' => $option['name'],
                'position' => $option['position'],
                'values' => $option['values'],
            ];
        }
        $transformedProduct['options'] = $options;

        // Images
        $images = [];
        if (!empty($node['images']['edges'])) {
            foreach ($node['images']['edges'] as $index => $imageEdge) {
                $imageNode = $imageEdge['node'];
                $imageId = (int)str_replace('gid://shopify/ProductImage/', '', $imageNode['id']);

                $variantIds = [];
                foreach ($variants as $variant) {
                    if ($variant['image_id'] === $imageId) {
                        $variantIds[] = $variant['id'];
                    }
                }

                $images[] = [
                    'id' => $imageId,
                    'alt' => null,
                    'position' => $index + 1,
                    'product_id' => $productId,
                    'created_at' => $node['createdAt'],
                    'updated_at' => date('c'),
                    'admin_graphql_api_id' => $imageNode['id'],
                    'width' => 0,
                    'height' => 0,
                    'src' => $imageNode['url'],
                    'variant_ids' => $variantIds,
                ];
            }
        }
        $transformedProduct['images'] = $images;

        // Featured image
        $transformedProduct['image'] = isset($images[0]) ? $images[0] : null;

        $transformedProducts[] = $transformedProduct;
    }

    return $transformedProducts;
}


function addlog($message, $type="INFO"){
    global $logfile;
    $txt = date("Y-m-d H:i:s")." [".$type."]: ".$message."\n";
    fwrite($logfile, $txt);
}

fclose($logfile);