<?php
set_time_limit(0);
ini_set('memory_limit', '-1');

require_once("/home/cp1infoshoreapps/public_html/updatedepi/cronjobs/includes/config.php");

require_once("/home/cp1infoshoreapps/public_html/updatedepi/cronjobs/includes/sendgrid/sendgrid-php.php");
require '/home/cp1infoshoreapps/public_html/cronjobs/includes/eblib/ebay-sdk-php-autoloader.php';

use DTS\eBaySDK\Trading\Types;
use DTS\eBaySDK\Trading\Services\TradingService;
use DTS\eBaySDK\Trading\Types\SetNotificationPreferencesRequestType;


global $ebConfig;

$conn = new mysqli($host, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}
mysqli_set_charset($conn, "utf8");

$eventTypes = ['FixedPriceTransaction', 'ItemListed', 'ItemClosed', 'ItemRevised', 'ItemSold'];
$csvData = [];


$csvHeader = array_merge(['User ID'], $eventTypes);
$csvData[] = $csvHeader;

$result = $conn->query("select * FROM users WHERE  installationstatus = 1 AND id IN (47972, 50331, 50340, 50341, 50342, 50343, 50344, 50345, 50346, 50347, 50348, 50349, 50351, 50352, 50355, 50356,
50357, 50358, 50363, 50364, 50366, 50367, 50368, 50370, 50372, 50373, 50379, 50383, 50387, 50390, 50391, 50392,
50393, 50394, 50395, 50399, 50400, 50401, 50403, 50404, 50405, 50406, 50407, 50408, 50409, 50410, 50411, 50413,
50414, 50415, 50416, 50417, 50418, 50419, 50420, 50421, 50422, 50423, 50424, 50425, 50426, 50428, 50429, 50430,
50431, 50433, 50434, 50435, 50437, 50438, 50439, 50440, 50443, 50444, 50445, 50446, 50447, 50448, 50449, 50450,
50451, 50452, 50458, 50459, 50460, 50461, 50462, 50463, 50464, 50466, 50468, 50470, 50471, 50472, 50473, 50474,
50475, 50476, 50477, 50478, 50479, 50480, 50481, 50482, 50483, 50484, 50485, 50486)");
if ($result->num_rows < 1) {
    die("No users found");
}

while ($row = $result->fetch_assoc()) {
    $user_id = $row['id'];
    $configResult = $conn->query("select  * FROM eb_keys WHERE user_id = '" . $user_id . "'");
    
    while ($configRow = $configResult->fetch_assoc()) {
        $token = $configRow['token'];
        $siteid = $configRow['siteid'];

        $rowResult = [$user_id];
        foreach ($eventTypes as $eventType) {
            $status = 'Enable';
            $eventURL = "https://y4rni1yzq9.execute-api.ap-south-1.amazonaws.com/test_any/";
            $response = setupIPN($user_id, $token, $siteid, $status, $eventType, $eventURL);
            $rowResult[] = $response['status'] ?? 'error';
        }

        $csvData[] = $rowResult;
    }
}

outputCSV($csvData, "ebay_ipn_enable_statusNew.csv");

function setupIPN($user_id, $token, $siteid, $status, $eventType, $eventURL) {
    global $ebConfig;

    if (strlen($token) == 0) {
        return ['status' => 'no_token'];
    }

    $service = new TradingService([
        'credentials' => $ebConfig['production']['credentials'],
        'sandbox'     => false,
        'siteId'      => $siteid
    ]);

    $request = new SetNotificationPreferencesRequestType();
    $request->RequesterCredentials = new Types\CustomSecurityHeaderType();
    $request->RequesterCredentials->eBayAuthToken = $token;

   
    $appPrefs = new Types\ApplicationDeliveryPreferencesType();
    $appPrefs->ApplicationURL = $eventURL;
    $request->ApplicationDeliveryPreferences = $appPrefs;

  
    $notificationEnable = new Types\NotificationEnableType();
    $notificationEnable->EventType = $eventType;
    $notificationEnable->EventEnable = $status;

    $notificationArray = new Types\NotificationEnableArrayType();
    $notificationArray->NotificationEnable = [$notificationEnable];
    $request->UserDeliveryPreferenceArray = $notificationArray;

   
    $userData = new Types\NotificationUserDataType();
    $userData->ExternalUserData = $user_id . "_servernew";
    $request->UserData = $userData;

    $response = $service->setNotificationPreferences($request);

    if ($response->Ack !== 'Failure') {
        return ['status' => 'Enabled'];
    } else {
        return ['status' => 'Failed'];
    }
}

function outputCSV($data, $filename) {
    $file = fopen($filename, 'w');
    foreach ($data as $row) {
        fputcsv($file, $row);
    }
    fclose($file);
    echo "CSV file generated: $filename\n";
}
