<?php

namespace App\Http\Controllers;

use App\Jobs\newjobb;
use App\Product;
use App\ShopifyRequest;
use App\EbRequest;

use App\EbKey;
require '/home/cp1infoshoreapps/public_html/updatedepi/api/ebay_sdk/vendor/autoload.php';

use DTS\eBaySDK\Trading\Services;
use DTS\eBaySDK\Trading\Types;
use DTS\eBaySDK\Trading\Enums;

use App\ProductVariant;
use App\ProductImage;
use App\Setting;
use App\ProcessImport;
use App\Process_reimport;
use App\Jobs\newjob;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Collection;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\Translation\Tests\Dumper\IniFileDumperTest;
use Validator;
use File;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use Maatwebsite\Excel\Facades\Excel;

class ProductController extends Controller {

	public function __construct() {
        // Apply the jwt.auth middleware to all methods in this controller
        // except for the authenticate method. We don't want to prevent
        // the user from retrieving their token if they don't already have it
        $this->middleware('jwt.auth', ['except' => ['authenticate']]);
    }

 public function index()
{
    $per_page = \Request::get('per_page') ?: 20;
    $currUser = Auth::user();
    $query = \Request::get('query') ?: '';

    $builder = $currUser->products()->with('variants.mainImage');

    switch ($query) {
        case 'Import In Progress':
        case 'Imported':
        case 'Error':
        case 'Ready To Import':
        case 'Already Exist':
            $builder->where('status', $query);
            break;

        case 'Product desc':
            $builder->orderBy('product_id', 'DESC');
            break;

		 case 'All':
            $builder->orderBy('product_id', 'DESC');
            break;

        case 'Product asc':
            $builder->orderBy('product_id', 'ASC');
            break;

        case 'Title asc':
            $builder->orderBy('title', 'ASC');
            break;

        case 'Title desc':
            $builder->orderBy('title', 'DESC');
            break;

        default:
            if (!empty($query)) {
                $builder->where(function ($q) use ($query) {
                    $q->where('title', 'like', '%' . $query . '%')
                      ->orWhere('ebayitemid', 'like', '%' . $query . '%');
                });
            }
            $builder->orderBy('product_id', 'DESC');
            break;
    }

    Log::info($currUser->id . " -- Ended - " . date("Y-m-d H:i:s"));
    return $builder->paginate($per_page);
}


	public function getProductCount(){
		$user = Auth::User();


		$counts = Product::where('user_id', $user->id)
			->selectRaw("
			        COUNT(*) AS all_count,

				SUM(CASE WHEN status = 'Already Exist' THEN 1 ELSE 0 END) AS already_exist_count,
				SUM(CASE WHEN status = 'Ready to Import' THEN 1 ELSE 0 END) AS ready_to_import_count,
				SUM(CASE WHEN status = 'Import in progress' THEN 1 ELSE 0 END) AS import_in_progress_count,
				SUM(CASE WHEN status = 'Imported' THEN 1 ELSE 0 END) AS imported_count,
				SUM(CASE WHEN status = 'reimport in progress' THEN 1 ELSE 0 END) AS reimport_in_progress_count,
				SUM(CASE WHEN status = 'error' THEN 1 ELSE 0 END) AS error_count
			")
			->first();
		return $counts;
	}
	public function PriceAndQuantityUpdateBoth(Request $request){
		$currUser = Auth::User();
		$user_id = $currUser->id ;
		$shopurl = $currUser->shopurl;
		$token = $currUser->token;
		Log::info("user_id ".$currUser->id);
		$variant = \Request::get('variant');
		$sellerid = \Request::get('sellerid');
		$variantArray = json_decode($variant, true); // decode as array
        $sku = $variantArray['sku'];
        $price = $variantArray['price'];
        $quantity = $variantArray['quantity'];
        $ebayitemid = $variantArray['ebayitemid'];
        $shopifyproductid = $variantArray['shopifyproductid'];
        $shopifyvariantid = $variantArray['shopifyvariantid'];
        $variantid = $variantArray['id'];
		$shopifyinventoryid = $variantArray['shopifyinventoryid'];
		$location_id = $variantArray['shopifylocationid'];
        Log::info("SKU: " . $sku);
		
		
		$eb_key = array();
		// $sellerid = '';
		Log::info("sellerid: " . $sellerid);
		Log::info("ebayitemid: " . $ebayitemid);

		if($sellerid == ""){
			if($user_id == 47340){
					Log::info("sellerid: hiteshmali " . $sellerid);
        Log::info("ebayitemid: hiteshmali " . $ebayitemid);

        // Fetch product with matching ebayitemid and user_id
        $product = Product::where('ebayitemid', $ebayitemid)
                          ->where('user_id', $user_id)
                          ->first();

         $sellerid = $product['searchstring'];
        Log::info("product: " . json_encode($sellerid));

				$eb_key = EbKey::where('sellerid', $sellerid)->where('user_id', $user_id)->first();
			}else{
                 $eb_key = EbKey::where('user_id',$user_id)->first();
			}
		}else{
			$eb_key = EbKey::where('sellerid', $sellerid)->where('user_id', $user_id)->first();
		}
		$ebToken = $eb_key['token'];
		$siteid = $eb_key['siteid'];
		Log::info("ebToken: " . $ebToken);
		// die();
		$ebConfig = array('production' => 
		array('credentials' => array(
			'devId' => '83df6eb2-cf1a-4c04-87ea-a5f3e450bd25',
			'appId' => 'InfoShor-SKUBubbl-PRD-42f5817e2-a5e09617',
			'certId' => 'PRD-2f5817e259c8-7213-4949-a498-8162')),
		'sandbox' => 
		array('credentials' => array(
			'devId' => '83df6eb2-cf1a-4c04-87ea-a5f3e450bd25',
			'appId' => 'InfoShor-SKUBubbl-SBX-145f6444c-fd18db0d',
			'certId' => 'SBX-45f6444cfae6-5fa1-4c90-bddb-6845')));

			$service = new Services\TradingService([
				'credentials' => $ebConfig['production']['credentials'],
				'sandbox'     => false,
				'siteId'      => $siteid
			]);
                 
                 $request = new Types\ReviseFixedPriceItemRequestType();
                 $request->RequesterCredentials = new Types\CustomSecurityHeaderType();
                 $request->RequesterCredentials->eBayAuthToken =  $ebToken; // Your auth token
                 
                 // Item to update
                 $request->Item = new Types\ItemType();
                 $request->Item->ItemID = $ebayitemid; // eBay Item ID
                 
                 // Variant/Variation to update
               
                //  $variation->SKU = $sku; // Replace with your SKU
				$request->Item->StartPrice = new Types\AmountType(['value' =>  (float) $price]); // Updated price
				$request->Item->Quantity = (int) $quantity; // Updated quantity
                 // Call the API
                 $response = $service->reviseFixedPriceItem($request);
                 // Check for success
                 if ($response->Ack !== 'Failure') {
					Log::info("Variant updated successfully! ebay item id  ". $ebayitemid);
                   if($shopifyproductid){
					$res = $this->updateShopifyInventory($token, $shopurl, $shopifyinventoryid, $location_id, $quantity);
                     
					if('location error' === $res){
						$location =  $this->getLocationId($token, $shopurl, $shopifyinventoryid);
						$res = $this->updateShopifyInventory($token,$shopurl,$shopifyinventoryid,$location,$quantity);
					   
						if($res == true){
							$variant = ProductVariant::find($variantid);
							if ($variant) {
							  $variant->update([
								  'price' => $price,
								  'quantity' => $quantity
							  ]);
						  }
						  $resprice = 	$this->updateShopifyVariant($token,$shopurl,$shopifyvariantid,$price,$shopifyproductid);
						  if($resprice == true){
							return [
								"response" => "success",
								'msg'=>"Quantity and price updated on both eBay and Shopify. Price " . $price ." Quantity " . $quantity
							];
						  }else{
							
							return [
								"response" => "success",
								'msg'=>"Quantity and price updated on eBay. Only quantity updated on Shopify. Price " . $price ." Quantity " . $quantity
							];
						  }
							

						}else{
							return [
								"response" => "success",
								'msg'=>"Quantity and price updated on eBay. No changes made on Shopify. Price " . $price ." Quantity " . $quantity
							];
						}
					}

					if($res == true){

						Log::info("price " . $price);

						$variant = ProductVariant::find($variantid);
						if ($variant) {
							$variant->update([
								'price' => $price,
								'quantity' => $quantity
							]);
						}
						$resprice = $this->updateShopifyVariant($token,$shopurl,$shopifyvariantid,$price,$shopifyproductid);
						if($resprice == true){
						  return [
							  "response" => "success",
							  'msg'=>"Quantity and price updated on both eBay and Shopify. Price " . $price ." Quantity " . $quantity
						  ];
						}else{
						  return [
							  "response" => "success",
							  'msg'=>"Quantity and price updated on eBay. Only quantity updated on Shopify. Price " . $price ." Quantity " . $quantity
						  ];
						}
						  

					  }else{
						  return [
							  "response" => "success",
							  'msg'=>"Quantity and price updated on eBay. No changes made on Shopify. Price " . $price ." Quantity " . $quantity
						  ];
					  }
					}else{
						return [
							"response" => "success",
							'msg'=>"Quantity and price updated on eBay. Product not yet imported on Shopify. Price " . $price ." Quantity " . $quantity
						];
					}

					
                 } else {
                     foreach ($response->Errors as $error) {
						Log::info(" error on price and quantity update error ");
						Log::info($error->ShortMessage);
						return [
							"response" => "error",
							'msg'=>"Update failed on both eBay and Shopify. Please contact support for further assistance."
						];
                     }
                 }

    }


public function getvarientsupdate(Request $request){
		$currUser = Auth::User();
		$variants = $currUser->variants->where('quantity', '!=', 0);
		return $variants;	
	}

public function updateShopifyVariant($token, $shopurl,$shopifyvariantid,$price,$shopifyproductid) {
		$variantId = $shopifyvariantid;  
		$price = number_format($price, 2, '.', '');
	
		$queryProductVariantsBulkUpdate = <<<QUERY
		mutation productVariantsBulkUpdate(\$productId: ID!, \$variants: [ProductVariantsBulkInput!]!) {
		  productVariantsBulkUpdate(productId: \$productId, variants: \$variants) {
			product {
			  id
			}
			productVariants {
			  id
			  price
			}
			userErrors {
			  field
			  message
			}
		  }
		}
		QUERY;
	
		$productId = "gid://shopify/Product/".$shopifyproductid; 
		$variants = [
			[
				"id" => "gid://shopify/ProductVariant/".$variantId, 
				"price" => $price,
			]
		];
		Log::info("  price update array  " . json_encode($variants));
		$variablesProductVariants = [
			"productId" => $productId,
			"variants" => $variants,
		];
	
		$payloadProductVariants = json_encode([
			"query" => $queryProductVariantsBulkUpdate,
			"variables" => $variablesProductVariants,
		]);
	
		$ch = curl_init("https://$shopurl/admin/api/2024-10/graphql.json");
	
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			"Content-Type: application/json",
			"X-Shopify-Access-Token: $token"
		]);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payloadProductVariants);
	
		$responseProductVariants = curl_exec($ch);
	
		if (curl_errno($ch)) {
			curl_close($ch);
			Log::info("ERROR IN UPDATESHOPIFYVARIANT ");
			return false;
		}
		curl_close($ch);
	
		$responseDataProductVariants = json_decode($responseProductVariants, true);
		Log::info("  price update response  " . json_encode($responseDataProductVariants));
		if (isset($responseDataProductVariants['data']['productVariantsBulkUpdate'])) {
			$errors = $responseDataProductVariants['data']['productVariantsBulkUpdate']['userErrors'] ?? [];
			if (!empty($errors)) {
				foreach ($errors as $error) {
					Log::info("Error: " . $error['message']);
				}
					return false;
			}
	
			$product = $responseDataProductVariants['data']['productVariantsBulkUpdate']['product'];
			Log::info("Updated Product ID: " . $product['id'] . "   ");
	
			$productVariants = $responseDataProductVariants['data']['productVariantsBulkUpdate']['productVariants'];
			foreach ($productVariants as $variant) {
				Log::info("Variant ID: " . $variant['id'] . "   and  Updated Price:  " . $variant['price'] . "    ");
			}
			return true;
		} else {
			Log::info("Product Variants Bulk Update - Unexpected response structure.");
			return false;
		}
	}

	
public function getLocationId($token, $shopurl, $inventory_item_id){	
    $graphqlUrl = "https://$shopurl/admin/api/2024-10/graphql.json"; 
  
    $query = <<<GRAPHQL
        {
        inventoryItem(id: "gid://shopify/InventoryItem/$inventory_item_id") {
          inventoryLevels(first: 10) {
          edges {
            node {
            id
            location {
              id
              name
            }
               quantities(names: ["available"]) {
              name
              quantity
            }
            }
          }
          }
        }
        }
  GRAPHQL;
  
    // Initialize cURL session
    $ch = curl_init($graphqlUrl);
  
    // Set cURL options
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
      'Content-Type: application/json',
      'X-Shopify-Access-Token: ' . $token
    ]);
  
    // Prepare the payload
    $data = json_encode(['query' => $query]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    // Execute the cURL request
    $response = curl_exec($ch);
  
  
    $response = json_decode($response,true);
    // print_r($response);
   
    $locationQuantity = array();
    foreach($response['data']['inventoryItem']['inventoryLevels']['edges'] as $inventoryItem){
      $locationQuantity[] = array(
        'location'=> $inventoryItem['node']['location']['id'],
        'quantity'=> $inventoryItem['node']['quantities'][0]['quantity'],
      );
    }
    $pattern = '/gid:\/\/shopify\/Location\//'; // The regex pattern to match the string
    $replacement = ''; // We replace it with an empty string (i.e., remove it)
    $locationId = preg_replace($pattern, $replacement, $locationQuantity[0]['location']);
    return $locationId;	
  
  }	

public function updateShopifyInventory($token,$shopurl,$inventory_item_id,$location_id,$quantity){
		$shopifyinverid = 'gid://shopify/InventoryItem/'.$inventory_item_id;
		$shopifylocatid = 'gid://shopify/Location/'.$location_id;
		
	   $quantity = (int) $quantity;
	
			$query = <<<QUERY
			mutation InventorySet(\$input: InventorySetQuantitiesInput!) {
			inventorySetQuantities(input: \$input) {
				inventoryAdjustmentGroup {
				createdAt
				reason
				changes {
					name
					delta
				}
				}
				userErrors {
				field
				message
				}
			}
			}
			QUERY;
	
	
		$variables = [
			"input" => [
				"ignoreCompareQuantity" => true,
				"name" => "available",
				"reason" => "correction",
				"quantities" => [
					[
						"inventoryItemId" => $shopifyinverid, 
						"locationId" => $shopifylocatid, 
						"quantity" => $quantity
					]
				]
			]
		];
	  
		
		$payload = json_encode([
			'query' => $query,
			'variables' => $variables
		]);
		$ch = curl_init("https://$shopurl/admin/api/2024-10/graphql.json");
		
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			"Content-Type: application/json",
			"X-Shopify-Access-Token: $token"
		]);
		
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
		


		//print_r($variables);
		$response = curl_exec($ch);
		
		if(curl_errno($ch)) {
			Log::info('cURL Error: ' . curl_error($ch));
		}
		curl_close($ch);
	
		$responseData = json_decode($response, true);
	
		Log::info("QUANTITY FOR UPDATE on shopify response : " . json_encode($responseData,true));
		if (isset($responseData['data']['inventorySetQuantities'])) {
			if(isset($responseData['data']['inventorySetQuantities']['userErrors'][0]['field'])){
				Log::info("PERTICULAR ID IN ARRAY.  ".json_encode($responseData['data']['inventorySetQuantities']['userErrors'])."");
				if (isset($responseData['data']['inventorySetQuantities']['userErrors'][0]['message']) && in_array($responseData['data']['inventorySetQuantities']['userErrors'][0]['message'], ['The specified inventory item is not stocked at the location.','The specified location could not be found.'])) {
					return 'location error';
				}
				 return false;
				}
			$inventoryAdjustmentGroup = $responseData['data']['inventorySetQuantities']['inventoryAdjustmentGroup'];  
			if (isset($inventoryAdjustmentGroup['changes'])) {
				foreach ($inventoryAdjustmentGroup['changes'] as $change) {
					Log::info("Change: " . $change['name'] . " | Delta: " . $change['delta'] ."");
				}
			}
	
			 return true;
		} else {
			Log::info("Error: ");
			 
			if (isset($responseData['errors'])) {
				if (is_array($responseData['errors'])) {
					foreach ($responseData['errors'] as $error) {
						Log::info("inventery not updata on shopify ".$error['message']);
						
					}
				} else {
					Log::info("inventery not updata shopify ".$responseData['errors'] );
					
				}
			}
		
			if (isset($responseData['data']['inventoryAdjustQuantities']['userErrors'])) {
				foreach ($responseData['data']['inventoryAdjustQuantities']['userErrors'] as $error) {
					Log::info($error['field'] . " - " . $error['message'] );
				}
			}
			return false;
		} 
}

	public function search(Request $request) {
		$per_page = \Request::get('per_page') ?: 20;
		$currUser = Auth::User();
        ### search
		Log::info("searchternvvv".$request['query']);
        if ($request['query']) {
			 if($currUser->id == '41840' || $currUser->id == '46873'){
				$products = $currUser->products()
				->where('title','like','%'.$request['query'].'%')->orWhere('ebayitemid','like','%'.$request['query'].'%')->orderBy('product_id', 'DESC');
				return $products->paginate($per_page);	
			}
			
			else if($currUser->id == '4335'){
			    $orderbystr = "CAST(searchstring AS DECIMAL(10,2)) DESC";
				$products = $currUser->products()->where('title','like','%'.$request['query'].'%')->orderByRaw($orderbystr);
				return $products->paginate($per_page);	
			} 
			else if( $currUser->id == '44841'){
			    $products = $currUser->products()->where('title','like','%'.$request['query'].'%')->where('deleted', '=', 0)->orderBy('product_id', 'DESC');
				return $products->paginate($per_page);	
			}
			else if($currUser->id == '43975' ){
                   
				if($request['query'] == 'outofstock'){
					
					$products = $currUser->products()->where('searchstring','like','%'.$request['query'].'%')->orderBy('product_id', 'DESC');
				return $products->paginate($per_page);	

				  }
	         else {
				
			   $products = $currUser->products()->where('title','like','%'.$request['query'].'%')->orderBy('product_id', 'DESC');
				return $products->paginate($per_page);	

			 }
			}
			else if ($currUser->id == '44719' || $currUser->id == '45738' || $currUser->id == '45165'   || $currUser->id == '45631' || $currUser->id == '46873'){
			  
				
				Log::info("searchtern".$request['query']);
				$products = $currUser->products()->where('block','=','0')->where('deleted','=','0')->where('title','like','%'.$request['query'].'%')->orderBy('product_id', 'DESC');
				//Log::info("data".json_encode($products));

				return $products->paginate($per_page);
			}
			else {
				$products = $currUser->products()->where('title','like','%'.$request['query'].'%')->orWhere('ebayitemid','like','%'.$request['query'].'%')->orderBy('product_id', 'DESC');
				return $products->paginate($per_page);	
			}
        } else {
			Log::info("searchtern else ".$request['query']);
			return $this->index();
		}
    }

   
	public function block($id){
		$temp = explode(",", $id);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		if($currUser->id != 5001){
    		$blockedCount = $currUser->products()->whereIn('product_id', $temp)->where(function ($query) {
    			$query->where('block', '=', 1)->orWhere('status', '!=', 'Ready to Import');
    				})->count();
    		if($blockedCount > 0){
    			$errMsg = "The selected products could not be blocked.";
    			if($count == 1){
    				$errMsg = "The selected product could not be blocked.";
    			}
    			return response()->json(['error' => ["msg"=>[$errMsg]]], 406);
    		}
		}
		$currUser->products()->whereIn('product_id', $temp)->update(['block' => 1]);
	//	$currUser->variants()->whereIn('product_id', $temp)->update(['block' => 1]);
        return response()->json(['success'], 200);
	}
	public function ShopifyToEbay()
	{
		$currUser = Auth::User();		
		//$currUser= User::where('id',1)->get();
		$ownername = $currUser->ownername;
		$email = $currUser->email;
		$shopurl = $currUser->shopurl;
		$token = $currUser->token;
		$created_at = $currUser->created_at;
		$updated_at = $currUser->updated_at;
		$EbKeys = $currUser->ebKey()->first();
		$sellerid = $EbKeys->sellerid;
		$Ebaytoken = $EbKeys->token;
		$siteid = $EbKeys->siteid;
		$Setting = $currUser->settings()->first();
		$shopifylocationid = $Setting->shopifylocationid;
		
		$data = [
			'ownername' => $ownername,
			'email' => $email,
			'shopurl' => $shopurl,
			'token' => $token,
			'created_at' => $created_at,
			'updated_at' => $updated_at,
			'sellerid' => $sellerid,
			'Ebaytoken' => $Ebaytoken,
			'siteid' => $siteid,
			'shopifylocationid' => $shopifylocationid,
		];
		
		// Convert the array to a JSON string
		$jsonData = json_encode($data);
		
		// Base64 encode the JSON string
		$base64Encoded = base64_encode($jsonData);
		
		// Output the result
		echo $base64Encoded;
	}
	public function unblock($id){
		$temp = explode(",", $id);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$currUser->products()->whereIn('product_id', $temp)->update(['block' => 0]);
	//	$currUser->variants()->whereIn('product_id', $temp)->update(['block' => 0]);
        return response()->json(['success'], 200);
	}

	public function push($id){
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription to import more products."]]], 406);
		}
		$temp = explode(",", $id);
		$count = count($temp);
		$count2 = count($temp);
		Log::info($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$user_id = $currUser->id;

		$count = $currUser->products()->whereIn('product_id', $temp)->where('status', '!=', 'Ready to Import')->count();

		if($count > 0){
			return response()->json(['error' => ["msg"=>['The selected products could not push to shopify because some items within the selection have already been imported.']]], 406);
		} else {
			$skulimit = $currUser->skulimit;
			$skuconsumed = $currUser->skuconsumed;
			$vproducts = $currUser->products()->whereIn('product_id', $temp)->where('block', 0)->where('duplicate', 0)->where('status', '=', 'Ready to Import');
			$vcount = $vproducts->count();			
			if($skulimit < ($skuconsumed + $vcount)){
				return response()->json(['error' => ["msg"=>['The number of eBay listings you want to import is more than your allowed limit. Please upgrade your plan.']]], 406);
			} else {
				$count1=$currUser->processimports()->where('user_id', $user_id)->first();
				$checkcount =0;
				if($count1){
					//Log::info("Count old count".json_encode($count1));
					 $totva =$count1->count;
					$countnew=$vcount+$totva;
					$checkcount = $countnew;
					Log::info("new count".$countnew);
					$currUser->processimports()->where('user_id', $user_id)->update(['count' => $countnew]);
					Log::info("new count has been updated".$countnew);
				}else{
					Log::info("Count old count 0");
					$import = new ProcessImport([
						'user_id' => $user_id,
						'count' => $count2, 
					]);
					$import->save();
					$checkcount = $count2;
					Log::info("new count have been added in processimport".$count2);
				
				}
				$currUser->products()->whereIn('product_id', $temp)->where('block', 0)->where('duplicate', 0)->where('status', '=', 'Ready to Import')->update(['status' => 'Import in Progress']);
				$currUser->skuconsumed = $skuconsumed + $vcount;
				$currUser->save();
				$msg="entered into new job in api";
				//newjobb::dispatch();
				$user =$user_id;
				// if($checkcount < 100){
				// dispatch(new newjobb($user));
		     	// }
				return response()->json(['skuconsumed' => $currUser->skuconsumed,'message'=>'Your Product are imported after sometime'], 200);
			}
		}
	}

	public function pushall(){	
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription to import more products."]]], 406);
		}
		$currUser = Auth::User();
		$skulimit = $currUser->skulimit;
		$skuconsumed = $currUser->skuconsumed;
		/*$products = $currUser->products()->where('status', 'Ready to Import')->where('block', 0)->with('variantsCount')->get();
		$vcount = 0;
		foreach($products as $product){			
			$vcount  = $vcount + $product->variantsCount()->first()->no_of_variants;
		}*/
		$vcountnew = $currUser->products()->where('block', 0)->where('duplicate', 0)->where('status', '=', 'Ready to Import');
		$vcount = $vcountnew->count();
		if($skulimit < ($skuconsumed + $vcount)){
			return response()->json(['error' => ["msg"=>['The number of ebay listings you want to import is more than your allowed limit. Please upgrade your plan.']]], 406);			
		} else {
               $count1  = $vcount;
			   $user_id = $currUser->id;
			   $count2=$currUser->processimports()->where('user_id', $user_id)->first();
			   
			if($count2){
				$count2vl =$count2->count;
				$countnew=$count1+$count2vl;
				$currUser->processimports()->where('user_id', $user_id)->update(['count' => $countnew]);
				Log::info("processbulk import cunt has been updated to ".$countnew);
			}else{
				//$count2vl = $count2['count'];
				$import = new ProcessImport([
					'user_id' => $user_id,
					'count' => $count1, 
				]);
				$import->save();
				Log::info("new count have been added in processimport".$count2->count);
			
			}

			$currUser->products()->where('status', 'Ready to Import')->where('block', 0)->where('duplicate', 0)->update(['status' => 'Import in Progress']);

			$currUser->skuconsumed = $skuconsumed + $vcount;
			$currUser->save();
			return response()->json(['skuconsumed' => $currUser->skuconsumed], 200);
		}		
	}
	
	public function getVariants(Request $request){
		$currUser = Auth::User();
		if($request->has("product_id")){
			$product_id = $request->input("product_id");
			$variants = $currUser->variants()->where('product_id', $product_id)->get();
			return $variants;
		} else {
			return array();
		}		
	}




	public function suggestedPlan(){
		$currUser = Auth::User();
		$count = $currUser->products()->count();//->where('quantity', '>', 0)
		$suggestedPlanType = 1;
		$suggestedPlanName = "BRONZE";
		if($count > 5000){
			$suggestedPlanType = 4;
			$suggestedPlanName = "CUSTOM";
		} else if($count > 2000){
			$suggestedPlanType = 3;
			$suggestedPlanName = "GOLD";
		} else if($count > 500) {
			$suggestedPlanType = 2;
			$suggestedPlanName = "SILVER";
		}		
		if($currUser->id == 721){
		    $suggestedPlanType = 3;
			$suggestedPlanName = "CUSTOM";
		}
		if($currUser->id == 212){
		    $suggestedPlanType = 3;
			$suggestedPlanName = "CUSTOM";
		}
		if($currUser->id == 1057){
		    $suggestedPlanType = 3;
			$suggestedPlanName = "CUSTOM";
		}
		if($currUser->id == 15864 || $currUser->id == 6232 || $currUser->id == 4059 || $currUser->id == 1358 || $currUser->id == 4946 || $currUser->id == 5587){
		    $suggestedPlanType = 1;
			$suggestedPlanName = "BRONZE";
		}
		if($currUser->id == 7205 || $currUser->id == 7370 || $currUser->id == 1250 || $currUser->id == 3766 || $currUser->id == 1886 || $currUser->id == 2487 || $currUser->id == 4350 || $currUser->id == 6168 || $currUser->id == 5715){
		    $suggestedPlanType = 3;
			$suggestedPlanName = "Gold";
		}
		if($currUser->id == 2221 || $currUser->id == 6232 || $currUser->id == 5461 || $currUser->id == 2275 || $currUser->id == 1748 || $currUser->id == 3463 || $currUser->id == 5852){
		    $suggestedPlanType = 1;
			$suggestedPlanName = "BRONZE";
		}
        if($currUser->id == 5053 || $currUser->id == 7683 || $currUser->id == 4884 || $currUser->id == 6236 || $currUser->id == 6317 || $currUser->id == 7103){
            $suggestedPlanType = 2;
            $suggestedPlanName = "SILVER";
        }
        if($currUser->id == 5891){
		    $suggestedPlanType = 2;
			$suggestedPlanName = "Silver";
		}
		return response()->json(['count' => $count, 'suggestedPlanType' => $suggestedPlanType, 'suggestedPlanName' => $suggestedPlanName], 200);
	}

	private function validateMembership(){
	    return true;
		/*$currUser = Auth::User();
		$review = $currUser->review;
		$paid_at = $currUser->paid_at;
		$created_at = $currUser->created_at;
		$fromtime = new Carbon($paid_at);
		if(strtotime($paid_at) < 1){
			$fromtime = new Carbon($created_at);
		}		
		$now = Carbon::now();
		$difference = $fromtime->diffInDays($now);
		if($difference > 30 && $currUser->sync == 0 && $currUser->review == 0) {
			return false;
		} else if($difference > 60 && $currUser->sync == 0 && $currUser->review == 1) {
			return false;
		} else {
			return true;
		}	*/	
	}
    
    public function exportFile(Request $request) {
		ini_set('memory_limit', '-1');
		$currUser = Auth::User();
		if($currUser->id != '10564'){
			return response()->json(['error' => ["msg" => ['You are not authorized to access this resource.']]], 406);
		}	
		$data = array();
		$data[] = array("Part Number", "Condition Description",	"Quantity",	"Unit of Measure", "Price",	"Shipping Cost", "Title", "Condition", "SKU", "Brand", "Item Description", "Images URL");
		$products = $currUser->products()->with('variants.mainImage')->get();
		foreach($products as $product){
		    $partnumber = "";
		    $unitofmeasure = "";
		    $item_specific = $product->item_specific;
			$itemSpecArr = json_decode($item_specific, true);
			if(isset($itemSpecArr["Manufacturer Part Number"])){
			    $partnumber = $itemSpecArr["Manufacturer Part Number"];
			}
			$images = $product->variants[0]->images()->get(['imgurl']);
		    $row = array();
		    $row[0] = $partnumber;
		    $row[1] = $product->condition_note;
		    $row[2] = $product->variants[0]->quantity;
		    $row[3] = "";
		    $row[4] = $product->variants[0]->price;
		    $row[5] = "";
		    $row[6] = $product->title;
		    $row[7] = $product->condition_val;
		    $row[8] = $product->variants[0]->sku;
		    $row[9] = $product->brand;
		    $row[10] = "";
		    $row[11] = "";
		    $data[] = $row;
		}
		Excel::create('invreport', function($excel) use ($data) {
			$excel->sheet('Sheet 1', function ($sheet) use ($data) {
				$sheet->fromArray($data);
			});
		})->store("xlsx", public_path()."/reports/");
		return response()->json(['success'], 200);
    }
    
	public function updatePDesc(Request $request) {
		$currUser = Auth::User();
		$validator = Validator::make($request->all(), [
								'product_id' => 'required'
							]);
		if ($validator->fails()) {
			return response()->json(['error' => $validator->errors()], 406);
		} else {			
			$product_id = $request->input('product_id');
			$productObj = $currUser->products()->find($product_id);
			if($productObj){
				$productObj->update($request->all());
				return response()->json(['success'], 200);
			} else {
				return response()->json(['error' => ["msg"=> ['There was some error updating product description.']]], 406);
			}
		}
	}
	
	public function remove($ids){
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription."]]], 406);
		}
		$temp = explode(",", $ids);
		$count = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$token = $currUser->token;
		$shopurl = $currUser->shopurl;
		$user_id = $currUser->id;
		foreach($temp as $id){
			$productObj = $currUser->products()->find($id);
			Log::info($productObj);
			if($productObj){
				$shopifyproductid = $productObj->shopifyproductid;
				if(strlen($shopifyproductid) > 0){
					// $this->deleteShopifyProduct($user_id, $token, $shopurl, $shopifyproductid);

					$response = $this->deleteShopifyProductGraphQL($shopurl, $token, $shopifyproductid);
					$productObj->variants()->update(['shopifyproductid' => '', 'shopifyvariantid' => '', 'status' => 'Ready to Import']);
					$productObj->shopifyproductid = '';
					$productObj->status = 'Ready to Import';
					$productObj->save();
				}
			}
		}
		$productObj = $currUser->products()->find($id);

		return response()->json( $productObj ,200);
	}

	public function deleteShopifyProductGraphQL($shop, $accessToken, $productGid)
	{
		$url = "https://{$shop}/admin/api/2024-10/graphql.json";

		$query = <<<GQL
		mutation {
			productDelete(input: {id: "gid://shopify/Product/$productGid"}) {
				deletedProductId
				userErrors {
				field
				message
				}
			}
			}
		GQL;

		Log::info($query);

	

		$payload = json_encode([
			'query' => $query,
		]);

		$headers = [
			"Content-Type: application/json",
			"X-Shopify-Access-Token: {$accessToken}"
		];

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$response = curl_exec($ch);
		curl_close($ch);

		Log::info($response);

		return json_decode($response, true);
	}


	public function fetchEbayProductRequest() {

		Log::info("enter in fetch eb requrest");

		$currUser = Auth::User();
		$ebKey = $currUser->ebKey()->first();
		if(!$ebKey){
			return response()->json(['error' => ["msg"=>['eBay account is not configured.']]], 406);			
		}

		$existingRequests = $currUser->ebRequests()->where('status', '!=', 'completed')->first();
		if($existingRequests){
			return response()->json(['error' => ["msg"=>['A request to fetch eBay products is already in progress. Please check the product page after a few moments.']]], 406);	
		}
		$ebRequestObject = EbRequest::create(array("status" => "pending"));
		$currUser->ebRequests()->save($ebRequestObject);
		return response()->json(['success'], 200);		
    }
	public function reimport($id){
		if(!$this->validateMembership()){
			return response()->json(['error' => ["msg"=>["Your membership has been expired. Please activate the subscription to import more products."]]], 406);
		}
		$temp = explode(",", $id);
		$count = count($temp);
	
		$count2 = count($temp);
		if($count == 0){
			return response()->json(['error' => ["msg"=>["Please choose atleast one product."]]], 406);
		}
		$currUser = Auth::User();
		$user_id = $currUser->id;

		$count = $currUser->products()->whereIn('product_id', $temp)->where('status', '!=', 'Imported')->count();
		if($count > 0){
			return response()->json(['error' => ["msg"=>['The selected products could not be re-imported to shopify.']]], 406);
		} else {
		
			$count456=$currUser->process_reimport()->where('user_id', $user_id)->first();
			//Log::info("All from process reimport ".json_encode($count456));


			if($count456){
				$reval = $count456->count;
				$countnew12=$reval+$count2;
				Log::info("new reimport item count".$countnew12);
				$currUser->process_reimport()->where('user_id', $user_id)->update(['count' => $countnew12]);
				Log::info("processbulk reimport done ".$countnew12);
			}else{
				Log::info("entered in the else condition");

				$reimport = new Process_reimport([
					'user_id' => $user_id,
					'count' => $count2, 
					
		
				]);
				$reimport->save();
				Log::info("processbulk reimport done ".$count2);
			  }

			$currUser->products()->whereIn('product_id', $temp)->where('block', 0)->where('duplicate', 0)->where('status', '=', 'Imported')->update(['status' => 'reimport in progress']);
			return response()->json(['success'], 200);
		}
	}

	
}
