<?php

namespace App\Http\Controllers;

use App\Setting;
use App\User;
use App\Webhook;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Collection;
use App\Http\Requests;
use Validator;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class SettingsController extends Controller
{
	public function __construct()
	{
		// Apply the jwt.auth middleware to all methods in this controller
		// except for the authenticate method. We don't want to prevent
		// the user from retrieving their token if they don't already have it
		$this->middleware('jwt.auth', ['except' => ['authenticate']]);
	}

	public function index()
	{
		$currUser = Auth::User();
		$settings = $currUser->settings()->first();

		if (!$settings) {
			$settingObj = new Setting;
			$settingObj->published = 1;
			$settingObj->tags = "";
			$settingObj->vendor = "";
			$settingObj->product_type = "";
			$settingObj->inventory_policy = "";
			$settingObj->inventory_sync = 0;
			$settingObj->price_sync = 0;
			$settingObj->outofstock_action = "outofstock";
			$settingObj->desc_cond = 0;
			$settingObj->desc_itemspecs = 0;
			$settingObj->markupenabled = 0;
			$settingObj->markuptype = 'FIXED';
			$settingObj->markupval = 0;
			$settingObj->markupround = 0;
			$currUser->settings()->save($settingObj);
			return $settingObj;
		} else {
			return $settings;
		}
	}

	public function store(Request $request)
	{
		$currUser = Auth::User();
		$published = 1;
		$tags = "";
		$vendor = "";
		$product_type = "";
		$inventory_policy = "shopify";
		$desc_cond = 0;
		$shopifytoebay = 0;
		$desc_itemspecs = 0;

		if ($request->has("published")) {
			$published = $request->input("published");
		}
		if ($request->has("tags")) {
			$tags = $request->input("tags");
		}
		if ($request->has("vendor")) {
			$vendor = $request->input("vendor");
		}
		if ($request->has("product_type")) {
			$product_type = $request->input("product_type");
		}
		if ($request->has("inventory_policy")) {
			$inventory_policy = $request->input("inventory_policy");
		}
		if ($request->has("desc_cond")) {
			$desc_cond = $request->input("desc_cond");
		}
		if ($request->has("desc_itemspecs")) {
			$desc_itemspecs = $request->input("desc_itemspecs");
		}

		if ($request->has("published")) {
			$shopifytoebay = $request->input("shopifytoebay");
		}

		$settingObj = $currUser->settings()->first();
		$settingObj->published = $published;
		$settingObj->shopifytoebay = $shopifytoebay;
		$settingObj->tags = $tags;
		$settingObj->vendor = $vendor;
		$settingObj->product_type = $product_type;
		$settingObj->inventory_policy = $inventory_policy;
		$settingObj->desc_cond = $desc_cond;
		$settingObj->desc_itemspecs = $desc_itemspecs;
		$currUser->settings()->save($settingObj);
		return response()->json(['success' => $settingObj], 200);
	}

	public function setupFinalStep(Request $request)
	{
		$currUser = Auth::User();
		$currUser->SetupStep = "3";
		$currUser->save();

		$settings = $currUser->settings;

		if ($settings) {
			$Input = $request->input("payload.value");
			$InvSyncVal = 0;
			$PriceSyncVal = 0;
			if ($Input == "Both Inventory & Price sync enabled") {
				$InvSyncVal = 1;
				$PriceSyncVal = 1;
			} elseif ($Input == "Inventory sync only enabled") {
				$InvSyncVal = 1;
			} else if ($Input == "Price sync only enabled") {
				$PriceSyncVal = 1;
			} else {
				$InvSyncVal = 0;
				$PriceSyncVal = 0;
			}

			$settings->inventory_sync = $InvSyncVal;
			$settings->price_sync = $PriceSyncVal;
			$settings->save();
		}

		return response()->json(['status' => 'success'], 200);
	}

	public function updateSetupStep(Request $request){
		$currUser = Auth::User();
		$currUser->SetupStep = "Done";
		$currUser->save();
		return response()->json(['status' => 'success'], 200);

	}


	public function savePricingRulesSettings(Request $request)
	{
		if ($request->apply == 'no') {
			$settings = $request->settings;
			$currUser = Auth::User();
			$settings = json_decode($settings);
			$markupenabled = 0;
			$markuptype = "FIXED";
			$markupval = 0;
			$markupvalfixed = 0;
			$markupround = 0;
			$markupenabled = $settings->markupenabled;
			$markuptype = $settings->markuptype;
			$markupval = $settings->markupval;
			if (isset($settings->markupvalfixed)) {
				$markupvalfixed = $settings->markupvalfixed;
			}
			$markupround = $settings->markupround;
			$settingObj = $currUser->settings()->first();
			$settingObj->markupenabled = $markupenabled;
			$settingObj->markuptype = $markuptype;
			$settingObj->markupval = $markupval;
			$settingObj->markupvalfixed = $markupvalfixed;
			$settingObj->markupround = $markupround;
			$currUser->settings()->save($settingObj);
			return response()->json(['success' => $settingObj], 200);
		} else {
			$settings = $request->settings;
			$currUser = Auth::User();
			$settings = json_decode($settings);
			$markupenabled = 0;
			$markuptype = "FIXED";
			$markupval = 0;
			$markupvalfixed = 0;
			$markupround = 0;
			$markupenabled = $settings->markupenabled;
			$markuptype = $settings->markuptype;
			$markupval = $settings->markupval;
			if (isset($settings->markupvalfixed)) {
				$markupvalfixed = $settings->markupvalfixed;
			}
			$markupround = $settings->markupround;

			$settingObj = $currUser->settings()->first();
			$settingObj->markupenabled = $markupenabled;
			$settingObj->markuptype = $markuptype;
			$settingObj->markupval = $markupval;
			$settingObj->markupvalfixed = $markupvalfixed;
			$settingObj->markupround = $markupround;
			$settingObj->change_status = 0;

			$currUser->settings()->save($settingObj);
			// TODO: Save in cron to update prices of all products
			return response()->json(['success' => $settingObj], 200);
		}
	}

	public function saveSyncSettings(Request $request)
	{
		log::info("saveSyncSettings called");
		log::info($request->all());
		$currUser = Auth::User();
		$inventory_sync = 0;
		$price_sync = 0;
		$autoimport = 0;
		$autodelete = 0;
		$shopifyorders = 0;
		$shopifyorders_action = "end";
		$outofstock_action = "outofstock";

		log::info($request->has("both"));




		if ($request->input('syncOption') === 'both') {
			Log::info("both called");
			$inventory_sync = 1;
			$shopifyorders = 1;
			$shopifyorders_action = "end";
		}

		if ($request->input('syncOption') === 'inventory') {
			Log::info("inventory called");
			$inventory_sync = 1;
		}





		if ($request->has("inventory_sync")) {
			$inventory_sync = $request->input("inventory_sync");
		}
		if ($request->has("price_sync")) {
			$price_sync = $request->input("price_sync");
		}
		if ($request->has("autoimport")) {
			$autoimport = $request->input("autoimport");
		}
		if ($request->has("shopifyorders")) {
			$shopifyorders = $request->input("shopifyorders");
		}
		if ($request->has("shopifyorders_action")) {
			$shopifyorders_action = $request->input("shopifyorders_action");
		}
		if ($request->has("outofstock_action")) {
			$outofstock_action = $request->input("outofstock_action");
			if ($outofstock_action == "delete") {
				$autodelete = 1;
			}
		}

		$settingObj = $currUser->settings()->first();
		$old_shopifyorders = $settingObj->shopifyorders;
		$settingObj->inventory_sync = $inventory_sync;
		$settingObj->price_sync = $price_sync;
		//$settingObj->autoimport = $autoimport;
		$settingObj->shopifyorders = $shopifyorders;
		//  $settingObj->shopifyorders_action = $shopifyorders_action;
		//  $settingObj->outofstock_action = $outofstock_action;
		//  $settingObj->autodelete = $autodelete;      
		$currUser->settings()->save($settingObj);
		if ($old_shopifyorders == 0 && $shopifyorders == 1) {

		}
		return response()->json(['success' => $settingObj], 200);
	}

}