<?php

namespace App\Http\Controllers;

use App\Setting;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Collection;

use App\Http\Requests;
use App\Http\Requests\SettingRequest;
use Validator;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class SettingsController extends Controller
{
    public function __construct()
    {
        // Apply the jwt.auth middleware to all methods in this controller
        // except for the authenticate method. We don't want to prevent
        // the user from retrieving their token if they don't already have it
        $this->middleware('jwt.auth', ['except' => ['authenticate']]);
    }


    public function index()
    {
		$currUser = Auth::User();
		$settings = $currUser->settings()->first();
		if(!$settings){
			$settingObj = new Setting;
			$settingObj->published = 1;
			$settingObj->fulfilment_service = "manual";
			$settingObj->inventory_policy = "shopify";
			$settingObj->inventory_sync = 0;
			$settingObj->price_sync = 0;
			$settingObj->autolink = 1;
			$settingObj->autodelete = 0;
			$currUser->settings()->save($settingObj);
			return $settingObj;
		} else {
			return $currUser->settings()->first();
		}
    }

    public function store(Request $request)
    {
		$currUser = Auth::User();
		$published = 1;
		$fulfilment_service = "manual";
		$inventory_policy = "shopify";
		$inventory_sync = 0;
		$price_sync = 0;
		if($request->has("published")){
			$published = $request->input("published");
		}
		if($request->has("fulfilment_service")){
			$fulfilment_service = $request->input("fulfilment_service");
		}
		if($request->has("inventory_policy")){
			$inventory_policy = $request->input("inventory_policy");
		}
		if($request->has("inventory_sync")){
			$inventory_sync = $request->input("inventory_sync");
		}
		if($request->has("price_sync")){
			$price_sync = $request->input("price_sync");
		}
		$settingObj = $currUser->settings()->first();
		$settingObj->published = $published;
		$settingObj->fulfilment_service = $fulfilment_service;
		$settingObj->inventory_policy = $inventory_policy;
		$settingObj->inventory_sync = $inventory_sync;
		$settingObj->price_sync = $price_sync;
		$currUser->settings()->save($settingObj);
		return response()->json(['success' => $settingObj], 200);				
    }   
}