<?php

namespace App\Http\Controllers;

use App\Service\ServiceMail;
use App\ShopifyRequest;
use App\ProcessEbayImport;
use App\User;
use App\Cron;
use App\Profile;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\ShopifyProduct;
use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Log;
require '/home/cp1infoshoreapps/public_html/updatedepi/api/ebay_sdk/vendor/autoload.php';
require '/home/cp1infoshoreapps/public_html/updatedepi/cronjobs/includes/sendgrid/sendgrid-php.php';

use DTS\eBaySDK\Trading\Services;
use DTS\eBaySDK\Trading\Types;
use DTS\eBaySDK\Trading\Enums;

class ShopifyProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware("jwt.auth", ["except" => ["authenticate"]]);
    }

    public function index()
    {
            Log::info('Request Data:', \Request::all());
            $per_page = \Request::get("per_page") ?: 20;
            $currUser = Auth::User();
            $user_id = $currUser->id;
            $query = \Request::get('query') ? : '';
            Log::info("ShopifyProductController");
            Log::info($currUser);
            if($query == 'UnLinked'){
                Log::info("inside if condition");
                $products = $currUser
                ->sh_products()
                
                ->where('status','Unlinked')
                ->orderBy("id", "DESC");
            return $products->paginate($per_page);
            }
            if($query == 'Import In Progress'){
                Log::info("inside if condition");
                $products = $currUser
                ->sh_products()
                
                ->where('status','Import In Progress')
                ->orderBy("id", "DESC");
            return $products->paginate($per_page);

            }
            if($query == 'Imported'){
                Log::info("inside if condition");
                $products = $currUser
                ->sh_products()
                
                ->where('status','Imported')
                ->orderBy("id", "DESC");
            return $products->paginate($per_page);

            }
            if($query == 'Linked'){
                Log::info("inside if condition");
                $products = $currUser
                ->sh_products()
                ->where('status','Linked')
                ->orderBy("id", "DESC");
            return $products->paginate($per_page);

            }
            if($query == 'Error'){
                Log::info("inside if condition");
                $products = $currUser
                ->sh_products()
                
                ->where('status','error')
                ->orderBy("id", "DESC");
            return $products->paginate($per_page);

            }
            if($query == 'All'){
                Log::info("inside if condition");
                $products = $currUser
                ->sh_products()
                
                ->orderBy("id", "DESC");
                return $products->paginate($per_page);

            }
            
            if(is_array($query)){
                Log::info("in is array condition ");
                if(isset($query['type'])){
                    $products = $currUser
                    ->sh_products()
               
                    ->where("shopify_product_type", "like", "%" . $query['type']. "%")
                    ->orderBy("id", "DESC");
                return $products->paginate($per_page);

                }
                if(isset($query['Vendor'])){
                    $products = $currUser
                    ->sh_products()
        
                    ->where("brand", "like", "%" . $query['Vendor']. "%")
                    ->orderBy("id", "DESC");
                return $products->paginate($per_page);

                }
                if(isset($query['sku'])){
                    $products = $currUser
                    ->sh_products()
                  
                    ->whereHas('sh_variants', function ($q) use ($query) {
                        $q->where("sku", "like", "%" . $query['sku'] . "%");
                    })
                    ->orderBy("id", "DESC");
                return $products->paginate($per_page);

                }
            }
            if($query == 'Title asc'){
                Log::info("inside if condition");
                $products = $currUser
                ->sh_products()
                
                ->orderBy("title", "ASC");
            return $products->paginate($per_page);
            }
            if($query == 'Title desc'){
                Log::info("inside if condition");
                $products = $currUser
                ->sh_products()
                
                ->orderBy("title", "DESC");
            return $products->paginate($per_page);
            }
            if($query == 'Product desc'){
                Log::info("inside if condition");
                $products = $currUser
                ->sh_products()
                
                ->orderBy("id", "DESC");
            return $products->paginate($per_page);
            }
            if($query == 'Product asc'){
                Log::info("inside if condition");
                $products = $currUser
                ->sh_products()
                
                ->orderBy("id", "ASC");
            return $products->paginate($per_page);
            }
            if($query){
                Log::info("inside if condition");
                $products = $currUser
                ->sh_products()
                
                ->where("title", "like", "%" . $query. "%")
                ->orWhere(
                    "shopify_product_id",
                    "like",
                    "%" . $query. "%"
                )
                ->orderBy("id", "DESC");
            return $products->paginate($per_page);
            }
    $products = $currUser
        ->sh_products()
        
        ->orderBy("id", "DESC")
        ->paginate($per_page);

            Log::info($currUser->id . " -- Ended - " . date("Y-m-d H:i:s"));
            return $products;
    }

    public function getProductCount(){
    $user = Auth::User();

	$counts = ShopifyProduct::where('user_id', $user->id)
    ->selectRaw("
        COUNT(*) AS all_count,
        SUM(CASE WHEN status = 'UnLinked' THEN 1 ELSE 0 END) AS unlinked_count,
        SUM(CASE WHEN status = 'Imported' THEN 1 ELSE 0 END) AS imported_count,
        SUM(CASE WHEN status = 'Import in progress' THEN 1 ELSE 0 END) AS import_in_progress_count,
        SUM(CASE WHEN status = 'Linked' THEN 1 ELSE 0 END) AS linked_count,
        SUM(CASE WHEN status = 'Error' THEN 1 ELSE 0 END) AS error_count
    ")
    ->first();
		return $counts;
	}

    // public function shopifyProductStatus()
    // {

    //     $per_page = \Request::get("per_page") ?: 20;
	// 	$query = \Request::get('query') ? : 'Ready to Import';

    //     $currUser = Auth::User();
    //     $products = $currUser
    //         ->sh_products()
    //         ->where("status", $status)
    //         ->where(function ($query) use ($user_id) {
    //     $query
    //         ->where(function ($q) use ($user_id) {
    //             $q->whereNull("ebayitemid")->whereNotIn(
    //                 "shopify_product_id",
    //                 function ($subQuery) use ($user_id) {
    //                     $subQuery
    //                         ->select("shopifyproductid")
    //                         ->from("products")
    //                         ->where('user_id', $user_id)
    //                         ->where('status', 'Imported')
    //                         ->whereNotNull("shopifyproductid");
    //                 }
    //             );
    //         })
    //         ->orWhereNotNull("ebayitemid");
    // })
    //         ->orderBy("id", "DESC")
    //         ->paginate($per_page);
    //     Log::info($currUser->id . " -- Ended - " . date("Y-m-d H:i:s"));
    //     return $products;
    // }
    public function searchShopifyProduct(Request $request)
    {
        $per_page = \Request::get("per_page") ?: 20;
        $currUser = Auth::User();
        Log::info("searchternvvv" . $request["query"]);
        if ($request["query"]) {
            Log::info("selectFilter");
            if ($request["selectedFilter"]) {
                $filter = json_decode($request["selectedFilter"], true);
                Log::info($filter);
                if ($filter["value"] == "title") {
                    Log::info($filter["value"]);

                    $products = $currUser
                        ->sh_products()
                        ->where(function ($query) {
                            $query
                                ->where(function ($q) {
                                    $q->whereNull("ebayitemid")->whereNotIn(
                                        "shopify_product_id",
                                        function ($subQuery) {
                                            $subQuery
                                                ->select("shopifyproductid")
                                                ->from("products")
                                                ->whereNotNull(
                                                    "shopifyproductid"
                                                );
                                        }
                                    );
                                })
                                ->orWhereNotNull("ebayitemid");
                        })
                        ->where("title", "like", "%" . $request["query"] . "%")
                        ->orWhere(
                            "shopify_product_id",
                            "like",
                            "%" . $request["query"] . "%"
                        )
                        ->orderBy("id", "DESC");
                    return $products->paginate($per_page);
                }
                if ($filter["value"] == "shopify_product_type") {
                    Log::info($filter["value"]);
                    Log::info("in side shopify_product_type");
                    Log::info($request["query"]);
                    $products = $currUser
                        ->sh_products()
                        ->where(function ($query) {
                            $query
                                ->where(function ($q) {
                                    $q->whereNull("ebayitemid")->whereNotIn(
                                        "shopify_product_id",
                                        function ($subQuery) {
                                            $subQuery
                                                ->select("shopifyproductid")
                                                ->from("products")
                                                ->whereNotNull(
                                                    "shopifyproductid"
                                                );
                                        }
                                    );
                                })
                                ->orWhereNotNull("ebayitemid");
                        })
                        ->where(
                            "shopify_product_type",
                            "like",
                            "%" . $request["query"] . "%"
                        )
                        ->orderBy("id", "DESC");
                    return $products->paginate($per_page);
                }
                if ($filter["value"] == "brand") {
                    Log::info($filter["value"]);
                    Log::info("in side brand");
                    Log::info($request["query"]);
                    $products = $currUser
                        ->sh_products()
                        ->where(function ($query) {
                            $query
                                ->where(function ($q) {
                                    $q->whereNull("ebayitemid")->whereNotIn(
                                        "shopify_product_id",
                                        function ($subQuery) {
                                            $subQuery
                                                ->select("shopifyproductid")
                                                ->from("products")
                                                ->whereNotNull(
                                                    "shopifyproductid"
                                                );
                                        }
                                    );
                                })
                                ->orWhereNotNull("ebayitemid");
                        })
                        ->where("brand", "like", "%" . $request["query"] . "%")
                        ->orderBy("id", "DESC");
                    return $products->paginate($per_page);
                }
                if ($filter["value"] == "shopify_product_id") {
                    Log::info($filter["value"]);
                    Log::info("in side shopify_product_id");
                    Log::info($request["query"]);
                    $products = $currUser
                        ->sh_products()
                        ->where(function ($query) {
                            $query
                                ->where(function ($q) {
                                    $q->whereNull("ebayitemid")->whereNotIn(
                                        "shopify_product_id",
                                        function ($subQuery) {
                                            $subQuery
                                                ->select("shopifyproductid")
                                                ->from("products")
                                                ->whereNotNull(
                                                    "shopifyproductid"
                                                );
                                        }
                                    );
                                })
                                ->orWhereNotNull("ebayitemid");
                        })
                        ->where(
                            "shopify_product_id",
                            "like",
                            "%" . $request["query"] . "%"
                        )
                        ->orderBy("id", "DESC");
                    return $products->paginate($per_page);
                }
            } else {
                $products = $currUser
                    ->sh_products()
                    ->where(function ($query) {
                        $query
                            ->where(function ($q) {
                                $q->whereNull("ebayitemid")->whereNotIn(
                                    "shopify_product_id",
                                    function ($subQuery) {
                                        $subQuery
                                            ->select("shopifyproductid")
                                            ->from("products")
                                            ->whereNotNull("shopifyproductid");
                                    }
                                );
                            })
                            ->orWhereNotNull("ebayitemid");
                    })
                    ->where("title", "like", "%" . $request["query"] . "%")
                    ->orWhere(
                        "shopify_product_id",
                        "like",
                        "%" . $request["query"] . "%"
                    )
                    ->orderBy("id", "DESC");
                return $products->paginate($per_page);
            }
        } else {
            return $this->index();
        }
    }


    public function insertProductOnPendingImport(Request $request)
    {
        $currUser = Auth::User();


        $sh_product_id = $request->id;
        $profile_id = $request->profile_id;
        Log::info("insertProductOnPendingImport put ");
        Log::info($request);
        Log::info($currUser);
      

        if (is_array($sh_product_id)) {
            $sh_product_ids = $sh_product_id;
        } else {
            $sh_product_ids = explode(",", $sh_product_id);
        }
        Log::info("product ids to published ");
        
        Log::info(json_encode($sh_product_ids));

        $currUser->skuconsumed =count($sh_product_ids) +  $currUser->skuconsumed;
        $currUser->save();

        $productStatusUpdate = $currUser
        ->sh_products()
        ->whereIn("id", $sh_product_ids)
        ->update([
            "status" => "Import in progress",
            "profile_id" => $profile_id,
        ]);
        if(count( $sh_product_ids) === 1){
                  $productStatusUpdate = $currUser
            ->sh_products()
            ->whereIn("id", $sh_product_ids)
            ->update([
                "status" => "Import in progress",
                "profile_id" => $profile_id,
            ]);
           return  $this->importProductToEbayDirect($sh_product_ids[0]);
        }
        
        $profiles = $currUser
            ->profiles()
            ->where("is_variantions", 1)
            ->get();

        $existingRequests = $currUser
            ->processebayimports()
            ->whereIn("sh_product_id", $sh_product_ids)
            ->where("status", "=", "pending")
            ->exists();

        if ($existingRequests) {
            return response()->json(
                [
                    "error" => [
                        "msg" => [
                            "A request to Import Shopify Products is already in progress. Please check the product page after a few moments.",
                        ],
                    ],
                ],
                406
            );
        }

        Log::info(json_encode($sh_product_ids));

        $productStatusUpdate = $currUser
            ->sh_products()
            ->whereIn("id", $sh_product_ids)
            ->update([
                "status" => "Import in progress",
                "profile_id" => $profile_id,
            ]);

        Log::info($productStatusUpdate);

        foreach ($sh_product_ids as $id) {
            $importRequest = ProcessEbayImport::create([
                "status" => "pending",
                "sh_product_id" => $id,
            ]);
            $currUser->processebayimports()->save($importRequest);
        }

        return ["massage"=>"success"];
    }

    public function getProfiles()
    {
        $currUser = Auth::User();
        return $currUser
            ->profiles()
            ->select("id", "name", "ebay_category_id", "is_variantions")
            ->get();
    }
    public function getVariantShopify(Request $request)
    {
        $currUser = Auth::User();
        if ($request->has("id")) {
            $product_id = $request->input("id");
            $variants = $currUser
                ->sh_variants()
                ->where("sh_product_id", $product_id)
                ->get();
            return $variants;
        } else {
            return [];
        }
    }

    public function fetchShopifyProducts()
    {
        $currUser = Auth::User();
        Log::info("inside fetchShopifyProducts");

        Log::info($currUser);
        $existingRequests = $currUser
            ->shRequests()
            ->where("status", "!=", "completed")
            ->first();

        Log::info($existingRequests);
        if ($existingRequests) {
            return response()->json(
                [
                    "error" => [
                        "msg" => [
                            "A request to fetch Shopify Products is already in progress. Please check the product page after a few moments.",
                        ],
                    ],
                ],
                406
            );
        }
        $shopifyRequest = ShopifyRequest::create(["status" => "pending"]);
        $currUser->shRequests()->save($shopifyRequest);
        return response()->json(["message"=>"Your Shopify products will be fetched shortly"], 200);
    }
    public function getShopifyVariants(Request $request)
    {
        $currUser = Auth::User();
        if ($request->has("id")) {
            $product_id = $request->input("id");
            $variants = $currUser
                ->sh_variants()
                ->where("id", $product_id)
                ->get();
            return $variants;
        } else {
            return [];
        }
    }

    
    public function verifyEbayItem(Request $request)
    {

        Log::info($request);
        $productId = $request->input("product_id");
        $profileId = $request->input("profile_id");
            $user = Auth::User();   
                     $ebay_key = $user->ebKey()->first();
        $token = $ebay_key->token;
        $siteid = $ebay_key->siteid;
        Log::info("ebay token ");

        //  ebay credentails
        $ebConfig = [
            "production" => [
                "credentials" => [
                    "devId" => "83df6eb2-cf1a-4c04-87ea-a5f3e450bd25",
                    "appId" => "InfoShor-SKUBubbl-PRD-42f5817e2-a5e09617",
                    "certId" => "PRD-2f5817e259c8-7213-4949-a498-8162",
                ],
            ],
            "sandbox" => [
                "credentials" => [
                    "devId" => "83df6eb2-cf1a-4c04-87ea-a5f3e450bd25",
                    "appId" => "InfoShor-SKUBubbl-SBX-145f6444c-fd18db0d",
                    "certId" => "SBX-45f6444cfae6-5fa1-4c90-bddb-6845",
                ],
            ],
        ];

        // define service
        $ebayService = new Services\TradingService([
            "credentials" => $ebConfig["production"]["credentials"],
            "sandbox" => false,
            "siteId" => $siteid,
        ]);

        $ebay_environment = "production";
        $profile = Profile::where("user_id", $user->id)
            ->where("id", $profileId)
            ->first();

        Log::info("inside of VerifyEbayItem");
        Log::info($profile);

        $listing_format = $profile->listing_format ? $profile->listing_format : 'fixed_price';
        $listing_duration = $profile->listing_duration ? $profile->listing_duration : 'GTC';

        $ebayRequest = 
            $listing_format == "auction"
                ? new Types\VerifyAddItemRequestType()
                : new Types\VerifyAddFixedPriceItemRequestType();

        $ebayRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
        $ebayRequest->RequesterCredentials->eBayAuthToken = $token;

        $ebayItem = new Types\ItemType();

        if ($listing_format == "auction") {
            Log::info("listing format is auction");
            $ebayItem->ListingType = Enums\ListingTypeCodeType::C_CHINESE;
            $ebayItem->ListingDuration = $listing_duration
                ? $listing_duration
                : Enums\ListingDurationCodeType::C_DAYS_7;
        } else {
            Log::info("listing format is fixed price ");
            $ebayItem->ListingType =
                Enums\ListingTypeCodeType::C_FIXED_PRICE_ITEM;
            $ebayItem->ListingDuration = $listing_duration
                ? $listing_duration
                : Enums\ListingDurationCodeType::C_GTC;
        }
        $product = ShopifyProduct::where("id", $productId)
            ->where("user_id", $user->id)
            ->with("sh_variants")
            ->first();
            Log::info($product);
        $shProduct = json_decode($product->shopify_product_data, true);
        $variants = $product->sh_variants;
        $shVariants = $shProduct["variants"];

    

          // option name get 
        $option1Name = (isset($shProduct["options"][0]["name"])) ? substr(trim(strtolower($shProduct["options"][0]["name"]),' '),0,65) : NULL;
        $option2Name = (isset($shProduct["options"][1]["name"])) ? substr(trim(strtolower($shProduct["options"][1]["name"]),' '),0,65) : NULL;
        $option3Name = (isset($shProduct["options"][2]["name"])) ? substr(trim(strtolower($shProduct["options"][2]["name"]),' '),0,65) : NULL;
        

        if ($profile->ebay_category_id) {
            Log::info( "here is the category id for ebay_category_id " .$profile->ebay_category_id);
            $ebayItem->PrimaryCategory = new Types\CategoryType();
            $ebayItem->PrimaryCategory->CategoryID = $profile->ebay_category_id;
        }
        $ProductTitleAndDescription = $this->productDescriptionAndTitle(
            $profile,
            $shProduct,
            $product
        );

        Log::info($ProductTitleAndDescription);
        $title = $ProductTitleAndDescription["title"];
        $description = $ProductTitleAndDescription["description"];
        $ebayItem->Title = $title;
        $ebayItem->Description = $description;

        //  fetch location by inventory id 
         $inventoryId = $variants[0]->shopify_inventory_item_id;
        $location = $this->getShopifyLocation($user->shopurl, $user->token,  $inventoryId);
        Log::info($location);
        if (
            isset(
                $location[
                    "countryCode"
                ]
            )
        ) {
            $ebayItem->Country =
                $location[
                    "countryCode"
                ];
            Log::info("Profile->Country " . $profile->Country);
        } else {
            $ebayItem->Country = $this->getEbayCountry($siteid);
        }
        if (
            isset(
                $location[
                    "zip"
                ]
            )
        ) {
            $ebayItem->PostalCode =
                (string) $location["zip"];
        }
        if (isset(
            $location[
                "city"
            ]
        )) {
            $ebayItem->Location =
                $location[
                    "city"
                ];
        }

        $ebayItem->Currency = $this->getEbayCurrency($siteid);

        if (
            isset($profile->item_condition) &&
            $profile->item_condition != null
        ) {
            Log::info("item_condition is not null");
            $dataObject = json_decode($profile->item_condition, true);
            Log::info($dataObject);
            if (
                isset($dataObject["label"]) ||
                isset($dataObject["value"])
            ) {
                Log::info("item_condition name & value is not null");
                $ebayItem->ConditionID = (int) $dataObject["value"];
            }
        } else {
            $ebayItem->ConditionID = 1000;
        }
        $skipImages = [];
        //    return $shVariants;

        $option1name = isset($shProduct["options"][0]["name"])
            ? substr(
                trim(strtolower($shProduct["options"][0]["name"]), " "),
                0,
                65
            )
            : null;
        $option2name = isset($shProduct["options"][1]["name"])
            ? substr(
                trim(strtolower($shProduct["options"][1]["name"]), " "),
                0,
                65
            )
            : null;
        $option3name = isset($shProduct["options"][2]["name"])
            ? substr(
                trim(strtolower($shProduct["options"][2]["name"]), " "),
                0,
                65
            )
            : null;
        $manuf_part_no = $variants[0]->sku
            ? substr($variants[0]->sku, 0, 65)
            : substr($shVariants[0]["sku"], 0, 65); // changby

        $vendor = $product->brand;
        Log::info($shVariants);
        $item_specifics = $profile->item_specifics
            ? json_decode($profile->item_specifics, true)
            : null;

        if (
            $option1name &&
            count($shVariants) > 1 &&
            (count($shVariants) > 1 ||
                $shVariants[0]["option1"] != "Default Title") &&
            $shVariants[0]["option1"] &&
            $listing_format != "auction"
        ) {
            Log::info("in varinat condition ");
            //  multi shVariants
            $ebayItem->Variations = new Types\VariationsType();

            // // Refactored setOptionsNames method to handle option name mappings dynamically and improve readability.
            $optionsNames = $this->setOptionsNames(
                $option1name,
                $option2name,
                $option3name
            );
            $option1name = $optionsNames["option1name"];
            $option2name = $optionsNames["option2name"];
            $option3name = $optionsNames["option3name"];

            $option1Values = $shProduct["options"][0]["values"] ?? [];
            $option2Values = $shProduct["options"][1]["values"] ?? [];
            $option3Values = $shProduct["options"][2]["values"] ?? [];

            $variationSpecificsSetData = $this->setValuesVariationSpecifics(
                $shVariants,
                $variants,
                $option1name,
                $option2name,
                $option3name,
                $option1Values,
                $option2Values,
                $option3Values
            );

            $option1Values = $variationSpecificsSetData["option1Values"];
            $option2Values = $variationSpecificsSetData["option2Values"];
            $option3Values = $variationSpecificsSetData["option3Values"];

            $variationSpecificsSet =
                $variationSpecificsSetData["variationSpecificsSet"];

            $ebayItem->Variations->VariationSpecificsSet = $variationSpecificsSet;

            // Log::info("add updated method  vart  item specific".json_encode($variationSpecificsSet));
            $voptionname = $option1name;
            if (
                strtolower($option2name) == "color" ||
                strtolower($option2name) == "colour"
            ) {
                $voptionname = $option2name;
            } elseif (
                strtolower($option3name) == "color" ||
                strtolower($option3name) == "colour"
            ) {
                $voptionname = $option3name;
            }
            $imageOptions = [];
            foreach ($shVariants as $shVariant) {
                Log::info(
                    "pvariant info for ->" . json_encode($shVariant, true)
                );
                $pvariant = [];
                foreach ($variants as $variant) {
                    if ($variant->shopify_variant_id == $shVariant["id"]) {
                        $pvariant = $variant;
                        break;
                    }
                }

                if (!$pvariant) {
                    continue;
                }

                $option1shVariant = isset($shVariant["option1"])
                    ? substr(trim($shVariant["option1"], " "), 0, 65)
                    : null;
                $option2shVariant = isset($shVariant["option2"])
                    ? substr(trim($shVariant["option2"], " "), 0, 65)
                    : null;
                $option3shVariant = isset($shVariant["option3"])
                    ? substr(trim($shVariant["option3"], " "), 0, 65)
                    : null;

                if (!in_array($option1shVariant, $option1Values)) {
                    Log::info(
                        "verifyEbayItem inside call does not exist in the option1Values array. " .
                            $option1shVariant
                    );
                    continue;
                } else {
                    if ($option2name && $option2Values) {
                        if (!in_array($option2shVariant, $option2Values)) {
                            Log::info(
                                "verifyEbayItem inside call does not exist in the option2shVariant array. " .
                                    $option2shVariant
                            );
                            continue;
                        } else {
                            if ($option3name && $option3Values) {
                                if (
                                    !in_array($option3shVariant, $option3Values)
                                ) {
                                    Log::info(
                                        "verifyEbayItem inside call does not exist in the option3shVariant array. " .
                                            $option3shVariant
                                    );
                                    continue;
                                }
                            }
                        }
                    }
                }

                $itemVariation = new Types\VariationType();
                // 		$itemVariation->SKU = $pvariant->sku;
                Log::info(
                    "sku is shopify variant id and that is-> " .
                        $pvariant->shopify_variant_id
                );
                $itemVariation->SKU = strval($pvariant->shopify_variant_id);
                Log::info("verifyEbayItem inside call processQuantityAndPrice");

                if ($shVariant["inventory_quantity"] == 0) {
                    $shVariant["inventory_quantity"] = 1;
                }
                $productVariantQuantity = $shVariant["inventory_quantity"];
                //  for testing
                $productVariantPrice = $shVariant["price"];
                // $productVariantPrice =1;

                $itemVariation->Quantity = $productVariantQuantity; 
                // $itemVariation->Quantity = 1;
                $itemVariation->StartPrice = new Types\AmountType([
                    "value" => (float) $productVariantPrice,
                ]);

                /*
                    if($productVariantCompareAtPrice > $productVariantPrice){
                        $discountPriceInfo = new Types\DiscountPriceInfoType();
                        $discountPriceInfo->OriginalRetailPrice = new Types\AmountType(['value' => (float) $productVariantCompareAtPrice]);
                        $itemVariation->DiscountPriceInfo = $discountPriceInfo;
                    }
                    */
                $categoryFeaturesdata = json_decode(
                    $profile->category_info,
                    true
                );

                //  setValueVariationProductListingDetails
                Log::info(
                    "verifyEbayItem inside call setValueVariationProductListingDetails"
                );
                $itemVariation = $this->setValueVariationProductListingDetails(
                    $categoryFeaturesdata,
                    $itemVariation,
                    $pvariant,
                    $ebay_environment,
                    $profile,
                    $user,
                    $vendor,
                    $siteid
                );

                Log::info("check siteId " . $siteid);

                // 	variationSpecifics setvalue option name and option value
                Log::info(
                    "verifyEbayItem inside call getValueVariationSpecifics"
                );
                $variationSpecifics = $this->getValueVariationSpecifics(
                    $option1name,
                    $option2name,
                    $option3name,
                    $option1shVariant,
                    $option2shVariant,
                    $option3shVariant
                );

                $itemVariation->VariationSpecifics[] = $variationSpecifics;

                $ebayItem->Variations->Variation[] = $itemVariation;

                if ($pvariant->image) {
                    $voption = $option1shVariant;
                    if (
                        $option2shVariant &&
                        (strtolower($option2name) == "color" ||
                            strtolower($option2name) == "colour")
                    ) {
                        $voption = $option2shVariant;
                    } elseif (
                        $option3shVariant &&
                        (strtolower($option3name) == "color" ||
                            strtolower($option3name) == "colour")
                    ) {
                        $voption = $option3shVariant;
                    }

                    $opfound = false;
                    foreach ($imageOptions as $imageOption) {
                        if ($imageOption["value"] == $voption) {
                            $opfound = true;
                            break;
                        }
                    }
                    if (!$opfound) {
                        $imageOptions[] = [
                            "id" => $pvariant->id,
                            "value" => $voption,
                            "image" => $pvariant->image,
                        ];
                        $skipImages[] = $pvariant->image;
                    }
                }
            }

            if ($voptionname && $imageOptions) {
                $pictures = new Types\PicturesType();
                $pictures->VariationSpecificName = $voptionname;
                foreach ($imageOptions as $imageOption) {
                    $pictureSet = new Types\VariationSpecificPictureSetType();
                    $pictureSet->VariationSpecificValue = $imageOption["value"];
                    $pictureSet->PictureURL[] = $imageOption["image"];
                    $pictures->VariationSpecificPictureSet[] = $pictureSet;
                } //forloop

                $ebayItem->Variations->Pictures[] = $pictures;
            }
        } else {
            Log::info("product is single variant ");

            $pvariant = $variants[0];
            Log::info("verifyEbayItem inside call processQuantityAndPrice");
            $quantityAndPrice = $this->processQuantityAndPrice($pvariant);
            $productVariantQuantity =
                $quantityAndPrice["productVariantQuantity"];
            $productVariantPrice = $quantityAndPrice["productVariantPrice"];
            $productVariantCompareAtPrice =
                $quantityAndPrice["productVariantCompareAtPrice"];
            $price =    $productVariantPrice;
            // $price = 1;
            // $productVariantQuantity = 1;

            $ebayItem->Quantity =
                $listing_format == "auction" ? 1 : $productVariantQuantity;

            $ebayItem->StartPrice = new Types\AmountType([
                "value" => (float) $price,
            ]);

            Log::info(
                "sku is shopify variant id in single variant for->" .
                    $pvariant->shopify_variant_id
            );
            $ebayItem->SKU = strval($pvariant->shopify_variant_id);

            if (
                isset($item_specifics["buy_it_now_price"]) &&
                $item_specifics["buy_it_now_price"] > 0
            ) {
                $ebayItem->BuyItNowPrice = new Types\AmountType([
                    "value" => $item_specifics["buy_it_now_price"],
                ]);
            }

            if (
                $profile->product_id_type &&
                $pvariant->product_id_val &&
                $ebay_environment != "sandbox"
            ) {
                $listdetailsadded = true;
                $ebayItem->ProductListingDetails = new Types\ProductListingDetailsType();
                Log::info(
                    "verifyEbayItem inside call getProductListingDetails"
                );
                $ebayItem->ProductListingDetails = $this->getProductListingDetailsVerify(
                    $profile,
                    $pvariant,
                    $siteid
                );
            }
            Log::info("check siteId " . $siteid);
        }
        
         if($vendor || $manuf_part_no || $item_specifics){
                $ebayItem->ItemSpecifics = $this->processEbayItemSpecifics($item_specifics,$option1Name,$option2Name,$option3Name,   $variants,$vendor,$product);
        }
        if ($shProduct["images"] === null || $shProduct["images"] === "") {
            // If null, assign default image
            $shProduct["images"] = [
                "https://app1.ecomshore.com/service/public/image/default_image.png",
            ]; // Replace "default.jpg" with your default image path

            if ($shProduct["images"] && $shProduct["images"]) {
                $ebayItem->PictureDetails = new Types\PictureDetailsType();
                $ebayItem->PictureDetails->GalleryType =
                    Enums\GalleryTypeCodeType::C_GALLERY;
                $imagesUrl = [];

                foreach ($shProduct["images"] as $image) {
                    if ($skipImages && in_array($image["src"], $skipImages)) {
                        continue;
                    }
                    $imagesUrl[] = $image;
                }
                $ebayItem->PictureDetails->PictureURL = $imagesUrl;
            }
        } else {
            if ($shProduct["images"] && $shProduct["images"]) {
                $ebayItem->PictureDetails = new Types\PictureDetailsType();
                $ebayItem->PictureDetails->GalleryType =
                    Enums\GalleryTypeCodeType::C_GALLERY;
                $imagesUrl = [];

                $counter = 0; // You entered more pictures than allowed
                foreach ($shProduct["images"] as $image) {
                    if ($skipImages && in_array($image["src"], $skipImages)) {
                        continue;
                    }
                    $imagesUrl[] = $image["src"];
                    $counter++; // Increment the counter  // You entered more pictures than allowed
                    if ($counter >= 12) {
                        break;
                    } // You entered more pictures than allowed
                }
                $ebayItem->PictureDetails->PictureURL = $imagesUrl;
            }
        }

        $paymentProfile = null;
        $shippingProfile = null;
        $returnProfile = null;
        $ShippingType = null;
        $intlShippingType = null;
        if ($profile->paymentProfile) {
            $paymentProfile = new Types\SellerPaymentProfileType();
            $paymentProfile->PaymentProfileID =
                (int) $profile->paymentProfile->seller_profile_id;
        }
        Log::info("code is running on the line 2056");
        if ($profile->shippingProfile) {
            $shippingProfile = new Types\SellerShippingProfileType();
            $shippingProfile->ShippingProfileID =
                (int) $profile->shippingProfile->seller_profile_id;
            $ShippingType = $profile->shippingProfile->shippingService_name;
            $shippingProfiledata = json_decode(
                $profile->shippingProfile->seller_profiles_data,
                true
            );
            if (isset($shippingProfiledata)) {
                $intlShippingType =
                    $shippingProfiledata["shippingPolicyInfo"][
                        "intlShippingType"
                    ];
            }

            Log::info(
                "shipping profile is here for the ShippingType" . $ShippingType
            );
            Log::info(
                "shipping profile is here for the current user" .
                    $shippingProfile->ShippingProfileID
            );
        }
        if ($profile->returnProfile) {
            $returnProfile = new Types\SellerReturnProfileType();
            $returnProfile->ReturnProfileID =
                (int) $profile->returnProfile->seller_profile_id;
        }

        if ($paymentProfile || $shippingProfile || $returnProfile) {
            $ebayItem->SellerProfiles = new Types\SellerProfilesType();
            $ebayRequest->Item = $ebayItem;

            if ($shippingProfile) {
                Log::info(
                    "shipping profile " . json_encode($shippingProfile, true)
                );
                $ebayItem->SellerProfiles->SellerShippingProfile = $shippingProfile;

                // 10/10/2024 change by  start
                if (
                    $ebay_key->siteid == 15 ||
                    $ebay_key->siteid == 2 ||
                    $ebay_key->siteid == 77 ||
                    $ebay_key->siteid == 101 ||
                    $ebay_key->siteid == 3 ||
                    $ebay_key->siteid == 0 ||
                    $ebay_key->siteid == 100
                ) {
                    if (
                        $ShippingType == "Calculated" ||
                        $intlShippingType == "Calculated"
                    ) {
                        // 12/24/2024
                        $packageDetails = new Types\ShipPackageDetailsType();
                        Log::info(
                            "verifyEbayItem inside call itemPackageDetails"
                        );
                        $packageDetails = $this->itemPackageDetails(
                            $shVariants,
                            $ebay_key,
                            $product,
                            $user,
                            $packageDetails
                        );
                        // 12/24/2024
                        $ebayItem->ShippingPackageDetails = $packageDetails;
                    }
                    // 10/10/2024 change by  end
                }

                if ($paymentProfile) {
                    $ebayItem->SellerProfiles->SellerPaymentProfile = $paymentProfile;
                }

                if ($returnProfile) {
                    $ebayItem->SellerProfiles->SellerReturnProfile = $returnProfile;
                }
            }

            $payment_methods = $profile->payment_methods
                ? json_decode($profile->payment_methods, true)
                : [];

            if (!$paymentProfile && $payment_methods) {
                $ebayItem->PaymentMethods = $payment_methods;
                if (
                    in_array("PayPal", $payment_methods) &&
                    $profile->paypal_email
                ) {
                    $ebayItem->PayPalEmailAddress = $profile->paypal_email;
                }
            }

            if (!$returnProfile) {
                $ebayItem->ReturnPolicy = new Types\ReturnPolicyType();

                if (
                    $profile->domestic_returns_accepted == "ReturnsAccepted" ||
                    ($profile->international_returns_accepted &&
                        $profile->international_returns_accepted !=
                            "ReturnsNotAccepted")
                ) {
                    if (
                        $profile->return_policy_details &&
                        ($siteid == 77 ||
                            $siteid == 16 ||
                            $siteid == 71 ||
                            $siteid == 101 ||
                            $siteid == 186 ||
                            $siteid == 2)
                    ) {
                        $ebayItem->ReturnPolicy->Description =
                            $profile->return_policy_details;
                    }
                }
                if ($profile->domestic_returns_accepted == "ReturnsAccepted") {
                    $ebayItem->ReturnPolicy->ReturnsAcceptedOption =
                        $profile->domestic_returns_accepted;
                    $ebayItem->ReturnPolicy->RefundOption =
                        $profile->domestic_refund_given_as;
                    $ebayItem->ReturnPolicy->ReturnsWithinOption =
                        $profile->domestic_returned_within;
                    $ebayItem->ReturnPolicy->ShippingCostPaidByOption =
                        $profile->domestic_returns_paid_by;
                }
                $ebayRequest->Item = $ebayItem;
                $ebayResponse =
                    $listing_format == "auction"
                        ? $ebayService->verifyAddItem($ebayRequest)
                        : $ebayService->verifyAddFixedPriceItem($ebayRequest);

                $ebayResponse =
                    $listing_format == "auction"
                        ? $ebayService->verifyAddItem($ebayRequest)
                        : $ebayService->verifyAddFixedPriceItem($ebayRequest);
                if (isset($ebayResponse->Message)) {
                    Log::info($ebayResponse->Message);
                } else {
                    Log::info("No message found in eBay response.");
                }

                Log::info($ebayItem);
            }
        }
        $ebayResponse =
            $listing_format == "auction"
                ? $ebayService->verifyAddItem($ebayRequest)
                : $ebayService->verifyAddFixedPriceItem($ebayRequest);

            Log::info(   "ebay response :");
            Log::info(   $ebayResponse);
            $errorMassage = [];
            if($ebayResponse->Ack === 'Failure'){
                $errors = $ebayResponse->Errors;
                foreach($errors as $error){
                    Log::info($error);
                    $errorMassage[] = $this->verifyResolve($user,$product,$profileId, $error->LongMessage);
                }
            }
            if(!$errorMassage){
                return [
                    'errorMassage'=>$errorMassage
                ];
            }else{
                return response()->json([
                    'message' => 'Item verified successfully',
                    'ebayItem' => $ebayItem,
                ], 200);
            }
    } 
    public function linkedProductToEbay(Request $request)
    {
        // sleep(1);
        $user = Auth::user();
        Log::info($request);
        $shProductId = $request->id;
        Log::info("shProductId :: " );
        Log::info( $shProductId);

        $shProducts = $user->sh_products()->whereIn('id', $shProductId)->where('status','Unlinked')->with('sh_variants')->get();
        $linkedStatus = false;
        foreach ($shProducts as $shProduct) {
            $title = substr($shProduct->title, 0, 80);
            $ebProduct = $user->products()->where('title', $title)->where('status','Ready to Import')->with('variants')->first();
            if ($ebProduct) {
                Log::info($ebProduct);
                $checkLink = $this->linkedProductByTitle($user, $shProduct, $ebProduct);
            }else{
                  $checkLink = $this->linkedProductBySKU($user,$shProduct);
            }
            if( $checkLink){
                    $linkedStatus = true;
            }
        }
        if($linkedStatus){
             return  ['message' => 'Product Linked Successfully.'];
        }

        return ['message' => 'No products found to link with this product'];
    }
    public function linkedProductBySKU($user,$shProduct){
        $shVariants = json_decode($shProduct->sh_variants,true);
        Log::info( $shVariants);
        $filteredVariants = array_filter($shVariants, function ($variant) {
            return !empty($variant['sku']);
        });
        $skus = array_column($filteredVariants, 'sku');
        Log::info("sku ::: ");
        Log::info( $skus);
        if($skus){
             $ebVProduct = $user->variants()->where('status','Ready to Import')->where('sku',$skus[0])->first();
             if($ebVProduct){
                 $ebProduct = $user->products()->where('product_id',$ebVProduct->product_id)->where('status','Ready to Import')->with('variants')->first();
                 Log::info($ebProduct);

                 if(  $ebProduct){

                     $shProductVariants = $shProduct->sh_variants;
                    $ebProductVariants = $ebProduct->variants;
                    if (count($shProductVariants) === 1 && count($ebProductVariants) === 1) {
                        Log::info("Single variant matching");
                        $ebVariant = $ebProductVariants->first();
                        $shVariant = $shProductVariants->first();
                        $ebVariant->update([
                            'shopifyproductid'   => $shVariant->shopify_product_id,
                            'shopifyvariantid'   => $shVariant->shopify_variant_id,
                            'shopifyinventoryid' => $shVariant->shopify_inventory_item_id,
                            'status'             => 'linked',
                        ]);
    
                        $ebProduct->shopifyproductid = $shProduct->shopify_product_id;
                        $ebProduct->status = 'linked';
                        $ebProduct->save();
                        $shProduct->ebayitemid = $ebProduct->ebayitemid;
    
                        $shProduct->status = 'linked';
                        $shProduct->save();
    
                        return false;
                    }
                    $countMatch = 0;
                    if (count($shProductVariants) === count($ebProductVariants)) {
                        foreach ($shProductVariants as $shProductVariant) {
                            $shopifyVariantData = json_decode($shProductVariant->shopify_variant_data, true);
                            Log::info($shopifyVariantData);
    
                            $ebVariant = $ebProductVariants->where('option1val', $shopifyVariantData['option1'])->first();
    
                            foreach ($ebProductVariants as $ebVariant) {
                                if (
                                    $ebVariant->option1val === $shopifyVariantData['option1'] &&
                                    ($shopifyVariantData['option2'] === null || $ebVariant->option2val === $shopifyVariantData['option2']) &&
                                    ($shopifyVariantData['option3'] === null || $ebVariant->option3val === $shopifyVariantData['option3'])
                                ) {
                                    // Match found!
                                    $ebVariant->update([
                                    'shopifyproductid'   => $shProductVariant->shopify_product_id,
                                    'shopifyvariantid'   => $shProductVariant->shopify_variant_id,
                                    'shopifyinventoryid' => $shProductVariant->shopify_inventory_item_id,
                                    'status'             => 'linked',
                                    ]);
                                    $ebVariant->status = 'linked';
                                    $ebVariant->save();
                                    $countMatch++;
                                    break;
                                }
                            }
                        }
                        if($countMatch === count($shProductVariants)){
                            $ebProduct->shopifyproductid = $shProduct->shopify_product_id;
                            $ebProduct->status = 'linked';
                            $ebProduct->save();
                
                            $shProduct->ebayitemid = $ebProduct->ebayitemid;
                            $shProduct->status = 'linked';
                            $shProduct->save();
                            return ['message' => 'Linked'];
                        }else{
                            return false;
                        }
                    }
                 }
            }else{
                return false;
            }
        }else{
                return false;
        }
    }
    public function linkedProductByTitle($user, $shProduct, $ebProduct)
    {
        Log::info("inside of linkedProductByTitle");

        $shProductVariants = $shProduct->sh_variants;
        $ebProductVariants = $ebProduct->variants;

        if (count($shProductVariants) === 1 && count($ebProductVariants) === 1) {
            Log::info("Single variant matching");

            $ebVariant = $ebProductVariants->first();
            $shVariant = $shProductVariants->first();

            $ebVariant->update([
                'shopifyproductid'   => $shVariant->shopify_product_id,
                'shopifyvariantid'   => $shVariant->shopify_variant_id,
                'shopifyinventoryid' => $shVariant->shopify_inventory_item_id,
                'status'             => 'linked',
            ]);

            $ebProduct->shopifyproductid = $shProduct->shopify_product_id;
            $ebProduct->status = 'linked';
            $ebProduct->save();
            $shProduct->ebayitemid = $ebProduct->ebayitemid;

            $shProduct->status = 'linked';
            $shProduct->save();

            return true;
        }
        $countMatch = 0;

        if (count($shProductVariants) === count($ebProductVariants)) {
            foreach ($shProductVariants as $shProductVariant) {
                $shopifyVariantData = json_decode($shProductVariant->shopify_variant_data, true);
                Log::info($shopifyVariantData);

                $ebVariant = $ebProductVariants->where('option1val', $shopifyVariantData['option1'])->first();

                foreach ($ebProductVariants as $ebVariant) {
                    if (
                        $ebVariant->option1val === $shopifyVariantData['option1'] &&
                        ($shopifyVariantData['option2'] === null || $ebVariant->option2val === $shopifyVariantData['option2']) &&
                        ($shopifyVariantData['option3'] === null || $ebVariant->option3val === $shopifyVariantData['option3'])
                    ) {
                        // Match found!
                        $ebVariant->update([
                        'shopifyproductid'   => $shProductVariant->shopify_product_id,
                        'shopifyvariantid'   => $shProductVariant->shopify_variant_id,
                        'shopifyinventoryid' => $shProductVariant->shopify_inventory_item_id,
                        'status'             => 'linked',
                        ]);
                        $ebVariant->status = 'linked';
                        $countMatch++;
                        break;
                    }
                }
            }

            if($countMatch === count($shProductVariants)){
                $ebProduct->shopifyproductid = $shProduct->shopify_product_id;
                $ebProduct->status = 'linked';
                $ebProduct->save();
                 $ebVariant->save();
                $shProduct->ebayitemid = $ebProduct->ebayitemid;
                $shProduct->status = 'linked';
                $shProduct->save();
                return true;
            }else{
                return false;
            }
        }

        // Fallback if counts don't match
        return false;
    }



    public function verifyResolve($user,$product,$profileId,$error){
         $Errorsolve = '' ;
        if(str_contains($error, 'Auth token is hard expired')){
            $Errorsolve .=   '<p> Please Ebay Configuration on clinck and  Reconfigure Ebay Account.(This can not be resolved from our side.) </p>';
        }else if(str_contains($error, 'This listing would cause you to exceed the number of items and amount you can list') || str_contains($error, 'Met deze aanbieding overschrijd je het aantal objecten en het bedrag dat je kunt aanbieden.') ){
            //  reduce max - Quantity to 1 
            $user->settings()->update(['Max_Inventory' => 1]);
        }else if(str_contains($error, 'reached the number of items you can list')){
            $Errorsolve[] =  'You need to contact ebay support to increase your monthly limit to list item quantity and price ';
        }	else if(str_contains($error, 'It looks like this listing is for an item you already have on eBay:')){
            $trim_title = substr($product->title,0,78).'_2';
            $product->edit_title = $trim_title;
            $product->save();
        } else if(str_contains($error, "You've provided an invalid return policy.") ){
			
            $user->profiles()->where('id', $profileId)->update(['return_profile' => NULL ]);
				
        }else if(str_contains($error, "Please check your business policies and provide a valid policy identifier") ){
			
            $user->profiles()->where('id', $profileId)->update(['payment_profile' => NULL ]);
				
        }	else{
            $Errorsolve = $error;
        }
        return   $Errorsolve;
    }

    public function getProductListingDetailsVerify($profile, $pvariant,$site_id) {

        return $profile;
             // 	getProductListingDetails shopify Variant  set product_id_type
          // in function set $productListingDetails in set getProductListingDetails product_id_type exp. UPC,ISBN,EAN and MPN
           Log::info("getProductListingDetails function  start ");
         
                
                      $isbnEnabled = isset( $categoryFeaturesdata['Category']['ISBNEnabled']) ?  $categoryFeaturesdata['Category']['ISBNEnabled'] : null;
                    $upcEnabled = isset( $categoryFeaturesdata['Category']['UPCEnabled']) ?  $categoryFeaturesdata['Category']['UPCEnabled'] : null;
                    $brandMpn = isset($categoryFeaturesdata['Category']['BrandMPNEnabled']) ? $categoryFeaturesdata['Category']['BrandMPNEnabled'] : null;
                    $eanEnabled = isset($categoryFeaturesdata['Category']['EANEnabled']) ? $categoryFeaturesdata['Category']['EANEnabled'] : null;
                  Log::info( " getProductListingDetails  ISBNEnabled " . $isbnEnabled . " UPCEnabled " . $upcEnabled . " EANEnabled " . $eanEnabled );
              
                  $deFaultValue = '';
               
                  if($site_id == 216 || $site_id == 211 || $site_id == 207 || $site_id == 205 || $site_id == 203 || $site_id == 0 || $site_id == 2 || $site_id == 3 || $site_id == 15 || $site_id == 100){
                    $deFaultValue = 'Does not apply';  
                  }
                  if($site_id == 16 || $site_id == 77 || $site_id == 193){
                    $deFaultValue = 'Nicht zutreffend';  
                  }
                  if($site_id == 23 || $site_id == 71){
                    $deFaultValue = 'Non applicable';  
                  }
                  if($site_id == 186){
                    $deFaultValue =  'No aplicable';
                  }
                  
                  if($site_id == 101 || $site_id == 210 ){
                    $deFaultValue = 'Non applicabile';  
                  }
                  if($site_id == 123 || $site_id == 146 ){
                    $deFaultValue = 'Niet van toepassing';  
                  }
                  if($site_id == 201 ){
                    $deFaultValue = '不适用';  
                  }
                  if($site_id == 212 ){
                    $deFaultValue = 'Nie dotyczy';  
                  }
                  
             Log::info("getProductListingDetails  defalut value  " . $deFaultValue );
                     $productListingDetails = new Types\ProductListingDetailsType(); // Initialize the ProductListingDetails object
                
                     // Check product_id_type and set corresponding value
                    if($isbnEnabled){
                     // International Standard Book Number
                              $isbn =  $pvariant->product_id_val;
                                if ($isbn && strlen($isbn) === 10) {
                                    Log::info("getProductListingDetails Valid 10-character ISBN. pass " . $isbn);
                                   $productListingDetails->ISBN = $isbn;
                              } elseif ($isbn && strlen($isbn) === 13 && (substr($isbn, 0, 3) === '978' || substr($isbn, 0, 3) === '979')) {
                                  //  "Valid 13-character ISBN.";
                                  Log::info("getProductListingDetails Valid 13-character ISBN. pass " . $isbn);
                                  $productListingDetails->ISBN = $isbn;
                              } else {
                                   Log::info("getProductListingDetails Invalid ISBN. Ensure it is a 10 or 13-character number, and 13-character ISBNs must start with '978' or '979'. the ISBN pass " . $deFaultValue);
                                  // "Invalid ISBN. Ensure it is a 10 or 13-character number, and 13-character ISBNs must start with '978' or '979'.";
                                   $productListingDetails->ISBN = $deFaultValue;
                              }
                       } 
                     
                      if($upcEnabled){
                           $upc = $pvariant->product_id_val ;
                          if ($upc &&  strlen($upc) === 12) {
                              //      "Valid: This is a 12-digit UPC.";
                                 Log::info("getProductListingDetails Valid: This is a 12-digit UPC pass " . $upc);
                                  $productListingDetails->UPC = $upc;
                            } else {
                              //    "Invalid UPC. Ensure it is a 12-digit number.";
                                  Log::info("getProductListingDetails Invalid UPC. Ensure it is a 12-digit number.  the UPC pass " . $deFaultValue);
                                  $productListingDetails->UPC = $deFaultValue;
                            }
                         
                      }
                     
                     if($eanEnabled){
                      $ean =  $pvariant->product_id_val;
                     if ($ean &&  (strlen($ean) === 8 || strlen($ean) === 13)) {
                              //    "Valid: This is an 8-digit EAN.";
                                Log::info("getProductListingDetails product_id_type is the EAN pass " . $ean);
                              $productListingDetails->EAN = $ean;
                           } else {
                              //    "Invalid EAN. Ensure it is either an 8-digit or 13-digit number.";
                               Log::info("getProductListingDetails product_id_type is the EAN pass " . $deFaultValue);
                               $productListingDetails->EAN = $deFaultValue;
                           }
                   }
                     
                  if($brandMpn){
                      if ($vendor) {
                         $brandMPN = new Types\BrandMPNType();
                         $brandMPN->Brand = $vendor;
                         $brandMPN->MPN = $pvariant->product_id_val;
                         $productListingDetails->BrandMPN = $brandMPN;
                         Log::info("getProductListingDetails product_id_type is MPN: " . $pvariant->product_id_val);
                     }
                  }
                  
                  //  $productListingDetails->IncludeeBayProductDetails = true;
                  //  $productListingDetails->IncludeStockPhotoURL = true;
                  // $productListingDetails->IncludeStockPhotoURLIncludeStockPhotoURL = true;
                  //  ProductReferenceID
                  // UseFirstProduct
                   Log::info("getProductListingDetails function  end ");
                     return $productListingDetails; // Return the assembled ProductListingDetails
          }	
    public function getProductListingDetails($profile,$sku,$barcode, $vendor,$siteId) {
        // 	getProductListingDetails shopify Variant  set product_id_type
     // in function set $productListingDetails in set getProductListingDetails product_id_type exp. UPC,ISBN,EAN and MPN
      Log::info("getProductListingDetails function  start ");
      Log::info("setValueVariationProductListingDetails productid type " . json_encode($profile->product_id_type,true));
      $type = json_decode($profile->product_id_type, true);
      Log::info($type);
      // foreach ( $type as $key => $value) {
      $key = array_keys($type)[0];    
      $value = array_values($type)[0]; 
      $productTypeValue = '';
      if($value == 'sku'){
          $productTypeValue = $sku;
      }
      if($value == 'barcode'){
          $productTypeValue = $barcode;
      }

                $productListingDetails = new Types\ProductListingDetailsType(); // Initialize the ProductListingDetails object
           
                // Check product_id_type and set corresponding value
               if($key == 'ISBN'){
                // International Standard Book Number
                      
                           if ($productTypeValue && strlen($productTypeValue) === 10) {
                               Log::info("getProductListingDetails Valid 10-character ISBN. pass " . $productTypeValue);
                              $productListingDetails->ISBN = $productTypeValue;
                         } elseif ($productTypeValue && strlen($productTypeValue) === 13 && (substr($productTypeValue, 0, 3) === '978' || substr($productTypeValue, 0, 3) === '979')) {
                             //  "Valid 13-character ISBN.";
                             Log::info("getProductListingDetails Valid 13-character ISBN. pass " . $productTypeValue);
                             $productListingDetails->ISBN = $productTypeValue;
                         } else {
                              Log::info("getProductListingDetails Invalid ISBN. Ensure it is a 10 or 13-character number, and 13-character ISBNs must start with '978' or '979'. the ISBN pass ");
                             // "Invalid ISBN. Ensure it is a 10 or 13-character number, and 13-character ISBNs must start with '978' or '979'.";
                              $productListingDetails->ISBN = $this->getProductTypeDeFaultValue($siteId);
                         }
                  } 
                
                 if($key == 'UPC'){
                     if ($productTypeValue &&  strlen($productTypeValue) === 12) {
                         //      "Valid: This is a 12-digit UPC.";
                            Log::info("getProductListingDetails Valid: This is a 12-digit UPC pass " . $productTypeValue);
                             $productListingDetails->UPC = $productTypeValue;
                       } else {
                         //    "Invalid UPC. Ensure it is a 12-digit number.";
                             Log::info("getProductListingDetails Invalid UPC. Ensure it is a 12-digit number.  the UPC pass ");
                             $productListingDetails->UPC = $this->getProductTypeDeFaultValue($siteId);
                       }
                    
                 }
                
                if($key == 'EAN'){
                if ($productTypeValue &&  (strlen($productTypeValue) === 8 || strlen($productTypeValue) === 13)) {
                         //    "Valid: This is an 8-digit EAN.";
                           Log::info("getProductListingDetails product_id_type is the EAN pass " . $productTypeValue);
                         $productListingDetails->EAN = $productTypeValue;
                      } else {
                         //    "Invalid EAN. Ensure it is either an 8-digit or 13-digit number.";
                          Log::info("getProductListingDetails product_id_type is the EAN pass " );
                          $productListingDetails->EAN = $this->getProductTypeDeFaultValue($siteId);
                      }
              }
                
             if($key == 'MPN'){
                 if ($vendor) {
                    $brandMPN = new Types\BrandMPNType();
                    $brandMPN->Brand = $vendor;
                    $brandMPN->MPN = $productTypeValue;
                    $productListingDetails->BrandMPN = $brandMPN;
                    Log::info("getProductListingDetails product_id_type is MPN: " . $productTypeValue);
                }
             }else{
                if($vendor && $sku){
                $brandMPN = new Types\BrandMPNType();
                $brandMPN->Brand = $vendor;
                $brandMPN->MPN = $sku;
                $productListingDetails->BrandMPN = $brandMPN;
                }
             }

              Log::info("getProductListingDetails function  end ");
                return $productListingDetails; // Return the assembled ProductListingDetails
     }

    public function processQuantityAndPrice($pvariant)
    {
        // this function working on markup price and quantity threshold_quantity_value of work return price and quantity
        Log::info("processQuantityAndPrice function in side ");
        Log::info("trial shipping package test start from here");
        $productVariantQuantity = (int) $pvariant->quantity;

        Log::info(
            "processQuantityAndPrice quantity is this before " .
                $productVariantQuantity
        );

        if ($productVariantQuantity < 0) {
            $productVariantQuantity = 0;
        }
        $productVariantPrice = (float) $pvariant->price;
        Log::info("Here is the price bafore " . $productVariantPrice);
        $productVariantCompareAtPrice = (float) $pvariant->compare_at_price;
        Log::info(
            "Here is the compare_at_price bafore " .
                $productVariantCompareAtPrice
        );

        return [
            "productVariantQuantity" => $productVariantQuantity,
            "productVariantPrice" => $productVariantPrice,
            "productVariantCompareAtPrice" => $productVariantCompareAtPrice,
        ];
    }

    public function itemPackageDetails(
        $shVariants,
        $ebayAccount,
        $product,
        $shopifyStore,
        $packageDetails
    ) {
        // This method will get the package details from db (weight, height, width) and return ebayPackageDetail
        Log::info("itemPackageDetails function in side ");
        $dimesionsproduct = json_decode($product->dimensions, true);
        $packageDetails->WeightMajor = new Types\MeasureType();
        $packageDetails->WeightMinor = new Types\MeasureType();

        $weightvariants = $shVariants[0]["weight"];
        $weightUnit = strtolower($shVariants[0]["weight_unit"]); // Normalize unit to lowercase
        $afterDecimal = 0;
        $beforeDecimal = 0;
        $PackageLength = 0;
        $PackageWidth = 0;
        $PackageDepth = 0;
        $dimensionstype = "";
        if ($ebayAccount->siteid == 0) {
            Log::info(
                "itemPackageDetails function in side ebaysite id " .
                    $ebayAccount->siteid
            );
            $ounces = 0;
            $dimensionstype = "in";
            if (
                $weightUnit == "lbs" ||
                $weightUnit == "lb" ||
                $weightUnit == "pounds"
            ) {
                // Convert pounds to ounces
                $ounces = $weightvariants * 16;
            } elseif ($weightUnit == "oz" || $weightUnit == "ounces") {
                // Already in ounces
                $ounces = $weightvariants;
            } elseif (
                $weightUnit == "gr" ||
                $weightUnit == "grams" ||
                $weightUnit == "g"
            ) {
                // Convert grams to ounces (1 gram = 0.03527396 ounces)
                $ounces = $weightvariants * 0.03527396;
            } elseif ($weightUnit == "kg" || $weightUnit == "kilograms") {
                // Convert kilograms to ounces (1 kilogram = 35.27396 ounces)
                $ounces = $weightvariants * 35.27396;
            } else {
                $ounces = 16;
            }

            // Split ounces into pounds and remaining ounces

            if ($weightvariants != 0) {
                $beforeDecimal = floor($ounces / 16); // Full pounds
                $afterDecimal = $ounces % 16; // Remaining ounces
            } else {
                $afterDecimal = 1;
                $beforeDecimal = 0;
            }

            Log::info(
                "itemPackageDetails function in side ebaysite == 0 WeightMinor_unit oz and WeightMajor_unit lbs " .
                    (int) $afterDecimal .
                    " " .
                    (int) $beforeDecimal
            );
            // Assign to package details
            $packageDetails->WeightMinor->unit = "oz";
            $packageDetails->WeightMinor->value = (int) $afterDecimal;
            $packageDetails->WeightMajor->unit = "lbs";
            $packageDetails->WeightMajor->value = (int) $beforeDecimal;

            if ($dimesionsproduct != null) {
                foreach ($dimesionsproduct as $item) {
                    if ($item["name"] == "Length") {
                        $PackageLength = $this->convertToInches(
                            (int) $item["value"],
                            $item["unit"]
                        );
                    }
                    if ($item["name"] == "Width") {
                        $PackageWidth = $this->convertToInches(
                            (int) $item["value"],
                            $item["unit"]
                        );
                    }
                    if ($item["name"] == "Height") {
                        $PackageDepth = $this->convertToInches(
                            (int) $item["value"],
                            $item["unit"]
                        );
                    }
                }
            } else {
                if ($product->error_no == 100000000000) {
                    Log::info("Entered in the  parcel detail of  ");
                    $PackageLength = $this->convertToInches(
                        23,
                        $dimensionstype
                    );
                    $PackageWidth = $this->convertToInches(18, $dimensionstype);
                    $PackageDepth = $this->convertToInches(8, $dimensionstype);
                } else {
                    if ($shopifyStore->user_id == 1512) {
                        Log::info("Entered in the  parcel detail of  ");
                        $PackageLength = $this->convertToInches(
                            23,
                            $dimensionstype
                        );
                        $PackageWidth = $this->convertToInches(
                            18,
                            $dimensionstype
                        );
                        $PackageDepth = $this->convertToInches(
                            8,
                            $dimensionstype
                        );
                    } else {
                        Log::info(
                            "Entered in the else condition of parcel detail"
                        );
                        $PackageLength = $this->convertToInches(
                            75,
                            $dimensionstype
                        );
                        $PackageWidth = $this->convertToInches(
                            50,
                            $dimensionstype
                        );
                        $PackageDepth = $this->convertToInches(
                            50,
                            $dimensionstype
                        );
                    }
                }
            }
            Log::info(
                "itemPackageDetails function in side ebaysite == 0 unit=inches PackageLength, PackageWidth and PackageDepth " .
                    (int) $PackageLength .
                    " " .
                    (int) $PackageWidth .
                    " " .
                    (int) $PackageDepth
            );
        } else {
            Log::info(
                "itemPackageDetails function in side ebaysite != 0  ebaysite = " .
                    $ebayAccount->siteid
            );
            $totalGrams = 0;
            $dimensionstype = "cm";
            if (
                $weightUnit == "lbs" ||
                $weightUnit == "lb" ||
                $weightUnit == "pounds"
            ) {
                // Convert pounds to grams
                $totalGrams = $weightvariants * 453.59237;
            } elseif ($weightUnit == "oz" || $weightUnit == "ounces") {
                // Convert ounces to grams
                $totalGrams = $weightvariants * 28.34952;
            } elseif (
                $weightUnit == "gr" ||
                $weightUnit == "grams" ||
                $weightUnit == "g"
            ) {
                // Already in grams
                $totalGrams = $weightvariants;
            } elseif ($weightUnit == "kg" || $weightUnit == "kilograms") {
                // Convert kilograms to grams
                $totalGrams = $weightvariants * 1000;
            } else {
                $totalGrams = 1;
            }

            // Split grams into kilograms and remaining grams
            if ($weightvariants != 0) {
                $beforeDecimal = floor($totalGrams / 1000); // Full kilograms
                $afterDecimal = $totalGrams % 1000; // Remaining grams
            } else {
                $afterDecimal = 1;
                $beforeDecimal = 0;
            }

            Log::info(
                "itemPackageDetails function in side ebaysite != 0 WeightMinor_unit g and WeightMajor_unit kg" .
                    (int) $afterDecimal .
                    " " .
                    (int) $beforeDecimal
            );
            // Assign to package details
            $packageDetails->WeightMinor->unit = "g"; // Grams
            $packageDetails->WeightMinor->value = (int) $afterDecimal;
            $packageDetails->WeightMajor->unit = "kg"; // Kilograms
            $packageDetails->WeightMajor->value = (int) $beforeDecimal;

            if ($dimesionsproduct != null) {
                foreach ($dimesionsproduct as $item) {
                    if ($item["name"] == "Length") {
                        $PackageLength = $this->convertToCentimeters(
                            (int) $item["value"],
                            $item["unit"]
                        );
                    }
                    if ($item["name"] == "Width") {
                        $PackageWidth = $this->convertToCentimeters(
                            (int) $item["value"],
                            $item["unit"]
                        );
                    }
                    if ($item["name"] == "Height") {
                        $PackageDepth = $this->convertToCentimeters(
                            (int) $item["value"],
                            $item["unit"]
                        );
                    }
                }
            } else {
                if ($product->error_no == 100000000000) {
                    Log::info("Entered in the  parcel detail of user_id 437 ");
                    $PackageLength = $this->convertToCentimeters(
                        23,
                        $dimensionstype
                    );
                    $PackageWidth = $this->convertToCentimeters(
                        18,
                        $dimensionstype
                    );
                    $PackageDepth = $this->convertToCentimeters(
                        8,
                        $dimensionstype
                    );
                } else {
                    Log::info("Entered in the else condition of parcel detail");
                    $PackageLength = $this->convertToCentimeters(
                        75,
                        $dimensionstype
                    );
                    $PackageWidth = $this->convertToCentimeters(
                        50,
                        $dimensionstype
                    );
                    $PackageDepth = $this->convertToCentimeters(
                        50,
                        $dimensionstype
                    );
                }
            }

            Log::info(
                "itemPackageDetails function in side ebaysite == 0 unit=inches PackageLength, PackageWidth and PackageDepth " .
                    (int) $PackageLength .
                    " " .
                    (int) $PackageWidth .
                    " " .
                    (int) $PackageDepth
            );
        }

        Log::info("store " . $shopifyStore->id);
        Log::info("shipping profile 2" . json_encode($packageDetails, true));
        Log::info("trial shipping package test start from here");

        $packageDetails->PackageLength = new Types\MeasureType();
        $packageDetails->PackageWidth = new Types\MeasureType();
        $packageDetails->PackageDepth = new Types\MeasureType();

        $packageDetails->PackageLength->unit = $dimensionstype;
        $packageDetails->PackageLength->value = (int) $PackageLength;
        $packageDetails->PackageWidth->unit = $dimensionstype;
        $packageDetails->PackageWidth->value = (int) $PackageWidth;
        $packageDetails->PackageDepth->unit = $dimensionstype;
        $packageDetails->PackageDepth->value = (int) $PackageDepth;
        Log::info("itemPackageDetails function end ");
        return $packageDetails;
    }


    public function saveEdit (Request $request){
        $currUser = Auth::User();

        Log::info(  $request->product);

        if((isset($request->product['dimensions'])) && ($request->product['dimensions'] != null)){
            $dimention = $request->dimention;
            Log::info( $dimention);
            $updateProduct = array(
                'edit_title'=>$request->product['title'],
                'dimensions'=>json_encode($request->product['dimensions'])
            );
            $currUser->sh_products()->where('id',$request->product['id'])->update($updateProduct);
        }else if(isset($request->product['title'])){
            $updateProduct = array(
                'edit_title'=>$request->product['title']
            );
            $currUser->sh_products()->where('id',$request->product['id'])->update($updateProduct);
            Log::info($request->title);
        }
        
    }

    public function setValueVariationProductListingDetails(
        $categoryFeaturesdata,
        $itemVariation,
        $pvariant,
        $ebay_environment,
        $profile,
        $shopifyStore,
        $vendor,
        $siteid
    ) {
        // 	VariationProductListingDetails shopify Variant  set product_id_type
        // in function set $itemVariation in set VariationProductListingDetails product_id_type exp. UPC,ISBN,EAN and MPN
        Log::info("setValueVariationProductListingDetails start");
        // $profile->ebay_category_1 ;

        $isbnEnabled = isset($categoryFeaturesdata["Category"]["ISBNEnabled"])
            ? $categoryFeaturesdata["Category"]["ISBNEnabled"]
            : null;
        $upcEnabled = isset($categoryFeaturesdata["Category"]["UPCEnabled"])
            ? $categoryFeaturesdata["Category"]["UPCEnabled"]
            : null;
        $brandMpn = isset($categoryFeaturesdata["Category"]["BrandMPNEnabled"])
            ? $categoryFeaturesdata["Category"]["BrandMPNEnabled"]
            : null;
        $eanEnabled = isset($categoryFeaturesdata["Category"]["EANEnabled"])
            ? $categoryFeaturesdata["Category"]["EANEnabled"]
            : null;
        Log::info(
            " setValueVariationProductListingDetails  ISBNEnabled " .
                $isbnEnabled .
                " UPCEnabled " .
                $upcEnabled .
                " EANEnabled " .
                $eanEnabled .
                "brandMpn" .
                $brandMpn
        );

        $deFaultValue = "";

        if (
            $siteid == 216 ||
            $siteid == 211 ||
            $siteid == 207 ||
            $siteid == 205 ||
            $siteid == 203 ||
            $siteid == 0 ||
            $siteid == 2 ||
            $siteid == 3 ||
            $siteid == 15 ||
            $siteid == 100
        ) {
            $deFaultValue = "Does not apply";
        }
        if ($siteid == 16 || $siteid == 77 || $siteid == 193) {
            $deFaultValue = "Nicht zutreffend";
        }
        if ($siteid == 23 || $siteid == 71) {
            $deFaultValue = "Non applicable";
        }
        if ($siteid == 186) {
            $deFaultValue = "No aplicable";
        }

        if ($siteid == 101 || $siteid == 210) {
            $deFaultValue = "Non applicabile";
        }
        if ($siteid == 123 || $siteid == 146) {
            $deFaultValue = "Niet van toepassing";
        }
        if ($siteid == 201) {
            $deFaultValue = "不适用";
        }
        if ($siteid == 212) {
            $deFaultValue = "Nie dotyczy";
        }

        Log::info(
            " setValueVariationProductListingDetails  defalut value  " .
                $deFaultValue
        );
        if (
            $profile->product_id_type &&
            $pvariant->product_id_val &&
            $ebay_environment != "sandbox"
        ) {
            $itemVariation->VariationProductListingDetails = new Types\VariationProductListingDetailsType();
            if ($isbnEnabled) {
                // International Standard Book Number
                $isbn = $pvariant->product_id_val;
                if (strlen($isbn) === 10) {
                    Log::info(
                        "setValueVariationProductListingDetails Valid 10-character ISBN. pass " .
                            $isbn
                    );
                    $itemVariation->VariationProductListingDetails->ISBN = $isbn;
                } elseif (
                    strlen($isbn) === 13 &&
                    (substr($isbn, 0, 3) === "978" ||
                        substr($isbn, 0, 3) === "979")
                ) {
                    //  "Valid 13-character ISBN.";
                    Log::info(
                        "setValueVariationProductListingDetails Valid 13-character ISBN. pass " .
                            $isbn
                    );
                    $itemVariation->VariationProductListingDetails->ISBN = $isbn;
                } else {
                    Log::info(
                        "setValueVariationProductListingDetails Invalid ISBN. Ensure it is a 10 or 13-character number, and 13-character ISBNs must start with '978' or '979'. the ISBN pass " .
                            $deFaultValue
                    );
                    // "Invalid ISBN. Ensure it is a 10 or 13-character number, and 13-character ISBNs must start with '978' or '979'.";
                    $itemVariation->VariationProductListingDetails->ISBN = $deFaultValue;
                }
            }
            if ($upcEnabled) {
                $upc = $pvariant->product_id_val;
                if (strlen($upc) === 12) {
                    //    "Valid: This is a 12-digit UPC.";
                    Log::info(
                        "setValueVariationProductListingDetails Valid: This is a 12-digit UPC pass " .
                            $upc
                    );
                    $itemVariation->VariationProductListingDetails->UPC = $upc;
                } else {
                    //    "Invalid UPC. Ensure it is a 12-digit number.";
                    Log::info(
                        "setValueVariationProductListingDetails Invalid UPC. Ensure it is a 12-digit number.  the UPC pass " .
                            $deFaultValue
                    );
                    $itemVariation->VariationProductListingDetails->UPC = $deFaultValue;
                }
            }
            if ($eanEnabled) {
                $ean = $pvariant->product_id_val;
                if (strlen($ean) === 8 || strlen($ean) === 13) {
                    //   "Valid: This is an 8-digit EAN.";
                    Log::info(
                        "setValueVariationProductListingDetails product_id_type is the EAN pass " .
                            $ean
                    );
                    $itemVariation->VariationProductListingDetails->EAN = $ean;
                } else {
                    //   "Invalid EAN. Ensure it is either an 8-digit or 13-digit number.";
                    Log::info(
                        "setValueVariationProductListingDetails product_id_type is the EAN pass " .
                            $deFaultValue
                    );
                    $itemVariation->VariationProductListingDetails->EAN = $deFaultValue;
                }
            }

            //  https://developer.ebay.com/devzone/xml/docs/reference/ebay/additem.html#Request.Item.ProductListingDetails.BrandMPN
            //  this add because check this url
            if ($brandMpn) {
                Log::info(
                    "product_id_type is the MPN " . $pvariant->product_id_val
                );
                Log::info("product_id_type is the brand " . $vendor);
                //$vendor = "Unbranded";
                $brandMPN = new Types\BrandMPNType();
                $brandMPN->Brand = $vendor;
                $brandMPN->MPN = $pvariant->product_id_val;
                Log::info("brand mpnnnnnnnn " . $brandMPN);
                $itemVariation->VariationProductListingDetails->BrandMPN = $brandMPN;
            }
        }
        Log::info("setValueVariationProductListingDetails end");
        return $itemVariation;
    }

      public function importProductToEbayDirect($sh_product_id){
      
                $user = Auth::User();
                $ebay_key = $user->ebKey()->first();
                $ebayToken = $ebay_key->token;
                $siteId = $ebay_key->siteid;
                $ebay_environment = "production";
                //  ebay credentails
                $ebConfig = [
                    "production" => [
                        "credentials" => [
                            "devId" => "83df6eb2-cf1a-4c04-87ea-a5f3e450bd25",
                            "appId" => "InfoShor-SKUBubbl-PRD-42f5817e2-a5e09617",
                            "certId" => "PRD-2f5817e259c8-7213-4949-a498-8162",
                        ],
                    ],
                    "sandbox" => [
                        "credentials" => [
                            "devId" => "83df6eb2-cf1a-4c04-87ea-a5f3e450bd25",
                            "appId" => "InfoShor-SKUBubbl-SBX-145f6444c-fd18db0d",
                            "certId" => "SBX-45f6444cfae6-5fa1-4c90-bddb-6845",
                        ],
                    ],
                ];
        
                // define service
                $ebayService = new Services\TradingService([
                    "credentials" => $ebConfig["production"]["credentials"],
                    "sandbox" => false,
                    "siteId" => $siteId,
                ]);
                $product = $user->sh_products()->where('id',$sh_product_id)->with(['sh_variants','profile'])->first();   

                $shProductVariants = $product->sh_variants;

                $profile = $product->profile;
                Log::info(      
                    "profile "
                );


                Log::info(      $profile);
                $shProductStatus = $product->status;

              
                $productImportType = ($shProductStatus == "Imported") ? true : false ;
                    if (!empty($product->ebayitemid)) {
                    // ebayitemid is set, do something
                         $productImportType  = true;
                  }

                $listing_format = $profile->listing_format ? $profile->listing_format : 'fixed_price';
               
                $ebayRequest = ($listing_format == "auction") ? new Types\AddItemRequestType() : new Types\AddFixedPriceItemRequestType();
				if($productImportType) $ebayRequest = ($listing_format == "auction") ? new Types\ReviseItemRequestType() : new Types\ReviseFixedPriceItemRequestType();
				$ebayRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
				$ebayRequest->RequesterCredentials->eBayAuthToken = $ebayToken;
                
                $ebayItem = new Types\ItemType();
                $listing_duration = $profile->listing_duration ? $profile->listing_duration : 'GTC';

				if($listing_format == "auction"){
				      Log::info("listing format is auction");
					$ebayItem->ListingType = Enums\ListingTypeCodeType::C_CHINESE;
					$ebayItem->ListingDuration = ($listing_duration) ? $listing_duration : Enums\ListingDurationCodeType::C_DAYS_7;
				}else{
				    Log::info("listing format is fixed price ");
					$ebayItem->ListingType = Enums\ListingTypeCodeType::C_FIXED_PRICE_ITEM;
					$ebayItem->ListingDuration = ($listing_duration) ? $listing_duration : Enums\ListingDurationCodeType::C_GTC;
				}

                if($productImportType) $ebayItem->ItemID = (string) $product->ebayitemid;

                $shProductJsonData = json_decode($product->shopify_product_data,true);

                Log::info("shProductJsonData this in decode");

                Log::info( $shProductJsonData);

                $descriptionAndTitle =  $this->productDescriptionAndTitle($profile,$shProductJsonData,$product);
                //  print_r($descriptionAndTitle);
                 Log::info("productDescriptionAndTitle return title ".$descriptionAndTitle['title']);
                 Log::info("productDescriptionAndTitle return description ".$descriptionAndTitle['description']);
                 $title =  $descriptionAndTitle['title'];
                 $description =  $descriptionAndTitle['description'];
                 $ebayItem->Title = $title;
                 $ebayItem->Description = $description;

                         // ebay category id 
                         if($profile->ebay_category_id){
                            Log::info("ebay category id ".$profile->ebay_category_id);
                           $ebayItem->PrimaryCategory = new Types\CategoryType();
                           $ebayItem->PrimaryCategory->CategoryID = $profile->ebay_category_id;
                         }
                        

                         // countery type
                            $inventoryId = $shProductVariants[0]->shopify_inventory_item_id;

                          $location = $this->getShopifyLocation($user->shopurl, $user->token,   $inventoryId);
                            Log::info($location);
                            if (
                                isset(
                                    $location[
                                        "countryCode"
                                    ]
                                )
                            ) {
                                $ebayItem->Country =
                                    $location[
                                        "countryCode"
                                    ];
                                Log::info("Profile->Country " . $profile->Country);
                            } else {
                                $ebayItem->Country = $this->getEbayCountry($siteId);
                            }
                            if (
                                isset(
                                    $location[
                                        "zip"
                                    ]
                                )
                            ) {
                                $ebayItem->PostalCode =
                                    (string) $location["zip"];
                            }
                            if (
                                isset(
                                $location[
                                    "city"
                                ]
                            )
                            ) {
                                $ebayItem->Location =
                                    $location[
                                        "city"
                                    ];
                            }
                    
                        $ebayItem->Currency = $this->getEbayCurrency($siteId);
        
                        
                        if (
                            isset($profile->item_condition) &&
                            $profile->item_condition != null
                        ) {
                            Log::info("item_condition is not null");
                            $dataObject = json_decode($profile->item_condition, true);
                            Log::info($dataObject);
                            if (
                                isset($dataObject["label"]) ||
                                isset($dataObject["value"])
                            ) {
                                Log::info("item_condition name & value is not null");
                                $ebayItem->ConditionID = (int) $dataObject["value"];
                            }
                        } else {
                            $ebayItem->ConditionID = 1000;
                        }

                                     
                        
               $vendor = isset($shProductJsonData['vendor']) ? $shProductJsonData['vendor'] : NULL;
               $skuFirstVarient = isset($shProductVariants[0]->sku) ? $shProductVariants[0]->sku : NULL;

               
               // option name get 
               $option1Name = (isset($shProductJsonData["options"][0]["name"])) ? substr(trim(strtolower($shProductJsonData["options"][0]["name"]),' '),0,65) : NULL;
               $option2Name = (isset($shProductJsonData["options"][1]["name"])) ? substr(trim(strtolower($shProductJsonData["options"][1]["name"]),' '),0,65) : NULL;
               $option3Name = (isset($shProductJsonData["options"][2]["name"])) ? substr(trim(strtolower($shProductJsonData["options"][2]["name"]),' '),0,65) : NULL;
              
               Log::info( ' option 1 '. $option1Name . ' option 2 '. $option2Name .' option 3 '. $option3Name ) ;
               //option values get 
               $option1Values = isset($shProductJsonData['options'][0]['values']) ?  array_intersect_key($shProductJsonData['options'][0]['values'], array_unique(array_map('strtolower', $shProductJsonData['options'][0]['values']))) : NULL ;
               $option2Values = isset($shProductJsonData['options'][1]['values']) ?  array_intersect_key($shProductJsonData['options'][1]['values'], array_unique(array_map('strtolower', $shProductJsonData['options'][0]['values']))) : NULL ;
               $option3Values = isset($shProductJsonData['options'][2]['values']) ?  array_intersect_key($shProductJsonData['options'][2]['values'], array_unique(array_map('strtolower', $shProductJsonData['options'][0]['values']))) : NULL ;

                       
                // Change images based on the selected color variant when a variant is clicked on ebay . 
                $imgVariationSpecificName = $option1Name;
                if(strtolower($option2Name) == "color" || strtolower($option2Name) == "colour") $imgVariationSpecificName = $option2Name;
                else if(strtolower($option3Name) == "color" || strtolower($option3Name) == "colour") $imgVariationSpecificName = $option3Name;
                $skipImages = array() ;
                $imageOptions= array() ; 

                     // multi variants product 
            if(count($shProductVariants) > 1 && $shProductJsonData['variants'][0]['option1'] !== 'Default Title' ){
                // multi variants product 
                Log::info('ebayImportProduct multi variants product');
                $ebayItem->Variations = new Types\VariationsType();
 
                // eBay does not allow some option names. For this add 's' after the option name. 
                $optionsNames =	$this->setOptionsNames($option1Name,$option2Name,$option3Name);
                $option1Name =  $optionsNames['option1name'];
                $option2Name =  $optionsNames['option2name'];
                $option3Name =  $optionsNames['option3name'];
                
                
                Log::info("ebayImportProduct inside call setValuesVariationSpecifics");
                // set option name and all options values set in VariationSpecifics
                $variationSpecificsSet	= $this->setValuesVariationSpecificsNew($option1Name,$option2Name,$option3Name,$option1Values,$option2Values,$option3Values);
                $ebayItem->Variations->VariationSpecificsSet = $variationSpecificsSet;
 
                foreach($shProductVariants as $shVariant){
                    $shVariantJsonData = json_decode($shVariant->shopify_variant_data,true);
                     
                     // product variants in for loop single options value get 
                     $option1shVariant = (isset($shVariantJsonData['option1'])) ? substr(trim($shVariantJsonData['option1'],' '),0,65) : NULL;
                     $option2shVariant = (isset($shVariantJsonData['option2'])) ? substr(trim($shVariantJsonData['option2'],' '),0,65) : NULL;
                     $option3shVariant = (isset($shVariantJsonData['option3'])) ? substr(trim($shVariantJsonData['option3'],' '),0,65) : NULL;
                     
                     // This checks that option values are not duplicated, e.g., 'Red' != 'red' != 'RED', as eBay does not allow case-insensitive duplicates. 
                     if (!in_array($option1shVariant, $option1Values)) {
                        continue ;
                    }else{
                            if($option2Name && $option2Values){
                                 if (!in_array($option2shVariant, $option2Values)) {
                                   continue ;
                                }else{
                                    if($option3Name && $option3Values){
                                          if (!in_array($option3shVariant, $option3Values)) {
                                              continue ;
                                            }
                                          }
                                }  
                            }
                    }
                      
                    $quantity = $shVariant->quantity;

                    // $quantity = 0;
                    if($quantity == 0) $quantity = 1;
                    // this set is variation listing details exp. EAN , UPC  etc 
                    $itemVariation =  $this->setValueVariationProductListingDetailsNew($shVariantJsonData,$shVariant,$ebay_environment,$vendor,$profile,$siteId,$option1shVariant,$option2shVariant,$option3shVariant,$option1Name,$option2Name,$option3Name);
                    $itemVariation->SKU = strval($shVariant->sku);
                    $itemVariation->Quantity = $quantity;
                    $price = $shVariant->price;
                    // $price = 1;
                    $itemVariation->StartPrice = new Types\AmountType(['value' => (float) $price]);
                    $ebayItem->Variations->Variation[] = $itemVariation;
                    // variant images insert in array in this imageOptions
                    if($shVariant->image){
                     //  images found 
                     
                     $voption = $option1shVariant;
                     if($option2shVariant && (strtolower($option2Name) == "color" || strtolower($option2Name) == "colour")){
                         $voption = $option2shVariant;
                     }
                     else if($option3shVariant && (strtolower($option3Name) == "color" || strtolower($option3Name) == "colour")){
                         $voption = $option3shVariant;
                     }
                     $opfound = false;
                     foreach($imageOptions as $imageOption){
                         if($imageOption["value"] == $voption){
                             $opfound = true;
                             break;
                         }
                     }
                     if(!$opfound){
                     $imageOptions[] = ["id" => $shVariant->id, "value" => $voption, "image" => $shVariant->image];
                     $skipImages[] = $shVariant->image;
                     }
                 }else{
                     // varient not images 
                     continue ;
                 }   
                 }
             
                 // variants images data set in item 
                 if($imgVariationSpecificName && $imageOptions){
                    $pictures = new Types\PicturesType();
                    $pictures->VariationSpecificName = $imgVariationSpecificName;
                    foreach($imageOptions as $imageOption){
                        $pictureSet = new Types\VariationSpecificPictureSetType();
                        $pictureSet->VariationSpecificValue = $imageOption["value"];
                        $pictureSet->PictureURL[] = $imageOption["image"];
                        $pictures->VariationSpecificPictureSet[] = $pictureSet;
                    }
                    $ebayItem->Variations->Pictures[] = $pictures;
                 }
                 Log::info('ebayImportProduct multi variants product end ');
             }else{
                 // single variants product 
                 Log::info('ebayImportProduct single variants product');
                 // echo 'single variants product';
                 $price = $shProductVariants[0]['price'];
                //  $price =  1;
                 $quantity = $shProductVariants[0]['quantity'];
                 if($quantity == 0) $quantity = 1;
                 $ebayItem->Quantity = ($listing_format == "auction") ? 1 : $quantity;
                 $ebayItem->StartPrice = new Types\AmountType(['value' => (float)$price ]);
                 $ebayItem->SKU = strval($skuFirstVarient);
              
                 $shVariantJsonData = json_decode($shProductVariants[0]['shopify_variant_data'],true);
                 
                 if($profile->product_id_type && $ebay_environment != "sandbox"){
                     // product listing details set  exp. EAN , UPC  etc 
                     $ebayItem->ProductListingDetails = new Types\ProductListingDetailsType();
                     $ebayItem->ProductListingDetails = $this->getProductListingDetails($profile,$skuFirstVarient,$shProductVariants[0]['Barcode'],$vendor,$siteId);
                 }
                
             }
             
            // item_specifics data set
            $shVariantJsonData = json_decode($shProductVariants[0]['shopify_variant_data'],true);
            $shFirstVarientColour = 'Not Found';
                 if($option1Name == 'color' || $option1Name == 'colour'){
                      $shFirstVarientColour =  ($shVariantJsonData['option1'] != '') ? substr(trim($shVariantJsonData['option1'],' '),0,65) : 'Not Found';
                 }else if($option2Name == 'color' || $option2Name == 'colour'){
                      $shFirstVarientColour =  ($shVariantJsonData['option1'] != '') ? substr(trim($shVariantJsonData['option1'],' '),0,65) : 'Not Found';
                 }else if($option3Name == 'color' || $option3Name == 'colour'){
                      $shFirstVarientColour =  ($shVariantJsonData['option1'] != '') ? substr(trim($shVariantJsonData['option1'],' '),0,65) : 'Not Found';
                 }
           
           
            
            $item_specifics = ($profile->item_specifics) ? json_decode($profile->item_specifics,true) : null;
            // process item specifics process by profile  
            if($vendor || $skuFirstVarient || $item_specifics){
                $ebayItem->ItemSpecifics = $this->processEbayItemSpecifics($item_specifics,$option1Name,$option2Name,$option3Name,$shProductVariants,$vendor,$product);
            }
           
            // product images data set
            $pictureDetails =  $this->processProductImages($shProductJsonData, $skipImages);
            $ebayItem->PictureDetails = $pictureDetails;

            
           
            // polices set  start 
            $paymentProfile = null;
            $shippingProfile = null;
            $returnProfile = null;
            $ShippingType = null;
            $intlShippingType = null ;

            if($profile->paymentProfile){
                $paymentProfile = new Types\SellerPaymentProfileType();
                $paymentProfile->PaymentProfileID = (int) $profile->paymentProfile->seller_profile_id;
            }
    
            if($profile->shippingProfile ){
                $shippingProfile = new Types\SellerShippingProfileType();	
                $shippingProfile->ShippingProfileID = (int) $profile->shippingProfile->seller_profile_id;
                    $ShippingType = $profile->shippingProfile->shippingService_name;
                $shippingProfiledata = json_decode($profile->shippingProfile->seller_profiles_data,true);
                if(isset($shippingProfiledata)){
                 $intlShippingType = $shippingProfiledata['shippingPolicyInfo']['intlShippingType'];
                }
                     Log::info("shipping profile is here for the ShippingType".	$ShippingType);
                 Log::info("shipping profile is here for the current user".	$shippingProfile->ShippingProfileID);
                
            }
            if($profile->returnProfile){
                $returnProfile = new Types\SellerReturnProfileType();
                $returnProfile->ReturnProfileID = (int) $profile->returnProfile->seller_profile_id;
            }
            if($paymentProfile || $shippingProfile || $returnProfile){
                $ebayItem->SellerProfiles = new Types\SellerProfilesType();
                if($shippingProfile){
                    Log::info("shipping profile ".json_encode($shippingProfile,true));
                    $ebayItem->SellerProfiles->SellerShippingProfile = $shippingProfile;	
                    if (in_array($siteId, [15, 2, 77, 101, 3, 0, 100])) {
                        if($ShippingType == 'Calculated' || $intlShippingType == 'Calculated'){		    
                           Log::info("verifyEbayItem inside call itemPackageDetails");
                           $packageDetails =  $this->itemPackageDetailsNew($shVariantJsonData,$siteId,$product);
                           $ebayItem->ShippingPackageDetails = $packageDetails;
                        }	
                    }
                }
                if($paymentProfile){
                    $ebayItem->SellerProfiles->SellerPaymentProfile = $paymentProfile;
                }
                if($returnProfile){
                    $ebayItem->SellerProfiles->SellerReturnProfile = $returnProfile;
                }
            }
            $payment_methods = ($profile->payment_methods) ? json_decode($profile->payment_methods,true) : array();
            if(!$paymentProfile && $payment_methods){
                $ebayItem->PaymentMethods = $payment_methods;
                if(in_array("PayPal",$payment_methods) && $profile->paypal_email) $ebayItem->PayPalEmailAddress = $profile->paypal_email;
            }

            if(!$returnProfile){
                // default return policy  
                $ebayItem->ReturnPolicy = new Types\ReturnPolicyType();

                if(($profile->domestic_returns_accepted == "ReturnsAccepted") || ($profile->international_returns_accepted && $profile->international_returns_accepted != "ReturnsNotAccepted") ){
                    if ($profile->return_policy_details && in_array($siteId, [77, 16, 71, 101, 186, 2])) {
                        $maxLength = 8000;  // this side id length difference because this conduction  DE, AT
                        if (in_array($siteId, [71, 101, 186])) { // this side id length FR, IT, ES
                            $maxLength = 5000;
                        }
                        $ebayItem->ReturnPolicy->Description = substr( $profile->return_policy_details, 0, $maxLength);;
                    }
                }

                if($profile->domestic_returns_accepted == "ReturnsAccepted"){
                $ebayItem->ReturnPolicy->ReturnsAcceptedOption = $profile->domestic_returns_accepted;
                    $ebayItem->ReturnPolicy->RefundOption = $profile->domestic_refund_given_as;
                    $ebayItem->ReturnPolicy->ReturnsWithinOption = $profile->domestic_returned_within;
                    $ebayItem->ReturnPolicy->ShippingCostPaidByOption = $profile->domestic_returns_paid_by;
                }

                // if($profile->international_returns_accepted && $profile->international_returns_accepted != "ReturnsNotAccepted"){
                // 	$ebayItem->ReturnPolicy->InternationalRefundOption = $profile->international_refund_given_as;
                // 	$ebayItem->ReturnPolicy->InternationalReturnsAcceptedOption = $profile->international_returns_accepted;
                // 	$ebayItem->ReturnPolicy->InternationalReturnsWithinOption = $profile->international_returned_within;
                // 	$ebayItem->ReturnPolicy->InternationalShippingCostPaidByOption = $profile->international_returns_paid_by;
                // }
                // else{
                // 	$ebayItem->ReturnPolicy->InternationalReturnsAcceptedOption = "ReturnsNotAccepted";
                // }
            }
            if(!$shippingProfile){
                // default shipping policy set 
                Log::info("domestic_ships_within_handling_days ".$profile->domestic_ships_within_handling_days);
                $domestic_ships_within_handling_days = (int) $profile->domestic_ships_within_handling_days;
                if($domestic_ships_within_handling_days !== "" && $domestic_ships_within_handling_days >= 0) $ebayItem->DispatchTimeMax = $domestic_ships_within_handling_days;
                $ebayItem = $this->setShippingPolicyInItem($profile,$shVariantJsonData,$siteId,$product,$ebayItem);
            }


            Log::info("here is ebay object we are passing " . $ebayItem);
            // print_r(json_decode($ebayItem,true));
            $ebayRequest->Item = $ebayItem;
           
            $errors = array();
            $ebayResponse = [];
            $ebayItemId = 0;
            $productEnded = false;
            $onEbayproductdelete = false;

            if($productImportType){
                // product update
                $ebayResponse = ($listing_format == "auction") ? $ebayService->reviseItem($ebayRequest) : $ebayService->reviseFixedPriceItem($ebayRequest);

            }
            else{
                // product create 
                $ebayResponse = ($listing_format == "auction") ? $ebayService->addItem($ebayRequest) : $ebayService->AddFixedPriceItem($ebayRequest);
            }
            if(isset($ebayResponse->Errors)){
                foreach($ebayResponse->Errors as $error){
                    $severityCode = $error->SeverityCode === Enums\SeverityCodeType::C_ERROR ? 'Error' : 'Warning';
                    if($severityCode == "Warning") continue;
                    if(strpos($error->ShortMessage,'ended') !== false || strpos($error->ShortMessage,'beendet') !== false){
                        // product ended 
                        $productEnded = true;
                    }

                    if(strpos($error->ShortMessage,'This Token has been revoked by App.') !== false){
                        // ebay token exp.
                        Log::info("ebay token exp. user id is   ".$user->id);
                        echo 'ebay token exp';
                        die();
                    }
                    if(strpos($error->ShortMessage,'Item cannot be accessed.') !== false ||  strpos($error->ShortMessage,'Listing removed for policy violation.') !== false ||   strpos($error->ShortMessage,'Buyers love large photos that clearly show the item, so please upload high-resolution photos that are at least 500 pixels on the longest side.') !== false || strpos($error->ShortMessage,'Item cannot be relisted.') !== false){
                        $onEbayproductdelete = true ;
                    }
                    $errors[] = array("severitycode" => $severityCode,"shortmessage" => $error->ShortMessage,"longmessage" => $error->LongMessage);
                }
                if (isset($ebayResponse->Message)) {
                    $errors[] = array("severitycode" => "message","shortmessage" =>" ","longmessage" =>  $ebayResponse->Message);
                    }
                
                Log::info("Error occures in publishing product to ebay and here is the error  ".json_encode($errors));
            }
            if($ebayResponse && isset($ebayResponse->Ack) && $ebayResponse->Ack !== 'Failure'){
                // product create Successfully 
               Log::info("ebay product published   ".json_encode($ebayResponse,true));
               $ebayItemId = $ebayResponse->ItemID;
               Log::info("ebay product published  ebay item id ".$ebayItemId );
               
             $this->eBayResponseSuccess($productImportType,$user,$ebayItemId,$siteId,$ebayToken,$ebayService,$product);

            }else if($ebayResponse && $ebayResponse->Ack === 'Failure' && $productEnded && $productImportType){
                $errors = [];
                $ebayRequest = ($listing_format == "auction") ? new Types\RelistItemRequestType() : new Types\RelistFixedPriceItemRequestType();
                $ebayRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
                $ebayRequest->RequesterCredentials->eBayAuthToken = $ebayToken;
                $ebayItem = new Types\ItemType();
                if($listing_format == "auction"){
                    $ebayItem->ListingType = Enums\ListingTypeCodeType::C_CHINESE;
                    $ebayItem->ListingDuration = ($listing_duration) ? $listing_duration : Enums\ListingDurationCodeType::C_DAYS_7;
                }else{
                    $ebayItem->ListingType = Enums\ListingTypeCodeType::C_FIXED_PRICE_ITEM;
                    $ebayItem->ListingDuration = ($listing_duration) ? $listing_duration : Enums\ListingDurationCodeType::C_GTC;
                }
                $ebayItem->ItemID = (string) $product->ebayitemid;
                $ebayItem->Site = $this->getEbaySiteNameFromID($siteId);
                $ebayRequest->Item = $ebayItem;
                $ebayResponse = array();
                sleep(2);
                $ebayResponse = ($listing_format == "auction") ? $ebayService->relistItem($ebayRequest) : $ebayService->relistFixedPriceItem($ebayRequest);
                if(isset($ebayResponse->Errors)){
                    foreach($ebayResponse->Errors as $error){
                        $severityCode = $error->SeverityCode === Enums\SeverityCodeType::C_ERROR ? 'Error' : 'Warning';
                        if($severityCode == "Warning") continue;

                        if(strpos($error->ShortMessage,'Item cannot be accessed.') !== false ||  strpos($error->ShortMessage,'Listing removed for policy violation.') !== false ||   strpos($error->ShortMessage,'Buyers love large photos that clearly show the item, so please upload high-resolution photos that are at least 500 pixels on the longest side.') !== false || strpos($error->ShortMessage,'Item cannot be relisted.') !== false){
                            $onEbayproductdelete = true ;
                        }
                        $errors[] = array("severitycode" => $severityCode,"shortmessage" => $error->ShortMessage,"longmessage" => $error->LongMessage);
                    }
                    if (isset($ebayResponse->Message)) {
                        $errors[] = array("severitycode" => "message","shortmessage" =>" ","longmessage" =>  $ebayResponse->Message);
                        //$errorData["message"] = $ebayResponse->Message;
                        }

                    Log::info("Error occures in publishing product to ebay and here is the error  ".json_encode($errors));
                }

                if($ebayResponse && isset($ebayResponse->Ack) && $ebayResponse->Ack !== 'Failure'){
                    Log::info("ebay product relist   ".json_encode($ebayResponse,true));
                    $ebayItemId = $ebayResponse->ItemID;
                    Log::info("ebay product relist  ebay item id ".$ebayItemId );
                    $this->eBayResponseSuccess($productImportType,$user,$ebayItemId,$siteId,$ebayToken,$ebayService,$product);
                }

            }

            $errorNew = [];
            foreach($errors as $error){
                $errorNew[] = $error['longmessage'];
            }
            if ($errorNew && count($errorNew) > 0) {
                $product->status = 'error';
                $product->error_info = json_encode($errors, JSON_INVALID_UTF8_IGNORE);
                $product->save();
                  $errorCount =  $user->sh_products()->where('status','error')->count();
                if( $errorCount == 1){
                    try{
                        $longMessage = "";
                        foreach($errors as $error ){
                            $longMessage.=  $error['longmessage']." <br><br>";
                        }
                        $email =$user->email;
                        $ownername =$user->ownername;
                        Log::info("email : ".$email);
                        ServiceMail::publish_error($ownername,$email, $longMessage);
                    }catch(Exception $e){
                        Log::info("error occurs when sending mail :: ",$e);
                    }
                }
            }
            if($errorNew && count($errorNew) > 0){
    
                return response()->json([
                    "message" => "Error in publishing product to eBay",
                    "errors" => $errorNew
                ], 200);
            }else{
                return response()->json([
                    "message" => "Import Successfully",
                ], 200);
            }
       }
    public function importProductToEbay(){
        echo "asd";
         $cronJob = Cron::where('crontype', 'importEbayProducts')->first();
         if ($cronJob && $cronJob->isrunning == 1) {
            die("Cron is already running.");
        } elseif ($cronJob) {
            $cronJob->isrunning = 1;
            $cronJob->save();
        } else {
            die("Cron job type 'importEbayProducts' not found.");
        }
        $pendingImports = ProcessEbayImport::where('status','pending')->get();
        Log::info(   $pendingImports );
        if($pendingImports->count() > 0){
            foreach($pendingImports as $pendingImport){
                $user_id = $pendingImport->user_id;
                $user = User::where("id", $user_id)->first();
                $ebay_key = $user->ebKey()->first();
                $ebayToken = $ebay_key->token;
                $siteId = $ebay_key->siteid;
                $ebay_environment = "production";
                //  ebay credentails
                $ebConfig = [
                    "production" => [
                        "credentials" => [
                            "devId" => "83df6eb2-cf1a-4c04-87ea-a5f3e450bd25",
                            "appId" => "InfoShor-SKUBubbl-PRD-42f5817e2-a5e09617",
                            "certId" => "PRD-2f5817e259c8-7213-4949-a498-8162",
                        ],
                    ],
                    "sandbox" => [
                        "credentials" => [
                            "devId" => "83df6eb2-cf1a-4c04-87ea-a5f3e450bd25",
                            "appId" => "InfoShor-SKUBubbl-SBX-145f6444c-fd18db0d",
                            "certId" => "SBX-45f6444cfae6-5fa1-4c90-bddb-6845",
                        ],
                    ],
                ];
        
                // define service
                $ebayService = new Services\TradingService([
                    "credentials" => $ebConfig["production"]["credentials"],
                    "sandbox" => false,
                    "siteId" => $siteId,
                ]);
                $product = $user->sh_products()->where('id',$pendingImport->sh_product_id)->with(['sh_variants','profile'])->first();   

                $shProductVariants = $product->sh_variants;

                $profile = $product->profile;


                $shProductStatus = $product->status;

              



              
                $productImportType = ($shProductStatus == "Imported") ? true : false ;

                  if (!empty($product->ebayitemid)) {
                    // ebayitemid is set, do something
                         $productImportType  = true;
                  }

               
                $listing_format = $profile->listing_format;
                $ebayRequest = ($listing_format == "auction") ? new Types\AddItemRequestType() : new Types\AddFixedPriceItemRequestType();
				if($productImportType) $ebayRequest = ($listing_format == "auction") ? new Types\ReviseItemRequestType() : new Types\ReviseFixedPriceItemRequestType();
				$ebayRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
				$ebayRequest->RequesterCredentials->eBayAuthToken = $ebayToken;
                
                $ebayItem = new Types\ItemType();
                $listing_duration = $profile->listing_duration;

				if($listing_format == "auction"){
				      Log::info("listing format is auction");
					$ebayItem->ListingType = Enums\ListingTypeCodeType::C_CHINESE;
					$ebayItem->ListingDuration = ($listing_duration) ? $listing_duration : Enums\ListingDurationCodeType::C_DAYS_7;
				}else{
				    Log::info("listing format is fixed price ");
					$ebayItem->ListingType = Enums\ListingTypeCodeType::C_FIXED_PRICE_ITEM;
					$ebayItem->ListingDuration = ($listing_duration) ? $listing_duration : Enums\ListingDurationCodeType::C_GTC;
				}

                if($productImportType) $ebayItem->ItemID = (string) $product->ebayitemid;

                $shProductJsonData = json_decode($product->shopify_product_data,true);

                Log::info("shProductJsonData this in decode");

                Log::info( $shProductJsonData);

                $descriptionAndTitle =  $this->productDescriptionAndTitle($profile,$shProductJsonData,$product);
                //  print_r($descriptionAndTitle);
                 Log::info("productDescriptionAndTitle return title ".$descriptionAndTitle['title']);
                 Log::info("productDescriptionAndTitle return description ".$descriptionAndTitle['description']);
                 $title =  $descriptionAndTitle['title'];
                 $description =  $descriptionAndTitle['description'];
                 $ebayItem->Title = $title;
                 $ebayItem->Description = $description;

                         // ebay category id 
                         if($profile->ebay_category_id){
                            Log::info("ebay category id ".$profile->ebay_category_id);
                           $ebayItem->PrimaryCategory = new Types\CategoryType();
                           $ebayItem->PrimaryCategory->CategoryID = $profile->ebay_category_id;
                         }
                        

                         // countery type
                            $inventoryId = $shProductVariants[0]->shopify_inventory_item_id;

                          $location = $this->getShopifyLocation($user->shopurl, $user->token,     $inventoryId);
                            Log::info($location);
                            if (
                                isset(
                                    $location[
                                        "countryCode"
                                    ]
                                )
                            ) {
                                $ebayItem->Country =
                                    $location[
                                        "countryCode"
                                    ];
                                Log::info("Profile->Country " . $profile->Country);
                            } else {
                                $ebayItem->Country = $this->getEbayCountry($siteId);
                            }
                            if (
                                isset(
                                    $location[
                                        "zip"
                                    ]
                                )
                            ) {
                                $ebayItem->PostalCode =
                                    (string) $location["zip"];
                            }
                            if (
                                $location[
                                    "city"
                                ]
                            ) {
                                $ebayItem->Location =
                                    $location[
                                        "city"
                                    ];
                            }
                    
                        $ebayItem->Currency = $this->getEbayCurrency($siteId);
        
                        
                        if (
                            isset($profile->item_condition) &&
                            $profile->item_condition != null
                        ) {
                            Log::info("item_condition is not null");
                            $dataObject = json_decode($profile->item_condition, true);
                            Log::info($dataObject);
                                  if (
                                isset($dataObject["label"]) ||
                               isset( $dataObject["value"])
                            ) {
                                Log::info("item_condition name & value is not null");
                                $ebayItem->ConditionID = (int) $dataObject["value"];
                            }
                        } else {
                            $ebayItem->ConditionID = 1000;
                        }

                                     
                        
               $vendor = isset($shProductJsonData['vendor']) ? $shProductJsonData['vendor'] : NULL;
               $skuFirstVarient = isset($shProductVariants[0]->sku) ? $shProductVariants[0]->sku : NULL;

               
               // option name get 
               $option1Name = (isset($shProductJsonData["options"][0]["name"])) ? substr(trim(strtolower($shProductJsonData["options"][0]["name"]),' '),0,65) : NULL;
               $option2Name = (isset($shProductJsonData["options"][1]["name"])) ? substr(trim(strtolower($shProductJsonData["options"][1]["name"]),' '),0,65) : NULL;
               $option3Name = (isset($shProductJsonData["options"][2]["name"])) ? substr(trim(strtolower($shProductJsonData["options"][2]["name"]),' '),0,65) : NULL;
              
               Log::info( ' option 1 '. $option1Name . ' option 2 '. $option2Name .' option 3 '. $option3Name ) ;
               //option values get 
               $option1Values = isset($shProductJsonData['options'][0]['values']) ?  array_intersect_key($shProductJsonData['options'][0]['values'], array_unique(array_map('strtolower', $shProductJsonData['options'][0]['values']))) : NULL ;
               $option2Values = isset($shProductJsonData['options'][1]['values']) ?  array_intersect_key($shProductJsonData['options'][1]['values'], array_unique(array_map('strtolower', $shProductJsonData['options'][0]['values']))) : NULL ;
               $option3Values = isset($shProductJsonData['options'][2]['values']) ?  array_intersect_key($shProductJsonData['options'][2]['values'], array_unique(array_map('strtolower', $shProductJsonData['options'][0]['values']))) : NULL ;

                       
                // Change images based on the selected color variant when a variant is clicked on ebay . 
                $imgVariationSpecificName = $option1Name;
                if(strtolower($option2Name) == "color" || strtolower($option2Name) == "colour") $imgVariationSpecificName = $option2Name;
                else if(strtolower($option3Name) == "color" || strtolower($option3Name) == "colour") $imgVariationSpecificName = $option3Name;
                $skipImages = array() ;
                $imageOptions= array() ; 

                     // multi variants product 
            if(count($shProductVariants) > 1 && $shProductJsonData['variants'][0]['option1'] !== 'Default Title' && $listing_format != "auction"){
                // multi variants product 
                Log::info('ebayImportProduct multi variants product');
                $ebayItem->Variations = new Types\VariationsType();
 
                // eBay does not allow some option names. For this add 's' after the option name. 
                $optionsNames =	$this->setOptionsNames($option1Name,$option2Name,$option3Name);
                $option1Name =  $optionsNames['option1name'];
                $option2Name =  $optionsNames['option2name'];
                $option3Name =  $optionsNames['option3name'];
                
                
                Log::info("ebayImportProduct inside call setValuesVariationSpecifics");
                // set option name and all options values set in VariationSpecifics
                $variationSpecificsSet	= $this->setValuesVariationSpecificsNew($option1Name,$option2Name,$option3Name,$option1Values,$option2Values,$option3Values);
                $ebayItem->Variations->VariationSpecificsSet = $variationSpecificsSet;
 
                foreach($shProductVariants as $shVariant){
                    $shVariantJsonData = json_decode($shVariant->shopify_variant_data,true);
                     
                     // product variants in for loop single options value get 
                     $option1shVariant = (isset($shVariantJsonData['option1'])) ? substr(trim($shVariantJsonData['option1'],' '),0,65) : NULL;
                     $option2shVariant = (isset($shVariantJsonData['option2'])) ? substr(trim($shVariantJsonData['option2'],' '),0,65) : NULL;
                     $option3shVariant = (isset($shVariantJsonData['option3'])) ? substr(trim($shVariantJsonData['option3'],' '),0,65) : NULL;
                     
                     // This checks that option values are not duplicated, e.g., 'Red' != 'red' != 'RED', as eBay does not allow case-insensitive duplicates. 
                     if (!in_array($option1shVariant, $option1Values)) {
                        continue ;
                    }else{
                            if($option2Name && $option2Values){
                                 if (!in_array($option2shVariant, $option2Values)) {
                                   continue ;
                                }else{
                                    if($option3Name && $option3Values){
                                          if (!in_array($option3shVariant, $option3Values)) {
                                              continue ;
                                            }
                                          }
                                }  
                            }
                    }
                      
                    $quantity = $shVariant->quantity;

                    // $quantity = 0;
                    if($quantity == 0) $quantity = 1;
                    // this set is variation listing details exp. EAN , UPC  etc 
                    $itemVariation =  $this->setValueVariationProductListingDetailsNew($shVariantJsonData,$shVariant,$ebay_environment,$vendor,$profile,$siteId,$option1shVariant,$option2shVariant,$option3shVariant,$option1Name,$option2Name,$option3Name);
                    $itemVariation->SKU = strval($shVariant->sku);
                    $itemVariation->Quantity = $quantity;
                    $price = $shVariant->price;
                    // $price = 1;
                    $itemVariation->StartPrice = new Types\AmountType(['value' => (float) $price]);
                    $ebayItem->Variations->Variation[] = $itemVariation;
                    // variant images insert in array in this imageOptions
                    if($shVariant->image){
                     //  images found 
                     
                     $voption = $option1shVariant;
                     if($option2shVariant && (strtolower($option2Name) == "color" || strtolower($option2Name) == "colour")){
                         $voption = $option2shVariant;
                     }
                     else if($option3shVariant && (strtolower($option3Name) == "color" || strtolower($option3Name) == "colour")){
                         $voption = $option3shVariant;
                     }
                     $opfound = false;
                     foreach($imageOptions as $imageOption){
                         if($imageOption["value"] == $voption){
                             $opfound = true;
                             break;
                         }
                     }
                     if(!$opfound){
                     $imageOptions[] = ["id" => $shVariant->id, "value" => $voption, "image" => $shVariant->image];
                     $skipImages[] = $shVariant->image;
                     }
                 }else{
                     // varient not images 
                     continue ;
                 }   
                 }
             
                 // variants images data set in item 
                 if($imgVariationSpecificName && $imageOptions){
                  $pictures = new Types\PicturesType();
                  $pictures->VariationSpecificName = $imgVariationSpecificName;
                  foreach($imageOptions as $imageOption){
                      $pictureSet = new Types\VariationSpecificPictureSetType();
                      $pictureSet->VariationSpecificValue = $imageOption["value"];
                      $pictureSet->PictureURL[] = $imageOption["image"];
                       $pictures->VariationSpecificPictureSet[] = $pictureSet;
                  }
                  $ebayItem->Variations->Pictures[] = $pictures;
                 }
                 Log::info('ebayImportProduct multi variants product end ');
             }else{
                 // single variants product 
                 Log::info('ebayImportProduct single variants product');
                 // echo 'single variants product';
                 $price = $shProductVariants[0]['price'];
                //  $price =  1;
                 $quantity = $shProductVariants[0]['quantity'];
                 if($quantity == 0) $quantity = 1;
                 $ebayItem->Quantity = ($listing_format == "auction") ? 1 : $quantity;
                 $ebayItem->StartPrice = new Types\AmountType(['value' => (float)$price ]);
                 $ebayItem->SKU = strval($skuFirstVarient);
              
                 $shVariantJsonData = json_decode($shProductVariants[0]['shopify_variant_data'],true);
                 
                 if($profile->product_id_type && $ebay_environment != "sandbox"){
                     // product listing details set  exp. EAN , UPC  etc 
                     $ebayItem->ProductListingDetails = new Types\ProductListingDetailsType();
                     $ebayItem->ProductListingDetails = $this->getProductListingDetailsNew($profile,$skuFirstVarient,$shProductVariants[0]['Barcode'],$vendor,$siteId);
                 }
                
             }
             
            // item_specifics data set
            $shVariantJsonData = json_decode($shProductVariants[0]['shopify_variant_data'],true);
            $shFirstVarientColour = 'Not Found';
                 if($option1Name == 'color' || $option1Name == 'colour'){
                      $shFirstVarientColour =  ($shVariantJsonData['option1'] != '') ? substr(trim($shVariantJsonData['option1'],' '),0,65) : 'Not Found';
                 }else if($option2Name == 'color' || $option2Name == 'colour'){
                      $shFirstVarientColour =  ($shVariantJsonData['option1'] != '') ? substr(trim($shVariantJsonData['option1'],' '),0,65) : 'Not Found';
                 }else if($option3Name == 'color' || $option3Name == 'colour'){
                      $shFirstVarientColour =  ($shVariantJsonData['option1'] != '') ? substr(trim($shVariantJsonData['option1'],' '),0,65) : 'Not Found';
                 }
           
                 //  item specifics in shopify product data array create 
          
            $item_specifics = ($profile->item_specifics) ? json_decode($profile->item_specifics,true) : null;
            // process item specifics process by profile  
            if($vendor || $skuFirstVarient || $item_specifics){
                $ebayItem->ItemSpecifics = $this->processEbayItemSpecifics($item_specifics,$option1Name,$option2Name,$option3Name,$shProductVariants,$vendor,$product);
            }
           
            // product images data set
            $pictureDetails =  $this->processProductImages($shProductJsonData, $skipImages);
            $ebayItem->PictureDetails = $pictureDetails;

            
           
            // polices set  start 
            $paymentProfile = null;
            $shippingProfile = null;
            $returnProfile = null;
            $ShippingType = null;
            $intlShippingType = null ;

            if($profile->paymentProfile){
                $paymentProfile = new Types\SellerPaymentProfileType();
                $paymentProfile->PaymentProfileID = (int) $profile->paymentProfile->seller_profile_id;
            }
    
            if($profile->shippingProfile ){
                $shippingProfile = new Types\SellerShippingProfileType();	
                $shippingProfile->ShippingProfileID = (int) $profile->shippingProfile->seller_profile_id;
                    $ShippingType = $profile->shippingProfile->shippingService_name;
                $shippingProfiledata = json_decode($profile->shippingProfile->seller_profiles_data,true);
                if(isset($shippingProfiledata)){
                 $intlShippingType = $shippingProfiledata['shippingPolicyInfo']['intlShippingType'];
                }
                     Log::info("shipping profile is here for the ShippingType".	$ShippingType);
                 Log::info("shipping profile is here for the current user".	$shippingProfile->ShippingProfileID);
                
            }
            if($profile->returnProfile){
                $returnProfile = new Types\SellerReturnProfileType();
                $returnProfile->ReturnProfileID = (int) $profile->returnProfile->seller_profile_id;
            }
            if($paymentProfile || $shippingProfile || $returnProfile){
                $ebayItem->SellerProfiles = new Types\SellerProfilesType();
                if($shippingProfile){
                    Log::info("shipping profile ".json_encode($shippingProfile,true));
                    $ebayItem->SellerProfiles->SellerShippingProfile = $shippingProfile;	
                    if (in_array($siteId, [15, 2, 77, 101, 3, 0, 100])) {
                        if($ShippingType == 'Calculated' || $intlShippingType == 'Calculated'){		    
                           Log::info("verifyEbayItem inside call itemPackageDetails");
                           $packageDetails =  $this->itemPackageDetailsNew($shVariantJsonData,$siteId,$product);
                           $ebayItem->ShippingPackageDetails = $packageDetails;
                        }	
                    }
                }
                if($paymentProfile){
                    $ebayItem->SellerProfiles->SellerPaymentProfile = $paymentProfile;
                }
                if($returnProfile){
                    $ebayItem->SellerProfiles->SellerReturnProfile = $returnProfile;
                }
            }
            $payment_methods = ($profile->payment_methods) ? json_decode($profile->payment_methods,true) : array();
            if(!$paymentProfile && $payment_methods){
                $ebayItem->PaymentMethods = $payment_methods;
                if(in_array("PayPal",$payment_methods) && $profile->paypal_email) $ebayItem->PayPalEmailAddress = $profile->paypal_email;
            }

            if(!$returnProfile){
                // default return policy  
                $ebayItem->ReturnPolicy = new Types\ReturnPolicyType();

                if(($profile->domestic_returns_accepted == "ReturnsAccepted") || ($profile->international_returns_accepted && $profile->international_returns_accepted != "ReturnsNotAccepted") ){
                    if ($profile->return_policy_details && in_array($siteId, [77, 16, 71, 101, 186, 2])) {
                        $maxLength = 8000;  // this side id length difference because this conduction  DE, AT
                        if (in_array($siteId, [71, 101, 186])) { // this side id length FR, IT, ES
                            $maxLength = 5000;
                        }
                        $ebayItem->ReturnPolicy->Description = substr( $profile->return_policy_details, 0, $maxLength);;
                    }
                }

                if($profile->domestic_returns_accepted == "ReturnsAccepted"){
                $ebayItem->ReturnPolicy->ReturnsAcceptedOption = $profile->domestic_returns_accepted;
                    $ebayItem->ReturnPolicy->RefundOption = $profile->domestic_refund_given_as;
                    $ebayItem->ReturnPolicy->ReturnsWithinOption = $profile->domestic_returned_within;
                    $ebayItem->ReturnPolicy->ShippingCostPaidByOption = $profile->domestic_returns_paid_by;
                }

                // if($profile->international_returns_accepted && $profile->international_returns_accepted != "ReturnsNotAccepted"){
                // 	$ebayItem->ReturnPolicy->InternationalRefundOption = $profile->international_refund_given_as;
                // 	$ebayItem->ReturnPolicy->InternationalReturnsAcceptedOption = $profile->international_returns_accepted;
                // 	$ebayItem->ReturnPolicy->InternationalReturnsWithinOption = $profile->international_returned_within;
                // 	$ebayItem->ReturnPolicy->InternationalShippingCostPaidByOption = $profile->international_returns_paid_by;
                // }
                // else{
                // 	$ebayItem->ReturnPolicy->InternationalReturnsAcceptedOption = "ReturnsNotAccepted";
                // }
            }
            if(!$shippingProfile){
                // default shipping policy set 
                Log::info("domestic_ships_within_handling_days ".$profile->domestic_ships_within_handling_days);
                $domestic_ships_within_handling_days = (int) $profile->domestic_ships_within_handling_days;
                if($domestic_ships_within_handling_days !== "" && $domestic_ships_within_handling_days >= 0) $ebayItem->DispatchTimeMax = $domestic_ships_within_handling_days;
                $ebayItem = $this->setShippingPolicyInItem($profile,$shVariantJsonData,$siteId,$product,$ebayItem);
            }


            Log::info("here is ebay object we are passing " . $ebayItem);
            // print_r(json_decode($ebayItem,true));
            $ebayRequest->Item = $ebayItem;
           
            $errors = array();
            $ebayResponse = [];
            $ebayItemId = 0;
            $productEnded = false;
            $onEbayproductdelete = false;

            if($productImportType){
                // product update
                $ebayResponse = ($listing_format == "auction") ? $ebayService->reviseItem($ebayRequest) : $ebayService->reviseFixedPriceItem($ebayRequest);

            }
            else{
                // product create 
                $ebayResponse = ($listing_format == "auction") ? $ebayService->addItem($ebayRequest) : $ebayService->AddFixedPriceItem($ebayRequest);
            }
            if(isset($ebayResponse->Errors)){
                foreach($ebayResponse->Errors as $error){
                    $severityCode = $error->SeverityCode === Enums\SeverityCodeType::C_ERROR ? 'Error' : 'Warning';
                    if($severityCode == "Warning") continue;
                    if(strpos($error->ShortMessage,'ended') !== false || strpos($error->ShortMessage,'beendet') !== false){
                        // product ended 
                        $productEnded = true;
                    }

                    if(strpos($error->ShortMessage,'This Token has been revoked by App.') !== false){
                        // ebay token exp.
                        Log::info("ebay token exp. user id is   ".$user->id);
                        echo 'ebay token exp';
                        // die();
                        $errors[] = array("severitycode" => $severityCode,"shortmessage" => $error->ShortMessage,"longmessage" => $error->LongMessage);

                    }
                    if(strpos($error->ShortMessage,'Item cannot be accessed.') !== false ||  strpos($error->ShortMessage,'Listing removed for policy violation.') !== false ||   strpos($error->ShortMessage,'Buyers love large photos that clearly show the item, so please upload high-resolution photos that are at least 500 pixels on the longest side.') !== false || strpos($error->ShortMessage,'Item cannot be relisted.') !== false){
                        $onEbayproductdelete = true ;
                    }
                    $errors[] = array("severitycode" => $severityCode,"shortmessage" => $error->ShortMessage,"longmessage" => $error->LongMessage);
                }
                if (isset($ebayResponse->Message)) {
                    $errors[] = array("severitycode" => "message","shortmessage" =>" ","longmessage" =>  $ebayResponse->Message);
                    }
                
                Log::info("Error occures in publishing product to ebay and here is the error  ".json_encode($errors));
            }
            if($ebayResponse && isset($ebayResponse->Ack) && $ebayResponse->Ack !== 'Failure'){
                // product create Successfully 
               Log::info("ebay product published   ".json_encode($ebayResponse,true));
               $ebayItemId = $ebayResponse->ItemID;
               Log::info("ebay product published  ebay item id ".$ebayItemId );
               
               $this->eBayResponseSuccess($productImportType,$user,$ebayItemId,$siteId,$ebayToken,$ebayService,$product,$pendingImport);

            }else if($ebayResponse && $ebayResponse->Ack === 'Failure' && $productEnded && $productImportType){
                $errors = [];
                $ebayRequest = ($listing_format == "auction") ? new Types\RelistItemRequestType() : new Types\RelistFixedPriceItemRequestType();
                $ebayRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
                $ebayRequest->RequesterCredentials->eBayAuthToken = $ebayToken;

                $ebayItem = new Types\ItemType();
                if($listing_format == "auction"){
                    $ebayItem->ListingType = Enums\ListingTypeCodeType::C_CHINESE;
                    $ebayItem->ListingDuration = ($listing_duration) ? $listing_duration : Enums\ListingDurationCodeType::C_DAYS_7;
                }else{
                    $ebayItem->ListingType = Enums\ListingTypeCodeType::C_FIXED_PRICE_ITEM;
                    $ebayItem->ListingDuration = ($listing_duration) ? $listing_duration : Enums\ListingDurationCodeType::C_GTC;
                }
                $ebayItem->ItemID = (string) $product->ebayitemid;
                $ebayItem->Site = $this->getEbaySiteNameFromID($siteId);
                $ebayRequest->Item = $ebayItem;
                $ebayResponse = array();
                sleep(2);
                $ebayResponse = ($listing_format == "auction") ? $ebayService->relistItem($ebayRequest) : $ebayService->relistFixedPriceItem($ebayRequest);
                if(isset($ebayResponse->Errors)){
                    foreach($ebayResponse->Errors as $error){
                        $severityCode = $error->SeverityCode === Enums\SeverityCodeType::C_ERROR ? 'Error' : 'Warning';
                        if($severityCode == "Warning") continue;

                        if(strpos($error->ShortMessage,'Item cannot be accessed.') !== false ||  strpos($error->ShortMessage,'Listing removed for policy violation.') !== false ||   strpos($error->ShortMessage,'Buyers love large photos that clearly show the item, so please upload high-resolution photos that are at least 500 pixels on the longest side.') !== false || strpos($error->ShortMessage,'Item cannot be relisted.') !== false){
                            $onEbayproductdelete = true ;
                        }
                        $errors[] = array("severitycode" => $severityCode,"shortmessage" => $error->ShortMessage,"longmessage" => $error->LongMessage);
                    }
                    if (isset($ebayResponse->Message)) {
                        $errors[] = array("severitycode" => "message","shortmessage" =>" ","longmessage" =>  $ebayResponse->Message);
                        //$errorData["message"] = $ebayResponse->Message;
                        }

                    Log::info("Error occures in publishing product to ebay and here is the error  ".json_encode($errors));
                }

                if($ebayResponse && isset($ebayResponse->Ack) && $ebayResponse->Ack !== 'Failure'){
                    Log::info("ebay product relist   ".json_encode($ebayResponse,true));
                    $ebayItemId = $ebayResponse->ItemID;
                    Log::info("ebay product relist  ebay item id ".$ebayItemId );
                    $this->eBayResponseSuccess($productImportType,$user,$ebayItemId,$siteId,$ebayToken,$ebayService,$product,$pendingImport);
                }

            }

                if (!empty($errors) && is_array($errors)) {

                    $errorNew = [];
                    foreach($errors as $error){
                        $errorNew[] = $error['longmessage'];
                    }
                    if ($errorNew && count($errorNew) > 0) {
                        $product->status = 'error';
                        $product->error_info = json_encode($errors, JSON_INVALID_UTF8_IGNORE);
                        $product->save();
                        $errorCount =  $user->sh_products()->where('status','error')->count();

                        if( $errorCount == 1){

                                try{
                                    $longMessage = "";
                                    foreach($errors as $error ){
                                        $longMessage.=  $error['longmessage']." <br><br>";
                                    }
                                    $email =$user->email;
                                    $ownername =$user->ownername;
                                    Log::info("email : ".$email);
                                    ServiceMail::publish_error($ownername,$email, $longMessage);
                                }catch(Exception $e){
                                    Log::info("error occurs when sending mail :: ",$e);
                                }
                            }
                    }
                    if( $ebayItemId == 0){
                        $pendingImport->update([
                            'status' => 'error',
                            'description' => json_encode($errors, JSON_INVALID_UTF8_IGNORE),
                        ]);
                    }else{
                        $pendingImport->update([
                            'description' => json_encode($errors, JSON_INVALID_UTF8_IGNORE),
                        ]);
                    }
                    
                }else{
                     $pendingImport->update([
                            'status' => 'completed',
                        ]);
                }
            }
        }
        $cronJob->isrunning = 0;
        $cronJob->save();
    }  

    public function eBayResponseSuccess($productImportType,$user,$ebayItemId,$siteId,$ebayToken,$ebayService,$shProduct,$ebProcessImport=''){

        if($productImportType){
            // ebay product update because this ebay product and eb_product_variants table  row delete this ebayitemid
            Log::info('eBayResponseSuccess ebay product and eb_product_variants table  row delete this ebayitemid ' . $ebayItemId);
            $user->products()->where('ebayitemid', $ebayItemId)->delete();
            $ebProductVariant = $user->variants()->where('ebayitemid', $ebayItemId)->delete();
         }
         $shProduct->update([
            'ebayitemid' => $ebayItemId,
            'status'=>'Imported'
        ]);
         
        Log::info($shProduct);
        
        $userValue = User::where('id',$user->id)->first();

        if($userValue->skuconsumed == 1){
            $this->sendEmailForImport($userValue,$ebayItemId);
   
        }

            // import on ebay and insert ebay product table and varients and status changes 
            $product_id = $this->getAndInsertInDbEbProduct($user->id,$siteId,$ebayToken,$ebayItemId,$user,$ebayService,$shProduct);
        
    }

    public function sendEmailForImport($user,$ebayItemId){
        $name = $user->ownername;
        $to = $user->email;
        $subject = "[Shopify APP] eBay Importer by Infoshore - First Product Imported Successfully";
					$body = '<p>Dear ' . $name . ',</p>
					<p>Congratulations on successfully publishing your first product on your Ebay site!
					</p>
					<p>We also invite you to explore our available plans and pricing on the <a href="https://cp.infoshoreapps.com/updatedepi/cp/Plan&Pricing" target="_blank">Plans & Pricing</a> page within our app.</p>
					<p>Thank you for choosing our service!</p>
					 <h3>We\'re Here for You</h3>
					<p>You can also <a href="https://calendly.com/madhu-infoshore/30min" target="_blank">schedule 30 minute meeting with our support </a> so we can assist you in setting up your account and import process.</p>
					<p>You can simply click here to <a href="https://direct.lc.chat/18704628/" target="_blank">Start the live chat</a> to know more about the app.</p>
                    <p>If you have any questions or need assistance, please don\'t hesitate to reach out. Simply reply to this email, and we\'ll be happy to help!</p>
					<p><strong>Best regards,<br>Pankaj Narang<br>InfoShore Apps</strong></p>
                    <p>Skype: pankaj.narang</p>
					  ';
					if(strlen($to) < 1){
            			return;
            		}
            		$email = new \SendGrid\Mail\Mail(); 
                    $email->setFrom("shopifyapps@infoshore.biz", "Pankaj from InfoshoreApps");
                    $email->setSubject($subject);
                    $email->addTo($to);
                    $email->addBcc("pankajnarang81@gmail.com");
					$email->addBcc("anjalilagma123@gmail.com");

                    $email->addContent(
                        "text/html", $body
                    );
                    $sendgrid = new \SendGrid('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');
                    try {
                        $response = $sendgrid->send($email);
                        return true;
                    } catch (Exception $e) {
                        @mail("khariwal.rohit@gmail.com", "Fetchebproducts: Error sending setup email", 'A sendgrid error occurred: '.$e->getMessage());
                        return false;
                    }
    }
    public function getAndInsertInDbEbProduct($user_id, $siteid, $token, $ebayitemid,$userDetails,$ebayService,$shProduct) {
        try{
        $itemRequest = new Types\GetItemRequestType();
        $itemRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
        $itemRequest->RequesterCredentials->eBayAuthToken = $token;
        $itemRequest->ItemID = $ebayitemid;
        $itemRequest->DetailLevel = ['ReturnAll'];
        $itemRequest->IncludeItemCompatibilityList = true;
        $itemRequest->IncludeItemSpecifics = true;
        $itemResponse = $ebayService->getItem($itemRequest);		
        if($itemResponse->Ack !== 'Failure') {
            if(!isset($itemResponse->Item)){				
                return false;
            }
            $item = $itemResponse->Item;
    
            $listingType = $item->ListingType;
    
            $title = "";
            $description = "";
            $brand = "";
            $product_type = "";						
            $condition = "";
            $condition_val = "";
            $condition_note = "";
            $option1name = "";
            $option2name = "";
            $option3name = "";
            $option4name = "";
            $option5name = "";
            $item_specific = "";
            $storecategoryid = "";
            $storecategoryid2 = "";
            $dimenStr = "";
    
            $sku = "";
            $price = 0;
            $quantity = 0;
            $productid = "";
            $productidtype = "";
            $weight = 0;
            $weight_unit = 'lb';
            $shippingServicesArr = array();
            $searchstring = "";
            if(isset($item->Title)){
                $title = $item->Title;
                $title = $this->remove_emoji($title);
            }
            if(isset($item->Description)){
                $description = $item->Description;
            }
            if(isset($item->ConditionDisplayName)){
                $condition_val = $item->ConditionDisplayName;
            }
            if(isset($item->ConditionDescription)){
                $condition_note = $item->ConditionDescription;
            }
            if(isset($item->ShippingDetails)){
                $shippingDetails = $item->ShippingDetails;
                if(isset($shippingDetails->ShippingServiceOptions)){
                    $shippingServiceOptions = $shippingDetails->ShippingServiceOptions;
                    foreach($shippingServiceOptions as $shippingServiceOption){
                        if(isset($shippingServiceOption->ShippingService)){
                            $shippingService = $shippingServiceOption->ShippingService;
                            $shippingServiceCost = $shippingServiceOption->ShippingServiceCost->value;
                            $shippingServicesArr[] = array("shippingService" => $shippingService, "shippingServiceCost" => $shippingServiceCost);    		        
                        }
                    }
                }
            }	
            if(isset($item->ShippingPackageDetails)){
                $shippingPackageDetails = $item->ShippingPackageDetails;
                if(isset($shippingPackageDetails->WeightMajor) && isset($shippingPackageDetails->WeightMinor)){
                    $weightMajor = $shippingPackageDetails->WeightMajor->value;
                    $weightMinor = $shippingPackageDetails->WeightMinor->value;
                    $weightMajorUnit = $shippingPackageDetails->WeightMajor->unit;
                    $weightMinorUnit = $shippingPackageDetails->WeightMinor->unit;					
                
                        if($weightMajorUnit == "kg" && $weightMinorUnit == "gm"){
                            $weight_unit = 'kg';
                            $weight = $weightMajor + $weightMinor*0.001;
                        } else {
                            $weight = $weightMajor + $weightMinor * 0.0625;
                        }
                
                }
            }
    
            if(isset($item->ItemSpecifics) && isset($item->ItemSpecifics->NameValueList)) {
                $itemSpecifics = $item->ItemSpecifics->NameValueList;
                foreach($itemSpecifics as $itemSpecific){
                    if($itemSpecific->Name == 'Brand'){
                        $brand = $itemSpecific->Value[0];
                    }
                }
            }
            if($brand == ""){
                if(isset($item->ProductListingDetails)){
                    $productListingDetails = $item->ProductListingDetails;
                    if(isset($productListingDetails->BrandMPN)){
                        $brandMPN = $productListingDetails->BrandMPN;
                        if(isset($brandMPN->Brand)){
                            $brand = $brandMPN->Brand;
                        }			
                    }
                }			
            }
            
            
            if(isset($item->PrimaryCategory->CategoryName)){
                $product_type = $item->PrimaryCategory->CategoryName;
            }
    
            if(isset($item->Storefront)){
                $storeFront = $item->Storefront;
                if(isset($storeFront->StoreCategoryID)){
                    $storecategoryid = $storeFront->StoreCategoryID;					
                }
                if(isset($storeFront->StoreCategory2ID)){
                    $storecategoryid2 = $storeFront->StoreCategory2ID;					
                }				
            }
    
            $itemSpecArr = array();
            if(isset($item->ItemSpecifics) && isset($item->ItemSpecifics->NameValueList)){
                foreach($item->ItemSpecifics->NameValueList as $itemSpecObj){
                    $name = $itemSpecObj->Name;
                    $value = $itemSpecObj->Value;
                    $itemSpecArr[$name] = implode(",", iterator_to_array($value));
                }
            }
    
            $item_specific = json_encode($itemSpecArr);
    
            if(!isset($item->Variations)){
                $orig_price = 0;
                if(isset($item->SellingStatus->PromotionalSaleDetails)){
                    $promotionalSaleDetails = $item->SellingStatus->PromotionalSaleDetails;
                    if(isset($promotionalSaleDetails->OriginalPrice)){
                        $orig_price = $promotionalSaleDetails->OriginalPrice->value;
                    }
                }
                $images = array();
                if(isset($item->SKU)){
                    $sku = $item->SKU;
                }
    
                if(isset($item->StartPrice)){
                    $price = $item->StartPrice->value;
                }
    
                if(isset($item->Quantity)){
                    $quantity = $item->Quantity;
                }
                if(isset($item->SellingStatus)){
                    $sellingStatus = $item->SellingStatus;
                    if(isset($sellingStatus->QuantitySold)){
                        $quantity = $quantity - $sellingStatus->QuantitySold;
                    }
                }
    
                if(isset($item->ProductListingDetails)){
                    $productListingDetails = $item->ProductListingDetails;
                    if(isset($productListingDetails->UPC)){
                        $productid = $productListingDetails->UPC;
                        $productidtype = "3";
                    } else if(isset($productListingDetails->EAN)){
                        $productid = $productListingDetails->EAN;
                        $productidtype = "4";
                    } else if(isset($productListingDetails->ISBN)){
                        $productid = $productListingDetails->ISBN;
                        $productidtype = "2";
                    }
                }
                $main_image = '';
                $main_image_check = true;
                if(isset($item->PictureDetails->PictureURL)) {
                    $pictureLength = count($item->PictureDetails->PictureURL);
                    for($i = 0; $i < $pictureLength; $i++) {
                        if ($main_image_check) {
                            # code...
                        $main_image = $item->PictureDetails->PictureURL[$i];
                        $main_image_check = false;
    
    
                        }
                        $images[] = $item->PictureDetails->PictureURL[$i];
                    }
                } else if(isset($item->PictureDetails->GalleryURL)) {
                    //$pictureLength = count($item->PictureDetails->GalleryURL);
                    //for($i = 0; $i < $pictureLength; $i++) {
                        if ($main_image_check) {
                            # code...
                            $main_image =  $item->PictureDetails->GalleryURL;
                            $main_image_check = false;
    
    
                        }
                        $images[] = $item->PictureDetails->GalleryURL;
                    //}
                } else if(isset($item->ProductListingDetails->StockPhotoURL)) {
                        if ($main_image_check) {
                            # code...
                            $main_image = $item->ProductListingDetails->StockPhotoURL;
                            $main_image_check = false;
    
    
                        }
                    $images[] = $item->ProductListingDetails->StockPhotoURL;
                    
                } 
    
                $data = [
                    'title' => $title,
                    'item_specific' => $item_specific,
                    'condition_val' => $condition_val,
                    'condition_note' => $condition_note,
                    'brand' => $brand,
                    'status'=>'linked',
                    'shopifyproductid'=>$shProduct->shopify_product_id,
                    'product_type' => $product_type,
                    'storecategoryid' => $storecategoryid,
                    'storecategoryid2' => $storecategoryid2,
                    'ebayitemid' => $ebayitemid,
                    'user_id' => $user_id,
                ];
                Log::info('jsadfhshfhasf'.json_encode($data));
                $product = $userDetails->products()->create($data);
                $product_id = $product->product_id;
                
                $variantData = [
                    'product_id'     => $product_id,
                    'sku'            => $sku,
                    'ebayitemid'     => $ebayitemid,
                    'price'          => $price,
                    'orig_price'     => $orig_price,
                    'shopifyproductid'=>$shProduct->shopify_product_id,
                    'shopifyvariantid'=> $shProduct->sh_variants[0]->shopify_variant_id,
                    'shopifyinventoryid'=> $shProduct->sh_variants[0]->shopify_inventory_item_id,
                    'quantity'       => $quantity,
                    'status'         =>'linked',
                    'productid'      => $productid,
                    'productidtype'  => $productidtype,
                    'weight'         => $weight,
                    'weight_unit'    => $weight_unit,
                    'user_id'        => $user_id,
                ];
                  Log::info('jsadfhshfhasf'.json_encode($variantData));
                $variant = $userDetails->variants()->create($variantData);
                $variant_id = $variant->id;
    
            } else {
                $variantImageArray = array();
                $variantData = array();
                $variations = array();
                $option1name = "";
                $option2name = "";
                $option3name = "";
                $option4name = "";
                $option5name = "";
                $vSpecificName = "";
                $weight = 0;
                $weight_unit = 'lb';
                $i = 0;
                $vCount = 0;
                if(isset($item->ShippingPackageDetails)){
                    $shippingPackageDetails = $item->ShippingPackageDetails;
                    if(isset($shippingPackageDetails->WeightMajor) && isset($shippingPackageDetails->WeightMinor)){
                        $weightMajor = $shippingPackageDetails->WeightMajor->value;
                        $weightMinor = $shippingPackageDetails->WeightMinor->value;
                        $weightMajorUnit = $shippingPackageDetails->WeightMajor->unit;
                        $weightMinorUnit = $shippingPackageDetails->WeightMinor->unit;					
                    /*	if($user_id == 1514){
                            $weightMajor = $weightMajor * 2.20462;
                            $weightMinor = $weightMinor * 0.035274;
                        } else {*/
                            if($weightMajorUnit == "kg" && $weightMinorUnit == "gm"){
                                $weight_unit = 'kg';
                                $weight = $weightMajor + $weightMinor*0.001;
                            } else { 
                                $weight = $weightMajor + $weightMinor * 0.0625;
                            }
                        //}						
                    }
    
                }
                $imgMapping = array();
                $commonImgArr = array();
                if(isset($item->Variations->VariationSpecificsSet)){
                    $variationSpecificsSet = $item->Variations->VariationSpecificsSet;
                    $variationSpecificsSetNameValueList = $variationSpecificsSet->NameValueList;
                    if(isset($variationSpecificsSetNameValueList[0])){
                        $option1name = $variationSpecificsSetNameValueList[0]->Name;
                    }
                    if(isset($variationSpecificsSetNameValueList[1])){
                        $option2name = $variationSpecificsSetNameValueList[1]->Name;
                    }
                    if(isset($variationSpecificsSetNameValueList[2])){
                        $option3name = $variationSpecificsSetNameValueList[2]->Name;
                    }
                    if(isset($variationSpecificsSetNameValueList[3])){
                        $option4name = $variationSpecificsSetNameValueList[3]->Name;
                    }
                    if(isset($variationSpecificsSetNameValueList[4])){
                        $option5name = $variationSpecificsSetNameValueList[4]->Name;
                    }
                }
                if(isset($item->Variations->Pictures)){
                    $pictures = $item->Variations->Pictures[0];
                    $vSpecificName = $pictures->VariationSpecificName;
                    $variationSpecificPictureSet = $pictures->VariationSpecificPictureSet;
                    foreach($variationSpecificPictureSet as $variationSpecificPicture){
                        $temp = array();
                        foreach($variationSpecificPicture->PictureURL as $pictureURL){
                            $temp[] = $pictureURL;
                        }
                        $imgMapping[$variationSpecificPicture->VariationSpecificValue] = $temp;
                    }
                }
    
                $pictureDetails = $item->PictureDetails;
                $temp = array();				
                $main_image = '';
                $main_image_check = true;
                foreach($pictureDetails->PictureURL as $pictureURL){
                    if ($main_image_check) {
                         $main_image = $pictureURL;
                         $main_image_check = false;
                    }
                    $temp[] = $pictureURL;
                }
                $commonImgArr = $temp;
                $origMultiplier = 1;
                if(isset($item->SellingStatus)){
                    $orig_price = 0;
                    $base_price = 0;
                    if($item->SellingStatus->PromotionalSaleDetails){
                        $promotionalSaleDetails = $item->SellingStatus->PromotionalSaleDetails;
                        if(isset($promotionalSaleDetails->OriginalPrice)){
                            $orig_price = $promotionalSaleDetails->OriginalPrice->value;
                        }
                    }
                    if($item->SellingStatus->CurrentPrice){						
                        $base_price = $item->SellingStatus->CurrentPrice->value;						
                    }
                    if($orig_price > 0 && $base_price > 0){
                        $origMultiplier = 1-($orig_price-$base_price)/$orig_price;
                    }
                }
    
                $productData = [
                    'title'=>  $title,
                    'item_specific'=> $item_specific,
                    'option1name'=> $option1name,
                    'option2name'=> $option2name,
                    'option3name'=> $option3name,
                    'condition_val'=>$condition_val,
                    'condition_note'=>$condition_note,
                    'status'=>'linked',
                    'shopifyproductid'=>$shProduct->shopify_product_id,
                    'brand'=>$brand,
                    'product_type'=>$product_type,
                    'storecategoryid'=>$storecategoryid,
                    'storecategoryid2'=>$storecategoryid2,
                    'ebayitemid'=>$ebayitemid,
                    'searchstring'=>$dimenStr,
                    'user_id' => $user_id
                ];
                Log::info('multi varients  2 '.json_encode($productData));
                
                Log::info(json_encode($productData));
                $product = $userDetails->products()->create($productData);
                $product_id = $product->product_id;
                $shopifyProductData = json_decode($shProduct->shopify_product_data,true);
                foreach($item->Variations->Variation as $variation) {
                    $sku = "";
                    $price = 0;
                    $orig_price = 0;
                    $quantity = 0;
                    $option1val = "";
                    $option2val = "";
                    $option3val = "";
                    $option4val = "";
                    $option5val = "";
                    $productid = "";
                    $productidtype = "";
                    $imgArr = array();
                    if(isset($variation->SKU)){
                        $sku = $variation->SKU;
                    }
    
                    if(isset($variation->StartPrice)){
                        $price = $variation->StartPrice->value;
                    }
                    if($origMultiplier != 1 && $origMultiplier > 0){
                        $orig_price = number_format($price/$origMultiplier, 2, '.', '');
                    }
                    if(isset($variation->Quantity)){
                        $quantity = $variation->Quantity;
                    }
                    if(isset($variation->SellingStatus)){
                        $sellingStatus = $variation->SellingStatus;
                        if(isset($sellingStatus->QuantitySold)){
                            $quantity = $quantity - $sellingStatus->QuantitySold;
                        }
                    }
                    if(isset($variation->VariationProductListingDetails)){
                        $variationProductListingDetails = $variation->VariationProductListingDetails;
                        if(isset($variationProductListingDetails->UPC)){
                            $productid = $variationProductListingDetails->UPC;
                            $productidtype = "3";
                        } else if(isset($variationProductListingDetails->EAN)){
                            $productid = $variationProductListingDetails->EAN;
                            $productidtype = "4";
                        } else if(isset($variationProductListingDetails->ISBN)){
                            $productid = $variationProductListingDetails->ISBN;
                            $productidtype = "2";
                        }
                    }
                    
                    if(isset($variation->VariationSpecifics)){
                        $options = $variation->VariationSpecifics[0]->NameValueList;
                        foreach($options as $option){
                            if($option->Name == $option1name){
                                $option1val = $option->Value[0];
                            } else if($option->Name == $option2name){
                                $option2val = $option->Value[0];
                            } else if($option->Name == $option3name){
                                $option3val = $option->Value[0];
                            } else if($option->Name == $option4name){
                                $option4val = $option->Value[0];
                            } else if($option->Name == $option5name){
                                $option5val = $option->Value[0];
                            }
                        }
                    }
                    
                   
                    if(strlen($vSpecificName) > 0 && $option1name == $vSpecificName){
                        $imgArr = isset($imgMapping[$option1val]) ? $imgMapping[$option1val] : "" ;

                    }
                    if(strlen($vSpecificName) > 0 && $option2name == $vSpecificName){
                        $imgArr = isset($imgMapping[$option2val]) ? $imgMapping[$option2val] : "" ;
                    }
                    if(strlen($vSpecificName) > 0 && $option3name == $vSpecificName){
                        $imgArr = isset($imgMapping[$option3val]) ? $imgMapping[$option3val] : "" ;
                    }
                    if(strlen($vSpecificName) > 0 && $option4name == $vSpecificName){
                        // $imgArr = $imgMapping[$option4val];
                        $imgArr = isset($imgMapping[$option4val]) ? $imgMapping[$option4val] : "" ;
                    }
                    if(strlen($vSpecificName) > 0 && $option5name == $vSpecificName){
                        $imgArr = isset($imgMapping[$option5val]) ? $imgMapping[$option5val] : "" ;
                        // $imgArr = $imgMapping[$option5val];
                    }
                    
                    if( is_array($imgArr) && count( $imgArr) == 0){
                        $imgArr = $commonImgArr;
                        $imgArr = array_unique($imgArr);					
                    }
                    $variantImageArray[$i++] = $imgArr;

                    $shopifyVariantId = '';
                    $shopifyInventoryId = '';


                    foreach($shopifyProductData['variants'] as $shVariant){
                        if($option1val != ""){
                            if($shVariant['option1'] == $option1val){
                                if($option2val != ""){
                                    if($shVariant['option2'] == $option2val){
                                        if($option3val != ""){
                                            if($shVariant['option3'] == $option3val){
                                                $shopifyVariantId = $shVariant['id'];
                                                $shopifyInventoryId = $shVariant['inventory_item_id'];
                                            }
                                        }else{
                                            $shopifyVariantId = $shVariant['id'];
                                            $shopifyInventoryId = $shVariant['inventory_item_id'];
                                        }
                                    }
                                }else{
                                    $shopifyVariantId = $shVariant['id'];
                                    $shopifyInventoryId = $shVariant['inventory_item_id'];
                                }
                            }

                        }

                    }
    
                    $variantData[] = [
                        'product_id'=> $product_id,
                        'sku'=> $sku,
                        'option1val'=> $option1val,
                        'option2val'=>$option2val,
                        'option3val'=>$option3val,
                        'status'=>'linked',
                        'shopifyproductid'=>$shProduct->shopify_product_id,
                        'ebayitemid'=>$ebayitemid,
                        'price'=> $price,
                        'shopifyvariantid' =>   $shopifyVariantId,
                        'shopifyinventoryid' =>   $shopifyInventoryId,
                        'orig_price'=>$orig_price,
                        'quantity'=> $quantity,
                        'productid'=> $productid,
                        'imageurl' => json_encode($imgArr),
                        'productidtype'=> $productidtype,
                        'weight'=> $weight,
                        'weight_unit'=> $weight_unit,
                        'user_id' =>$user_id
                    ];
                    $vCount++;                 
                }
                Log::info($variantData);
                $variants = $userDetails->variants()->createMany($variantData);
                
            }	
            return $product_id;	
        }
        } catch(Exception $e){
            echo 'ebay product fetch error';
            print_r($e->getMessage());
        }
    }
    
    public function getProductListingDetailsNew($profile,$sku,$barcode, $vendor,$siteId) {
        // 	getProductListingDetails shopify Variant  set product_id_type
     // in function set $productListingDetails in set getProductListingDetails product_id_type exp. UPC,ISBN,EAN and MPN
      Log::info("getProductListingDetails function  start ");
      Log::info("setValueVariationProductListingDetails productid type " . json_encode($profile->product_id_type,true));
      $type = json_decode($profile->product_id_type, true);
      // foreach ( $type as $key => $value) {
      
      Log::info($type);
        $productTypeValue = '';

        if (isset($type['value'])) {
            if ($type['value'] == 'sku' && isset($sku)) {
                $productTypeValue = $sku;
            } elseif ($type['value'] == 'barcode' && isset($barcode)) {
                $productTypeValue = $barcode;
            }
        }

        $key = isset($type['name']) ? $type['name'] : '';

                $productListingDetails = new Types\ProductListingDetailsType(); // Initialize the ProductListingDetails object
           
                // Check product_id_type and set corresponding value
               if($key === 'ISBN'){
                // International Standard Book Number
                      
                           if ($productTypeValue && strlen($productTypeValue) === 10) {
                               Log::info("getProductListingDetails Valid 10-character ISBN. pass " . $productTypeValue);
                              $productListingDetails->ISBN = $productTypeValue;
                         } elseif ($productTypeValue && strlen($productTypeValue) === 13 && (substr($productTypeValue, 0, 3) === '978' || substr($productTypeValue, 0, 3) === '979')) {
                             //  "Valid 13-character ISBN.";
                             Log::info("getProductListingDetails Valid 13-character ISBN. pass " . $productTypeValue);
                             $productListingDetails->ISBN = $productTypeValue;
                         } else {
                              Log::info("getProductListingDetails Invalid ISBN. Ensure it is a 10 or 13-character number, and 13-character ISBNs must start with '978' or '979'. the ISBN pass ");
                             // "Invalid ISBN. Ensure it is a 10 or 13-character number, and 13-character ISBNs must start with '978' or '979'.";
                              $productListingDetails->ISBN = $this->getProductTypeDeFaultValue($siteId);
                         }
                  } 
                
                 if($key === 'UPC'){
                     if ($productTypeValue &&  strlen($productTypeValue) === 12) {
                         //      "Valid: This is a 12-digit UPC.";
                            Log::info("getProductListingDetails Valid: This is a 12-digit UPC pass " . $productTypeValue);
                             $productListingDetails->UPC = $productTypeValue;
                       } else {
                         //    "Invalid UPC. Ensure it is a 12-digit number.";
                             Log::info("getProductListingDetails Invalid UPC. Ensure it is a 12-digit number.  the UPC pass ");
                             $productListingDetails->UPC = $this->getProductTypeDeFaultValue($siteId);
                       }
                    
                 }
                
                if($key === 'EAN'){
                if ($productTypeValue &&  (strlen($productTypeValue) === 8 || strlen($productTypeValue) === 13)) {
                         //    "Valid: This is an 8-digit EAN.";
                           Log::info("getProductListingDetails product_id_type is the EAN pass " . $productTypeValue);
                         $productListingDetails->EAN = $productTypeValue;
                      } else {
                         //    "Invalid EAN. Ensure it is either an 8-digit or 13-digit number.";
                          Log::info("getProductListingDetails product_id_type is the EAN pass " );
                          $productListingDetails->EAN = $this->getProductTypeDeFaultValue($siteId);
                      }
              }
                
             if($key === 'MPN'){
                 if ($vendor) {
                    $brandMPN = new Types\BrandMPNType();
                    $brandMPN->Brand = $vendor;
                    $brandMPN->MPN = $productTypeValue;
                    $productListingDetails->BrandMPN = $brandMPN;
                    Log::info("getProductListingDetails product_id_type is MPN: " . $productTypeValue);
                }
             }else{
                if($vendor && $sku){
                $brandMPN = new Types\BrandMPNType();
                $brandMPN->Brand = $vendor;
                $brandMPN->MPN = $sku;
                $productListingDetails->BrandMPN = $brandMPN;
                }
             }

              Log::info("getProductListingDetails function  end ");
              Log::info($productListingDetails);
                return $productListingDetails; // Return the assembled ProductListingDetails
     }
    function setValueVariationProductListingDetailsNew($shVariantJsonData,$shVariant,$ebay_environment,$vendor,$profile,$siteId,$option1shVariant,$option2shVariant,$option3shVariant,$option1Name,$option2Name,$option3Name){
        Log::info("setValueVariationProductListingDetails start");
        $itemVariation = new Types\VariationType();
        Log::info("setValueVariationProductListingDetails productid type " . json_encode($profile->product_id_type,true));
        $type = json_decode($profile->product_id_type, true);
        // foreach ( $type as $key => $value) {
        $key = array_keys($type)[0];    
        $value = array_values($type)[0]; 
        $productTypeValue = '';
        if($value == 'sku'){
            $productTypeValue = $shVariant['sku'];
        }
        if($value == 'barcode'){
            $productTypeValue = $shVariant['Barcode'];
        }
      
        // $productTypeValue = 
        if($ebay_environment != "sandbox"  && $profile->product_id_type ){
            $itemVariation->VariationProductListingDetails = new Types\VariationProductListingDetailsType();

                 if($key == 'ISBN'){
                          // International Standard Book Number
                           if (strlen($productTypeValue) === 10) {
                               Log::info("setValueVariationProductListingDetails Valid 10-character ISBN. pass " . $productTypeValue);
                              $itemVariation->VariationProductListingDetails->ISBN = $productTypeValue;
                         } elseif (strlen($productTypeValue) === 13 && (substr($productTypeValue, 0, 3) === '978' || substr($productTypeValue, 0, 3) === '979')) {
                             //  "Valid 13-character ISBN.";
                             Log::info("setValueVariationProductListingDetails Valid 13-character ISBN. pass " . $productTypeValue);
                             $itemVariation->VariationProductListingDetails->ISBN = $productTypeValue;
                         } else {
                              Log::info("setValueVariationProductListingDetails Invalid ISBN. Ensure it is a 10 or 13-character number, and 13-character ISBNs must start with '978' or '979'. the ISBN pass " );
                             // "Invalid ISBN. Ensure it is a 10 or 13-character number, and 13-character ISBNs must start with '978' or '979'.";
                              $itemVariation->VariationProductListingDetails->ISBN = $this->getProductTypeDeFaultValue($siteId);
                         }
                }

                if($key == 'UPC'){
                   if (strlen($productTypeValue) === 12) {
                       //    "Valid: This is a 12-digit UPC.";
                          Log::info("setValueVariationProductListingDetails Valid: This is a 12-digit UPC pass " . $productTypeValue);
                          $itemVariation->VariationProductListingDetails->UPC = $productTypeValue;
                     } else {
                       //    "Invalid UPC. Ensure it is a 12-digit number.";
                           Log::info("setValueVariationProductListingDetails Invalid UPC. Ensure it is a 12-digit number.  the UPC pass  " );
                          $itemVariation->VariationProductListingDetails->UPC = $this->getProductTypeDeFaultValue($siteId);
                     }
               }
               if($key == 'EAN'){
                    if (strlen($productTypeValue) === 8 || strlen($productTypeValue) === 13) {
                        //   "Valid: This is an 8-digit EAN.";
                          Log::info("setValueVariationProductListingDetails product_id_type is the EAN pass " . $productTypeValue);
                         $itemVariation->VariationProductListingDetails->EAN = $productTypeValue;
                     } else {
                        //   "Invalid EAN. Ensure it is either an 8-digit or 13-digit number.";
                         Log::info("setValueVariationProductListingDetails product_id_type is the EAN pass " );
                         $itemVariation->VariationProductListingDetails->EAN = $this->getProductTypeDeFaultValue($siteId);
                     }
              }
              if($key == 'MPN'){
                Log::info("product_id_type is the MPN ".$productTypeValue);
                 Log::info("product_id_type is the brand ".$vendor);
                //$vendor = "Unbranded";
               $brandMPN = new Types\BrandMPNType();
               $brandMPN->Brand = $vendor; 
               $brandMPN->MPN =  $productTypeValue;
                Log::info("brand mpnnnnnnnn ".$brandMPN);
               $itemVariation->VariationProductListingDetails->BrandMPN = $brandMPN;
           }
        }

        // }
        $variationSpecifics =  $this->getValueVariationSpecificsNew($option1shVariant,$option2shVariant,$option3shVariant,$option1Name,$option2Name,$option3Name);
        $itemVariation->VariationSpecifics[] = $variationSpecifics;

        return $itemVariation ;
       
    }

     function getProductTypeDefaultValue($siteId) {
        $defaultValues = [
            216 => 'Does not apply',
            211 => 'Does not apply',
            207 => 'Does not apply',
            205 => 'Does not apply',
            203 => 'Does not apply',
            0   => 'Does not apply',
            2   => 'Does not apply',
            3   => 'Does not apply',
            15  => 'Does not apply',
            100 => 'Does not apply',
            16  => 'Nicht zutreffend',
            77  => 'Nicht zutreffend',
            193 => 'Nicht zutreffend',
            23  => 'Non applicable',
            71  => 'Non applicable',
            186 => 'No aplicable',
            101 => 'Non applicabile',
            210 => 'Non applicabile',
            123 => 'Niet van toepassing',
            146 => 'Niet van toepassing',
            201 => '不适用',
            212 => 'Nie dotyczy',
        ];
    
        Log::info("getProductTypeDefaultValue function start ==> " .  $defaultValues[$siteId] ?? '' );
        return $defaultValues[$siteId] ?? ''; // Return the value or an empty string if not found
    }
    public function getValueVariationSpecificsNew($option1shVariant,$option2shVariant,$option3shVariant,$option1Name,$option2Name,$option3Name){
        // 	variationSpecifics setvalue option name and option value 
          Log::info("getValueVariationSpecifics start");
        $variationSpecifics = new Types\NameValueListArrayType();
                    
                    $optionNameValue = new Types\NameValueListType();
                    $optionNameValue->Name = $option1Name;
                    $optionNameValue->Value = [$option1shVariant];
                    $variationSpecifics->NameValueList[] = $optionNameValue;
                        Log::info("option1Name ".$option1Name . ' length '. strlen($option1Name) ." Variation ".$option1shVariant . ' length '. strlen($option1shVariant));
                    if($option2shVariant && $option2Name){
                        $optionNameValue = new Types\NameValueListType();
                        $optionNameValue->Name = $option2Name;
                        $optionNameValue->Value = [$option2shVariant];
                        $variationSpecifics->NameValueList[] = $optionNameValue;
                        Log::info("option2Name ".$option2Name  . ' length '. strlen($option2Name) ."  Variation value ".$option2shVariant . ' length '. strlen($option2shVariant));
                        if($option3shVariant && $option3Name){
                            $optionNameValue = new Types\NameValueListType();
                            $optionNameValue->Name = $option3Name;
                            $optionNameValue->Value = [$option3shVariant];
                            $variationSpecifics->NameValueList[] = $optionNameValue;
                        Log::info("option3Name ".$option3Name . ' length '. strlen($option3Name) ." Variation ".$option3shVariant . ' length '. strlen($option3shVariant));
                        }
                    }
                      Log::info("getValueVariationSpecifics end");
            return $variationSpecifics;
}
    public function setShippingPolicyInItem($profile,$shVariantJsonData,$siteId,$shProduct,$ebayItem){
        Log::info("setShippingPolicyInItem function start  ");
        // Log::info("domesticShipping ".$profile->domestic_shipping);
        // Log::info("domestic_ship_service1 ".$profile->domestic_ship_service1);
        // Log::info("ship_fee1 ".$profile->ship_fee1);
        // Log::info("domestic_local_pickup ".$profile->domestic_local_pickup);
        // Log::info("domestic_ship_additional_services ".$profile->domestic_ship_additional_services);
        // Log::info("domestic_free_shipping ".$profile->domestic_free_shipping);
        $ebayItem->ShippingDetails = new Types\ShippingDetailsType();

        $domestic_shipping = $profile->domestic_shipping;
        $intl_shipping = $profile->intl_shipping;
        if($domestic_shipping && $domestic_shipping != "NotSpecified" && $domestic_shipping != "NOT_SPECIFIED"){
                  Log::info("first if conduction ". $domestic_shipping && $domestic_shipping != "NotSpecified" && $domestic_shipping != "NOT_SPECIFIED");

            if($domestic_shipping == "Flat" && $intl_shipping == "Calculated"){
                $ebayItem->ShippingDetails->ShippingType = Enums\ShippingTypeCodeType::C_FLAT_DOMESTIC_CALCULATED_INTERNATIONAL;
            }
            else if($domestic_shipping == "Calculated" && $intl_shipping == "Flat"){
                $ebayItem->ShippingDetails->ShippingType = Enums\ShippingTypeCodeType::C_CALCULATED_DOMESTIC_FLAT_INTERNATIONAL;
            }
            else if($domestic_shipping == "Flat" || $intl_shipping == "Flat"){
                $ebayItem->ShippingDetails->ShippingType = Enums\ShippingTypeCodeType::C_FLAT;
            }
            else if($domestic_shipping == "Calculated" || $intl_shipping == "Calculated"){
                $ebayItem->ShippingDetails->ShippingType = Enums\ShippingTypeCodeType::C_CALCULATED;
            }
            else if($domestic_shipping == "Freight"){
                $ebayItem->ShippingDetails->ShippingType = Enums\ShippingTypeCodeType::C_FREIGHT;
            }
            else if($domestic_shipping == "FreightFlat"){
                $ebayItem->ShippingDetails->ShippingType = Enums\ShippingTypeCodeType::C_FREIGHT_FLAT;
            }


            if($domestic_shipping == "Calculated" || $intl_shipping == "Calculated"){
                $ebayItem->ShippingDetails->CalculatedShippingRate = new Types\CalculatedShippingRateType();

                if($domestic_shipping == "Calculated"){
                    $ebayItem->ShippingDetails->CalculatedShippingRate->PackagingHandlingCosts = new Types\AmountType(['value' => $profile->domestic_pkg_handling_fee]);
                }
                if($intl_shipping == "Calculated"){
                //	$ebayItem->ShippingDetails->CalculatedShippingRate->InternationalPackagingHandlingCosts = new Types\AmountType(['value' => $profile->intl_pkg_handling_fee]);
                }
                $ebayItem->ShippingDetails->CalculatedShippingRate->OriginatingPostalCode = (string) $profile->postal_code;
                
                // 10/10/2024 change by  start
                if (in_array($siteId, [15, 2, 77, 101, 3, 0, 100])) {
                    $packageDetails = new Types\ShipPackageDetailsType();
                    $packageDetails->ShippingPackage = 'PackageThickEnvelope';
                        if($siteId  == 0){
                           $packageDetails->MeasurementUnit = Enums\MeasurementSystemCodeType::C_ENGLISH;
                        }
                        else{
                            //$packageDetails->ShippingPackage = 'BulkyGoods';
                            $packageDetails->MeasurementUnit = Enums\MeasurementSystemCodeType::C_METRIC;
                        }
                    $packageDetails->ShippingIrregular = true;
                    $packageDetails =  $this->itemPackageDetailsNew($shVariantJsonData,$siteId,$shProduct);
                    $ebayItem->ShippingPackageDetails = $packageDetails;
               }		
            }
              // 10/10/2024 change by  end


            if($profile->domestic_ship_service1 && $profile->domestic_ship_service1 != "NotSelected" && $profile->domestic_shipping != "NotSpecified"){
                   Log::info("second if conduction  domestic_ship");
                $shippingService = new Types\ShippingServiceOptionsType();
                $shippingService->ShippingServicePriority = 1;
                $shippingService->ShippingService = $profile->domestic_ship_service1;
                if($domestic_shipping == "Flat"){
                    Log::info("domestic_shipping ". $domestic_shipping);
                     $shippingService->ShippingServiceCost = new Types\AmountType(['value' => (float) $profile->ship_fee1]);
                    // $shippingService->ShippingServiceCost = new Types\AmountType(['value' => 0.00]); // by  test
                    if($profile && isset($profile->x_ship_fee1) && $profile->x_ship_fee1 !== NULL && $profile->x_ship_fee1 !== ""){
                         Log::info("x_ship_fee1 ". $profile && isset($profile->x_ship_fee1) && $profile->x_ship_fee1 !== NULL && $profile->x_ship_fee1 !== "");
                        $shippingService->ShippingServiceAdditionalCost = new Types\AmountType(['value' => (float) $profile->x_ship_fee1]);
                    }
                }
                if($profile->domestic_free_shipping){
                    $shippingService->FreeShipping = true;
                     Log::info("domestic_free_shipping ". $profile->domestic_free_shipping );
                    
                }
                // Freeshipping no false
                if($profile->domestic_local_pickup){
                    $shippingService->LocalPickup = true;
                     Log::info("domestic_local_pickup ". $profile->domestic_local_pickup );
                }
                else{
                    $shippingService->LocalPickup = false;
                }
                $ebayItem->ShippingDetails->ShippingServiceOptions[] = $shippingService;
            }
            $domestic_ship_additional_services = ($profile->domestic_ship_additional_services) ? json_decode($profile->domestic_ship_additional_services) : array();
            if($domestic_ship_additional_services){
                $pr = 2;
                foreach($domestic_ship_additional_services as $dsservice){
                    if(isset($dsservice->domestic_ship_service1) && $dsservice->domestic_ship_service1 && $dsservice->domestic_ship_service1 != "NOT_SPECIFIED" && $dsservice->domestic_ship_service1 != "NotSpecified" && $dsservice->domestic_ship_service1 != "NotSelected"){

                        $shippingService = new Types\ShippingServiceOptionsType();
                        $shippingService->ShippingServicePriority = $pr;
                        $shippingService->ShippingService = $dsservice->domestic_ship_service1;
                        if($domestic_shipping == "Flat"){
                            $shippingService->ShippingServiceCost = new Types\AmountType(['value' => (float) $dsservice->ship_fee1]);
                            if($dsservice && isset($dsservice->x_ship_fee1) && $dsservice->x_ship_fee1 !== NULL && $dsservice->x_ship_fee1 !== ""){
                                $shippingService->ShippingServiceAdditionalCost = new Types\AmountType(['value' => (float) $dsservice->x_ship_fee1]);
                            }
                        }
                        if(isset($dsservice->domestic_free_shipping) && $dsservice->domestic_free_shipping) $shippingService->FreeShipping = true;
                        if(isset($dsservice->domestic_local_pickup) && $dsservice->domestic_local_pickup){
                            $shippingService->LocalPickup = true;
                        }
                        else{
                            $shippingService->LocalPickup = false;
                        }
                        $ebayItem->ShippingDetails->ShippingServiceOptions[] = $shippingService;
                        $pr++;
                    }
                }
            }


            if($profile->intl_ship_service1 && $profile->intl_ship_service1 != "NOT_SPECIFIED" && $profile->intl_ship_service1 != "NotSpecified" && $profile->intl_ship_service1 != "NotSelected" && $profile->intl_shipping != "NotSpecified"){
                $shippingService = new Types\InternationalShippingServiceOptionsType();
                $shippingService->ShippingServicePriority = 1;
                $shippingService->ShippingService = $profile->intl_ship_service1;
                if($intl_shipping == "Flat"){
                    $shippingService->ShippingServiceCost = new Types\AmountType(['value' => (float) $profile->intl_ship_fee1]);
                    $shippingService->ShippingServiceAdditionalCost = new Types\AmountType(['value' => (float) $profile->intl_x_ship_fee1]);
                }
                $intl_ship_options1 = $profile->intl_ship_options1;
                if($intl_ship_options1 == 2){
                    $intl_locations1 = ($profile->intl_locations1) ? explode(",",$profile->intl_locations1) : array('WorldWide');
                    $shippingService->ShipToLocation = ($intl_locations1) ? $intl_locations1 : array('WorldWide');
                }
                else if($intl_ship_options1 == 3){
                    $shippingService->ShipToLocation = ['CA'];
                }
                else{
                    $shippingService->ShipToLocation = ['WorldWide'];
                }
                //$shippingService->LocalPickup = false;
                $ebayItem->ShippingDetails->InternationalShippingServiceOption[] = $shippingService;
            }

            $intl_ship_additional_services = ($profile->intl_ship_additional_services) ? json_decode($profile->intl_ship_additional_services) : array();
            if($intl_ship_additional_services){
                $pr = 2;
                foreach($intl_ship_additional_services as $isservice){
                    if(isset($isservice->intl_ship_service1) && $isservice->intl_ship_service1 && $isservice->intl_ship_service1 != "NOT_SPECIFIED" && $isservice->intl_ship_service1 != "NotSpecified" && $isservice->intl_ship_service1 != "NotSelected"){

                        $shippingService = new Types\InternationalShippingServiceOptionsType();
                        $shippingService->ShippingServicePriority = $pr;
                        $shippingService->ShippingService = $isservice->intl_ship_service1;
                        if($intl_shipping == "Flat"){
                            $shippingService->ShippingServiceCost = new Types\AmountType(['value' => (float) $isservice->intl_ship_fee1]);
                            $shippingService->ShippingServiceAdditionalCost = new Types\AmountType(['value' => (float) $isservice->intl_x_ship_fee1]);
                        }
                        $intl_ship_options1 = $isservice->intl_ship_options1;
                        if($intl_ship_options1 == 2){
                            if(!is_array($isservice->intl_locations1)) $intl_locations1 = ($isservice->intl_locations1) ? explode(",",$isservice->intl_locations1) : array('WorldWide');
                            else $intl_locations1 = $isservice->intl_locations1;
                            $shippingService->ShipToLocation = ($intl_locations1) ? $intl_locations1 : array('WorldWide');
                        }
                        else if($intl_ship_options1 == 3){
                            $shippingService->ShipToLocation = ['CA'];
                        }
                        else{
                            $shippingService->ShipToLocation = ['WorldWide'];
                        }
                        //$shippingService->LocalPickup = false;
                        $ebayItem->ShippingDetails->InternationalShippingServiceOption[] = $shippingService;
                        $pr++;
                    }
                }
            }
        }
        else{
              Log::info("first if conduction else");
            $ebayItem->ShippingDetails->ShippingType = Enums\ShippingTypeCodeType::C_NOT_SPECIFIED;
            //$ebayItem->ShipToLocations[] = 'None';
        }

        if($profile->sales_tax_rate > 0 && $profile->sales_tax_region && $profile->sales_tax_region != "ALL"){
            $salesTaxType = new Types\SalesTaxType();
            $salesTaxType->SalesTaxPercent = (double) $profile->sales_tax_rate;
            $salesTaxType->SalesTaxState = $profile->sales_tax_region;
            if($profile->apply_tax_to_shipping){
                $salesTaxType->ShippingIncludedInTax = true;
            }
            $ebayItem->ShippingDetails->SalesTax = $salesTaxType;
        }

        Log::info("setShippingPolicyInItem function end  ");
       return $ebayItem;
    }
    public function itemPackageDetailsNew($shVariantJsonData,$siteId,$product){
         
        Log::info($shVariantJsonData);
	    // This method will get the package details from db (weight, height, width) and return ebayPackageDetail
	    	Log::info("itemPackageDetails function in side ");
            $packageDetails = new Types\ShipPackageDetailsType();
	    $dimesionsproduct = json_decode($product->dimensions,true);
				 			$packageDetails->WeightMajor = new Types\MeasureType();
                            $packageDetails->WeightMinor = new Types\MeasureType();

            $weightvariants = $shVariantJsonData['weight'];
            $weightUnit = $shVariantJsonData['weight_unit'];
            $afterDecimal = 0 ;
            $beforeDecimal = 0 ;
            $PackageLength = 0;
            $PackageWidth = 0;
            $PackageDepth = 0;
            $dimensionstype = '';
           if($siteId == 0){
               Log::info("itemPackageDetails function in side ebaysite id ".$siteId);
                  $ounces = 0;
                  $dimensionstype = 'in';
                  if ($weightUnit == 'lbs' || $weightUnit == 'lb' || $weightUnit == 'pounds' || $weightUnit == 'POUNDS') {
                      // Convert pounds to ounces
                      $ounces = $weightvariants * 16;
                  } elseif ($weightUnit == 'oz' || $weightUnit == 'ounces' || $weightUnit == 'OUNCES' || $weightUnit == 'OZ') {
                      // Already in ounces
                      $ounces = $weightvariants;
                  } elseif ($weightUnit == 'gr' || $weightUnit == 'grams' || $weightUnit == 'g' || $weightUnit == 'GRAMS') {
                      // Convert grams to ounces (1 gram = 0.03527396 ounces)
                      $ounces = $weightvariants * 0.03527396;
                  } elseif ($weightUnit == 'kg' || $weightUnit == 'kilograms' || $weightUnit == 'KG' || $weightUnit == 'KILOGRAMS') {
                      // Convert kilograms to ounces (1 kilogram = 35.27396 ounces)
                      $ounces = $weightvariants * 35.27396;
                  } else {
                     $ounces = 16 ;
                  }
                  
                  // Split ounces into pounds and remaining ounces
                  
                  if($weightvariants != 0){
                  $beforeDecimal = floor($ounces / 16); // Full pounds
                  $afterDecimal = $ounces % 16;         // Remaining ounces
                  }else{
                  $afterDecimal = 1 ;
                  $beforeDecimal = 0 ;
                  }
                  
                  Log::info("itemPackageDetails function in side ebaysite == 0 WeightMinor_unit oz and WeightMajor_unit lbs ".(int) $afterDecimal .' '. (int) $beforeDecimal);
                  // Assign to package details
                  $packageDetails->WeightMinor->unit = "oz";
                  $packageDetails->WeightMinor->value = (int)$afterDecimal;
                  $packageDetails->WeightMajor->unit = 'lbs';
                  $packageDetails->WeightMajor->value = (int)$beforeDecimal;

            if($dimesionsproduct != NULL){
                foreach ($dimesionsproduct as $item) {
                     if($item['name'] == 'Length'){
                    $PackageLength =  $this->convertToInches((int) $item['value'], $item['unit']) ;
                     }
                   if($item['name'] == 'Width'){
                    $PackageWidth =  $this->convertToInches((int) $item['value'], $item['unit']) ;
                    }
                  if($item['name'] == 'Height'){
                    $PackageDepth =  $this->convertToInches((int) $item['value'], $item['unit']) ;
                 }
              }
            }else{
               	// if($product->error_no ==  100000000000 ) {
               	     Log::info("Entered in the  parcel detail of  ");  
               	$PackageLength =  $this->convertToInches(23, $dimensionstype) ;
                $PackageWidth =  $this->convertToInches(18, $dimensionstype) ;
                $PackageDepth =  $this->convertToInches(8, $dimensionstype) ;
               
               	// }else{
               	//    Log::info("Entered in the else condition of parcel detail");  
               	// $PackageLength =  $this->convertToInches(75, $dimensionstype) ;
                // $PackageWidth =  $this->convertToInches(50, $dimensionstype) ;
                // $PackageDepth =  $this->convertToInches(50, $dimensionstype) ;
               	// }
               	
             }
              Log::info("itemPackageDetails function in side ebaysite == 0 unit=inches PackageLength, PackageWidth and PackageDepth ".(int) $PackageLength .' '. (int) $PackageWidth .' '.(int) $PackageDepth);
                     
                  
           }else{
               Log::info("itemPackageDetails function in side ebaysite != 0  ebaysite = ".$siteId);
                $totalGrams = 0 ;
                $dimensionstype = 'cm' ;
                if ($weightUnit == 'lbs' || $weightUnit == 'lb' || $weightUnit == 'pounds' || $weightUnit == 'POUNDS') {
                               // Convert pounds to grams
                               $totalGrams = $weightvariants * 453.59237;
                           } elseif ($weightUnit == 'oz' || $weightUnit == 'ounces' || $weightUnit == 'OUNCES') {
                               // Convert ounces to grams
                               $totalGrams = $weightvariants * 28.34952;
                           } elseif ($weightUnit == 'gr' || $weightUnit == 'grams' || $weightUnit == 'g' || $weightUnit == 'GRAMS') {
                               // Already in grams
                               $totalGrams = $weightvariants;
                           } elseif ($weightUnit == 'kg' || $weightUnit == 'kilograms' || $weightUnit == 'KILOGRAMS') {
                               // Convert kilograms to grams
                               $totalGrams = $weightvariants * 1000;
                           } else {
                                $totalGrams = 1;
                           }
                       
                           // Split grams into kilograms and remaining grams
                           if($weightvariants != 0){
                                 $beforeDecimal = floor($totalGrams / 1000); // Full kilograms
                                 $afterDecimal = $totalGrams % 1000;         // Remaining grams
                            }else{
                                $afterDecimal = 1 ;
                                $beforeDecimal = 0 ;
                            }
                          
       Log::info("itemPackageDetails function in side ebaysite != 0 WeightMinor_unit g and WeightMajor_unit kg".(int) $afterDecimal .' '. (int) $beforeDecimal);                  
                           // Assign to package details
                           $packageDetails->WeightMinor->unit = "g"; // Grams
                           $packageDetails->WeightMinor->value = (int)$afterDecimal;
                           $packageDetails->WeightMajor->unit = "kg"; // Kilograms
                           $packageDetails->WeightMajor->value = (int)$beforeDecimal;
                           
                           	if($dimesionsproduct != NULL){
                foreach ($dimesionsproduct as $item) {
                     if($item['name'] == 'Length'){
                        
                    $PackageLength =  $this->convertToCentimeters((int) $item['value'], $item['unit']) ;
                     }
                   if($item['name'] == 'Width'){
                        $PackageWidth =  $this->convertToCentimeters((int) $item['value'], $item['unit']) ;
                     
                    }
                  if($item['name'] == 'Height'){
                       $PackageDepth =  $this->convertToCentimeters((int) $item['value'], $item['unit']) ;
                 }
              }
             }else{
               	// if($product->error_no ==  100000000000 ) {
               	     Log::info("Entered in the  parcel detail of user_id 437 ");  
                $PackageLength =  $this->convertToCentimeters(23, $dimensionstype) ;
                $PackageWidth =  $this->convertToCentimeters(18, $dimensionstype) ;
                $PackageDepth =  $this->convertToCentimeters(8, $dimensionstype) ;
               	// }else{
               	//    Log::info("Entered in the else condition of parcel detail");  
               	// $PackageLength =  $this->convertToCentimeters(75, $dimensionstype) ;
                // $PackageWidth =  $this->convertToCentimeters(50, $dimensionstype) ;
                // $PackageDepth =  $this->convertToCentimeters(50, $dimensionstype) ;
             
               	// }
             }
                       Log::info("itemPackageDetails function in side ebaysite == 0 unit=inches PackageLength, PackageWidth and PackageDepth ".(int) $PackageLength .' '. (int) $PackageWidth .' '.(int) $PackageDepth);           
             }
             
                       Log::info("trial shipping package test start from here");
                      $packageDetails->PackageLength = new Types\MeasureType();
                      $packageDetails->PackageWidth = new Types\MeasureType();
                      $packageDetails->PackageDepth = new Types\MeasureType();
                      $packageDetails->PackageLength->unit = $dimensionstype; 
                      $packageDetails->PackageLength->value = (int) $PackageLength;
                      $packageDetails->PackageWidth->unit = $dimensionstype;
                      $packageDetails->PackageWidth->value = (int) $PackageWidth;
                      $packageDetails->PackageDepth->unit = $dimensionstype;
                      $packageDetails->PackageDepth->value = (int) $PackageDepth;
        	Log::info("itemPackageDetails function end ");              
        return  $packageDetails ;
	}
    

  public function convertToCentimeters($value, $unit) {
     }
    function processProductImages($shProductJsonData, $skipImages = null) {
        Log::info("processProductImages function inside ");
        Log::info($shProductJsonData['images']);
        $imagesUrl = [];

    
        if (isset($shProductJsonData['images']) && is_array($shProductJsonData['images']) && !empty($shProductJsonData['images'])) {
            // Find product images
            $counter = 0;
            foreach ($shProductJsonData['images'] as $image) {
                if (isset($image['src'])) {
                    if (is_array($skipImages) && in_array($image['src'], $skipImages)) {
                        continue;
                    }
                    $imagesUrl[] = $image['src'];
                    $counter++;
                    if ($counter >= 12) {
                        break;
                    }
                } else {
                    // Image node URL is missing.
                    Log::warning("Image node URL is missing.");
                }
            }
        } else {
            // Product has no images; use default image
            $defaultImg = "https://app1.ecomshore.com/service/public/image/default_image.png";
            $imagesUrl[] = $defaultImg;
        }
    
        
        $pictureDetails = new Types\PictureDetailsType();
        $pictureDetails->GalleryType = Enums\GalleryTypeCodeType::C_GALLERY;
        $pictureDetails->PictureURL = $imagesUrl;
        Log::info("processProductImages function end  ");
        return $pictureDetails;
    }


    function processEbayItemSpecifics($item_specifics,$option1Name,$option2Name,$option3Name,$shProductVariants,$vendor,$product){
        Log::info("processEbayItemSpecifics fucntion start ");
        $itemSpecificsSet = new Types\NameValueListArrayType();
        if($item_specifics){

               foreach ($item_specifics as $item_specific_key => $item_specific_value) {
                foreach ($item_specific_value as $attribute => $info) {
                      if(count($shProductVariants)  > 1){
                             $excludedNames = ['Size', 'material', 'style', 'quantity', 'type'];
                                 if (!in_array($option1Name, $excludedNames) && !in_array($option2Name, $excludedNames) && !in_array($option3Name, $excludedNames)) {
                                     if ($attribute == $option1Name || $attribute == $option2Name || $attribute == $option3Name) {
                                         continue;
                                     }
                                 }
                         }
                    foreach ($info as $key => $value) {
                        if($key === "recommendation"){
                            $itemSpecificsSet->NameValueList[] = $this->addItemSpecific($attribute, $value);
                        }
                        if($key === "custom"){
                            $itemSpecificsSet->NameValueList[] = $this->addItemSpecific($attribute, $value);
                        }
                        Log::info( $shProductVariants);
                        if($key === "shopify"){
                            $specificValue = '';
                            if ($value === 'vendor') {
                                $specificValue = $vendor;
                            } elseif ($value === 'handle') {
                                $specificValue = $product->shopify_product_handle;
                            } elseif ($value === 'product_type') {
                                $specificValue = $product->shopify_product_type;
                            } elseif ($value === 'sku') {
                                $specificValue = $shProductVariants[0]->sku ?? "";
                            } elseif ($value === 'barcode') {
                                $specificValue = $shProductVariants[0]->Barcode ?? "";
                            }  elseif ($value === 'title') {
                                $specificValue = $shProductVariants[0]->title ;
                            }

                            $itemSpecificsSet->NameValueList[] = $this->addItemSpecific($attribute, $specificValue);
                        }
                     
                    }
                }
                  						
               }
            
        }else{
            if($vendor){
                  
                    $itemSpecificsSet->NameValueList[] =  $this->addItemSpecific('Brand', $vendor);
               }

        }
        Log::info("processEbayItemSpecifics function end ");
        return $itemSpecificsSet;

    }
       public  function getEbaySiteNameFromID($site_id = 0){
		$countryCodes = array(
			15 => "Australia",
			16 => "Austria",
			123 => "Belgium_Dutch",
			23 => "Belgium_French",
			2 => "Canada",
			210 => "CanadaFrench",
			71 => "France",
			77 => "Germany",
			201 => "HongKong",
			203 => "India",
			205 => "Ireland",
			101 => "Italy",
			207 => "Malaysia",
			146 => "Netherlands",
			211 => "Philippines",
			212 => "Poland",
			215 => "Russia",
			216 => "Singapore",
			186 => "Spain",
			193 => "Switzerland",
			3 => "UK",
			//3 => "GB",
			0 => "US"
		);
		return (isset($countryCodes[$site_id])) ? $countryCodes[$site_id] : "ZZ";
	}
    private function addItemSpecific( $name, $value) {
        $itemSpecificNameValue = new Types\NameValueListType();
        $itemSpecificNameValue->Name = $name;
        $itemSpecificNameValue->Value = is_array($value) ? $value : array($value);

       return $itemSpecificNameValue;
    }
    public function setValuesVariationSpecificsNew($option1Name,$option2Name,$option3Name,$option1Values,$option2Values,$option3Values){
        Log::info("setValuesVariationSpecifics function start ");

                     $variationSpecificsSet = new Types\NameValueListArrayType();
                          Log::info("code is running on the line 1760 in add updated method");
                     $optionNameValue = new Types\NameValueListType();
                     $optionNameValue->Name = $option1Name ;
                     $optionNameValue->Value = $option1Values;
                     $variationSpecificsSet->NameValueList[] = $optionNameValue;
                      Log::info("option1Name setValuesVariationSpecifics ".$option1Name. ' length '. strlen($option1Name));
                      Log::info("option1Values setValuesVariationSpecifics ".json_encode($option1Values,true));
                     if($option2Name && $option2Values){
                         $optionNameValue = new Types\NameValueListType();
                         $optionNameValue->Name = $option2Name;
                         $optionNameValue->Value = $option2Values;
                         $variationSpecificsSet->NameValueList[] = $optionNameValue;
                        Log::info("option2Name setValuesVariationSpecifics ".$option2Name. ' length '. strlen($option2Name));
                      Log::info("option1Values setValuesVariationSpecifics ".json_encode($option2Values,true));
                         if($option3Name && $option3Values){
                             $optionNameValue = new Types\NameValueListType();
                             $optionNameValue->Name = $option3Name ;
                             $optionNameValue->Value = $option3Values ; 
                             $variationSpecificsSet->NameValueList[] = $optionNameValue;
                             Log::info("option3Name setValuesVariationSpecifics ".$option3Name. ' length '. strlen($option3Name));
                      Log::info("option1Values setValuesVariationSpecifics ".json_encode($option3Values,true));
                         }
                     }
                     Log::info("setValuesVariationSpecifics function end ");
             
             
            return  $variationSpecificsSet ;
           
        
     }
  
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function setOptionsNames($option1name, $option2name, $option3name)
    {
        // Refactored setOptionsNames method to handle option name mappings dynamically and improve readability.
        Log::info("setOptionsNames function start ");
        Log::info("setOptionsNames fix  option1name before " . $option1name);
        Log::info("setOptionsNames fix  option2name before " . $option2name);
        Log::info("setOptionsNames fix  option3name before " . $option3name);
        $option1name = $option1name == "type" ? "types" : $option1name;
        if ($option1name == "material") {
            $option1name = "Materials";
        } elseif ($option1name == "type") {
            $option1name = "types";
        } elseif ($option1name == "style") {
            $option1name = "styles";
        } elseif ($option1name == "quantity") {
            $option1name = "inventory";
        } elseif ($option1name == "Size") {
            $option1name = "Sizes";
        } elseif ($option1name == "stone") {
            $option1name = "stones";
        } elseif ($option1name == "Title" || $option1name == "title") {
            $option1name = "titles";
        } else {
            $option1name = $option1name;
        }

        if ($option2name == "material") {
            $option2name = "materials";
        } elseif ($option2name == "type") {
            $option2name = "types";
        } elseif ($option2name == "style") {
            $option2name = "styles";
        } elseif ($option2name == "quantity") {
            $option2name = "inventory";
        } elseif ($option2name == "Size") {
            $option2name = "sizes";
        } elseif ($option2name == "stone") {
            $option2name = "stones";
        } elseif ($option2name == "Title" || $option2name == "title") {
            $option2name = "titles";
        } else {
            $option2name = $option2name;
        }

        if ($option3name == "material") {
            $option3name = "materials";
        } elseif ($option3name == "type") {
            $option3name = "types";
        } elseif ($option3name == "style") {
            $option3name = "styles";
        } elseif ($option3name == "quantity") {
            $option3name = "inventory";
        } elseif ($option3name == "Size") {
            $option3name = "sizes";
        } elseif ($option3name == "stone") {
            $option3name = "stones";
        } elseif ($option3name == "Title" || $option3name == "title") {
            $option3name = "titles";
        } else {
            $option3name = $option3name;
        }
        Log::info("setOptionsNames fix  option1name after " . $option1name);
        Log::info("setOptionsNames fix  option2name after " . $option2name);
        Log::info("setOptionsNames fix  option3name after " . $option3name);
        Log::info("setOptionsNames function end ");
        return [
            "option1name" => $option1name,
            "option2name" => $option2name,
            "option3name" => $option3name,
        ];
    }

    public function productDescriptionAndTitle($profile, $shProduct, $product)
    {
        Log::info("productDescriptionAndTitle function in side ");
        $description = "";
        $listing_title = "";
        // Title to working on working  start
        // shopify product title

        Log::info($shProduct);

        if($product->edit_title != null){
            $listing_title = $product->edit_title;
        }else{
            $listing_title = $shProduct["title"];
        }
        Log::info("title is :: ".$listing_title);
        $listing_title = $this->remove_emoji($listing_title);

        if ($profile->trim_title == 1) {
            //!$profile->listing_title &&
            $listing_title = substr($listing_title, 0, 80);
        }

        Log::info("add updated ebay item title $listing_title");
        $listing_title = str_replace("Fucking", "", $listing_title);
        $listing_title = str_replace("Swarovski", "", $listing_title);
        $listing_title = str_replace("Bumper", "", $listing_title);
        $listing_title = str_replace("Mystery Box", "", $listing_title);
        $listing_title = str_replace("Onesie", "", $listing_title);
        $listing_title = str_replace("Box Clasp", "", $listing_title);

        // this discription working start
        if ($profile->template && $profile->template->template_data) {
            $description = str_replace(
                "{{description}}",
                $shProduct["body_html"],
                $profile->template->template_data
            );
            // 	$ebayItem->Description = str_replace("{{description}}", $this->remove_emoji($shProduct["body_html"]),$profile->template->template_data); // by  add
        } elseif ($shProduct["body_html"] == "") {
            //	$ebayItem->Description ="new items";//??

            Log::info("Description " . $listing_title);
            Log::info("Description " . $shProduct["body_html"]);
            $description = $listing_title;
        } else {
            Log::info("Description  before " . $shProduct["body_html"]);
            $body_html = str_replace(
                "http://",
                "https://",
                $shProduct["body_html"]
            );

            while (
                ($remove_startiframes = strpos($body_html, "<script")) !== false
            ) {
                // Find the end of the <script> tag
                $remove_endiframes = strpos(
                    $body_html,
                    "</script>",
                    $remove_startiframes
                );

                // Ensure a closing </script> tag exists
                if ($remove_endiframes !== false) {
                    $remove_endiframes += strlen("</script>"); // Move the pointer to the end of the </script> tag

                    // Log the position of the script end
                    Log::info(
                        "Description end position: " . $remove_endiframes
                    );

                    // Remove the <script> tag and its contents
                    $body_html =
                        substr($body_html, 0, $remove_startiframes) .
                        substr($body_html, $remove_endiframes);

                    // Log the updated body_html after script removal
                    Log::info(
                        "Updated HTML after </script> removal: " . $body_html
                    );
                } else {
                    Log::info("Closing </script> tag not found.");
                    break; // Break the loop if no closing tag is found
                }
            }

            //   $remove_startiframe = strpos($body_html, '<iframe');
            while (
                ($remove_startiframe = strpos($body_html, "<iframe")) !== false
            ) {
                // Find the end of the <iframe> tag
                $remove_endiframe = strpos(
                    $body_html,
                    "</iframe>",
                    $remove_startiframe
                );

                // Ensure a closing </iframe> tag exists
                if ($remove_endiframe !== false) {
                    $remove_endiframe += strlen("</iframe>"); // Move the pointer to the end of the </iframe> tag

                    // Log the position of the iframe end
                    Log::info("Description end position: " . $remove_endiframe);

                    // Remove the <iframe> tag and its contents
                    $body_html =
                        substr($body_html, 0, $remove_startiframe) .
                        substr($body_html, $remove_endiframe);

                    // Log the updated body_html after iframe removal
                    Log::info(
                        "Updated HTML after </iframe> removal: " . $body_html
                    );
                } else {
                    Log::info("Closing </iframe> tag not found.");
                    break; // Break the loop if no closing tag is found
                }
            }

            if ($body_html == "<!---->") {
                Log::info("Description  <!----> " . $listing_title);
                $body_html = $listing_title;
            }
            Log::info("Description " . $body_html);

            $body_html = str_replace("Fuck", "", $body_html);
            $body_html = str_replace("fuck off", "", $body_html);
            $body_html = str_replace("Western Union", "", $body_html);
            $body_html = str_replace("Bumper", "", $body_html);
            $body_html = str_replace("Mystery Box", "", $body_html);
            $body_html = str_replace('slate-data-type="image"', "", $body_html);

            $start = strpos($body_html, "𝐂𝐡𝐞𝐜𝐤 𝐨𝐮𝐭 𝐭𝐡𝐞 𝐫𝐞𝐬𝐭 𝐨𝐟 𝐨𝐮𝐫 𝐬𝐭𝐨𝐫𝐞");

            if ($start !== false) {
                // Find the position of the first </p> after the start
                $end = strpos($body_html, "</p>", $start);

                if ($end !== false) {
                    // Include the length of </p> to remove it entirely
                    $end += 4;
                    // Remove the content
                    $body_html = substr_replace(
                        $body_html,
                        "",
                        $start,
                        $end - $start
                    );
                }
            }

            $starts = strpos($body_html, "listing here:");

            if ($starts !== false) {
                // Find the position of the first </p> after the start
                $end = strpos($body_html, "</p>", $starts);

                if ($end !== false) {
                    // Include the length of </p> to remove it entirely
                    $end += 4;
                    // Remove the content
                    $body_html = substr_replace(
                        $body_html,
                        "",
                        $starts,
                        $end - $starts
                    );
                }
            }
            // email check
            $emailRegex = "/[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}/";
            if (preg_match($emailRegex, $body_html, $matches)) {
                // Output the matched email

                $body_html = str_replace($matches[0], "", $body_html);
            }

            $pattern = "/[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}/";
            $body_html = preg_replace($pattern, "", $body_html);
            $description = $body_html;
        }
        $listing_title = mb_substr($listing_title, 0, 80);

        return [
            "title" => $listing_title,
            "description" => $description,
        ];
    }

    public function getShopifyLocation($shopurl, $token,$inventory_item_id)
    {
         $query = <<<GRAPHQL
            {
            inventoryItem(id: "gid://shopify/InventoryItem/$inventory_item_id") {
                inventoryLevels(first: 1) {
                edges {
                node {
                id
                location {
                    id
                    name
                    address {
                        city
                        country
                        countryCode
                        zip
                        }
                }
                }
                }
                }
            }
            }
            GRAPHQL;
            
                  $locationData = $this->callShopifyGraphQL($shopurl, $token, $query);

                  Log::info(   $locationData);
                  Log::info("888888888");
                  $address = array();
                  if( isset($locationData['data']['inventoryItem']['inventoryLevels']['edges'][0]['node']['location']['address']) && isset($locationData['data']['inventoryItem']['inventoryLevels']['edges'][0]['node']['location']['address']['city']) && !empty($locationData['data']['inventoryItem']['inventoryLevels']['edges'][0]['node']['location']['address']['city'])){
                      $address = $locationData['data']['inventoryItem']['inventoryLevels']['edges'][0]['node']['location']['address'];
                  }else{
                      $query = 'query {
                              locations(first: 5) {
                                  edges {
                                  node {
                                      address {
                                      city
                                      country
                                      countryCode
                                      zip
                                      }
                                  }
                                  }
                              }
                              }
                              ';

                      $locationData = $this->callShopifyGraphQL($shopurl, $token, $query);
                      Log::info(   $locationData);
                      if(isset($locationData['data']['locations']['edges'][0]['node']['address'])){
                        $address = $locationData['data']['locations']['edges'][0]['node']['address'];

                      }
                    }
                    return $address;
    }

    function callShopifyGraphQL($shopUrl, $accessToken, $query, $variables = [])
    {
        $ch = curl_init("https://$shopUrl/admin/api/2024-10/graphql.json");
        $payload = [
            "query" => $query,
        ];

        if (!empty($variables)) {
            $payload["variables"] = $variables;
        }

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "X-Shopify-Access-Token: $accessToken",
        ]);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            $errorMsg = curl_error($ch);
            curl_close($ch);
            return [
                "error" => true,
                "message" => "cURL error: $errorMsg",
            ];
        }

        curl_close($ch);

        $responseDecoded = json_decode($response, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            return [
                "error" => true,
                "message" => "Invalid JSON response",
                "rawResponse" => $response,
            ];
        }
        return $responseDecoded;
    }

    public function getEbayCurrency($siteid = 0)
    {
        $currencyCodes = [
            15 => "AUD",
            16 => "EUR",
            123 => "EUR",
            23 => "EUR",
            2 => "CAD",
            210 => "CAD",
            71 => "EUR",
            77 => "EUR",
            201 => "HKD",
            203 => "INR",
            205 => "EUR",
            101 => "EUR",
            207 => "MYR",
            146 => "EUR",
            211 => "PHP",
            212 => "PLN",
            215 => "RUB",
            216 => "SGD",
            186 => "EUR",
            193 => "CHF",
            3 => "GBP",
            0 => "USD",
        ];
        return isset($currencyCodes[$siteid]) ? $currencyCodes[$siteid] : "USD";
    }

    public static function getEbayCountry($siteid = 0)
    {
        $countryCodes = [
            15 => "AU",
            16 => "AT",
            123 => "BE",
            23 => "BE",
            2 => "CA",
            210 => "CA",
            71 => "FR",
            77 => "DE",
            201 => "HK",
            203 => "IN",
            205 => "IE",
            101 => "IT",
            207 => "MY",
            146 => "NL",
            211 => "PH",
            212 => "PL",
            215 => "RU",
            216 => "SG",
            186 => "ES",
            193 => "CH",
            100 => "MOTOR",
            //3 => "UK",
            3 => "GB",
            0 => "US",
            //	218 => "SE"
        ];
        return isset($countryCodes[$siteid]) ? $countryCodes[$siteid] : "ZZ";
    }
    public function setValuesVariationSpecifics(
        $shVariants,
        $variants,
        $option1name,
        $option2name,
        $option3name,
        $option1Values,
        $option2Values,
        $option3Values
    ) {
        Log::info("setValuesVariationSpecifics function start ");
        Log::info(
            json_encode([
                "shVariants" => $shVariants,
                "variants" => $variants,
                "option1name" => $option1name,
                "option2name" => $option2name,
                "option3name" => $option3name,
                "option1Values" => $option1Values,
                "option2Values" => $option2Values,
                "option3Values" => $option3Values,
            ])
        );
        foreach ($shVariants as $shVariant) {
            $pvariant = [];
            foreach ($variants as $variant) {
                if ($variant->shopify_variant_id == $shVariant["id"]) {
                    $pvariant = $variant;
                    break;
                }
            }

            if (!$pvariant) {
                continue;
            }

            $option1shVariant = isset($shVariant["option1"])
                ? substr(trim($shVariant["option1"], " "), 0, 65)
                : null;
            $option2shVariant = isset($shVariant["option2"])
                ? substr(trim($shVariant["option2"], " "), 0, 65)
                : null;
            $option3shVariant = isset($shVariant["option3"])
                ? substr(trim($shVariant["option3"], " "), 0, 65)
                : null;

            if ($option1shVariant) {
                $normalizedOption1Value = strtolower($option1shVariant);
                if (
                    !in_array(
                        $normalizedOption1Value,
                        array_map("strtolower", $option1Values)
                    )
                ) {
                    $option1Values[] = $option1shVariant; // Keep original casing
                }
            }

            // Process option2
            if ($option2shVariant) {
                $normalizedOption2Value = strtolower($option2shVariant);
                if (
                    !in_array(
                        $normalizedOption2Value,
                        array_map("strtolower", $option2Values)
                    )
                ) {
                    $option2Values[] = $option2shVariant; // Keep original casing
                }
            }

            // Process option3
            if ($option3shVariant) {
                $normalizedOption3Value = strtolower($option3shVariant);
                if (
                    !in_array(
                        $normalizedOption3Value,
                        array_map("strtolower", $option3Values)
                    )
                ) {
                    $option3Values[] = $option3shVariant; // Keep original casing
                }
            }
        }

        $variationSpecificsSet = new Types\NameValueListArrayType();
        Log::info("code is running on the line 1760 in add updated method");
        $optionNameValue = new Types\NameValueListType();
        $optionNameValue->Name = $option1name;
        $optionNameValue->Value = $option1Values;
        $variationSpecificsSet->NameValueList[] = $optionNameValue;
        Log::info(
            "option1Name setValuesVariationSpecifics " .
                $option1name .
                " length " .
                strlen($option1name)
        );
        Log::info(
            "option1Values setValuesVariationSpecifics " .
                json_encode($option1Values, true)
        );
        if ($option2name && $option2Values) {
            $optionNameValue = new Types\NameValueListType();
            $optionNameValue->Name = $option2name;
            $optionNameValue->Value = $option2Values;
            $variationSpecificsSet->NameValueList[] = $optionNameValue;
            Log::info(
                "option2Name setValuesVariationSpecifics " .
                    $option2name .
                    " length " .
                    strlen($option2name)
            );
            Log::info(
                "option1Values setValuesVariationSpecifics " .
                    json_encode($option2Values, true)
            );
            if ($option3name && $option3Values) {
                $optionNameValue = new Types\NameValueListType();
                $optionNameValue->Name = $option3name;
                $optionNameValue->Value = $option3Values;
                $variationSpecificsSet->NameValueList[] = $optionNameValue;
                Log::info(
                    "option3Name setValuesVariationSpecifics " .
                        $option3name .
                        " length " .
                        strlen($option3name)
                );
                Log::info(
                    "option1Values setValuesVariationSpecifics " .
                        json_encode($option3Values, true)
                );
            }
        }
        Log::info("setValuesVariationSpecifics function end ");

        return [
            "option1Values" => $option1Values,
            "option2Values" => $option2Values,
            "option3Values" => $option3Values,
            "variationSpecificsSet" => $variationSpecificsSet,
        ];
    }
    public function getValueVariationSpecifics(
        $option1name,
        $option2name,
        $option3name,
        $option1shVariant,
        $option2shVariant,
        $option3shVariant
    ) {
        // 	variationSpecifics setvalue option name and option value
        Log::info("getValueVariationSpecifics start");
        $variationSpecifics = new Types\NameValueListArrayType();

        $optionNameValue = new Types\NameValueListType();
        $optionNameValue->Name = $option1name;
        $optionNameValue->Value = [$option1shVariant];
        $variationSpecifics->NameValueList[] = $optionNameValue;
        Log::info(
            "option1Name " .
                $option1name .
                " length " .
                strlen($option1name) .
                " Variation " .
                $option1shVariant .
                " length " .
                strlen($option1shVariant)
        );
        if ($option2shVariant && $option2name) {
            $optionNameValue = new Types\NameValueListType();
            $optionNameValue->Name = $option2name;
            $optionNameValue->Value = [$option2shVariant];
            $variationSpecifics->NameValueList[] = $optionNameValue;
            Log::info(
                "option2Name " .
                    $option2name .
                    " length " .
                    strlen($option2name) .
                    "  Variation value " .
                    $option2shVariant .
                    " length " .
                    strlen($option2shVariant)
            );
            if ($option3shVariant && $option3name) {
                $optionNameValue = new Types\NameValueListType();
                $optionNameValue->Name = $option3name;
                $optionNameValue->Value = [$option3shVariant];
                $variationSpecifics->NameValueList[] = $optionNameValue;
                Log::info(
                    "option3Name " .
                        $option3name .
                        " length " .
                        strlen($option3name) .
                        " Variation " .
                        $option3shVariant .
                        " length " .
                        strlen($option3shVariant)
                );
            }
        }
        Log::info("getValueVariationSpecifics end");
        return $variationSpecifics;
    }
    public function remove_emoji($text)
    {
        return preg_replace(
            "/[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0077}\x{E006C}\x{E0073}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0073}\x{E0063}\x{E0074}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0065}\x{E006E}\x{E0067}\x{E007F})|[\x{1F3F4}](?:\x{200D}\x{2620}\x{FE0F})|[\x{1F3F3}](?:\x{FE0F}\x{200D}\x{1F308})|[\x{0023}\x{002A}\x{0030}\x{0031}\x{0032}\x{0033}\x{0034}\x{0035}\x{0036}\x{0037}\x{0038}\x{0039}](?:\x{FE0F}\x{20E3})|[\x{1F441}](?:\x{FE0F}\x{200D}\x{1F5E8}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F468})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F468})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B0})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2640}\x{FE0F})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2642}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2695}\x{FE0F})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FF})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FE})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FD})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FC})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FB})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FA}](?:\x{1F1FF})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1FA}](?:\x{1F1FE})|[\x{1F1E6}\x{1F1E8}\x{1F1F2}\x{1F1F8}](?:\x{1F1FD})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F9}\x{1F1FF}](?:\x{1F1FC})|[\x{1F1E7}\x{1F1E8}\x{1F1F1}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1FB})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1FB}](?:\x{1F1FA})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FE}](?:\x{1F1F9})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FA}\x{1F1FC}](?:\x{1F1F8})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F7})|[\x{1F1E6}\x{1F1E7}\x{1F1EC}\x{1F1EE}\x{1F1F2}](?:\x{1F1F6})|[\x{1F1E8}\x{1F1EC}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}](?:\x{1F1F5})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EE}\x{1F1EF}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1F8}\x{1F1F9}](?:\x{1F1F4})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1F3})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F4}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FF}](?:\x{1F1F2})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F1})|[\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FD}](?:\x{1F1F0})|[\x{1F1E7}\x{1F1E9}\x{1F1EB}\x{1F1F8}\x{1F1F9}](?:\x{1F1EF})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EB}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F3}\x{1F1F8}\x{1F1FB}](?:\x{1F1EE})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1ED})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1EC})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F9}\x{1F1FC}](?:\x{1F1EB})|[\x{1F1E6}\x{1F1E7}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FB}\x{1F1FE}](?:\x{1F1EA})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1E9})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FB}](?:\x{1F1E8})|[\x{1F1E7}\x{1F1EC}\x{1F1F1}\x{1F1F8}](?:\x{1F1E7})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F6}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}\x{1F1FF}](?:\x{1F1E6})|[\x{00A9}\x{00AE}\x{203C}\x{2049}\x{2122}\x{2139}\x{2194}-\x{2199}\x{21A9}-\x{21AA}\x{231A}-\x{231B}\x{2328}\x{23CF}\x{23E9}-\x{23F3}\x{23F8}-\x{23FA}\x{24C2}\x{25AA}-\x{25AB}\x{25B6}\x{25C0}\x{25FB}-\x{25FE}\x{2600}-\x{2604}\x{260E}\x{2611}\x{2614}-\x{2615}\x{2618}\x{261D}\x{2620}\x{2622}-\x{2623}\x{2626}\x{262A}\x{262E}-\x{262F}\x{2638}-\x{263A}\x{2640}\x{2642}\x{2648}-\x{2653}\x{2660}\x{2663}\x{2665}-\x{2666}\x{2668}\x{267B}\x{267E}-\x{267F}\x{2692}-\x{2697}\x{2699}\x{269B}-\x{269C}\x{26A0}-\x{26A1}\x{26AA}-\x{26AB}\x{26B0}-\x{26B1}\x{26BD}-\x{26BE}\x{26C4}-\x{26C5}\x{26C8}\x{26CE}-\x{26CF}\x{26D1}\x{26D3}-\x{26D4}\x{26E9}-\x{26EA}\x{26F0}-\x{26F5}\x{26F7}-\x{26FA}\x{26FD}\x{2702}\x{2705}\x{2708}-\x{270D}\x{270F}\x{2712}\x{2714}\x{2716}\x{271D}\x{2721}\x{2728}\x{2733}-\x{2734}\x{2744}\x{2747}\x{274C}\x{274E}\x{2753}-\x{2755}\x{2757}\x{2763}-\x{2764}\x{2795}-\x{2797}\x{27A1}\x{27B0}\x{27BF}\x{2934}-\x{2935}\x{2B05}-\x{2B07}\x{2B1B}-\x{2B1C}\x{2B50}\x{2B55}\x{3030}\x{303D}\x{3297}\x{3299}\x{1F004}\x{1F0CF}\x{1F170}-\x{1F171}\x{1F17E}-\x{1F17F}\x{1F18E}\x{1F191}-\x{1F19A}\x{1F201}-\x{1F202}\x{1F21A}\x{1F22F}\x{1F232}-\x{1F23A}\x{1F250}-\x{1F251}\x{1F300}-\x{1F321}\x{1F324}-\x{1F393}\x{1F396}-\x{1F397}\x{1F399}-\x{1F39B}\x{1F39E}-\x{1F3F0}\x{1F3F3}-\x{1F3F5}\x{1F3F7}-\x{1F3FA}\x{1F400}-\x{1F4FD}\x{1F4FF}-\x{1F53D}\x{1F549}-\x{1F54E}\x{1F550}-\x{1F567}\x{1F56F}-\x{1F570}\x{1F573}-\x{1F57A}\x{1F587}\x{1F58A}-\x{1F58D}\x{1F590}\x{1F595}-\x{1F596}\x{1F5A4}-\x{1F5A5}\x{1F5A8}\x{1F5B1}-\x{1F5B2}\x{1F5BC}\x{1F5C2}-\x{1F5C4}\x{1F5D1}-\x{1F5D3}\x{1F5DC}-\x{1F5DE}\x{1F5E1}\x{1F5E3}\x{1F5E8}\x{1F5EF}\x{1F5F3}\x{1F5FA}-\x{1F64F}\x{1F680}-\x{1F6C5}\x{1F6CB}-\x{1F6D2}\x{1F6E0}-\x{1F6E5}\x{1F6E9}\x{1F6EB}-\x{1F6EC}\x{1F6F0}\x{1F6F3}-\x{1F6F9}\x{1F910}-\x{1F93A}\x{1F93C}-\x{1F93E}\x{1F940}-\x{1F945}\x{1F947}-\x{1F970}\x{1F973}-\x{1F976}\x{1F97A}\x{1F97C}-\x{1F9A2}\x{1F9B0}-\x{1F9B9}\x{1F9C0}-\x{1F9C2}\x{1F9D0}-\x{1F9FF}]/u",
            "",
            $text
        );
    }
}


