<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Product extends Model {

	protected $table = 'products';

	protected $primaryKey = 'product_id';

    public function user() {
		return $this->belongsTo('App\User', 'user_id', 'id');
	}
	
	public function variants() {
		return $this->hasMany('App\ProductVariant', 'product_id', 'product_id');
	}

	public function variantsCount() {
		return $this->hasOne('App\ProductVariant', 'product_id', 'product_id')->selectRaw('product_id, count(*) as no_of_variants, sum(quantity) as quantity')->groupBy('product_id');
	}

    protected $fillable = [
        'product_id', 'title', 'description', 'ebayitemid','item_specific','status', 'condition_note', 'condition_val', 'brand', 'product_type', 'option1name', 'option2name', 'option3name', 'option4name', 'option5name', 'shopifyproductid', 'newflag', 'quantityflag', 'priceflag'
	];
	
}