<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductImage extends Model {

	protected $table = 'product_images';
	protected $primaryKey = 'id';
	
	public function productVariant() {
		return $this->belongsTo('App\ProductVariant', 'variant_id', 'id');
	}

	public function user() {
		return $this->belongsTo('App\User', 'user_id', 'id');
	}
	
	protected $fillable = [
        'variant_id', 'imgurl'
    ];
}
