<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ShopifyProduct extends Model
{
    protected $table = 'sh_products'; 
    public function user() {
		return $this->belongsTo('App\User', 'id', 'user_id');
	}
	
	public function sh_variants() {
		return $this->hasMany('App\ShopifyVariant', 'sh_product_id', 'id');
	}

	public function variantsCount() {
		return $this->hasOne('App\ShopifyVariant', 'id', 'sh_product_id')->selectRaw('sh_product_id, count(*) as no_of_variants, sum(quantity) as quantity')->groupBy('sh_product_id');
	}


    public function profile(){
        return $this->hasOne('App\Profile','id','profile_id');
    }

    protected $fillable = [
        'title',
        'edit_title',
        'image',
        'status',
        'shopify_product_id',
        'ebayitemid',
        'shopify_product_handle',
        'shopify_product_type',
        'shopify_product_data',
        'error_no',
        'dimensions',
        'Source',
        'submit',
        'error_info',
        'profile_id',
        'user_id'
    ];

}