<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ShopifyVariant extends Model
{
    protected $table = 'sh_product_variants'; // Ensure the table name matches your database
    
	public function user() {
		return $this->belongsTo('App\User', 'user_id', 'id');
	}

	public function product() {
		return $this->belongsTo('App\ShopifyProduct', 'sh_product_id', 'id');
	}	
    protected $fillable = [
        'title',
        'sku',
        'image',
        'Barcode',
        'quantity',
        'price',
        'compare_at_price',
        'shopify_variant_id',
        'shopify_inventory_item_id',
        'shopify_product_id',
        'shopify_product_handle',
        'shopify_variant_data',
        'sh_product_id',
        'user_id'
    ];
}
