<?php

namespace App;

use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Foundation\Auth\Access\Authorizable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use Nicolaslopezj\Searchable\SearchableTrait;
use PhpSoft\Users\Models\UserTrait;

class User extends Model implements AuthenticatableContract,
                                    //AuthorizableContract,
                                    CanResetPasswordContract
{
	
    use Authenticatable, CanResetPassword,UserTrait;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'users';


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'ownername', 'email', 'password', 'SetupStep',  'shopurl','appTour'
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = ['password', 'remember_token'];

    public function products() {
		return $this->hasMany('App\Product', 'user_id', 'id');
	}

    public function summary(){
        return $this->hasOne('App\Summary','user_id','id');
    }
    public function sh_products() {
		return $this->hasMany('App\ShopifyProduct', 'user_id', 'id');
	}
	public function processimports() {
        return $this->hasOne('App\ProcessImport', 'user_id', 'id');
    }
    public function processebayimports() {
        return $this->hasOne('App\ProcessEbayImport', 'user_id', 'id');
    }
    public function process_reimport() {
        return $this->hasOne('App\Process_reimport', 'user_id', 'id');
    }
    public function profiles() {
        return $this->hasMany('App\Profile', 'user_id', 'id');
    }
    public function sellerProfiles() {
        return $this->hasMany('App\SellerProfile', 'user_id', 'id');
    }
    public function variants() {
        return $this->hasMany('App\ProductVariant', 'user_id', 'id');
    }
    public function sh_variants() {
        return $this->hasMany('App\ShopifyVariant', 'user_id', 'id');
    }
    public function images() {
        return $this->hasMany('App\ProductImage', 'user_id', 'id');
    }

	public function ebKey(){
		return $this->hasOne('App\EbKey', 'user_id', 'id')->select('id', 'token','sellerid', 'expirydate', 'valid','siteid','lastdatafetched');
	}	
	
	public function ebRequests(){
		return $this->hasMany('App\EbRequest', 'user_id', 'id');
	}
    public function shRequests(){
		return $this->hasMany('App\ShopifyRequest', 'user_id', 'id');
	}

	public function settings() {
        return $this->hasOne('App\Setting', 'user_id', 'id');
    }
    public function webhook(){
         return $this->hasOne('App\Webhook', 'user_id', 'id');
    }
}