<?php
set_time_limit(0);
require_once("/home/cp1infoshoreapps/public_html/cronjobs/includes/config.php");
require '/home/cp1infoshoreapps/public_html/cronjobs/includes/eblib/ebay-sdk-php-autoloader.php';
	
use \DTS\eBaySDK\Constants;
use \DTS\eBaySDK\Trading\Services;
use \DTS\eBaySDK\Trading\Types;
use \DTS\eBaySDK\Trading\Enums;

$logfile = fopen("logs/cronorders_tarun.txt", "a+") or die("Unable to open log file!");
addlog("Execution Started", "INFO");

$conn = new mysqli($host, $username, $password, $dbname);
// Check connection
if($conn->connect_error){
	die("Connection failed: " . $conn->connect_error);
}

$user_id = 48062;
$result = $conn->query("select * from users where id = '".mysqli_real_escape_string($conn, $user_id)."'");
if($result->num_rows == 0){
	die("");
}
$row = $result->fetch_assoc();
$shopurl = $row['shopurl'];
$token = $row['token'];
$inventoryUpdates = array();
$error = false;

$result = $conn->query("SELECT max(orderid) as maxid FROM `shopifyorders` where user_id = ".$user_id);
if($result->num_rows == 0){
	die("");
}
$row = $result->fetch_assoc();
$maxorderid = $row['maxid'];
$maxorderid = intval(preg_replace('/[^0-9]/', '', $maxorderid));
if($maxorderid == 0){
    $maxorderid = 1;
}
echo "check maxid \n";
print_r($maxorderid);
// die("");

fetchOrders($shopurl, $token, $maxorderid, $user_id);

function fetchOrders($shopurl, $token, $maxorderid, $user_id) {
    $query = '
    {
      orders(first: 250, query: "id:>'.$maxorderid.'") {
        edges {
          node {
            id
            createdAt
            lineItems(first: 5) {
              edges {
                node {
                  title
                  quantity
                variant {
                    id
                    sku
                  
                  product {
                    id
                  }

                }
                }
              }
            }
          }
        }
      }
    }';

    $graphql_url = "https://" . $shopurl . "/admin/api/2024-10/graphql.json";

    $session = curl_init();
    curl_setopt($session, CURLOPT_URL, $graphql_url);
    curl_setopt($session, CURLOPT_POST, 1);
    curl_setopt($session, CURLOPT_HTTPHEADER, array(
        'X-Shopify-Access-Token: ' . $token,
        'Content-Type: application/json'
    ));
    curl_setopt($session, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($session, CURLOPT_POSTFIELDS, json_encode(array('query' => $query)));
    curl_setopt($session, CURLOPT_SSL_VERIFYPEER, true);

    $response = curl_exec($session);
    $http_status = curl_getinfo($session, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($session);

    curl_close($session);

    if ($http_status == 200) {
        $orders_array = json_decode($response, true);
        echo "CHECK order \n";
        print_r($orders_array);

        if ($orders_array && isset($orders_array['data']['orders']['edges'])) {
            foreach ($orders_array['data']['orders']['edges'] as $orderEdge) {
                $order = $orderEdge['node'];
                processOrder($user_id, $order);
            }
        } else {
            echo "No orders found.";
        }
    } else {
        echo "Error: Unable to fetch orders, HTTP Status: " . $http_status;
        if ($curl_error) {
            echo " cURL Error: " . $curl_error;
        }
    }
}

function processOrder($user_id, $order) {
    echo "Entered in processorder function \n";
    global $conn, $inventoryUpdates;
    
    $order_id = $order['id'];
    
    $checkExistanceQuery = $conn->query("SELECT * FROM shopifyorders WHERE user_id = '" . mysqli_real_escape_string($conn, $user_id) . "' AND orderid = '" . mysqli_real_escape_string($conn, $order_id) . "'");
    
    if ($checkExistanceQuery->num_rows > 0) {
        die("Duplicate webhook called");
    }
    
    $conn->query("INSERT INTO shopifyorders (orderid, user_id, orderdata, created_at, updated_at) 
                  VALUES ('" . mysqli_real_escape_string($conn, $order_id) . "', 
                          '" . mysqli_real_escape_string($conn, $user_id) . "', 
                          '" . mysqli_real_escape_string($conn, serialize($order)) . "', 
                          NOW(), NOW())");

    if (isset($order['lineItems']) && is_array($order['lineItems']['edges']) && !empty($order['lineItems']['edges'])) {
        $line_items = $order['lineItems']['edges'];
        echo "Founded line items for order id " . $order_id . "\n";
        print_r($line_items);
        foreach ($line_items as $line_item_edge) {
            $line_item = $line_item_edge['node'];
            $product_id = (string) $line_item['product']['id'];
            $product_id = preg_replace('/[^0-9]/', '', $product_id);
            $variant_id = (string) $line_item['variant']['id'];
            $variant_id = preg_replace('/[^0-9]/', '', $variant_id);
            $quantity = (int) $line_item['quantity'];
            $sku = $line_item['variant']['sku'];
            
            $variantResult = $conn->query("SELECT * FROM product_variants WHERE shopifyvariantid != '' 
                                          AND shopifyproductid = '" . mysqli_real_escape_string($conn, $product_id) . "' 
                                          AND shopifyvariantid = '" . mysqli_real_escape_string($conn, $variant_id) . "' 
                                          AND user_id = " . (int)$user_id);
            
            if ($variantResult->num_rows > 0) {
                echo "order variants founded in database \n";
                $variantRow = $variantResult->fetch_assoc();
                $id = $variantRow['id'];
                
                addQty($id, $quantity, $variantRow);        
            }
        }
    } else {
        echo "No line items found for order ID: " . $order_id;
    }
    echo "******************************** \n";
    print_r($inventoryUpdates);
    addlog("inventoryUpdates - " . json_encode($inventoryUpdates), "INFO");

    $conn->query("UPDATE shopifyorders 
                  SET inventoryupdates = '" . mysqli_real_escape_string($conn, json_encode($inventoryUpdates)) . "' 
                  WHERE user_id = " . (int)$user_id . " 
                  AND orderid = '" . mysqli_real_escape_string($conn, $order_id) . "'");

    updateInventory($user_id);

    $inventoryUpdates = array();
}


function updateInventory($user_id){
	global $conn, $inventoryUpdates, $ebConfig;
	$ebKeysResult = $conn->query("select * from eb_keys where valid = 1 and user_id = ".$user_id);
	if($ebKeysResult->num_rows < 1){
		addlog("eBay keys not available.", "ERROR");
		return false;
	}	
	$ebKeysRow = $ebKeysResult->fetch_assoc();
	$token = $ebKeysRow["token"];
	$siteid = $ebKeysRow["siteid"];
	if (!empty($inventoryUpdates)) {
        foreach($inventoryUpdates as $dataObj){
            $variantRow = $dataObj["variantRow"];
            $variant_id = $dataObj["variant_id"];
            $qtysold = $dataObj["qtysold"];

            if($variantRow["option1val"] == ""){
                $ebayitemid = $variantRow["ebayitemid"];
                $oldqty = $variantRow["quantity"];
                $newqty = $oldqty - $qtysold;
                if($newqty < 1  && $user_id != 6168 && $user_id != 8108 && $user_id != 11129 && $user_id != 10702 && $user_id != 11006 && $user_id != 10176 && $user_id != 5377 && $user_id != 32){
                    if($user_id == 7512){
                        $conn->query("update products set deleted = 1, searchstring = 'SOLD_OUT' where user_id = ".$user_id." and product_id = ".$variantRow['product_id']);
                    }
                    endItem($ebayitemid, $token, $siteid);
                } else {			
                    if($newqty < 1){
                    $newqty = 0; 
                    }
                    $service = new Services\TradingService([
                        'credentials' => $ebConfig['production']['credentials'],
                        'sandbox'     => false,
                        'siteId'      => $siteid
                    ]);
                    $request = new Types\ReviseInventoryStatusRequestType();
                    $request->RequesterCredentials = new Types\CustomSecurityHeaderType();
                    $request->RequesterCredentials->eBayAuthToken = $token;
                    $inventoryStatusType = new Types\InventoryStatusType();
                    $inventoryStatusType->ItemID = $ebayitemid;
                    $inventoryStatusType->Quantity = $newqty;
                    $request->InventoryStatus = array($inventoryStatusType);
                    $response = $service->reviseInventoryStatus($request);
                    addlog("Response - ".serialize($response), "INFO");
                    //print_r($response);
                    if ($response->Ack !== 'Failure') {
                        addlog("Quantity on eBay updated successfully - ".$ebayitemid.":".$qty, "INFO");
                    } else {
                        $errmsg = "";
                        if (isset($response->Errors)) {
                            foreach ($response->Errors as $error) {
                                $errmsg .= $error->LongMessage.", ";
                            }
                        }
                        addlog("Error in updating quantity on eBay - ".$ebayitemid." Error - ".$errmsg, "ERROR");
                    }
                }
            } else {
                $product_id = $variantRow["product_id"];
                $ebayitemid = $variantRow["ebayitemid"];
                $oldqty = $variantRow["quantity"];
                $newqty = $oldqty - $qtysold;
                $options = array();
                $productsResult = $conn->query("select option1name, option2name, option3name, option4name, option5name from products where user_id = ".$user_id." and product_id = ".$product_id);
                if($productsResult->num_rows < 1){
                    continue;
                }
                $productsRow = $productsResult->fetch_assoc();
                if($productsRow["option1name"] != "" && $variantRow["option1val"] != ""){
                    $options[$productsRow["option1name"]] = $variantRow["option1val"];
                }
                if($productsRow["option2name"] != "" && $variantRow["option2val"] != ""){
                    $options[$productsRow["option2name"]] = $variantRow["option2val"];
                }
                if($productsRow["option3name"] != "" && $variantRow["option3val"] != ""){
                    $options[$productsRow["option3name"]] = $variantRow["option3val"];
                }
                if($productsRow["option4name"] != "" && $variantRow["option4val"] != ""){
                    $options[$productsRow["option4name"]] = $variantRow["option4val"];
                }
                if($productsRow["option5name"] != "" && $variantRow["option5val"] != ""){
                    $options[$productsRow["option5name"]] = $variantRow["option5val"];
                }
                            
                $service = new Services\TradingService([
                        'credentials' => $ebConfig['production']['credentials'],
                        'sandbox'     => false,
                        'siteId'      => $siteid
                    ]);

                $request = new Types\ReviseFixedPriceItemRequestType();
                $request->RequesterCredentials = new Types\CustomSecurityHeaderType();
                $request->RequesterCredentials->eBayAuthToken = $token;
                
                $itemType = new Types\ItemType();
                $itemType->ItemID = $ebayitemid;
                $variationsType = new Types\VariationsType();
                $variationType = new Types\VariationType();
                $variationType->Quantity = $newqty;		
                $variationType->SKU = $variantRow["sku"];
                $variationSpecificsSetType = new Types\NameValueListArrayType();
                $variationSpecificsSetType->NameValueList = array();
                foreach($options as $k => $v){
                    $nameValueListType = new Types\NameValueListType();
                    $nameValueListType->Name = $k;
                    $nameValueListType->Value = array($v);
                    $variationSpecificsSetType->NameValueList[] = $nameValueListType;
                }
                $variationType->VariationSpecifics = array($variationSpecificsSetType);
                $variationsType->Variation = array($variationType);
                $itemType->Variations = $variationsType;
                $request->Item = $itemType;			
                $response = $service->reviseFixedPriceItem($request);
                addlog("Response - ".serialize($response), "INFO");
                if ($response->Ack !== 'Failure') {
                    addlog("Quantity on eBay updated successfully - ".$ebayitemid.":".$qty, "INFO");
                } else {
                    $errmsg = "";
                    if (isset($response->Errors)) {
                        foreach ($response->Errors as $error) {
                            $errmsg .= $error->LongMessage.", ";
                        }
                    }
                    addlog("Error in updating quantity on eBay - ".$ebayitemid." Error - ".$errmsg, "ERROR");
                }
            }
        }
    }
}

function endItem($ebayitemid, $token, $siteid){
	global $conn, $ebConfig;
	if(strlen($token) == 0){
		addlog("eBay keys not available.", "ERROR");
		return false;
	}
	$service = new Services\TradingService([
				'credentials' => $ebConfig['production']['credentials'],
				'sandbox'     => false,
				'siteId'      => $siteid
				]);

	$request = new Types\EndFixedPriceItemRequestType();
	$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
	$request->RequesterCredentials->eBayAuthToken = $token;
	$request->ItemID = $ebayitemid;
	$request->EndingReason = "NotAvailable";
	$response = $service->endFixedPriceItem($request);
	addlog("Response - ".json_encode($response), "INFO");
	if ($response->Ack !== 'Failure') {
		addlog("Quantity on eBay ended successfully - ".$ebayitemid, "INFO");
	} else {
		$errmsg = "";
		if (isset($response->Errors)) {
			foreach ($response->Errors as $error) {
				$errmsg .= $error->LongMessage.", ";
			}
		}
		addlog("Error in ending item on eBay - ".$ebayitemid." Error - ".$errmsg, "ERROR");
		@mail("khariwal.rohit@gmail.com", "[Shopify APP] - EPI - order hook failed", "Error in ending item on eBay - ".$ebayitemid." Error - ".$errmsg);
	}
}

function addQty($variant_id, $quantity, $variantRow){
	global $inventoryUpdates;
	if(!array_key_exists($variant_id, $inventoryUpdates)){
		$inventoryUpdates[$variant_id] = array("qtysold" => $quantity, "variantRow" => $variantRow);
	} else {
		$inventoryUpdates[$variant_id]["qtysold"] = $inventoryUpdates[$variant_id]["qtysold"]+$quantity;
	}
}

function addlog($message, $type){
	global $logfile;
	$txt = date("Y-m-d H:i:s")." [".$type."]: ".$message."\n";
	fwrite($logfile, $txt);
}
addlog("Execution Finished", "INFO");
fclose($logfile);
?>