<?php
set_time_limit(0);
//exit(0);
require_once("/home/cp1infoshoreapps/public_html/cronjobs/includes/config.php");
require '/home/cp1infoshoreapps/public_html/cronjobs/includes/eblib/ebay-sdk-php-autoloader.php';
	
use \DTS\eBaySDK\Constants;
use \DTS\eBaySDK\Trading\Services;
use \DTS\eBaySDK\Trading\Types;
use \DTS\eBaySDK\Trading\Enums;

$logfile = fopen("logs/hook_orders_".date('m-d-Y_hia').".txt", "a+") or die("Unable to open log file!");
addlog("Execution Started", "INFO");

define('SHOPIFY_APP_SECRET', '60b2d8f5474dce861583e40088cfe8f8');
// echo "jhfg";
$hmac_header = $_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'];
$data = file_get_contents('php://input');
$verified = verify_webhook($data, $hmac_header);
$is_ok=var_export($verified, true);
$key = $_GET['key'];

if($key == 45000){
	exit(0);
	addlog("Execution Beforre 9188 wbhook verification", "INFO");
}
else{

	addlog("Execution Beforre user wbhook verification ".$key, "INFO");

}

if( $is_ok=="false" ){
	addlog("order hook verification failed", "INFO");
	@mail("khariwal.rohit@gmail.com", "[Shopify APP] - EPI - order hook verification failed",$data);
	die("");
}

if(!isset($_GET['key'])){
	die("");
}

$key = $_GET['key'];

$conn = new mysqli($host, $username, $password, $dbname);
// Check connection
if($conn->connect_error){
	die("Connection failed: " . $conn->connect_error);
}

if($key == 9188){
	addlog("Execution After 9188 wbhook verification", "INFO");
}
else{

	addlog("Execution After user wbhook verification ".$key, "INFO");
}


if($key == 6943){
    die("");
}
if($key == 15000 || $key == 11839 || $key == 13661 || $key == 11580 || $key == 12522 || $key == 15771 || $key == 46026){
    die("");
}
// $result = $conn->query("select * from users where id = '".mysqli_real_escape_string($conn, $key)."'");

$result = $conn->query("select u.id, u.shopurl, u.token, s.shopifyorders_action from users u, settings s where u.id = s.user_id and u.installationstatus = 1 and u.sync = 1 and s.shopifyorders = 1 and  u.id = '".mysqli_real_escape_string($conn, $key)."'  and u.id !=39373 ");
if($result->num_rows == 0){
	die("");
}
$row = $result->fetch_assoc();
$shopurl = $row['shopurl'];
$token = $row['token'];
$user_id = $row['id'];
$shopifyorders_action = $row['shopifyorders_action'];

$jsonString = '';
$jsonData = fopen('php://input' , 'rb'); 
while (!feof($jsonData)) { $jsonString .= fread($jsonData, 4096); }
fclose($jsonData);

//@mail("khariwal.rohit@gmail.com","[Shopify APP] - EPI - order hook called", $jsonString);
$order = json_decode($jsonString, true);
$jsonerr = "";
switch (json_last_error()) {
	case JSON_ERROR_NONE:
		$jsonerr = "";
        break;
	case JSON_ERROR_DEPTH:
		$jsonerr =  ' - Maximum stack depth exceeded';
        break;
	case JSON_ERROR_STATE_MISMATCH:
        $jsonerr =  ' - Underflow or the modes mismatch';
        break;
    case JSON_ERROR_CTRL_CHAR:
        $jsonerr =  ' - Unexpected control character found';
		break;
	case JSON_ERROR_SYNTAX:
		$jsonerr =  ' - Syntax error, malformed JSON';
        break;
	case JSON_ERROR_UTF8:
        $jsonerr =  ' - Malformed UTF-8 characters, possibly incorrectly encoded';
        break;
    default:
        $jsonerr =  ' - Unknown error';
        break;
}

if(strlen($jsonerr) > 0){
	@mail("khariwal.rohit@gmail.com", "[Shopify APP] - EPI - JSON Err", $jsonerr);
	die("");
}

$order_id = $order["id"];
addlog("inventoryUpdates for user and order - ".$key. " and order id ".$order_id, "INFO");
$checkExistanceQuery = $conn->query("select * from shopifyorders where user_id = '".$user_id."' and orderid = '".mysqli_real_escape_string($conn, $order_id)."'");
if($checkExistanceQuery->num_rows > 0){
	die("duplicate webhook called");
}
$conn->query("insert into shopifyorders(orderid, user_id, orderdata, created_at, updated_at) values('".mysqli_real_escape_string($conn, $order_id)."', '".$user_id."', '".mysqli_real_escape_string($conn, serialize($order))."',now(), now())");

$line_items = $order['line_items'];
$inventoryUpdates = array();
$error = false;
foreach($line_items as $line_item){
	$product_id = "".$line_item['product_id'];
	$variant_id = "".$line_item['variant_id'];
	$quantity = $line_item['quantity'];
	$sku = $line_item['sku'];	
	$variantResult = $conn->query("select * from product_variants where shopifyvariantid !='' and shopifyproductid = '".$product_id."' and shopifyvariantid = '".$variant_id."' and user_id = ".$user_id);
	if($variantResult->num_rows > 0){
		$variantRow = $variantResult->fetch_assoc();
		$id = $variantRow['id'];
		addQty($id, $quantity, $variantRow);		
	}
}
addlog("inventoryUpdates - ".json_encode($inventoryUpdates), "INFO");
$conn->query("update shopifyorders set inventoryupdates = '".mysqli_real_escape_string($conn, json_encode($inventoryUpdates))."' where user_id = ".$user_id." and orderid = '".mysqli_real_escape_string($conn, $order_id)."'");
if($user_id == 11839){
	updateInventory_11839($user_id, $shopurl, $token,$shopifyorders_action);
} else if($user_id == 14562){
	updateInventory_14562($user_id, $shopurl, $token,$shopifyorders_action);
} else {
	updateInventory($user_id,$shopifyorders_action );
}

function updateInventory_14562($user_id, $shopurl, $token,$shopifyorders_action){
	global $conn, $inventoryUpdates, $ebConfig;
	$ebKeysResult = $conn->query("select * from eb_keys where valid = 1 and user_id = ".$user_id);
	if($ebKeysResult->num_rows < 1){
		addlog("eBay keys not available.", "ERROR");
		return false;
	}
	$eBTokenArr = array();
	while($ebKeysRow = $ebKeysResult->fetch_assoc()){
		$token = $ebKeysRow["token"];
		$siteid = $ebKeysRow["siteid"];
		$sellerid = $ebKeysRow["sellerid"];
		$eBTokenArr[$sellerid] = array("siteid" => $siteid, "token" => $token);
	}
	
	foreach($inventoryUpdates as $dataObj){
		$variantRow = $dataObj["variantRow"];
		$variant_id = $dataObj["variant_id"];
		$product_id = $variantRow["product_id"];
		$qtysold = $dataObj["qtysold"];
		$productResult = $conn->query("select searchstring from products where user_id = ".$user_id." and product_id = ".$product_id);
		if($productResult->num_rows < 1){
			addlog("Error in fetching product_id - ".$product_id, "ERROR");
			continue;
		}
		$productRow = $productResult->fetch_assoc();
		$sellerid = $productRow['searchstring'];
		if(!array_key_exists($sellerid, $eBTokenArr)){
			addlog("Keys not found for product_id - ".$product_id, "ERROR");
			continue;
		}
		$token = $eBTokenArr[$sellerid]["token"];
		$siteid = $eBTokenArr[$sellerid]["siteid"];
		if($variantRow["option1val"] == ""){
			$ebayitemid = $variantRow["ebayitemid"];
			$oldqty = $variantRow["quantity"];
			$newqty = $oldqty - $qtysold; 
			if($newqty < 1  && $shopifyorders_action == "end"){
				if($user_id == 7512 || $user_id == 16735   ){
				    $conn->query("update products set deleted = 1, searchstring = 'SOLD_OUT' where user_id = ".$user_id." and product_id = ".$variantRow['product_id']);
				}
				addlog("Here is the user Id for  ".$user_id, "ERROR");
				endItem($ebayitemid, $token, $siteid);
			} else {			
			    if($newqty < 1){
			       $newqty = 0; 
			    }
				$service = new Services\TradingService([
					'credentials' => $ebConfig['production']['credentials'],
					'sandbox'     => false,
					'siteId'      => $siteid
				]);
				$request = new Types\ReviseInventoryStatusRequestType();
				$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
				$request->RequesterCredentials->eBayAuthToken = $token;
				$inventoryStatusType = new Types\InventoryStatusType();
				$inventoryStatusType->ItemID = $ebayitemid;
				$inventoryStatusType->Quantity = $newqty;
				$request->InventoryStatus = array($inventoryStatusType);
				$response = $service->reviseInventoryStatus($request);
				addlog("Response - ".serialize($response), "INFO");
				//print_r($response);
				
								
				if ($response->Ack !== 'Failure') {
					addlog("Quantity on eBay updated successfully - ".$ebayitemid.":".$qty, "INFO");
				} else {
					$errmsg = "";
					if (isset($response->Errors)) {
						foreach ($response->Errors as $error) {
							$errmsg .= $error->LongMessage.", ";
						}
					}
					addlog("Error in updating quantity on eBay - ".$ebayitemid." Error - ".$errmsg, "ERROR");
				}
			}
		} else {
			$product_id = $variantRow["product_id"];
			$ebayitemid = $variantRow["ebayitemid"];
			$oldqty = $variantRow["quantity"];
			$newqty = $oldqty - $qtysold;
			$options = array();
			$productsResult = $conn->query("select option1name, option2name, option3name, option4name, option5name from products where user_id = ".$user_id." and product_id = ".$product_id);
			if($productsResult->num_rows < 1){
				continue;
			}
			$productsRow = $productsResult->fetch_assoc();
			if($productsRow["option1name"] != "" && $variantRow["option1val"] != ""){
				$options[$productsRow["option1name"]] = $variantRow["option1val"];
			}
			if($productsRow["option2name"] != "" && $variantRow["option2val"] != ""){
				$options[$productsRow["option2name"]] = $variantRow["option2val"];
			}
			if($productsRow["option3name"] != "" && $variantRow["option3val"] != ""){
				$options[$productsRow["option3name"]] = $variantRow["option3val"];
			}
			if($productsRow["option4name"] != "" && $variantRow["option4val"] != ""){
				$options[$productsRow["option4name"]] = $variantRow["option4val"];
			}
			if($productsRow["option5name"] != "" && $variantRow["option5val"] != ""){
				$options[$productsRow["option5name"]] = $variantRow["option5val"];
			}
						
			$service = new Services\TradingService([
					'credentials' => $ebConfig['production']['credentials'],
					'sandbox'     => false,
					'siteId'      => $siteid
				]);

			$request = new Types\ReviseFixedPriceItemRequestType();
			$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
			$request->RequesterCredentials->eBayAuthToken = $token;
			
			$itemType = new Types\ItemType();
			$itemType->ItemID = $ebayitemid;
			$variationsType = new Types\VariationsType();
			$variationType = new Types\VariationType();
			$variationType->Quantity = $newqty;		
			$variationType->SKU = $variantRow["sku"];
			$variationSpecificsSetType = new Types\NameValueListArrayType();
			$variationSpecificsSetType->NameValueList = array();
			foreach($options as $k => $v){
				$nameValueListType = new Types\NameValueListType();
				$nameValueListType->Name = $k;
				$nameValueListType->Value = array($v);
				$variationSpecificsSetType->NameValueList[] = $nameValueListType;
			}
			$variationType->VariationSpecifics = array($variationSpecificsSetType);
			$variationsType->Variation = array($variationType);
			$itemType->Variations = $variationsType;
			$request->Item = $itemType;			
			$response = $service->reviseFixedPriceItem($request);
			addlog("Response - ".serialize($response), "INFO");
			
							
			if ( $response->Ack !== 'Failure') {
				addlog("Quantity on eBay updated successfully - ".$ebayitemid.":".$qty, "INFO");
			}
			 else {
				$errmsg = "";
				if (isset($response->Errors)) {
					foreach ($response->Errors as $error) {
						$errmsg .= $error->LongMessage.", ";
					}
				}
				addlog("Error in updating quantity on eBay - ".$ebayitemid." Error - ".$errmsg, "ERROR");
			}
		}
	}
}

function updateInventory($user_id,$shopifyorders_action ){
      addlog("Updating inventory for ".$user_id, "INFO");
	global $conn, $inventoryUpdates, $ebConfig;
	$ebKeysResult = $conn->query("select * from eb_keys where valid = 1 and user_id = ".$user_id);
	if($ebKeysResult->num_rows < 1){
		addlog("eBay keys not available.", "ERROR");
		return false;
	}	
	$ebKeysRow = $ebKeysResult->fetch_assoc();
	$token = $ebKeysRow["token"];
	$siteid = $ebKeysRow["siteid"];
	
	foreach($inventoryUpdates as $dataObj){
		$variantRow = $dataObj["variantRow"];
		$variant_id = $dataObj["variant_id"];
		$qtysold = $dataObj["qtysold"];
		if ($user_id == 47855 && $variantRow["option1val"] != "" && $variantRow["option2val"] == '') {
			$variantRow["option1val"] = "";
		}
		if($variantRow["option1val"] == "" || $user_id == 17378){
			$ebayitemid = $variantRow["ebayitemid"];
			$oldqty = $variantRow["quantity"];
			$newqty = $oldqty - $qtysold;  //19844
			addlog("user id $user_id  for  eBay order action $shopifyorders_action variant  id  $variant_id", "Info");
			if($newqty < 1  && $shopifyorders_action == "end"){// 
				addlog("user id $user_id  for  eBay order action $shopifyorders_action quantity to be updated is  $newqty try to enditem", "Info");
				if($user_id == 7512 || $user_id == 16735){
				    $conn->query("update products set deleted = 1, searchstring = 'SOLD_OUT' where user_id = ".$user_id." and product_id = ".$variantRow['product_id']);
				}
				endItem($ebayitemid, $token, $siteid);
			} else {			
			    if($newqty < 1){
			       $newqty = 0; 
			    }
				addlog("user id $user_id  for  eBay order action $shopifyorders_action quantity to be updated is  $newqty", "Info");
				$service = new Services\TradingService([
					'credentials' => $ebConfig['production']['credentials'],
					'sandbox'     => false,
					'siteId'      => $siteid
				]);
				$request = new Types\ReviseInventoryStatusRequestType();
				$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
				$request->RequesterCredentials->eBayAuthToken = $token;
				$inventoryStatusType = new Types\InventoryStatusType();
				$inventoryStatusType->ItemID = $ebayitemid;
				$inventoryStatusType->Quantity = $newqty;
				$request->InventoryStatus = array($inventoryStatusType);
				$response = $service->reviseInventoryStatus($request);
				addlog("Response - ".serialize($response), "INFO");
				//print_r($response);

               
								
				if ( $response->Ack !== 'Failure') {
					addlog("Quantity on eBay updated successfully - ".$ebayitemid.":".$qty, "INFO");
				}
                else {
					$errmsg = "";
					if (isset($response->Errors)) {
						foreach ($response->Errors as $error) {
							$errmsg .= $error->LongMessage.", ";
						}
					}
					addlog($user_id." User Id have Error in updating quantity on eBay - ".$ebayitemid." Error - ".$errmsg, "ERROR");
				}
			}
		} else {
			$product_id = $variantRow["product_id"];
			$ebayitemid = $variantRow["ebayitemid"];
			$oldqty = $variantRow["quantity"];
			$newqty = $oldqty - $qtysold;
			$options = array();
			$productsResult = $conn->query("select option1name, option2name, option3name, option4name, option5name from products where user_id = ".$user_id." and product_id = ".$product_id);
			if($productsResult->num_rows < 1){
				continue;
			}
			$productsRow = $productsResult->fetch_assoc();
			if($productsRow["option1name"] != "" && $variantRow["option1val"] != ""){
				$options[$productsRow["option1name"]] = $variantRow["option1val"];
			}
			if($productsRow["option2name"] != "" && $variantRow["option2val"] != ""){
				$options[$productsRow["option2name"]] = $variantRow["option2val"];
			}
			if($productsRow["option3name"] != "" && $variantRow["option3val"] != ""){
				$options[$productsRow["option3name"]] = $variantRow["option3val"];
			}
			if($productsRow["option4name"] != "" && $variantRow["option4val"] != ""){
				$options[$productsRow["option4name"]] = $variantRow["option4val"];
			}
			if($productsRow["option5name"] != "" && $variantRow["option5val"] != ""){
				$options[$productsRow["option5name"]] = $variantRow["option5val"];
			}
						
			$service = new Services\TradingService([
					'credentials' => $ebConfig['production']['credentials'],
					'sandbox'     => false,
					'siteId'      => $siteid
				]);

			$request = new Types\ReviseFixedPriceItemRequestType();
			$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
			$request->RequesterCredentials->eBayAuthToken = $token;
			
			$itemType = new Types\ItemType();
			$itemType->ItemID = $ebayitemid;
			$variationsType = new Types\VariationsType();
			$variationType = new Types\VariationType();
			$variationType->Quantity = $newqty;	
			if($user_id != 10702){
			    $variationType->SKU = $variantRow["sku"];   
			}
			$variationSpecificsSetType = new Types\NameValueListArrayType();
			$variationSpecificsSetType->NameValueList = array();
			foreach($options as $k => $v){
				$nameValueListType = new Types\NameValueListType();
				$nameValueListType->Name = $k;
				$nameValueListType->Value = array($v);
				$variationSpecificsSetType->NameValueList[] = $nameValueListType;
			}
			$variationType->VariationSpecifics = array($variationSpecificsSetType);
			$variationsType->Variation = array($variationType);
			$itemType->Variations = $variationsType;
			$request->Item = $itemType;			
			$response = $service->reviseFixedPriceItem($request);
			addlog("Response - ".serialize($response), "INFO");
            
			
							
			if ( $response->Ack !== 'Failure') {
				addlog("Quantity on eBay updated successfully - ".$ebayitemid.":".$qty, "INFO");
			}
			 else {
				$errmsg = "";
				if (isset($response->Errors)) {
					foreach ($response->Errors as $error) {
						$errmsg .= $error->LongMessage.", ";
					}
				}
				addlog($user_id ." User Id Error in updating quantity on eBay - ".$ebayitemid." Error - ".$errmsg, "ERROR");
			}
		}
	}
}

function endItem($ebayitemid, $token, $siteid){
	global $conn, $ebConfig;
	if(strlen($token) == 0){
		addlog("eBay keys not available.", "ERROR");
		return false;
	}
	$service = new Services\TradingService([
				'credentials' => $ebConfig['production']['credentials'],
				'sandbox'     => false,
				'siteId'      => $siteid
				]);

	$request = new Types\EndFixedPriceItemRequestType();
	$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
	$request->RequesterCredentials->eBayAuthToken = $token;
	$request->ItemID = $ebayitemid;
	$request->EndingReason = "NotAvailable";
	$response = $service->endFixedPriceItem($request);
	addlog("Response - ".json_encode($response), "INFO");
    

	if ($response->Ack !== 'Failure') {
		addlog("Quantity on eBay ended successfully - ".$ebayitemid, "INFO");
	} else {
		$errmsg = "";
		if (isset($response->Errors)) {
			foreach ($response->Errors as $error) {
				$errmsg .= $error->LongMessage.", ";
			}
		}
		addlog("Error in ending item on eBay - ".$ebayitemid." Error - ".$errmsg, "ERROR");
		@mail("khariwal.rohit@gmail.com", "[Shopify APP] - EPI - order hook failed", "Error in ending item on eBay - ".$ebayitemid." Error - ".$errmsg);
	}
}

function updateInventory_11839($user_id, $shopurl, $token){
	global $conn, $inventoryUpdates, $ebConfig;
	foreach($inventoryUpdates as $dataObj){
		$variantRow = $dataObj["variantRow"];		
		$inventory_item_id = $variantRow["shopifyinventoryid"];
		$location_id = $variantRow["shopifylocationid"];
		$quantity = $variantRow["quantity"];
		updateShopifyInventory($token, $shopurl, $inventory_item_id, $location_id, $quantity);
	}
}

function updateShopifyInventory($token,$shopurl,$inventory_item_id,$location_id,$quantity){
	$shopifyinverid = 'gid://shopify/InventoryItem/'.$inventory_item_id;
	$shopifylocatid = 'gid://shopify/Location/'.$location_id;
		// echo $hopifylocatid;
   $quantity = (int) $quantity;

   addlog("shopify inventory in grapghql for invetory ".$shopifyinverid."","info");

   echo 'shopify bariehshdf > '.$shopifyinverid;
	// die();
		$query = <<<QUERY
		mutation InventorySet(\$input: InventorySetQuantitiesInput!) {
		inventorySetQuantities(input: \$input) {
			inventoryAdjustmentGroup {
			createdAt
			reason
			changes {
				name
				delta
			}
			}
			userErrors {
			field
			message
			}
		}
		}
		QUERY;


	$variables = [
		"input" => [
			"ignoreCompareQuantity" => true,
			"name" => "available",
			"reason" => "correction",
			"quantities" => [
				[
					"inventoryItemId" => $shopifyinverid, 
					"locationId" => $shopifylocatid, 
					"quantity" => $quantity
				]
			]
		]
	];
  
	
	$payload = json_encode([
		'query' => $query,
		'variables' => $variables
	]);
	$ch = curl_init("https://$shopurl/admin/api/2024-10/graphql.json");
	
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, [
		"Content-Type: application/json",
		"X-Shopify-Access-Token: $token"
	]);
	
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
	
	$response = curl_exec($ch);
	
	if(curl_errno($ch)) {
		echo 'cURL Error: ' . curl_error($ch);
	}
	curl_close($ch);

	$responseData = json_decode($response, true);

	print_r($responseData);
	addlog("QUANTITY FOR UPDATE on shopify response ". json_encode($responseData,true), "INFO");
	if (isset($responseData['data']['inventorySetQuantities'])) {
		if(isset($responseData['data']['inventorySetQuantities']['userErrors'][0]['field'])){
			//   echo 'error count >'.count($inventoryAdjustmentGroup['userErrors']).'>';
			 print_r($responseData['data']['inventorySetQuantities']['userErrors']);
			 addlog("PERTICULAR ID IN ARRAY.  ".json_encode($responseData['data']['inventorySetQuantities']['userErrors'])."","INFO");
			 return false;
			}
		$inventoryAdjustmentGroup = $responseData['data']['inventorySetQuantities']['inventoryAdjustmentGroup'];  
		if (isset($inventoryAdjustmentGroup['changes'])) {
			foreach ($inventoryAdjustmentGroup['changes'] as $change) {
				echo "Change: " . $change['name'] . " | Delta: " . $change['delta'] . "\n";
				addlog("Change: " . $change['name'] . " | Delta: " . $change['delta'] ."","INFO");
			}
		}

		 return true;
	} else {
		echo "Error: ";
		 
		if (isset($responseData['errors'])) {
			if (is_array($responseData['errors'])) {
				foreach ($responseData['errors'] as $error) {
					echo $error['message'] . "\n";
					addlog("inventery not updata on shopify ".$error['message'], "INFO");
				}
			} else {
				echo "Unexpected error format: " . print_r($responseData['errors'], true) . "\n";
				addlog("inventery not updata shopify ".$responseData['errors'] ,"INFO");
			}
		}
		// if (isset($responseData['errors'])) {
		//     foreach ($responseData['errors'] as $error) {
		//         echo $error['message'] . "\n";
		//     }
		// }
		if (isset($responseData['data']['inventoryAdjustQuantities']['userErrors'])) {
			foreach ($responseData['data']['inventoryAdjustQuantities']['userErrors'] as $error) {
				echo $error['field'] . " - " . $error['message'] . "\n";
				
			}
		}
		return false;
	} 
}



function verify_webhook($data, $hmac_header){
	$calculated_hmac = base64_encode(hash_hmac('sha256', $data, SHOPIFY_APP_SECRET, true));
	return ($hmac_header == $calculated_hmac);
}

function addQty($variant_id, $quantity, $variantRow){
	global $inventoryUpdates;
	if(!array_key_exists($variant_id, $inventoryUpdates)){
		$inventoryUpdates[$variant_id] = array("qtysold" => $quantity, "variantRow" => $variantRow);
	} else {
		$inventoryUpdates[$variant_id]["qtysold"] = $inventoryUpdates[$variant_id]["qtysold"]+$quantity;
	}
}

function addlog($message, $type){
	global $logfile;
	$txt = date("Y-m-d H:i:s")." [".$type."]: ".$message."\n";
	fwrite($logfile, $txt);
}
addlog("Execution Finished", "INFO");
fclose($logfile);
?>