<?php
set_time_limit(0);
ini_set('memory_limit', '-1');
require_once("/home/cp1infoshoreapps/public_html/cronjobs/includes/config.php");
require '/home/cp1infoshoreapps/public_html/cronjobs/includes/eblib/ebay-sdk-php-autoloader.php';
	
use \DTS\eBaySDK\Constants;
use \DTS\eBaySDK\Trading\Services;
use \DTS\eBaySDK\Trading\Types;
use \DTS\eBaySDK\Trading\Enums;

$logfile = fopen("logs/processShopifyWebhook.txt", "a+") or die("Unable to open log file!");
addlog("Execution Started", "INFO");

$conn = new mysqli($host, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
	addlog("Database connection failed: " . $conn->connect_error, "ERROR");
	die("");
}
mysqli_set_charset($conn, "utf8");

$user_id = 6412;
$result = $conn->query("select * from eb_keys where valid = 1 and user_id = ".$user_id);
if($result->num_rows < 1){
	die("error");
}
$row = $result->fetch_assoc();
$siteid = $row['siteid'];
$token = $row['token'];
$dataArr = array(array("ebayitemid" => "183779438715", "qty" => 0, "isvariation" => 0),array("ebayitemid" => "183150298446", "qty" => 0, "isvariation" => 0),array("ebayitemid" => "183784603946", "qty" => 0, "isvariation" => 0));
updateInventory($dataArr, $token, $siteid);
exit;
//Input: array(array("ebayitemid" => 1234, "qty" => 2, "isvariation" => 0), array("ebayitemid" => 2343,  "qty" => 3, "isvariation" => 1, "options" => array('color" =>"red", "size" ="X"))


$cronQuery = $conn->query("select isrunning from crons where crontype = 'processipn'");
$cronrow = $cronQuery->fetch_assoc();
if($cronrow['isrunning'] == 1){
	@mail("khariwal.rohit@gmail.com", "EPI: processIPN: Cron already running", "processIPN: Cron already running");
	die("");
}
	
$conn->query("update crons set lastrun = now(), isrunning = 1 where crontype = 'processipn'");

$usersData = getAllValidUsers();
$existingItems = array();
$ipnStatusArr = array();
$actionQueueArr = array();

$result = $conn->query("select distinct user_id from shopifyorders where processed = 0");
if($result->num_rows > 0){
	while($row = $result->fetch_assoc()){
		$user_id = $row['user_id'];
		// Check validity of user
		if(!array_key_exists($user_id, $usersData)){			
			continue;
		}		
		$shopurl = $usersData[$user_id]["shopurl"];
		$token = $usersData[$user_id]["token"];		
		$settingsResult = $conn->query("select * from settings where user_id = ".$user_id);
		if($settingsResult->num_rows < 1){
			// Settings missing
			continue;
		}
		$settingsRow = $settingsResult->fetch_assoc();
		echo "Start - ".date("Y-m-d H:i:s")."<br />";
		$existingItems = getExistingData($user_id);	
		echo "After getExistingData - ".date("Y-m-d H:i:s")."<br />";
		$ipnStatusArr = array();
		$actionQueueArr = array();
		$ipnResult = $conn->query("select * from ipndata1 where status = 'unprocessed' and user_id = ".$user_id." order by createdAt limit 0, 1000");
		if($ipnResult->num_rows > 0){
			while($ipnRow = $ipnResult->fetch_assoc()){
				echo "Start processing ".$ipn_type." - ".date("Y-m-d H:i:s")."<br />";
				$ipn_type = $ipnRow['ipn_type'];
				if($ipn_type == "ItemClosed" || $ipn_type == "ItemSold"){ // Item closed
					processItemClosed($ipnRow, $settingsRow);
				} else if($ipn_type == "ItemRevised"){ // review item
					processReviseItem($ipnRow, $settingsRow);
				} else if($ipn_type == "FixedPriceTransaction"){ // transaction
					processTransactions($ipnRow, $settingsRow);
				}
				echo "End processing ".$ipn_type." - ".date("Y-m-d H:i:s")."<br />";
			}
			echo "Completed processing ".$ipn_type." - ".date("Y-m-d H:i:s")."<br />";
			echo $user_id;
			print_r($actionQueueArr);
			print_r($ipnStatusArr);
			processUpdates($user_id, $shopurl, $token, $settingsRow);
			updateIPNStatus($user_id);
		}
	}
}
//Input: array(array("ebayitemid" => 1234, "qty" => 2, "isvariation" => 0), array("ebayitemid" => 2343,  "qty" => 3, "isvariation" => 1, "options" => array('color" =>"red", "size" ="X"))

function endItem($ebayitemid, $token, $siteid){
	global $conn, $ebConfig;
	if(strlen($token) == 0){
		addlog("eBay keys not available.", "ERROR");
		return false;
	}
	$service = new Services\TradingService([
				'credentials' => $ebConfig['production']['credentials'],
				'sandbox'     => false,
				'siteId'      => $siteid
				]);

	$request = new Types\EndFixedPriceItemRequestType();
	$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
	$request->RequesterCredentials->eBayAuthToken = $token;
	$request->ItemID = $ebayitemid;
	$response = $service->endFixedPriceItem($request);
	print_r($response);
	if ($response->Ack !== 'Failure') {
		addlog("Quantity on eBay ended successfully - ".$ebayitemid, "INFO");
	} else {
		$errmsg = "";
		if (isset($response->Errors)) {
			foreach ($response->Errors as $error) {
				$errmsg .= $error->LongMessage.", ";
			}
		}
		addlog("Error in ending item on eBay - ".$ebayitemid." Error - ".$errmsg, "ERROR");
	}
}
function updateInventory($dataArr, $token, $siteid){
	global $conn, $ebConfig;	
	foreach($dataArr as $dataObj){
		if($dataObj["isvariation"] == 0){
			$ebayitemid = $dataObj["ebayitemid"];
			endItem($ebayitemid, $token, $siteid);continue;
			$qty = $dataObj["qty"];
			if(strlen($token) == 0){
				addlog("eBay keys not available.", "ERROR");
				return false;
			}
			$service = new Services\TradingService([
					'credentials' => $ebConfig['production']['credentials'],
					'sandbox'     => false,
					'siteId'      => $siteid
				]);

			$request = new Types\ReviseInventoryStatusRequestType();
			$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
			$request->RequesterCredentials->eBayAuthToken = $token;
			$inventoryStatusType = new Types\InventoryStatusType();
			$inventoryStatusType->ItemID = $ebayitemid;
			$inventoryStatusType->Quantity = $qty;
			$request->InventoryStatus = array($inventoryStatusType);
			$response = $service->reviseInventoryStatus($request);
			print_r($response);
			if ($response->Ack !== 'Failure') {
				addlog("Quantity on eBay updated successfully - ".$ebayitemid.":".$qty, "INFO");
				continue;
			} else {
				$errmsg = "";
				if (isset($response->Errors)) {
					foreach ($response->Errors as $error) {
						$errmsg .= $error->LongMessage.", ";
					}
				}
				addlog("Error in updating quantity on eBay - ".$ebayitemid." Error - ".$errmsg, "ERROR");
				continue;
			}
		} else if($dataObj["isvariation"] == 1) {
			$ebayitemid = $dataObj["ebayitemid"];
			$qty = $dataObj["qty"];
			$options = $dataObj["options"];
			if(strlen($token) == 0){
				addlog("eBay keys not available.", "ERROR");
				return false;
			}
			$service = new Services\TradingService([
					'credentials' => $ebConfig['production']['credentials'],
					'sandbox'     => false,
					'siteId'      => $siteid
				]);

			$request = new Types\ReviseFixedPriceItemRequestType();
			$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
			$request->RequesterCredentials->eBayAuthToken = $token;
			
			$itemType = new Types\ItemType();
			$itemType->ItemID = $ebayitemid;
			$variationsType = new Types\VariationsType();
			$variationType = new Types\VariationType();
			$variationType->Quantity = $qty;		
			$variationSpecificsSetType = new Types\NameValueListArrayType();
			$variationSpecificsSetType->NameValueList = array();
			foreach($options as $k => $v){
				$nameValueListType = new Types\NameValueListType();
				$nameValueListType->Name = $k;
				$nameValueListType->Value = array($v);
				$variationSpecificsSetType->NameValueList[] = $nameValueListType;
			}
			$variationType->VariationSpecifics = array($variationSpecificsSetType);
			$variationsType->Variation = array($variationType);
			$itemType->Variations = $variationsType;
			$request->Item = $itemType;			
			$response = $service->reviseItem($request);
			
			if ($response->Ack !== 'Failure') {
				addlog("Quantity on eBay updated successfully - ".$ebayitemid.":".$qty, "INFO");
				continue;
			} else {
				$errmsg = "";
				if (isset($response->Errors)) {
					foreach ($response->Errors as $error) {
						$errmsg .= $error->LongMessage.", ";
					}
				}
				addlog("Error in updating quantity on eBay - ".$ebayitemid." Error - ".$errmsg, "ERROR");
				continue;
			}
		}
	}
}

function getAllValidUsers(){
	global $conn;
	$usersData = array();
	$userResult = $conn->query("select u.id, u.shopurl, u.token, u.sync, u.created_at, u.paid_at, u.review from users u, settings s where u.id = s.user_id and u.installationstatus = 1 and s.realtime = 1");
	if($userResult->num_rows > 0){
		while($userRow = $userResult->fetch_assoc()){
			$user_id = $userRow['id'];
			$shopurl = $userRow['shopurl'];
			$token = $userRow['token'];
			$sync = $userRow['sync'];
			$created_at = $userRow['created_at'];
			$paid_at = $userRow['paid_at'];
			$review = $userRow['review'];
			$created_at_time = strtotime($created_at);
			$paid_at_time = strtotime($paid_at);
			$daysdiff = 61;
			$now = time();
			if($paid_at_time <= 0){
				$datediff = $now - $created_at_time;
				$daysdiff = floor($datediff / (60 * 60 * 24));
			} else {
				$datediff = $now - $paid_at_time;
				$daysdiff = floor($datediff / (60 * 60 * 24));
			}
			if($sync == 0 && ($daysdiff > 60 || ($daysdiff > 30 && $review == 0))){
				continue;
			}
			$usersData[$user_id] = array("shopurl" => $shopurl, "token" => $token);
		}
	}
	return $usersData;
}

function addlog($message, $type){
	global $logfile;
	$txt = date("Y-m-d H:i:s")." [".$type."]: ".$message."\n";
	fwrite($logfile, $txt);
}
addlog("Execution Finished", "INFO");
fclose($logfile);
?>