<?php
/*
 * Copyright 2016 Jan Eichhorn <exeu65@googlemail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace ApaiIO\Test\Request;

use ApaiIO\Request\Util;

class UtilTest extends \PHPUnit_Framework_TestCase
{
    public function testSignature()
    {
        $expectedResult = "9hUgcq4Tnuwb9naeMAyL/Xnk070qcbQUfSbWsFBztgM=";
        $this->assertEquals($expectedResult, Util::buildSignature('ABCD', 'EFG'));
    }

    public function testTimestamp()
    {
        $this->assertRegExp('#[0-9]{4}(-[0-9]{2}){2}T([0-9]{2}:){2}[0-9]{2}Z#', Util::getTimeStamp());
    }
}
