<?php
//die();
set_time_limit(0);
ini_set('memory_limit', '-1');
require_once("includes/config.php");
require '/home/cp1infoshoreapps/public_html/updatedepi/api/ebay_sdk/vendor/autoload.php';

use \DTS\eBaySDK\Constants;
use \DTS\eBaySDK\Trading\Services;
use \DTS\eBaySDK\Trading\Types;
use \DTS\eBaySDK\Trading\Enums;

$logfile = fopen("logs/cronreimport" . date('y-m-d') . ".txt", "a+") or die("Unable to open log file!");
addlog("Execution Started", "INFO");

$conn = new mysqli($host, $username, $password, $dbname);

//Check connection
if ($conn->connect_error) {
	addlog("Database connection failed: " . $conn->connect_error, "ERROR");
	die("");
}
mysqli_set_charset($conn, "utf8");
$cronQuery = $conn->query("select isrunning from crons where crontype = 'cronreimport'");
$cronrow = $cronQuery->fetch_assoc();
if ($cronrow['isrunning'] == 1) {

	@mail("khariwal.rohit@gmail.com", "cronreimport: Cron already running", "cronreimport: Cron already running");
	die("");
}

$conn->query("update crons set lastrun = now(), isrunning = 1 where crontype = 'cronreimport'");

$result = $conn->query("select distinct user_id from process_reimport where  user_id != 6067 and user_id != 6876  and user_id != 35770 and user_id != 48766  "); // and user_id != 9188
if ($result->num_rows > 0) {
	while ($row = $result->fetch_assoc()) {
		// echo '1';
		$user_id = $row['user_id'];
		echo $user_id;
		addlog("Reimport process started for user_id - " . $user_id, "INFO");
		processReimport($user_id);
		$conn->query("delete from process_reimport where user_id = " . $user_id);
	}
}

$conn->query("update crons set isrunning = 0 where crontype = 'cronreimport'");
// $cmd = '/usr/bin/php -f /home/dev9/public_html/cronjobs/cronreimporttitledesc.php /dev/null 2>&1 &';
//exec($cmd);

function processReimport($user_id)
{
	global $conn;
	$userResult = $conn->query("select * from users where id = '" . $user_id . "' and installationstatus = 1");
	if ($userResult->num_rows < 1) {
		return false;
	}
	$userRow = $userResult->fetch_assoc();
	// echo 'USER : ';
	// print_r($userRow);
	// die();
	$shopurl = $userRow['shopurl'];
	$shopifytoken = $userRow['token'];

	$configResult = $conn->query("select * from eb_keys where valid = 1 and user_id = '" . $user_id . "'");
	if ($configResult->num_rows > 0) {
		$configRow = $configResult->fetch_assoc();
		$sellerid = $configRow['sellerid'];
		$token = $configRow['token'];
		$siteid = $configRow['siteid'];
		$cnt12 = 0;
		$productResult = $conn->query("select * from products where status = 'reimport in progress' and user_id = " . $user_id);
		if ($productResult->num_rows > 0) {
			$cnt12 = $productResult->num_rows;
			while ($productRow = $productResult->fetch_assoc()) {

				$ebayitemid = $productRow['ebayitemid'];
				$product_id = $productRow['product_id'];
				echo 'EBAY ITEM ID : <br>';
				echo $ebayitemid;
				$shopifyproductid = $productRow['shopifyproductid'];
				if ($shopifyproductid != "") {
					$res = deleteShopifyProduct($user_id, $shopifytoken, $shopurl, $shopifyproductid);
					sleep(1);
				}
				/*if(!$res){
						continue;
					}*/
				$conn->query("delete from product_description where product_id = '" . mysqli_real_escape_string($conn, $product_id) . "' and user_id = " . $user_id);
				$conn->query("delete from products where ebayitemid = '" . mysqli_real_escape_string($conn, $ebayitemid) . "' and user_id = " . $user_id);
				$conn->query("delete from product_images where variant_id in (select id from product_variants where ebayitemid = '" . mysqli_real_escape_string($conn, $ebayitemid) . "' and user_id = " . $user_id . ") and user_id = " . $user_id);
				$conn->query("delete from product_variants where ebayitemid = '" . mysqli_real_escape_string($conn, $ebayitemid) . "' and user_id = " . $user_id);
				$conn->query("delete from ebproducts where ebayitemid = '" . mysqli_real_escape_string($conn, $ebayitemid) . "' and user_id = " . $user_id);
				$res = processItem($user_id, $siteid, $token, $ebayitemid);
				print_r($res);
				if ($res) {
					echo 'processed';
					$conn->query("insert into ebproducts(ebayitemid, user_id, created_at, updated_at) values('" . mysqli_real_escape_string($conn, $itemId) . "', " . $user_id . ", now(), now())");
				}
				if ($user_id != 17821) {
					$conn->query("update products set status = 'Import in progress' where status = 'Ready to Import' and ebayitemid = '" . mysqli_real_escape_string($conn, $ebayitemid) . "' and user_id = " . $user_id);
				}
			}
			$pcount = $conn->query("select * from processimports where user_id =" . $user_id);
			if ($pcount->num_rows > 0) {
				while ($pRow = $pcount->fetch_assoc()) {
					$cntold = $row['count'];
					$newocunt = $cntold + $cnt12;
					$conn->query("update processimports set count =" . mysqli_real_escape_string($conn, $newocunt) . "' where  user_id = " . $user_id);
					echo "In if old  count" . $cntold . "new count" . $newocunt;
				}
			} else {
				$cnt = $cnt12;
				$processimport = "insert into processimports (user_id,count,created_at,updated_at	
				) values(" . $user_id . ", " . $cnt . ", now(), now())";
				$processimport12 = mysqli_query($conn, $processimport);
				$pimpid = $conn->insert_id;
				echo "process import table id" . $pimpid;
			}
		}
	} else {

		addlog("No valid eBay token found. user_id - " . $user_id, "ERROR");
		return false;
	}
}
function deleteShopifyProduct($user_id, $token, $shopurl, $shopifyproductid)
{

	// Correct Product ID formatting

	$productId = "gid://shopify/Product/" . $shopifyproductid;

	// Mutation for deleting the product
	$queryProductVariantsBulkUpdate = <<<QUERY
        mutation {
            productDelete(input: {id: "$productId"}) {
                deletedProductId
                userErrors {
                    field
                    message
                }
            }
        }
        QUERY;

	// Prepare the payload
	$payloadProductVariants = json_encode([
		"query" => $queryProductVariantsBulkUpdate
	]);

	// Initialize cURL
	$ch = curl_init("https://$shopurl/admin/api/" . GRAPHQL_API_VERSION . "/graphql.json");

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, [
		"Content-Type: application/json",
		"X-Shopify-Access-Token: $token"
	]);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $payloadProductVariants);

	// Execute the request
	$response = curl_exec($ch);

	// Handle cURL errors
	if (curl_errno($ch)) {
		echo 'cURL Error: ' . curl_error($ch);
	} else {
		$responseData = json_decode($response, true);

		// Print raw response for debugging
		print_r($responseData);

		// Process the response
		if (isset($responseData['data']['productDelete'])) {
			$deletedProductId = $responseData['data']['productDelete']['deletedProductId'];
			$userErrors = $responseData['data']['productDelete']['userErrors'];

			if (!empty($deletedProductId)) {
				addlog("Product successfully deleted. Deleted Product ID: " . $deletedProductId . "", "INFO");
				addlog("delete item for this shopify product id " . $shopifyproductid . "", "INFO");
			}

			if (!empty($userErrors)) {
				foreach ($userErrors as $error) {
					echo "Error: " . $error['message'] . PHP_EOL;
					addlog("Error: " . $error['message'] . "", "ERORROR");
				}
			}
		} else {
			echo "Unexpected response format. Check the Shopify API documentation." . PHP_EOL;
			addlog("Unexpected response format. Check the Shopify API documentation.", "ERORROR");
		}
	}

	// Close cURL


	curl_close($ch);
	return true;
}


function processItem($user_id, $siteid, $token, $ebayitemid)
{
	global $conn, $ebConfig;
	$service = new Services\TradingService([
		'credentials' => $ebConfig['production']['credentials'],
		'sandbox'     => false,
		'siteId'      => $siteid
	]);
	$itemRequest = new Types\GetItemRequestType();
	$itemRequest->RequesterCredentials = new Types\CustomSecurityHeaderType();
	$itemRequest->RequesterCredentials->eBayAuthToken = $token;
	$itemRequest->ItemID = $ebayitemid;
	$itemRequest->DetailLevel = ['ReturnAll'];
	$itemRequest->IncludeItemCompatibilityList = true;
	$itemRequest->IncludeItemSpecifics = true;
	$itemResponse = $service->getItem($itemRequest);
	if ($itemResponse->Ack !== 'Failure') {
		if (!isset($itemResponse->Item)) {
			return false;
		}
		$item = $itemResponse->Item;
		$listingType = $item->ListingType;
		if ($listingType != "FixedPriceItem") {
			addlog("Listing is not fixed price. ebayitemid - " . $ebayitemid, "ERROR");
			return false;
		}
		$title = "";
		$description = "";
		$brand = "";
		$product_type = "";
		$condition = "";
		$condition_val = "";
		$condition_note = "";
		$option1name = "";
		$option2name = "";
		$option3name = "";
		$option4name = "";
		$option5name = "";
		$item_specific = "";
		$storecategoryid = "";
		$storecategoryid2 = "";
		$dimenStr = "";

		$sku = "";
		$price = 0;
		$quantity = 0;
		$productid = "";
		$productidtype = "";
		$weight = 0;
		$weight_unit = 'lb';
		$shippingServicesArr = array();

		if (isset($item->Title)) {
			$title = $item->Title;
			$title = remove_emoji($title);
		}
		if ($user_id == 3020) {
			$title = preg_replace('/[^\00-\255]+/u', '', $title);
		}
		if (isset($item->Description)) {
			$description = $item->Description;
			$description = remove_emoji($description);
		}
		if (isset($item->ConditionDisplayName)) {
			$condition_val = $item->ConditionDisplayName;
		}
		if (isset($item->ConditionDescription)) {
			$condition_note = $item->ConditionDescription;
		}
		if (isset($item->ShippingDetails)) {
			$shippingDetails = $item->ShippingDetails;
			if (isset($shippingDetails->ShippingServiceOptions)) {
				$shippingServiceOptions = $shippingDetails->ShippingServiceOptions;
				foreach ($shippingServiceOptions as $shippingServiceOption) {
					if (isset($shippingServiceOption->ShippingService)) {
						$shippingService = $shippingServiceOption->ShippingService;
						$shippingServiceCost = $shippingServiceOption->ShippingServiceCost->value;
						$shippingServicesArr[] = array("shippingService" => $shippingService, "shippingServiceCost" => $shippingServiceCost);
					}
				}
			}
		}
		if (isset($item->ShippingPackageDetails)) {
			$shippingPackageDetails = $item->ShippingPackageDetails;
			if (isset($shippingPackageDetails->WeightMajor) && isset($shippingPackageDetails->WeightMinor)) {
				$weightMajor = $shippingPackageDetails->WeightMajor->value;
				$weightMinor = $shippingPackageDetails->WeightMinor->value;
				$weightMajorUnit = $shippingPackageDetails->WeightMajor->unit;
				$weightMinorUnit = $shippingPackageDetails->WeightMinor->unit;
				/*if($user_id == 1514){
						$weightMajor = $weightMajor * 2.20462;
						$weightMinor = $weightMinor * 0.035274;
					} else {*/
				if ($weightMajorUnit == "kg" && $weightMinorUnit == "gm") {
					$weight_unit = 'kg';
					$weight = $weightMajor + $weightMinor * 0.001;
				} else {
					$weight = $weightMajor + $weightMinor * 0.0625;
				}
				//}
			}
			if ($user_id == 46190) {
				$shippingDetails = $item->SellerProfiles;
				if (isset($shippingDetails)) {
					$dimenStr = $item->SellerProfiles->SellerShippingProfile->ShippingProfileName;;
				}
			}



			if ($user_id == 4697 && isset($shippingPackageDetails->PackageDepth) && isset($shippingPackageDetails->PackageLength) && isset($shippingPackageDetails->PackageWidth)) {
				$depth = $shippingPackageDetails->PackageDepth->value;
				$depthUnit = $shippingPackageDetails->PackageDepth->unit;
				$length = $shippingPackageDetails->PackageLength->value;
				$lengthUnit = $shippingPackageDetails->PackageLength->unit;
				$width = $shippingPackageDetails->PackageWidth->value;
				$widthUnit = $shippingPackageDetails->PackageWidth->unit;
				$dimenArr = array("depth" => $depth, "depthUnit" => $depthUnit, "length" => $length, "lengthUnit" => $lengthUnit, "width" => $width, "widthUnit" => $widthUnit);
				$dimenStr = json_encode($dimenArr);
			}
		}

		if ($user_id == 3720) {
			if (isset($item->SellerProfiles) && isset($item->SellerProfiles->SellerShippingProfile)) {
				$sellerShippingProfile	= $item->SellerProfiles->SellerShippingProfile;
				if (isset($sellerShippingProfile->ShippingProfileName)) {
					$dimenStr = $sellerShippingProfile->ShippingProfileName;
					echo " 3720 reimport for " . $ebayitemid;
				}
			}
			//processItem3720($user_id, $siteid, $token, $ebayitemid, 'update', $product_id, $shopifyproductid); 
		}

		if ($user_id == 47617) {
			if (isset($item->SellerProfiles) && isset($item->SellerProfiles->SellerShippingProfile)) {
				$sellerShippingProfile	= $item->SellerProfiles->SellerShippingProfile;
				if (isset($sellerShippingProfile->ShippingProfileName)) {
					$dimenStr = $sellerShippingProfile->ShippingProfileName;
					//echo " 3720 reimport for ".$ebayitemid;
				}
			}
			//processItem3720($user_id, $siteid, $token, $ebayitemid, 'update', $product_id, $shopifyproductid); 
		}


		if (isset($item->ItemSpecifics) && isset($item->ItemSpecifics->NameValueList)) {
			$itemSpecifics = $item->ItemSpecifics->NameValueList;
			foreach ($itemSpecifics as $itemSpecific) {
				if ($itemSpecific->Name == 'Brand') {
					$brand = $itemSpecific->Value[0];
					echo "brand from itemSpecific  $brand";
				}
			}
		}
		if ($brand == "") {
			if (isset($item->ProductListingDetails)) {
				$productListingDetails = $item->ProductListingDetails;
				if (isset($productListingDetails->BrandMPN)) {
					$brandMPN = $productListingDetails->BrandMPN;
					if (isset($brandMPN->Brand)) {
						$brand = $brandMPN->Brand;
						echo "brand empty $brand";
					}
				}
			}
		}


		if (isset($item->PrimaryCategory->CategoryName)) {
			$product_type = $item->PrimaryCategory->CategoryName;
		}
		if (($user_id == 43700 ||  $user_id == 42198 || $user_id == 35390 ||  $user_id == 20356 || $user_id == 20611 || $user_id == 20828 || $user_id == 21123 || $user_id ==  17609 || $user_id  == 38696 || $user_id == 48018)   && $item->PrimaryCategory->CategoryID) {
			$dimenStr = $item->PrimaryCategory->CategoryID;
		}
		if (isset($item->Storefront)) {
			$storeFront = $item->Storefront;
			if (isset($storeFront->StoreCategoryID)) {
				$storecategoryid = $storeFront->StoreCategoryID;
			}
			if (isset($storeFront->StoreCategory2ID)) {
				$storecategoryid2 = $storeFront->StoreCategory2ID;
			}
		}
		$itemSpecArr = array();
		if (isset($item->ItemSpecifics) && isset($item->ItemSpecifics->NameValueList)) {
			foreach ($item->ItemSpecifics->NameValueList as $itemSpecObj) {
				$name = $itemSpecObj->Name;
				$value = $itemSpecObj->Value;
				$itemSpecArr[$name] = implode(",", iterator_to_array($value));
			}
		}
		if ($user_id == 48599 || $user_id == 49053 || $user_id == 8678 || $user_id == 14386 || $user_id == 18969 || $user_id == 22738 || $user_id == 36620  || $user_id == 23330 || $user_id == 39221  || $user_id == 44188 || $user_id == 48964) { //
			$itemSpecArr['ItemCompatibilityList'] = array();
			if (isset($item->ItemCompatibilityList->Compatibility)) {
				echo "list of user $user_id compatibility data" . json_encode($item->ItemCompatibilityList);
				foreach ($item->ItemCompatibilityList->Compatibility as $compatibility) {
					echo "item compatibility $compatibility";
					$subItemSpecific = array();
					if (isset($compatibility->NameValueList)) {
						foreach ($compatibility->NameValueList as $obj) {
							$name = $obj->Name;
							$value = $obj->Value[0];
							if (strlen($name) > 0) {
								$subItemSpecific[$name] = $value;
							}
						}
						echo "subItemSpecific  $subItemSpecific";
						$itemSpecArr['ItemCompatibilityList'][] = $subItemSpecific;
					}
				}
			}
		}
		$item_specific = json_encode($itemSpecArr);

		if (!isset($item->Variations)) {
			$orig_price = 0;
			if (isset($item->SellingStatus->PromotionalSaleDetails)) {
				$promotionalSaleDetails = $item->SellingStatus->PromotionalSaleDetails;
				if (isset($promotionalSaleDetails->OriginalPrice)) {
					$orig_price = $promotionalSaleDetails->OriginalPrice->value;
				}
			}
			$images = array();
			if (isset($item->SKU)) {
				$sku = $item->SKU;
			}

			if (isset($item->StartPrice)) {
				$price = $item->StartPrice->value;
			}

			if (isset($item->Quantity)) {
				$quantity = $item->Quantity;
			}
			if (isset($item->SellingStatus)) {
				$sellingStatus = $item->SellingStatus;
				if (isset($sellingStatus->QuantitySold)) {
					$quantity = $quantity - $sellingStatus->QuantitySold;
				}
			}

			if (isset($item->ProductListingDetails)) {
				$productListingDetails = $item->ProductListingDetails;
				if (isset($productListingDetails->UPC)) {
					$productid = $productListingDetails->UPC;
					$productidtype = "3";
				} else if (isset($productListingDetails->EAN)) {
					$productid = $productListingDetails->EAN;
					$productidtype = "4";
				} else if (isset($productListingDetails->ISBN)) {
					$productid = $productListingDetails->ISBN;
					$productidtype = "2";
				}
			}

			if (isset($item->PictureDetails->PictureURL)) {
				$pictureLength = count($item->PictureDetails->PictureURL);
				for ($i = 0; $i < $pictureLength; $i++) {
					$images[] = $item->PictureDetails->PictureURL[$i];
				}
			} else if (isset($item->PictureDetails->GalleryURL)) {
				//$pictureLength = count($item->PictureDetails->GalleryURL);
				//for($i = 0; $i < $pictureLength; $i++) {
				$images[] = $item->PictureDetails->GalleryURL;
				//}
			} else if (isset($item->ProductListingDetails->StockPhotoURL)) {
				$images[] = $item->ProductListingDetails->StockPhotoURL;
			}
			print_r("       image array is  " . $images);
			//echo "iamges are". $item->PictureDetails->GalleryURL;
			//echo "images are". $item->PictureDetails->PictureURL[0];

			$productQuery = "insert into products (title, item_specific, condition_val, condition_note, brand, product_type, storecategoryid, storecategoryid2, ebayitemid, searchstring, user_id, created_at, updated_at) values ('" . mysqli_real_escape_string($conn, $title) . "', '" . mysqli_real_escape_string($conn, $item_specific) . "', '" . mysqli_real_escape_string($conn, $condition_val) . "', '" . mysqli_real_escape_string($conn, $condition_note) . "', '" . mysqli_real_escape_string($conn, $brand) . "', '" . mysqli_real_escape_string($conn, $product_type) . "', '" . mysqli_real_escape_string($conn, $storecategoryid) . "', '" . mysqli_real_escape_string($conn, $storecategoryid2) . "', '" . mysqli_real_escape_string($conn, $ebayitemid) . "', '" . mysqli_real_escape_string($conn, $dimenStr) . "', " . $user_id . ", now(), now())";
			echo $productQuery;
			//$productQuery = "insert into products (title, condition_val, condition_note, brand, product_type, ebayitemid, user_id, created_at, updated_at) values ('".mysqli_real_escape_string($conn, $title). "', '".mysqli_real_escape_string($conn, $condition_val)."', '".mysqli_real_escape_string($conn, $condition_note)."', '".mysqli_real_escape_string($conn, $brand)."', '".mysqli_real_escape_string($conn, $product_type)."', '".mysqli_real_escape_string($conn, $ebayitemid)."', ".$user_id.", now(), now())";
			$productResult = mysqli_query($conn, $productQuery);
			$product_id = $conn->insert_id;

			// Saving description to other table
			$productDescriptionQuery = "insert into product_description (product_id, description, user_id, created_at, updated_at) values (" . $product_id . ", '" . mysqli_real_escape_string($conn, $description) . "', " . $user_id . ", now(), now())";
			mysqli_query($conn, $productDescriptionQuery);

			$productVariantQuery = "insert into product_variants (product_id, sku, ebayitemid, price, orig_price, quantity, productid, productidtype, weight, weight_unit, user_id, created_at, updated_at) values (" . $product_id . ", '" . mysqli_real_escape_string($conn, $sku) . "', '" . mysqli_real_escape_string($conn, $ebayitemid) . "', '" . mysqli_real_escape_string($conn, $price) . "', '" . mysqli_real_escape_string($conn, $orig_price) . "', '" . mysqli_real_escape_string($conn, $quantity) . "', '" . mysqli_real_escape_string($conn, $productid) . "', '" . mysqli_real_escape_string($conn, $productidtype) . "', '" . mysqli_real_escape_string($conn, $weight) . "', '" . mysqli_real_escape_string($conn, $weight_unit) . "', " . $user_id . ", now(), now())";
			echo $productVariantQuery;
			$productVariantResult = mysqli_query($conn, $productVariantQuery);
			$variant_id = $conn->insert_id;

			foreach ($images as $imgurl) {
				echo "      image url is " . $imgurl;
				$productImageQuery = "insert into product_images(variant_id, imgurl, user_id, created_at, updated_at) values (" . $variant_id . ", '" . mysqli_real_escape_string($conn, $imgurl) . "', " . $user_id . ", now(), now())";
				$productImageResult = mysqli_query($conn, $productImageQuery);
			}
			if ($user_id == 48747 || $user_id == 5027 || $user_id == 10564 || $user_id ==  19187  || $user_id == 20854  || $user_id == 46190) {
				foreach ($shippingServicesArr as $shippingServiceObj) {
					$shippingService = $shippingServiceObj["shippingService"];
					$shippingServiceCost = $shippingServiceObj["shippingServiceCost"];
					$conn->query("insert into shippingcost (product_id, service_type, cost, user_id, created_at, updated_at) values(" . $product_id . ", '" . $shippingService . "', '" . $shippingServiceCost . "', " . $user_id . ", now(), now())");
				}
			}






			if ($user_id == 44582) {
				if (isset($item->ShippingDetails)) {
					$shippingDetails = $item->ShippingDetails;

					if (isset($shippingDetails->ShippingServiceOptions)) {
						$shippingServiceOptions = $shippingDetails->ShippingServiceOptions;


						foreach ($shippingServiceOptions as $shippingServiceOption) {
							if (isset($shippingServiceOption->ShippingService)) {

								$shippingService = $shippingServiceOption->ShippingService;
								$shippingServiceCost = $shippingServiceOption->ShippingServiceCost->value;
								//    echo "select * from shippingcost where user_id = $user_id and product_id =".$product_id;
								// echo "select * from shippingcost where user_id =".$user_id." and product_id =".$product_id."";

								$conn->query("insert into shippingcost (product_id, service_type, cost, user_id, created_at, updated_at) values(" . $product_id . ", '" . $shippingService . "', '" . $shippingServiceCost . "', " . $user_id . ", now(), now())");

								//    echo "done".$shopifyproductid;





							}
						}


						if (isset($shippingDetails->InternationalShippingServiceOption)) {
							$internationalShippingServiceOptions = $shippingDetails->InternationalShippingServiceOption;
							foreach ($internationalShippingServiceOptions as $internationalShippingServiceOption) {
								if (isset($internationalShippingServiceOption->ShippingService)) {
									$shippingService = $internationalShippingServiceOption->ShippingService;
									$shippingServiceCost = $internationalShippingServiceOption->ShippingServiceCost->value;

									// Insert into table
									$conn->query("INSERT INTO shippingcost (product_id, service_type, cost, user_id, created_at, updated_at) 
													  VALUES ($product_id, '$shippingService', $shippingServiceCost, $user_id, NOW(), NOW())");
								}
							}
						}
					}
				}
			}
		} else {
			$variations = array();
			$option1name = "";
			$option2name = "";
			$option3name = "";
			$option4name = "";
			$option5name = "";
			$vSpecificName = "";
			$weight = 0;
			$weight_unit = 'lb';
			$imgMapping = array();
			$commonImgArr = array();
			if (isset($item->Variations->VariationSpecificsSet)) {
				$variationSpecificsSet = $item->Variations->VariationSpecificsSet;
				$variationSpecificsSetNameValueList = $variationSpecificsSet->NameValueList;
				if (isset($variationSpecificsSetNameValueList[0])) {
					$option1name = $variationSpecificsSetNameValueList[0]->Name;
				}
				if (isset($variationSpecificsSetNameValueList[1])) {
					$option2name = $variationSpecificsSetNameValueList[1]->Name;
				}
				if (isset($variationSpecificsSetNameValueList[2])) {
					$option3name = $variationSpecificsSetNameValueList[2]->Name;
				}
				if (isset($variationSpecificsSetNameValueList[3])) {
					$option4name = $variationSpecificsSetNameValueList[3]->Name;
				}
				if (isset($variationSpecificsSetNameValueList[4])) {
					$option5name = $variationSpecificsSetNameValueList[4]->Name;
				}
			}
			if (isset($item->Variations->Pictures)) {
				$pictures = $item->Variations->Pictures[0];
				$vSpecificName = $pictures->VariationSpecificName;
				$variationSpecificPictureSet = $pictures->VariationSpecificPictureSet;
				foreach ($variationSpecificPictureSet as $variationSpecificPicture) {
					$temp = array();
					foreach ($variationSpecificPicture->PictureURL as $pictureURL) {
						$temp[] = $pictureURL;
					}
					$imgMapping[$variationSpecificPicture->VariationSpecificValue] = $temp;
				}
			}

			$pictureDetails = $item->PictureDetails;
			$temp = array();
			foreach ($pictureDetails->PictureURL as $pictureURL) {
				$temp[] = $pictureURL;
			}
			$commonImgArr = $temp;
			$origMultiplier = 1;
			if (isset($item->SellingStatus)) {
				$orig_price = 0;
				$base_price = 0;
				if ($item->SellingStatus->PromotionalSaleDetails) {
					$promotionalSaleDetails = $item->SellingStatus->PromotionalSaleDetails;
					if (isset($promotionalSaleDetails->OriginalPrice)) {
						$orig_price = $promotionalSaleDetails->OriginalPrice->value;
					}
				}
				if ($item->SellingStatus->CurrentPrice) {
					$base_price = $item->SellingStatus->CurrentPrice->value;
				}
				if ($orig_price > 0 && $base_price > 0) {
					$origMultiplier = 1 - ($orig_price - $base_price) / $orig_price;
				}
			}
			if (isset($item->ShippingPackageDetails)) {
				$shippingPackageDetails = $item->ShippingPackageDetails;
				if (isset($shippingPackageDetails->WeightMajor) && isset($shippingPackageDetails->WeightMinor)) {
					$weightMajor = $shippingPackageDetails->WeightMajor->value;
					$weightMinor = $shippingPackageDetails->WeightMinor->value;
					$weightMajorUnit = $shippingPackageDetails->WeightMajor->unit;
					$weightMinorUnit = $shippingPackageDetails->WeightMinor->unit;
					/*if($user_id == 1514){
    						$weightMajor = $weightMajor * 2.20462;
    						$weightMinor = $weightMinor * 0.035274;
    					} else {*/
					if ($weightMajorUnit == "kg" && $weightMinorUnit == "gm") {
						$weight_unit = 'kg';
						$weight = $weightMajor + $weightMinor * 0.001;
					} else {
						$weight = $weightMajor + $weightMinor * 0.0625;
					}
					//}
				}


				if ($user_id == 4697 && isset($shippingPackageDetails->PackageDepth) && isset($shippingPackageDetails->PackageLength) && isset($shippingPackageDetails->PackageWidth)) {
					$depth = $shippingPackageDetails->PackageDepth->value;
					$depthUnit = $shippingPackageDetails->PackageDepth->unit;
					$length = $shippingPackageDetails->PackageLength->value;
					$lengthUnit = $shippingPackageDetails->PackageLength->unit;
					$width = $shippingPackageDetails->PackageWidth->value;
					$widthUnit = $shippingPackageDetails->PackageWidth->unit;
					$dimenArr = array("depth" => $depth, "depthUnit" => $depthUnit, "length" => $length, "lengthUnit" => $lengthUnit, "width" => $width, "widthUnit" => $widthUnit);
					$dimenStr = json_encode($dimenArr);
				}
			}

			if ($user_id == 3720) {
				echo "setting search str for 3720";
				if (isset($item->SellerProfiles) && isset($item->SellerProfiles->SellerShippingProfile)) {
					$sellerShippingProfile	= $item->SellerProfiles->SellerShippingProfile;
					if (isset($sellerShippingProfile->ShippingProfileName)) {
						$dimenStr = $sellerShippingProfile->ShippingProfileName;
					}
				}
				echo "setting search str ended  for 3720";
			}
			foreach ($item->Variations->Variation as $variation) {
				$sku = "";
				$price = 0;
				$orig_price = 0;
				$quantity = 0;
				$option1val = "";
				$option2val = "";
				$option3val = "";
				$option4val = "";
				$option5val = "";
				$productid = "";
				$productidtype = "";
				$imgArr = array();
				if (isset($variation->SKU)) {
					$sku = $variation->SKU;
				}
				if (isset($variation->StartPrice)) {
					$price = $variation->StartPrice->value;
				}
				if ($origMultiplier != 1 && $origMultiplier > 0) {
					$orig_price = number_format($price / $origMultiplier, 2, '.', '');
				}
				if (isset($variation->Quantity)) {
					$quantity = $variation->Quantity;
				}
				if (isset($variation->SellingStatus)) {
					$sellingStatus = $variation->SellingStatus;
					if (isset($sellingStatus->QuantitySold)) {
						$quantity = $quantity - $sellingStatus->QuantitySold;
					}
				}
				if (isset($variation->VariationProductListingDetails)) {
					$variationProductListingDetails = $variation->VariationProductListingDetails;
					if (isset($variationProductListingDetails->UPC)) {
						$productid = $variationProductListingDetails->UPC;
						$productidtype = "3";
					} else if (isset($variationProductListingDetails->EAN)) {
						$productid = $variationProductListingDetails->EAN;
						$productidtype = "4";
					} else if (isset($variationProductListingDetails->ISBN)) {
						$productid = $variationProductListingDetails->ISBN;
						$productidtype = "2";
					}
				}

				if (isset($variation->VariationSpecifics)) {
					$options = $variation->VariationSpecifics[0]->NameValueList;
					foreach ($options as $option) {
						if ($option->Name == $option1name) {
							$option1val = $option->Value[0];
						} else if ($option->Name == $option2name) {
							$option2val = $option->Value[0];
						} else if ($option->Name == $option3name) {
							$option3val = $option->Value[0];
						} else if ($option->Name == $option4name) {
							$option4val = $option->Value[0];
						} else if ($option->Name == $option5name) {
							$option5val = $option->Value[0];
						}
					}
				}

				if (strlen($vSpecificName) > 0 && $option1name == $vSpecificName) {
					$imgArr = $imgMapping[$option1val];
				}
				if (strlen($vSpecificName) > 0 && $option2name == $vSpecificName) {
					$imgArr = $imgMapping[$option2val];
				}
				if (strlen($vSpecificName) > 0 && $option3name == $vSpecificName) {
					$imgArr = $imgMapping[$option3val];
				}
				if (strlen($vSpecificName) > 0 && $option4name == $vSpecificName) {
					$imgArr = $imgMapping[$option4val];
				}
				if (strlen($vSpecificName) > 0 && $option5name == $vSpecificName) {
					$imgArr = $imgMapping[$option5val];
				}

				if (count($imgArr) == 0) {
					$imgArr = $commonImgArr;
				} else if ($user_id != 2966) {
					$imgArr = array_merge($imgArr, $commonImgArr);
				}
				$imgArr = array_unique($imgArr);
				$variations[] = array("sku" => $sku, "price" => $price, "orig_price" => $orig_price, "quantity" => $quantity, "productid" => $productid, "productidtype" => $productidtype, "option1val" => $option1val, "option2val" => $option2val, "option3val" => $option3val, "option4val" => $option4val, "option5val" => $option5val, "images" => $imgArr);
			}

			//$productQuery = "insert into products (title, option1name, option2name, option3name, option4name, option5name, condition_val, condition_note, brand, product_type, ebayitemid, user_id, created_at, updated_at) values ('".mysqli_real_escape_string($conn, $title)."', '".mysqli_real_escape_string($conn, $option1name)."', '".mysqli_real_escape_string($conn, $option2name)."', '".mysqli_real_escape_string($conn, $option3name)."', '".mysqli_real_escape_string($conn, $option4name)."', '".mysqli_real_escape_string($conn, $option5name)."', '".mysqli_real_escape_string($conn, $condition_val)."', '".mysqli_real_escape_string($conn, $condition_note)."', '".mysqli_real_escape_string($conn, $brand)."', '".mysqli_real_escape_string($conn, $product_type)."', '".mysqli_real_escape_string($conn, $ebayitemid)."', ".$user_id.", now(), now())";
			// echo $productquery;
			$productQuery = "insert into products (title, item_specific, option1name, option2name, option3name, option4name, option5name, condition_val, condition_note, brand, product_type, storecategoryid, storecategoryid2, ebayitemid, searchstring, user_id, created_at, updated_at) values ('" . mysqli_real_escape_string($conn, $title) . "', '" . mysqli_real_escape_string($conn, $item_specific) . "', '" . mysqli_real_escape_string($conn, $option1name) . "', '" . mysqli_real_escape_string($conn, $option2name) . "', '" . mysqli_real_escape_string($conn, $option3name) . "', '" . mysqli_real_escape_string($conn, $option4name) . "', '" . mysqli_real_escape_string($conn, $option5name) . "', '" . mysqli_real_escape_string($conn, $condition_val) . "', '" . mysqli_real_escape_string($conn, $condition_note) . "', '" . mysqli_real_escape_string($conn, $brand) . "', '" . mysqli_real_escape_string($conn, $product_type) . "', '" . mysqli_real_escape_string($conn, $storecategoryid) . "', '" . mysqli_real_escape_string($conn, $storecategoryid2) . "', '" . mysqli_real_escape_string($conn, $ebayitemid) . "', '" . mysqli_real_escape_string($conn, $dimenStr) . "', " . $user_id . ", now(), now())";
			echo $productQuery;
			$productResult = mysqli_query($conn, $productQuery);
			$product_id = $conn->insert_id;

			// Saving description to other table
			$productDescriptionQuery = "insert into product_description (product_id, description, user_id, created_at, updated_at) values (" . $product_id . ", '" . mysqli_real_escape_string($conn, $description) . "', " . $user_id . ", now(), now())";
			mysqli_query($conn, $productDescriptionQuery);

			foreach ($variations as $variation) {
				if ($user_id == 35770) {
					if ($variation['option1val'] == 'S') {
						$variation['option1val'] = 'Small';
					}
					if ($variation['option1val'] == 'M') {
						$variation['option1val'] = 'Medium';
					}
					if ($variation['option1val'] == 'L') {
						$variation['option1val'] = 'Large';
					}
					if ($variation['option1val'] == 'XS') {
						$variation['option1val'] = 'X-Small';
					}
					if ($variation['option1val'] == 'XL') {
						$variation['option1val'] = 'X-Large';
					}
					if ($variation['option1val'] == 'XXL') {
						$variation['option1val'] = 'XX-Large';
					}
					if ($variation['option1val'] == 'XXS') {
						$variation['option1val'] = 'XX-Small';
					}
					if ($variation['option1val'] == '2XL') {
						$variation['option1val'] = '2X-Large';
					}
				}
				echo "anjali" . $variation['option1val'];

				$productVariantQuery = "insert into product_variants (product_id, sku, option1val, option2val, option3val, option4val, option5val, ebayitemid, price, orig_price, quantity, productid, productidtype, weight, weight_unit, user_id, created_at, updated_at) values (" . $product_id . ", '" . mysqli_real_escape_string($conn, $variation['sku']) . "', '" . mysqli_real_escape_string($conn, $variation['option1val']) . "', '" . mysqli_real_escape_string($conn, $variation['option2val']) . "', '" . mysqli_real_escape_string($conn, $variation['option3val']) . "', '" . mysqli_real_escape_string($conn, $variation['option4val']) . "', '" . mysqli_real_escape_string($conn, $variation['option5val']) . "', '" . mysqli_real_escape_string($conn, $ebayitemid) . "', '" . mysqli_real_escape_string($conn, $variation['price']) . "', '" . mysqli_real_escape_string($conn, $variation['orig_price']) . "',  '" . mysqli_real_escape_string($conn, $variation['quantity']) . "', '" . mysqli_real_escape_string($conn, $variation['productid']) . "', '" . mysqli_real_escape_string($conn, $variation['productidtype']) . "', '" . mysqli_real_escape_string($conn, $weight) . "', '" . mysqli_real_escape_string($conn, $weight_unit) . "', " . $user_id . ", now(), now())";
				$productVariantResult = mysqli_query($conn, $productVariantQuery);
				$variant_id = $conn->insert_id;

				foreach ($variation['images'] as $imgurl) {
					$productImageQuery = "insert into product_images(variant_id, imgurl, user_id, created_at, updated_at) values (" . $variant_id . ", '" . mysqli_real_escape_string($conn, $imgurl) . "', " . $user_id . ", now(), now())";
					$productImageResult = mysqli_query($conn, $productImageQuery);
				}
			}
			if ($user_id == 48747 || $user_id == 5027 || $user_id == 10564 || $user_id ==  19187 || $user_id == 20854 || $user_id == 44582) {
				foreach ($shippingServicesArr as $shippingServiceObj) {
					$shippingService = $shippingServiceObj["shippingService"];
					$shippingServiceCost = $shippingServiceObj["shippingServiceCost"];
					$conn->query("insert into shippingcost (product_id, service_type, cost, user_id, created_at, updated_at) values(" . $product_id . ", '" . $shippingService . "', '" . $shippingServiceCost . "', " . $user_id . ", now(), now())");
				}
			}


			if ($user_id == 44582) {
				if (isset($item->ShippingDetails)) {
					$shippingDetails = $item->ShippingDetails;

					if (isset($shippingDetails->ShippingServiceOptions)) {
						$shippingServiceOptions = $shippingDetails->ShippingServiceOptions;


						foreach ($shippingServiceOptions as $shippingServiceOption) {
							if (isset($shippingServiceOption->ShippingService)) {

								$shippingService = $shippingServiceOption->ShippingService;
								$shippingServiceCost = $shippingServiceOption->ShippingServiceCost->value;
								//    echo "select * from shippingcost where user_id = $user_id and product_id =".$product_id;
								// echo "select * from shippingcost where user_id =".$user_id." and product_id =".$product_id."";

								$conn->query("insert into shippingcost (product_id, service_type, cost, user_id, created_at, updated_at) values(" . $product_id . ", '" . $shippingService . "', '" . $shippingServiceCost . "', " . $user_id . ", now(), now())");

								//    echo "done".$shopifyproductid;





							}
						}


						if (isset($shippingDetails->InternationalShippingServiceOption)) {
							$internationalShippingServiceOptions = $shippingDetails->InternationalShippingServiceOption;
							foreach ($internationalShippingServiceOptions as $internationalShippingServiceOption) {
								if (isset($internationalShippingServiceOption->ShippingService)) {
									$shippingService = $internationalShippingServiceOption->ShippingService;
									$shippingServiceCost = $internationalShippingServiceOption->ShippingServiceCost->value;

									// Insert into table
									$conn->query("INSERT INTO shippingcost (product_id, service_type, cost, user_id, created_at, updated_at) 
													  VALUES ($product_id, '$shippingService', $shippingServiceCost, $user_id, NOW(), NOW())");
								}
							}
						}
					}
				}
			}
		}
		if ($user_id == 43040 || $user_id == 47379 || $user_id = 48018) {
			echo "new items in";
			echo $user_id;
			echo $site_id;
			echo $token;
			echo $ebayitemid;
			echo $product_id;
			echo $shopifyproductid;
			$depth =   $item->ShippingPackageDetails->PackageDepth->value;
			$depthUnit =   $item->ShippingPackageDetails->PackageDepth->unit;

			$length =   $item->ShippingPackageDetails->PackageLength->value;
			$lengthUnit = $item->ShippingPackageDetails->PackageLength->unit;

			$width =   $item->ShippingPackageDetails->PackageWidth->value;
			$widthUnit = $item->ShippingPackageDetails->PackageWidth->unit;

			$widthmajor  = $item->ShippingPackageDetails->WeightMajor->value;
			$widthmajorunit =  $item->ShippingPackageDetails->WeightMajor->unit;

			$dimenArr = array("depth" => $depth, "depthUnit" => $depthUnit, "length" => $length, "lengthUnit" => $lengthUnit, "width" => $width, "widthUnit" => $widthUnit, "widthmajor" => $widthmajor, "widthmajorunit" => $widthmajorunit);

			// addlog("dimenArr - ".$dimenArr);	

			print_r($dimenArr);
			$conn->query("insert into product_dimensions( product_id, ebayitemid, user_id, depth, depthUnit, length, lengthUnit, width, widthUnit, widthmajor, widthmajorunit) VALUES ( '" . mysqli_real_escape_string($conn, $product_id) . "','" . mysqli_real_escape_string($conn, $ebayitemid) . "','" . mysqli_real_escape_string($conn, $user_id) . "','" . mysqli_real_escape_string($conn, $depth) . "','" . mysqli_real_escape_string($conn, $depthUnit) . "','" . mysqli_real_escape_string($conn, $length) . "','" . mysqli_real_escape_string($conn, $lengthUnit) . "','" . mysqli_real_escape_string($conn, $width) . "','" . mysqli_real_escape_string($conn, $widthUnit) . "','" . mysqli_real_escape_string($conn, $widthmajor) . "','" . mysqli_real_escape_string($conn, $widthmajorunit) . "')");

			//processItem3720($user_id, $siteid, $token, $ebayitemid, 'update', $product_id, $shopifyproductid); 
			echo "new items out";
		}
		return true;
	} else {
		$errmsg = "";
		if (isset($response->Errors)) {
			foreach ($response->Errors as $error) {
				$errmsg = $errmsg . " :: " . $error->LongMessage;
			}
		}
		verifyToken($user_id, $token, $siteid);
		addlog("Error in getting eBay item details. ebayItemid - " . $ebayitemid . ", Error - " . $errmsg, "ERROR");
		return false;
	}
}

function remove_emoji($text)
{
	return preg_replace('/[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0077}\x{E006C}\x{E0073}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0073}\x{E0063}\x{E0074}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0065}\x{E006E}\x{E0067}\x{E007F})|[\x{1F3F4}](?:\x{200D}\x{2620}\x{FE0F})|[\x{1F3F3}](?:\x{FE0F}\x{200D}\x{1F308})|[\x{0023}\x{002A}\x{0030}\x{0031}\x{0032}\x{0033}\x{0034}\x{0035}\x{0036}\x{0037}\x{0038}\x{0039}](?:\x{FE0F}\x{20E3})|[\x{1F441}](?:\x{FE0F}\x{200D}\x{1F5E8}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F468})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F468})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B0})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2640}\x{FE0F})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2642}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2695}\x{FE0F})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FF})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FE})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FD})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FC})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FB})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FA}](?:\x{1F1FF})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1FA}](?:\x{1F1FE})|[\x{1F1E6}\x{1F1E8}\x{1F1F2}\x{1F1F8}](?:\x{1F1FD})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F9}\x{1F1FF}](?:\x{1F1FC})|[\x{1F1E7}\x{1F1E8}\x{1F1F1}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1FB})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1FB}](?:\x{1F1FA})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FE}](?:\x{1F1F9})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FA}\x{1F1FC}](?:\x{1F1F8})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F7})|[\x{1F1E6}\x{1F1E7}\x{1F1EC}\x{1F1EE}\x{1F1F2}](?:\x{1F1F6})|[\x{1F1E8}\x{1F1EC}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}](?:\x{1F1F5})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EE}\x{1F1EF}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1F8}\x{1F1F9}](?:\x{1F1F4})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1F3})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F4}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FF}](?:\x{1F1F2})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F1})|[\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FD}](?:\x{1F1F0})|[\x{1F1E7}\x{1F1E9}\x{1F1EB}\x{1F1F8}\x{1F1F9}](?:\x{1F1EF})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EB}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F3}\x{1F1F8}\x{1F1FB}](?:\x{1F1EE})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1ED})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1EC})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F9}\x{1F1FC}](?:\x{1F1EB})|[\x{1F1E6}\x{1F1E7}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FB}\x{1F1FE}](?:\x{1F1EA})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1E9})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FB}](?:\x{1F1E8})|[\x{1F1E7}\x{1F1EC}\x{1F1F1}\x{1F1F8}](?:\x{1F1E7})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F6}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}\x{1F1FF}](?:\x{1F1E6})|[\x{00A9}\x{00AE}\x{203C}\x{2049}\x{2122}\x{2139}\x{2194}-\x{2199}\x{21A9}-\x{21AA}\x{231A}-\x{231B}\x{2328}\x{23CF}\x{23E9}-\x{23F3}\x{23F8}-\x{23FA}\x{24C2}\x{25AA}-\x{25AB}\x{25B6}\x{25C0}\x{25FB}-\x{25FE}\x{2600}-\x{2604}\x{260E}\x{2611}\x{2614}-\x{2615}\x{2618}\x{261D}\x{2620}\x{2622}-\x{2623}\x{2626}\x{262A}\x{262E}-\x{262F}\x{2638}-\x{263A}\x{2640}\x{2642}\x{2648}-\x{2653}\x{2660}\x{2663}\x{2665}-\x{2666}\x{2668}\x{267B}\x{267E}-\x{267F}\x{2692}-\x{2697}\x{2699}\x{269B}-\x{269C}\x{26A0}-\x{26A1}\x{26AA}-\x{26AB}\x{26B0}-\x{26B1}\x{26BD}-\x{26BE}\x{26C4}-\x{26C5}\x{26C8}\x{26CE}-\x{26CF}\x{26D1}\x{26D3}-\x{26D4}\x{26E9}-\x{26EA}\x{26F0}-\x{26F5}\x{26F7}-\x{26FA}\x{26FD}\x{2702}\x{2705}\x{2708}-\x{270D}\x{270F}\x{2712}\x{2714}\x{2716}\x{271D}\x{2721}\x{2728}\x{2733}-\x{2734}\x{2744}\x{2747}\x{274C}\x{274E}\x{2753}-\x{2755}\x{2757}\x{2763}-\x{2764}\x{2795}-\x{2797}\x{27A1}\x{27B0}\x{27BF}\x{2934}-\x{2935}\x{2B05}-\x{2B07}\x{2B1B}-\x{2B1C}\x{2B50}\x{2B55}\x{3030}\x{303D}\x{3297}\x{3299}\x{1F004}\x{1F0CF}\x{1F170}-\x{1F171}\x{1F17E}-\x{1F17F}\x{1F18E}\x{1F191}-\x{1F19A}\x{1F201}-\x{1F202}\x{1F21A}\x{1F22F}\x{1F232}-\x{1F23A}\x{1F250}-\x{1F251}\x{1F300}-\x{1F321}\x{1F324}-\x{1F393}\x{1F396}-\x{1F397}\x{1F399}-\x{1F39B}\x{1F39E}-\x{1F3F0}\x{1F3F3}-\x{1F3F5}\x{1F3F7}-\x{1F3FA}\x{1F400}-\x{1F4FD}\x{1F4FF}-\x{1F53D}\x{1F549}-\x{1F54E}\x{1F550}-\x{1F567}\x{1F56F}-\x{1F570}\x{1F573}-\x{1F57A}\x{1F587}\x{1F58A}-\x{1F58D}\x{1F590}\x{1F595}-\x{1F596}\x{1F5A4}-\x{1F5A5}\x{1F5A8}\x{1F5B1}-\x{1F5B2}\x{1F5BC}\x{1F5C2}-\x{1F5C4}\x{1F5D1}-\x{1F5D3}\x{1F5DC}-\x{1F5DE}\x{1F5E1}\x{1F5E3}\x{1F5E8}\x{1F5EF}\x{1F5F3}\x{1F5FA}-\x{1F64F}\x{1F680}-\x{1F6C5}\x{1F6CB}-\x{1F6D2}\x{1F6E0}-\x{1F6E5}\x{1F6E9}\x{1F6EB}-\x{1F6EC}\x{1F6F0}\x{1F6F3}-\x{1F6F9}\x{1F910}-\x{1F93A}\x{1F93C}-\x{1F93E}\x{1F940}-\x{1F945}\x{1F947}-\x{1F970}\x{1F973}-\x{1F976}\x{1F97A}\x{1F97C}-\x{1F9A2}\x{1F9B0}-\x{1F9B9}\x{1F9C0}-\x{1F9C2}\x{1F9D0}-\x{1F9FF}]/u', '', $text);
}

function verifyToken($user_id, $token, $siteid)
{
	global $conn, $ebConfig;
	$service = new Services\TradingService([
		'credentials' => $ebConfig['production']['credentials'],
		'sandbox'     => false,
		'siteId'      => $siteid
	]);
	$request = new Types\GetTokenStatusRequestType();
	$request->RequesterCredentials = new Types\CustomSecurityHeaderType();
	$request->RequesterCredentials->eBayAuthToken = $token;
	$response = $service->getTokenStatus($request);
	if ($response->Ack !== 'Failure') {
		if (!isset($response->TokenStatus)) {
			return false;
		}
		$tokenStatus = $response->TokenStatus;
		$tokenStatusVal = $tokenStatus->Status;
		if ($tokenStatusVal == 'Active') {
			$conn->query("update eb_keys set `status` = '" . mysqli_real_escape_string($conn, $tokenStatusVal) . "', valid = 1 where user_id = " . $user_id);
		} else {
			$conn->query("update eb_keys set `status` = '" . mysqli_real_escape_string($conn, $tokenStatusVal) . "', valid = 0 where user_id = " . $user_id);
		}
	} else {
		$errArr = array();
		if (isset($response->Errors)) {
			foreach ($response->Errors as $error) {
				$errArr[] = array("error_code" => $error->ErrorCode, "error_message" => $error->LongMessage);
			}
		}
		$conn->query("update eb_keys set `status` = '" . mysqli_real_escape_string($conn, json_encode($errArr)) . "', valid = 0 where user_id = " . $user_id);
	}
}

function addlog($message, $type)
{
	global $logfile;
	$txt = date("Y-m-d H:i:s") . " [" . $type . "]: " . $message . "\n";
	fwrite($logfile, $txt);
}
addlog("Execution Finished", "INFO");
fclose($logfile);
